/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.htmltopdf;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.document.DocumentScope;
import coldfusion.document.webkit.DocumentInvalidEncryptionStrengthWebkit;
import coldfusion.document.webkit.HttpPDFRequestHandler;
import coldfusion.document.webkit.PDFgErrorHandler;
import coldfusion.document.webkit.PDFgRequestUtil;
import coldfusion.document.webkit.PDFgServiceManager;
import coldfusion.document.webkit.PDFgServiceManagerHelper;
import coldfusion.document.webkit.PDFgServiceRequestCreator;
import coldfusion.document.webkit.core.DocumentSettingsWebkit;
import coldfusion.document.webkit.core.HeaderFooterObject;
import coldfusion.document.webkit.core.HtmlToPdfConstants;
import coldfusion.document.webkit.core.HtmlToPdfMargin;
import coldfusion.document.webkit.core.HtmlToPdfPageLayout;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.jsp.JspWriterIncludeResponse;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.PDFService;
import coldfusion.runtime.AbortException;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFOutput;
import coldfusion.runtime.NeoPageContext;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.io.FileUtils;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.util.Semaphore;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFile;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.vfs2.FileObject;

public class HtmlToPdfTag
extends GenericTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    private static final GenericTagPermission tp = new GenericTagPermission("cfhtmltopdf");
    private String saveAsName;
    private String source;
    private URL srcUrl;
    private File sourceFile;
    private String destination = null;
    private boolean overwrite = false;
    private String name = null;
    private String language = "English";
    private String content = null;
    private String orientation = "Portrait";
    private String pagetype = "LETTER";
    private double pagewidth;
    private double pageheight;
    private String unit = "in";
    private double margintop = -1.0;
    private double marginbottom = -1.0;
    private double marginleft = -1.0;
    private double marginright = -1.0;
    private String conformance;
    private String encryption = "None";
    private String ownerpassword = null;
    private String userpassword = null;
    private String permissions = null;
    private URL baseurl = null;
    private ByteArrayOutputStream byteOut = null;
    private HtmlToPdfMargin margin = new HtmlToPdfMargin();
    private HtmlToPdfPageLayout pagelayout = new HtmlToPdfPageLayout();
    private boolean bHaveHF = false;
    private HeaderFooterObject header = null;
    private HeaderFooterObject footer = null;
    private boolean bSingleThreadInUse = false;
    private static Semaphore taskwaiter = new Semaphore(1);
    private boolean hasAbsoluteFile = false;
    private boolean encryptionSet = false;
    private boolean addWaterMark = false;
    private static Object waterMarkImageObj = null;
    private static Object waterMarkImageObjOrig = null;
    public static final String MARGINBOTTOM = "MarginBottom";
    public static final String MARGINTOP = "MarginTop";
    public static final String MARGINRIGHT = "MarginRight";
    public static final String MARGINLEFT = "MarginLeft";
    public static final String LANGUAGE = "Language";
    public static final String ENCRYPTION = "Encryption";
    public static final String PAGETYPE = "PageType";
    public static final String PERMISSIONS = "Permissions";
    public static final String SAVEASNAME = "SaveAsName";
    public static final String UNIT = "unit";
    public static final String CONFORMANCE = "Conformance";
    public static List<String> valid_conformance_vals = null;
    public static final String PDFA1A = "PDFA1a";
    public static final String PDFA1B = "PDFA1b";
    public static final String PDFA2A = "PDFA2a";
    public static final String PDFA2B = "PDFA2b";
    public static final String PDFA2U = "PDFA2u";
    public static final String PDFA3A = "PDFA3a";
    public static final String PDFA3B = "PDFA3b";
    public static final String PDFA3U = "PDFA3u";
    public static final String OWNERPASSWORD = "OwnerPassword";
    public static final String USERPASSWORD = "UserPassword";
    public static final String CFLICENSE = "CfLicense";
    public static final String HEADER = "Header";
    public static final String HEADER_ALIGN = "Header_Align";
    public static final String HEADER_LEFTMARGIN = "Header_LeftMargin";
    public static final String HEADER_RIGHTMARGIN = "Header_RightMargin";
    public static final String HEADER_TOPMARGIN = "Header_TopMargin";
    public static final String HEADER_BOTTOMMARGIN = "Header_BottomMargin";
    public static final String HEADER_NUMBERFORMAT = "Header_NumberFormat";
    public static final String HEADER_OPACITY = "Header_Opacity";
    public static final String HEADER_CONTENT = "Header_Content";
    public static final String FOOTER = "Footer";
    public static final String FOOTER_ALIGN = "Footer_Align";
    public static final String FOOTER_LEFTMARGIN = "Footer_LeftMargin";
    public static final String FOOTER_RIGHTMARGIN = "Footer_RightMargin";
    public static final String FOOTER_TOPMARGIN = "Footer_TopMargin";
    public static final String FOOTER_BOTTOMMARGIN = "Footer_BottomMargin";
    public static final String FOOTER_NUMBERFORMAT = "Footer_NumberFormat";
    public static final String FOOTER_OPACITY = "Footer_Opacity";
    public static final String FOOTER_CONTENT = "Footer_Content";
    public static final String HEADER_FOOTER_HTML_PRESENT = "Header_Footer_Html_Present";
    public static final String HTML_PATTERN = "<(\"[^\"]*\"|'[^']*'|[^'\">])*>";

    public static List<String> getValidConformanceValues() {
        if (valid_conformance_vals == null || valid_conformance_vals.isEmpty()) {
            valid_conformance_vals = new ArrayList<String>();
            valid_conformance_vals.add(PDFA1A);
            valid_conformance_vals.add(PDFA1B);
            valid_conformance_vals.add(PDFA2A);
            valid_conformance_vals.add(PDFA2B);
            valid_conformance_vals.add(PDFA2U);
            valid_conformance_vals.add(PDFA3A);
            valid_conformance_vals.add(PDFA3B);
            valid_conformance_vals.add(PDFA3U);
        }
        return valid_conformance_vals;
    }

    public static void setupWaterMarkImage() {
        File waterMarkImageFile;
        if (ServiceFactory.getLicenseService().isDeveloper() && (waterMarkImageFile = HtmlToPdfTag.getWaterMarkImage()) != null) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(waterMarkImageFile);
                if (img != null) {
                    waterMarkImageObjOrig = ServiceFactory.getImageService().newImage((Object)img, null);
                    waterMarkImageObj = ServiceFactory.getImageService().newImage(waterMarkImageObjOrig, null);
                    ServiceFactory.getImageService().resize(waterMarkImageObj, String.valueOf(612.0), String.valueOf(792.0), "highestPerformance");
                }
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    public void enableHasAbsoluteFile() {
        this.hasAbsoluteFile = true;
    }

    protected HtmlToPdfPageLayout getPagelayout() {
        return this.pagelayout;
    }

    protected Permission getPermission() {
        return tp;
    }

    public String getConformance() {
        return this.conformance;
    }

    public void setConformance(String conformance) {
        this.conformance = conformance;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = Utils.getFileFullPath((String)destination, (PageContext)this.pageContext, (boolean)true);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPagetype() {
        return this.pagetype;
    }

    public void setPagetype(String pagetype) {
        this.pagetype = pagetype;
        try {
            this.pagelayout.setPagetype(pagetype);
        }
        catch (IllegalArgumentException e) {
            throw new HtmlToPdfInvalidPageTypeException(pagetype);
        }
    }

    public double getPagewidth() {
        return this.pagewidth;
    }

    public void setPagewidth(double pw) {
        this.pagewidth = pw;
    }

    public double getPageheight() {
        return this.pageheight;
    }

    public void setPageheight(double ph) {
        this.pageheight = ph;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        if (orientation.equalsIgnoreCase("Landscape")) {
            this.orientation = "Landscape";
        } else if (orientation.equalsIgnoreCase("Portrait")) {
            this.orientation = "Portrait";
        } else {
            throw new HtmlToPdfInvalidOrientationException(orientation);
        }
        this.pagelayout.setOrientation(this.orientation);
    }

    public double getMargintop() {
        return this.margintop;
    }

    public void setMargintop(double m) {
        this.margintop = m;
    }

    public double getMarginbottom() {
        return this.marginbottom;
    }

    public void setMarginbottom(double m) {
        this.marginbottom = m;
    }

    public double getMarginleft() {
        return this.marginleft;
    }

    public void setMarginleft(double m) {
        this.marginleft = m;
    }

    public double getMarginright() {
        return this.marginright;
    }

    public void setMarginright(double m) {
        this.marginright = m;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        if (!unit.equalsIgnoreCase("in") && !unit.equalsIgnoreCase("cm")) {
            throw new HtmlToPdfInvalidUnitException(unit);
        }
        this.unit = unit;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public void setEncryption(String encryption) {
        if (!(encryption.equalsIgnoreCase("RC4_40") || encryption.equalsIgnoreCase("RC4_128") || encryption.equalsIgnoreCase("RC4_128M") || encryption.equalsIgnoreCase("AES_128") || encryption.equalsIgnoreCase("None"))) {
            throw new DocumentInvalidEncryptionStrengthWebkit(encryption);
        }
        this.encryption = encryption.trim();
        this.encryptionSet = true;
    }

    public void setOwnerpassword(String ownerpassword) {
        this.ownerpassword = ownerpassword;
    }

    public void setUserpassword(String userpassword) {
        this.userpassword = userpassword;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
        if (permissions == null || permissions.trim().length() == 0) {
            throw new HtmlToPdfInvalidEncryptionPermission(permissions);
        }
        String[] permArr = permissions.split(",");
        for (int i = 0; i < permArr.length; ++i) {
            String perm = permArr[i].trim();
            if (perm.equalsIgnoreCase("AllowPrinting") || perm.equalsIgnoreCase("AllowModifyContents") || perm.equalsIgnoreCase("AllowCopy") || perm.equalsIgnoreCase("AllowModifyAnnotations") || perm.equalsIgnoreCase("AllowFillIn") || perm.equalsIgnoreCase("AllowAssembly") || perm.equalsIgnoreCase("AllowScreenReaders") || perm.equalsIgnoreCase("AllowDegradedPrinting") || perm.equalsIgnoreCase("All") || perm.equalsIgnoreCase("None") || perm.equalsIgnoreCase("AllowSecure")) continue;
            throw new HtmlToPdfInvalidEncryptionPermission(permissions);
        }
    }

    public String getSaveAsName() {
        return this.saveAsName;
    }

    private String encodeURL(String url) {
        URI uri_decoded = null;
        try {
            url = url.replace("+", "%2B");
            String decodedURL = URLDecoder.decode(url, "UTF-8");
            URL url_decoded = new URL(decodedURL);
            uri_decoded = new URI(url_decoded.getProtocol(), url_decoded.getUserInfo(), url_decoded.getHost(), url_decoded.getPort(), url_decoded.getPath(), url_decoded.getQuery(), url_decoded.getRef());
        }
        catch (Exception e) {
            return url;
        }
        return uri_decoded.toASCIIString();
    }

    public void setSaveAsName(String saveAsName) {
        this.saveAsName = saveAsName;
    }

    public void setSource(String source) {
        if (source == null || source.trim().length() == 0) {
            throw new HtmlToPdfInvalidSrcException(source);
        }
        File f = VFSFileFactory.getFileObject((String)(source = source.trim()));
        if (!this.isURL(f) && f.isAbsolute() && f.exists()) {
            this.sourceFile = f;
            this.hasAbsoluteFile = true;
        } else {
            try {
                source = this.encodeURL(source);
                this.srcUrl = new URL(this.resolveURL(source));
            }
            catch (HtmlToPdfInvalidSrcException | MalformedURLException e) {
                if (File.separatorChar == '/' && f.isAbsolute() && f.exists()) {
                    this.sourceFile = f;
                    this.hasAbsoluteFile = true;
                }
                throw new HtmlToPdfInvalidSrcException(source);
            }
        }
        this.source = source;
    }

    private boolean isURL(File f) {
        if (f instanceof VFile) {
            FileObject fo = ((VFile)f).getFileObject();
            return fo.getClass().getName().contains("HttpFileObject") || fo.getClass().getName().contains("UrlFileObject");
        }
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public synchronized void setHeader(HeaderFooterObject header) {
        if (!this.bHaveHF) {
            this.bHaveHF = true;
        }
        this.header = header;
    }

    public synchronized void setFooter(HeaderFooterObject footer) {
        if (!this.bHaveHF) {
            this.bHaveHF = true;
        }
        this.footer = footer;
    }

    public synchronized boolean isHaveHF() {
        return this.bHaveHF;
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.baseurl == null) {
            if (this.request instanceof DummyHttpServletRequest) {
                String url = this.request.getPathTranslated();
                this.baseurl = new File(url).toURI().toURL();
            } else {
                String url = this.request.getRequestURL().toString();
                this.baseurl = new URL(url);
            }
        }
        return this.baseurl;
    }

    public synchronized HeaderFooterObject getHeader() {
        return this.header;
    }

    public synchronized HeaderFooterObject getFooter() {
        return this.footer;
    }

    public HtmlToPdfMargin getMargin() {
        return this.margin;
    }

    private String resolveURL(String src) {
        ResolvePage rp = new ResolvePage();
        String baseUrlStr = null;
        try {
            baseUrlStr = this.getBaseURL().toString();
            String parentUrl = rp.prepareUrl(baseUrlStr);
            String actualBaseUrl = rp.baseUrl(baseUrlStr);
            String contextUrl = actualBaseUrl + this.request.getContextPath();
            String resolvedUrl = rp.resolveUrl(src, parentUrl, contextUrl);
            if (resolvedUrl == null) {
                return src;
            }
            if (resolvedUrl.startsWith(contextUrl)) {
                String uriStr = resolvedUrl.substring(contextUrl.length(), resolvedUrl.length());
                String path = this.application.getRealPath(uriStr);
                File f = VFSFileFactory.getFileObject((String)path);
                if (f.isAbsolute() && !f.exists()) {
                    throw new HtmlToPdfInvalidSrcException(src);
                }
            } else if (src.toLowerCase().startsWith("www.")) {
                return "http://" + src;
            }
            return resolvedUrl;
        }
        catch (MalformedURLException malformedURLException) {
            return src;
        }
    }

    public int doStartTag() throws HtmlToPdfTagException {
        Tag parentTag;
        this.onTagStart();
        FeatureRouter.getInstance().allowFeature(EFRConstants.pdf_generation.intValue(), this.tagNameFromClass(), null);
        String conttype = this.request.getHeader("User-Agent");
        if (conttype != null && conttype.equalsIgnoreCase("contype")) {
            this.response.setContentType("application/pdf");
            throw new AbortException();
        }
        boolean bHasDocParent = false;
        for (parentTag = this.getParent(); parentTag != null; parentTag = parentTag.getParent()) {
            if (!(parentTag instanceof HtmlToPdfTag)) continue;
            bHasDocParent = true;
            break;
        }
        if (bHasDocParent) {
            throw new HtmlToPdfInvalidParentTagException(parentTag.getClass().getName());
        }
        if (this.ownerpassword != null && this.ownerpassword.equals(this.userpassword)) {
            throw new HtmlToPdfInvalidPasswordException();
        }
        if (this.encryption.equalsIgnoreCase("None") && (this.userpassword != null || this.ownerpassword != null || this.permissions != null)) {
            throw new HtmlToPdfMissingEncryptionAttribute();
        }
        if (this.destination != null && !this.isOverwrite() && this.fileExists(this.destination)) {
            throw new HtmlToPdfFileExistsException(this.destination);
        }
        if (this.conformance != null) {
            if (this.conformance.isEmpty()) {
                throw new HtmlToPdfInvalidConformanceException(this.conformance);
            }
            List<String> validConformanceVals = HtmlToPdfTag.getValidConformanceValues();
            if (!validConformanceVals.contains(this.conformance)) {
                throw new HtmlToPdfInvalidConformanceException(this.conformance);
            }
        }
        this.setupSizeMargins();
        this.setupWatermark();
        DocumentScope docScope = (DocumentScope)this.fContext.hiddenScope.get((Object)"CFHTMLTOPDF");
        if (docScope == null) {
            docScope = new DocumentScope();
            this.fContext.hiddenScope.put((Object)"CFHTMLTOPDF", (Object)docScope);
        }
        try {
            PDFgRequestUtil.validateMargins(this.pagelayout, this.margin);
        }
        catch (HtmlToPdfMargin.InvalidMarginException e) {
            throw new HtmlToPdfInvalidMarginSizeException(e);
        }
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentSettingsWebkit populatePDFSettingsObj(String htmlFileName, boolean isLocal) {
        if (this.hasAbsoluteFile && !isLocal) {
            throw new UnsupportedFileConversionException();
        }
        DocumentSettingsWebkit pdfSettings = new DocumentSettingsWebkit();
        if (htmlFileName != null && htmlFileName.length() > 0) {
            PDFgRequestUtil.setTempHtmlNBaseURL(this.request, pdfSettings, htmlFileName, isLocal);
        } else if (this.sourceFile != null && this.sourceFile.exists()) {
            if (!isLocal) {
                CFLogs.SERVER_LOG.error((Object)"When webkit implementation is used, local service manager must be enabled to handle absolute file conversion requests.");
                throw new UnsupportedFileConversionException();
            }
            String absolutePath = this.sourceFile.getAbsolutePath();
            if (absolutePath != null) {
                String pageURL = "file:///" + absolutePath;
                pdfSettings.setPageURL(pageURL);
            }
        } else if (this.srcUrl != null) {
            pdfSettings.setPageURL(this.srcUrl.toString());
            try {
                Object baseURLForPDFg = this.getBaseURLForPDFg(isLocal);
                if (baseURLForPDFg != null && !((String)baseURLForPDFg).endsWith("/")) {
                    baseURLForPDFg = (String)baseURLForPDFg + "/";
                }
                pdfSettings.setBaseURL((String)baseURLForPDFg);
            }
            catch (MalformedURLException e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
        this.adjustHostName(isLocal, pdfSettings);
        pdfSettings.setOverwrite(this.overwrite);
        pdfSettings.setPageLayout(this.pagelayout);
        if (this.addWaterMark) {
            pdfSettings.setAddDevWatermark(true);
        }
        pdfSettings.setHeader(this.header);
        pdfSettings.setFooter(this.footer);
        return pdfSettings;
    }

    private void adjustHostName(boolean isLocal, DocumentSettingsWebkit pdfSettings) {
        if (!isLocal) {
            try {
                String baseURL;
                String pageURL = pdfSettings.getPageURL();
                if (pageURL != null && pageURL.length() > 0) {
                    String lowerCasePageURL = pageURL.toLowerCase();
                    if (lowerCasePageURL.contains("localhost")) {
                        pageURL = pageURL.replace("localhost", InetAddress.getLocalHost().getHostAddress());
                    } else if (lowerCasePageURL.contains("127.0.0.1")) {
                        pageURL = pageURL.replace("127.0.0.1", InetAddress.getLocalHost().getHostAddress());
                    }
                    pdfSettings.setPageURL(pageURL);
                }
                if ((baseURL = pdfSettings.getBaseURL()) != null && baseURL.length() > 0) {
                    String lowerCaseBaseURL = baseURL.toLowerCase();
                    if (lowerCaseBaseURL.contains("localhost")) {
                        baseURL = baseURL.replace("localhost", InetAddress.getLocalHost().getHostAddress());
                    } else if (lowerCaseBaseURL.contains("127.0.0.1")) {
                        baseURL = baseURL.replace("127.0.0.1", InetAddress.getLocalHost().getHostAddress());
                    }
                    pdfSettings.setBaseURL(baseURL);
                }
            }
            catch (UnknownHostException e) {
                CFLogs.SERVER_LOG.error((Throwable)e);
            }
        }
    }

    public String getBaseURLForPDFg(boolean isLocal) throws MalformedURLException {
        String baseurl = null;
        if (this.srcUrl != null && (this.srcUrl.toString().startsWith("http:") || this.srcUrl.toString().startsWith("https:"))) {
            return baseurl;
        }
        if (this.hasAbsoluteFile) {
            return Utils.getBaseTemplatePath((PageContext)this.pageContext);
        }
        if (this.request instanceof DummyHttpServletRequest) {
            baseurl = this.request.getPathTranslated();
        } else {
            baseurl = this.request.getRequestURL().toString();
            ResolvePage rp = new ResolvePage();
            baseurl = rp.prepareUrl(baseurl);
        }
        return baseurl;
    }

    private void setupSizeMargins() {
        boolean bInch = this.unit.equalsIgnoreCase("in");
        if (this.pagetype.equalsIgnoreCase("CUSTOM")) {
            if (this.pageheight == 0.0 || this.pagewidth == 0.0) {
                throw new HtmlToPdfMissingPageSizeException();
            }
            if (!bInch) {
                this.pageheight /= 2.54;
                this.pagewidth /= 2.54;
            }
            if (this.pageheight < 2.0) {
                throw new HtmlToPdfInvalidPageSizeException("" + this.pageheight);
            }
            if (this.pagewidth < 2.0) {
                throw new HtmlToPdfInvalidPageSizeException("" + this.pagewidth);
            }
            this.pagelayout.setPageheight(this.pageheight);
            this.pagelayout.setPagewidth(this.pagewidth);
        }
        if (!bInch) {
            if (this.margintop != -1.0) {
                this.margintop /= 2.54;
            }
            if (this.marginbottom != -1.0) {
                this.marginbottom /= 2.54;
            }
            if (this.marginleft != -1.0) {
                this.marginleft /= 2.54;
            }
            if (this.marginright != -1.0) {
                this.marginright /= 2.54;
            }
        }
        this.margin.setTop(this.margintop);
        this.margin.setBottom(this.marginbottom);
        this.margin.setLeft(this.marginleft);
        this.margin.setRight(this.marginright);
        this.pagelayout.setMargin(this.margin);
    }

    private void processPDFgRequest(PDFgServiceManager serviceManager, String conversionXml) {
        CFLogs.SERVER_LOG.debug((Object)("Converting PDF using service manager " + serviceManager.getURL() + " . Request URL was " + this.request.getRequestURL().toString()));
        this.byteOut = HttpPDFRequestHandler.requestPDFGeneration(serviceManager, conversionXml);
    }

    private void setupWatermark() {
        if (ServiceFactory.getLicenseService().isDeveloper()) {
            this.addWaterMark = true;
        }
    }

    private boolean fileExists(final String filename) {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getFileObject((String)filename).exists();
        }
        Boolean bExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return VFSFileFactory.getFileObject((String)filename).exists();
            }
        });
        return bExists;
    }

    private static File getWaterMarkImage() {
        if (System.getSecurityManager() == null) {
            return ServiceFactory.getDocumentService().getWmimageFileWithChecksum();
        }
        return (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServiceFactory.getDocumentService().getWmimageFileWithChecksum();
            }
        });
    }

    public int doAfterBody() throws HtmlToPdfTagException {
        if (this.bodyContent != null) {
            this.content = this.bodyContent.getString().trim();
            this.bodyContent.clearBody();
        }
        return 0;
    }

    private void convertToPDF() {
        block6: {
            boolean hasContent = this.content != null && this.content.length() > 0;
            try {
                if (ServiceFactory.getLicenseService().isStandard() && !this.bSingleThreadInUse) {
                    taskwaiter.acquire();
                    this.bSingleThreadInUse = true;
                }
                if (hasContent || this.srcUrl != null || this.sourceFile != null) {
                    this.handlePDFgConversionRequest(hasContent);
                    break block6;
                }
                throw new EmptyBodyException();
            }
            finally {
                if (this.bSingleThreadInUse) {
                    taskwaiter.release();
                    this.bSingleThreadInUse = false;
                }
            }
        }
    }

    private HashMap<String, String> addOtherConfigSettings(DocumentSettingsWebkit settingsObj) throws Exception {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put(LANGUAGE, this.getLanguage());
        settings.put(PAGETYPE, this.getPagetype());
        settings.put(UNIT, this.getUnit());
        settings.put(CONFORMANCE, this.getConformance());
        settings.put(CFLICENSE, ServiceFactory.getLicenseService().getEdition());
        boolean isHtmlPresent = false;
        try {
            String headerContent;
            HeaderFooterObject header = settingsObj.getHeader();
            settings.put(HEADER, Boolean.toString(header != null));
            if (header != null && header.getContentProvider() != null && this.isHtmlContentPresent(headerContent = header.getContentProvider().getContent(1, 1).trim())) {
                isHtmlPresent = true;
                settings.put(HEADER_CONTENT, headerContent);
                settings.put(HEADER_ALIGN, header.getAlign());
                settings.put(HEADER_NUMBERFORMAT, header.getNumberFormat());
                settings.put(HEADER_LEFTMARGIN, Double.toString(header.getLeftMargin()));
                settings.put(HEADER_RIGHTMARGIN, Double.toString(header.getRightMargin()));
                settings.put(HEADER_TOPMARGIN, Double.toString(header.getTopMargin()));
                settings.put(HEADER_OPACITY, Integer.toString(header.getOpacity()));
            }
        }
        catch (Throwable th) {
            CFLogs.SERVER_LOG.error((Object)"Error in fetching the content of Header");
        }
        try {
            String footerContent;
            HeaderFooterObject footer = settingsObj.getFooter();
            settings.put(FOOTER, Boolean.toString(footer != null));
            if (footer != null && footer.getContentProvider() != null && this.isHtmlContentPresent(footerContent = footer.getContentProvider().getContent(1, 1).trim())) {
                isHtmlPresent = true;
                settings.put(FOOTER_CONTENT, footerContent);
                settings.put(FOOTER_ALIGN, footer.getAlign());
                settings.put(FOOTER_NUMBERFORMAT, footer.getNumberFormat());
                settings.put(FOOTER_LEFTMARGIN, Double.toString(footer.getLeftMargin()));
                settings.put(FOOTER_RIGHTMARGIN, Double.toString(footer.getRightMargin()));
                settings.put(FOOTER_TOPMARGIN, Double.toString(footer.getTopMargin()));
                settings.put(FOOTER_OPACITY, Integer.toString(footer.getOpacity()));
            }
        }
        catch (Throwable th) {
            CFLogs.SERVER_LOG.error((Object)"Error in fetching the content of Footer");
        }
        settings.put(HEADER_FOOTER_HTML_PRESENT, Boolean.toString(isHtmlPresent));
        return settings;
    }

    private boolean isHtmlContentPresent(String headerFooterContent) {
        Pattern pattern = Pattern.compile(HTML_PATTERN);
        Matcher matcher = pattern.matcher(headerFooterContent);
        return matcher.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePDFgConversionRequest(boolean hasContent) {
        String absolutePath;
        String htmlFileName = null;
        if (hasContent) {
            this.content = this.content + "\n<title>PDF</title>";
            String encoding = null;
            if (this.pageContext instanceof NeoPageContext) {
                encoding = ((NeoPageContext)this.pageContext).getPageEncoding();
            }
            if (encoding == null) {
                encoding = HtmlToPdfConstants.DEFAULT_CHARSET;
            }
            htmlFileName = PDFgRequestUtil.writeContentToTempFile(this.content, encoding);
        } else if (this.sourceFile != null && VFSFileFactory.checkIfVFile((String)(absolutePath = this.sourceFile.getAbsolutePath()))) {
            byte[] contentData = FileUtils.readBinaryFile((String)absolutePath);
            htmlFileName = PDFgRequestUtil.writeContentToTempFile(contentData, null);
        }
        boolean needLocal = false;
        if (this.hasAbsoluteFile) {
            needLocal = true;
        }
        try {
            PDFgServiceManager serviceManager = PDFgServiceManagerHelper.getInstance().getPDFgServiceManager(needLocal);
            DocumentSettingsWebkit settingsObj = this.populatePDFSettingsObj(htmlFileName, serviceManager.isLocal());
            HashMap<String, String> otherPdfSettings = this.addOtherConfigSettings(settingsObj);
            String conversionXml = PDFgServiceRequestCreator.buildConvertPDFRequest(settingsObj, otherPdfSettings, serviceManager.getEngine());
            try {
                this.processPDFgRequest(serviceManager, conversionXml);
            }
            catch (PDFgErrorHandler.ServiceManagerRetryException e) {
                this.handleRetryError(needLocal, conversionXml);
            }
            catch (PDFgErrorHandler.ServiceManagerReRegisterException e) {
                this.handleReRegisterError(needLocal, serviceManager, conversionXml);
            }
            if (serviceManager.getEngine().equalsIgnoreCase("pdfReactor")) {
                this.applyExtraAttributesUsingPDFModule(settingsObj, Boolean.parseBoolean(otherPdfSettings.get(HEADER_FOOTER_HTML_PRESENT)));
            } else {
                this.applyExtraAttributesForWebkit(settingsObj);
            }
            if (htmlFileName == null) return;
        }
        catch (Exception e) {
            try {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
                if (htmlFileName == null) return;
            }
            catch (Throwable throwable) {
                if (htmlFileName == null) throw throwable;
                PDFgRequestUtil.deleteTempHtmlFile(htmlFileName);
                throw throwable;
            }
            PDFgRequestUtil.deleteTempHtmlFile(htmlFileName);
            return;
        }
        PDFgRequestUtil.deleteTempHtmlFile(htmlFileName);
        return;
    }

    private void applyExtraAttributesUsingPDFModule(DocumentSettingsWebkit settingsObj, boolean isHtmlPresentInHeaderFooter) {
        boolean usePDFModuleForExtraAttributes;
        boolean bl = usePDFModuleForExtraAttributes = !isHtmlPresentInHeaderFooter || !this.encryption.equalsIgnoreCase("None") || this.ownerpassword != null || this.userpassword != null || this.permissions != null;
        if (usePDFModuleForExtraAttributes) {
            this.applyExtraAttributesForWebkit(settingsObj);
        }
    }

    private void applyExtraAttributesForWebkit(DocumentSettingsWebkit settingsObj) {
        if (this.byteOut == null) {
            this.getByteOut();
        }
        if (this.byteOut == null) {
            throw new PDFGenerationException();
        }
        PDFService pdfService = ServiceFactory.getPDFService();
        if (pdfService != null) {
            pdfService.applyExtraAttributesForWebkit(settingsObj, this.byteOut, this.addWaterMark, this.encryption, this.ownerpassword, this.permissions, this.userpassword, waterMarkImageObj, this.encryptionSet, this.pagelayout, waterMarkImageObjOrig, this.getLanguage());
        }
    }

    private void handleRetryError(boolean needLocal, String conversionXml) {
        PDFgServiceManager serviceManager = PDFgServiceManagerHelper.getInstance().getPDFgServiceManager(needLocal);
        try {
            this.processPDFgRequest(serviceManager, conversionXml);
        }
        catch (Exception ei) {
            throw new PDFgErrorHandler.ServiceManagerConversionException(ei, serviceManager.getURL());
        }
    }

    private void handleReRegisterError(boolean needLocal, PDFgServiceManager serviceManager, String conversionXml) {
        serviceManager = PDFgServiceManagerHelper.getInstance().reRegisterServiceManager(needLocal, serviceManager);
        try {
            this.processPDFgRequest(serviceManager, conversionXml);
        }
        catch (PDFgErrorHandler.ServiceManagerConversionException se) {
            throw se;
        }
        catch (Exception ei) {
            throw new PDFgErrorHandler.ServiceManagerConversionException(ei, serviceManager.getURL());
        }
    }

    public int doEndTag() throws HtmlToPdfTagException {
        this.convertToPDF();
        this.runGcIfRequired();
        OutputStream os = null;
        if (this.byteOut != null) {
            if (this.destination != null) {
                try {
                    os = this.getFileOutputStream(this.destination);
                    this.createDoc(os, this.byteOut);
                }
                catch (Throwable e) {
                    throw new HtmlToPdfTagException(e);
                }
                finally {
                    if (os != null) {
                        this.close(os);
                    }
                }
                if (this.name != null) {
                    this.pageContext.setAttribute(this.name, (Object)this.byteOut.toByteArray());
                }
            } else {
                try {
                    if (this.name == null) {
                        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
                        res.setHeader("Expires", "0");
                        res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                        res.setHeader("Pragma", "public");
                        HttpServletResponse resp = res;
                        while (resp instanceof JspWriterIncludeResponse) {
                            resp = ((JspWriterIncludeResponse)resp).getResponse();
                        }
                        if (this.out instanceof CFOutput) {
                            ((CFOutput)this.out).clearAll();
                        }
                        if (this.pageContext instanceof NeoPageContext) {
                            ((NeoPageContext)this.pageContext).setFlushOutput(false);
                        }
                        if (this.saveAsName != null) {
                            res.setHeader("Content-disposition", "inline; filename=" + this.saveAsName);
                        }
                        resp.setContentType("application/pdf");
                        os = resp.getOutputStream();
                        this.createDoc(os, this.byteOut);
                        os.flush();
                        this.onTagEnd();
                        throw new AbortException();
                    }
                    this.pageContext.setAttribute(this.name, (Object)this.byteOut.toByteArray());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.onTagEnd();
        return 6;
    }

    private OutputStream getFileOutputStream(String destination) throws FileNotFoundException {
        return VFSFileFactory.getOutputStream((String)destination);
    }

    private void runGcIfRequired() {
        String rungc = System.getProperty("coldfusion.forcegc", "false");
        if (rungc.equals("true")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Runtime runtime = Runtime.getRuntime();
                    if (runtime.totalMemory() > 0xC800000L) {
                        runtime.gc();
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDoc(OutputStream os, ByteArrayOutputStream result) throws IOException {
        try {
            int size = result.size();
            if (this.destination == null) {
                this.response.setContentLength(size);
            }
            result.writeTo(os);
        }
        finally {
            this.close(this.byteOut);
        }
    }

    private void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            this.warning(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getByteOut() {
        BufferedInputStream bis = null;
        InputStream fis = null;
        try {
            File file = null;
            if (this.destination != null) {
                file = new File(this.destination);
            }
            if (file == null || !file.exists()) {
                throw new PDFgErrorHandler.ServiceManagerConversionException(" PDF file not found.");
            }
            fis = VFSFileFactory.getInputStream((File)file);
            bis = new BufferedInputStream(fis);
            this.byteOut = new ByteArrayOutputStream();
            byte[] buffer = new byte[bis.available()];
            bis.read(buffer);
            this.byteOut.write(buffer);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Throwable)e);
        }
        finally {
            try {
                if (this.byteOut != null) {
                    this.byteOut.close();
                }
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void release() {
        this.cleanup();
        super.release();
    }

    private void cleanup() {
        this.saveAsName = null;
        this.source = null;
        this.destination = null;
        this.overwrite = false;
        this.name = null;
        this.language = "English";
        this.encryption = "None";
        this.ownerpassword = null;
        this.userpassword = null;
        this.permissions = null;
        this.pagetype = "LETTER";
        this.pagewidth = -1.0;
        this.pageheight = -1.0;
        this.orientation = "Portrait";
        this.margintop = -1.0;
        this.marginbottom = -1.0;
        this.marginleft = -1.0;
        this.marginright = -1.0;
        this.unit = "in";
        this.conformance = null;
        this.content = null;
        this.byteOut = null;
        this.bSingleThreadInUse = false;
        this.srcUrl = null;
        this.sourceFile = null;
        this.baseurl = null;
        this.addWaterMark = false;
        this.hasAbsoluteFile = false;
        this.bHaveHF = false;
        this.header = null;
        this.footer = null;
        this.pagelayout.clean();
    }

    public void doFinally() {
        this.cleanup();
    }

    public static class HtmlToPdfInvalidPageTypeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String pagetype;

        public HtmlToPdfInvalidPageTypeException(String pagetype) {
            this.pagetype = pagetype;
        }
    }

    public class HtmlToPdfInvalidOrientationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String orientation = "";
        public final String landscapeorientation = "Landscape";
        public final String portraitorientation = "Portrait";

        public HtmlToPdfInvalidOrientationException(String orientation) {
            this.orientation = orientation;
        }
    }

    public class HtmlToPdfInvalidUnitException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String unit = "";
        public final String inchunit = "in";
        public final String cmunit = "cm";

        public HtmlToPdfInvalidUnitException(String unit) {
            this.unit = unit;
        }
    }

    public class HtmlToPdfInvalidEncryptionPermission
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String permission = "";

        public HtmlToPdfInvalidEncryptionPermission(String permission) {
            this.permission = permission;
        }
    }

    public class HtmlToPdfInvalidSrcException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String src;

        public HtmlToPdfInvalidSrcException(String src) {
            this.src = src;
        }
    }

    public class HtmlToPdfInvalidParentTagException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String parentTag = "";

        public HtmlToPdfInvalidParentTagException(String parentTag) {
            this.parentTag = parentTag;
        }
    }

    public static class HtmlToPdfInvalidPasswordException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfMissingEncryptionAttribute
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfFileExistsException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String filename = "";

        public HtmlToPdfFileExistsException(String filename) {
            this.filename = filename;
        }
    }

    public class HtmlToPdfInvalidConformanceException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String conformance;

        public HtmlToPdfInvalidConformanceException(String conformance) {
            this.conformance = conformance;
        }
    }

    public class HtmlToPdfInvalidMarginSizeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String marginsize;
        private String pagesize;

        public HtmlToPdfInvalidMarginSizeException(HtmlToPdfMargin.InvalidMarginException ex) {
            super((Throwable)ex);
            this.marginsize = ex.getMarginsize();
            this.pagesize = ex.getPagesize();
        }

        public String getMarginsize() {
            return this.marginsize;
        }

        public String getPagesize() {
            return this.pagesize;
        }
    }

    public static class UnsupportedFileConversionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfMissingPageSizeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfInvalidPageSizeException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String size = "";

        public HtmlToPdfInvalidPageSizeException(String size) {
            this.size = size;
        }
    }

    public static class EmptyBodyException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class PDFGenerationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class HtmlToPdfTagException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        HtmlToPdfTagException(Throwable ex) {
            super(ex);
        }
    }
}

