/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.observers.BasicIntQueueDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapCompletable<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, ? extends CompletableSource> mapper;
    final boolean delayErrors;

    public ObservableFlatMapCompletable(ObservableSource<T> source2, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
        super(source2);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new FlatMapCompletableMainObserver<T>(observer, this.mapper, this.delayErrors));
    }

    static final class FlatMapCompletableMainObserver<T>
    extends BasicIntQueueDisposable<T>
    implements Observer<T> {
        private static final long serialVersionUID = 8443155186132538303L;
        final Observer<? super T> downstream;
        final AtomicThrowable errors;
        final Function<? super T, ? extends CompletableSource> mapper;
        final boolean delayErrors;
        final CompositeDisposable set;
        Disposable upstream;
        volatile boolean disposed;

        FlatMapCompletableMainObserver(Observer<? super T> observer, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
            this.downstream = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new CompositeDisposable();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            CompletableSource cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.disposed && this.set.add(inner)) {
                cs.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    }
                } else {
                    this.disposed = true;
                    this.upstream.dispose();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        @Nullable
        public T poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public int requestFusion(int mode) {
            return mode & 2;
        }

        void innerComplete(InnerObserver inner) {
            this.set.delete(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            this.onError(e);
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainObserver.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapCompletableMainObserver.this.innerError(this, e);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }
        }
    }
}

