/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.internal.ResponseReader;
import com.apollographql.apollo.api.internal.ResponseWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.ResponseFieldSpec;
import com.apollographql.apollo.compiler.TestUtilsKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.apollographql.apollo.compiler.ir.Condition;
import com.apollographql.apollo.compiler.ir.Field;
import com.apollographql.apollo.compiler.ir.TypeDeclaration;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 A2\u00020\u0001:\u0001AB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0006\u0010 \u001a\u00020\u001bJ&\u0010!\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0016\u0010/\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bJ\u0018\u00100\u001a\n 2*\u0004\u0018\u000101012\u0006\u00103\u001a\u00020,H\u0002J\u0018\u00104\u001a\n 2*\u0004\u0018\u000101012\u0006\u00103\u001a\u00020,H\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u00107\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u0018\u00108\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010:\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J \u0010;\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020,2\u0006\u00109\u001a\u00020\u001bH\u0002J \u0010>\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bH\u0002J\u0018\u0010?\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001e\u0010@\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006B"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec;", "", "irField", "Lcom/apollographql/apollo/compiler/ir/Field;", "fieldSpec", "Lcom/squareup/javapoet/FieldSpec;", "normalizedFieldSpec", "responseFieldType", "Lcom/apollographql/apollo/api/ResponseField$Type;", "typeConditions", "", "", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/ir/Field;Lcom/squareup/javapoet/FieldSpec;Lcom/squareup/javapoet/FieldSpec;Lcom/apollographql/apollo/api/ResponseField$Type;Ljava/util/List;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getFieldSpec", "()Lcom/squareup/javapoet/FieldSpec;", "getIrField", "()Lcom/apollographql/apollo/compiler/ir/Field;", "getNormalizedFieldSpec", "getResponseFieldType", "()Lcom/apollographql/apollo/api/ResponseField$Type;", "getTypeConditions", "()Ljava/util/List;", "booleanConditionsCode", "Lcom/squareup/javapoet/CodeBlock;", "conditions", "Lcom/apollographql/apollo/compiler/ir/Condition;", "customTypeFactoryCode", "factoryMethod", "factoryCode", "fragmentFactoryCode", "possibleTypes", "genericFactoryCode", "readCustomCode", "readerParam", "fieldParam", "readEnumCode", "readFragmentsCode", "readListCode", "readListItemStatement", "rawFieldType", "Lcom/squareup/javapoet/TypeName;", "readObjectCode", "readScalarCode", "readValueCode", "responseFieldListItemReaderType", "Lcom/squareup/javapoet/ParameterizedTypeName;", "kotlin.jvm.PlatformType", "type", "responseFieldObjectReaderType", "writeCustomCode", "writerParam", "writeEnumCode", "writeFragmentCode", "marshaller", "writeFragmentsCode", "writeListCode", "writeListItemStatement", "listItemType", "writeObjectCode", "writeScalarCode", "writeValueCode", "Companion", "apollo-compiler"})
public final class ResponseFieldSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Field irField;
    @NotNull
    private final FieldSpec fieldSpec;
    @NotNull
    private final FieldSpec normalizedFieldSpec;
    @NotNull
    private final ResponseField.Type responseFieldType;
    @NotNull
    private final List<String> typeConditions;
    @NotNull
    private final CodeGenerationContext context;
    @NotNull
    private static final Map<ResponseField.Type, String> FACTORY_METHODS;
    @NotNull
    private static final Map<ResponseField.Type, String> READ_METHODS;
    @NotNull
    private static final Map<ResponseField.Type, String> WRITE_METHODS;
    @NotNull
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_READ_METHODS;
    @NotNull
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec RESPONSE_READER_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_READER_PARAM;
    private static final ParameterSpec ITEMS_VALUE_PARAM;
    private static final ParameterSpec ITEM_VALUE_PARAM;
    private static final ParameterSpec RESPONSE_LIST_ITEM_WRITER_PARAM;

    public ResponseFieldSpec(@NotNull Field irField, @NotNull FieldSpec fieldSpec, @NotNull FieldSpec normalizedFieldSpec, @NotNull ResponseField.Type responseFieldType, @NotNull List<String> typeConditions, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(irField, "irField");
        Intrinsics.checkParameterIsNotNull(fieldSpec, "fieldSpec");
        Intrinsics.checkParameterIsNotNull(normalizedFieldSpec, "normalizedFieldSpec");
        Intrinsics.checkParameterIsNotNull((Object)responseFieldType, "responseFieldType");
        Intrinsics.checkParameterIsNotNull(typeConditions, "typeConditions");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.irField = irField;
        this.fieldSpec = fieldSpec;
        this.normalizedFieldSpec = normalizedFieldSpec;
        this.responseFieldType = responseFieldType;
        this.typeConditions = typeConditions;
        this.context = context;
    }

    public /* synthetic */ ResponseFieldSpec(Field field, FieldSpec fieldSpec, FieldSpec fieldSpec2, ResponseField.Type type, List list, CodeGenerationContext codeGenerationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(field, fieldSpec, fieldSpec2, type, list, codeGenerationContext);
    }

    @NotNull
    public final Field getIrField() {
        return this.irField;
    }

    @NotNull
    public final FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    @NotNull
    public final FieldSpec getNormalizedFieldSpec() {
        return this.normalizedFieldSpec;
    }

    @NotNull
    public final ResponseField.Type getResponseFieldType() {
        return this.responseFieldType;
    }

    @NotNull
    public final List<String> getTypeConditions() {
        return this.typeConditions;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    @NotNull
    public final CodeBlock factoryCode() {
        CodeBlock codeBlock;
        Object object = FACTORY_METHODS.get((Object)this.responseFieldType);
        if (object == null) {
            String string = Intrinsics.stringPlus("Unrecognized responseFieldType: ", (Object)this.responseFieldType);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String factoryMethod = object;
        object = this.responseFieldType;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                codeBlock = this.customTypeFactoryCode(this.irField, factoryMethod);
                break;
            }
            case 2: {
                codeBlock = this.fragmentFactoryCode(this.irField, factoryMethod, this.typeConditions);
                break;
            }
            default: {
                codeBlock = this.genericFactoryCode(this.irField, factoryMethod);
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock readValueCode(@NotNull CodeBlock readerParam, @NotNull CodeBlock fieldParam) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull(readerParam, "readerParam");
        Intrinsics.checkParameterIsNotNull(fieldParam, "fieldParam");
        ResponseField.Type type = this.responseFieldType;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                codeBlock = this.readScalarCode(readerParam, fieldParam);
                break;
            }
            case 1: {
                codeBlock = this.readCustomCode(readerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.readEnumCode(readerParam, fieldParam);
                break;
            }
            case 9: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 10: {
                codeBlock = this.readListCode(readerParam, fieldParam);
                break;
            }
            case 2: {
                codeBlock = this.readObjectCode(readerParam, fieldParam);
                break;
            }
            case 11: {
                codeBlock = this.readFragmentsCode();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock fieldParam, @NotNull CodeBlock marshaller2) {
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull(writerParam, "writerParam");
        Intrinsics.checkParameterIsNotNull(fieldParam, "fieldParam");
        Intrinsics.checkParameterIsNotNull(marshaller2, "marshaller");
        ResponseField.Type type = this.responseFieldType;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                codeBlock = this.writeScalarCode(writerParam, fieldParam);
                break;
            }
            case 8: {
                codeBlock = this.writeEnumCode(writerParam, fieldParam);
                break;
            }
            case 1: {
                codeBlock = this.writeCustomCode(writerParam, fieldParam);
                break;
            }
            case 9: {
                codeBlock = this.writeObjectCode(writerParam, fieldParam, marshaller2);
                break;
            }
            case 10: {
                codeBlock = this.writeListCode(writerParam, fieldParam, marshaller2);
                break;
            }
            case 2: {
                codeBlock = this.writeFragmentCode(writerParam, marshaller2);
                break;
            }
            case 11: {
                codeBlock = this.writeFragmentsCode(writerParam, marshaller2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    private final CodeBlock customTypeFactoryCode(Field irField, String factoryMethod) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = TestUtilsKt.normalizeGraphQlType$default(irField.getType(), false, 2, null);
        Object[] objectArray = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "ENGLISH");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase((Locale)objectArray);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string4;
        objectArray = new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), customScalarEnum, customScalarEnumConst, this.booleanConditionsCode(irField.getConditions())};
        string = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $T.$L, $L)", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(string, "of(\"\\$T.\\$L(\\$S, \\$S, \\$L, \\$L, \\$T.\\$L, \\$L)\", ResponseField::class.java,\n        factoryMethod,\n        irField.responseName, irField.fieldName, irField.argumentCodeBlock(), irField.isOptional(), customScalarEnum,\n        customScalarEnumConst, booleanConditionsCode(irField.conditions))");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock fragmentFactoryCode(Field irField, String factoryMethod, List<String> possibleTypes) {
        CodeBlock codeBlock;
        Object[] objectArray;
        void $this$foldIndexed$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CodeBlock codeBlock2;
        boolean bl;
        CodeBlock builder;
        CodeBlock $this$foldIndexed$iv2;
        int n;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Condition it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2 = irField.getConditions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Condition)element$iv$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(it.getKind(), Condition.Kind.BOOLEAN.getRawValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void condition;
            it = (Condition)item$iv$iv;
            Collection collection = destination$iv$iv;
            n = 0;
            Object[] objectArray2 = new Object[]{ResponseField.Condition.class, condition.getVariableName(), condition.getInverted()};
            CodeBlock codeBlock3 = CodeBlock.of((String)"$T.booleanCondition($S, $L)", (Object[])objectArray2);
            collection.add(codeBlock3);
        }
        List booleanConditions = (List)destination$iv$iv;
        Iterable $i$f$map22 = possibleTypes;
        CodeBlock.Builder initial$iv322 = CodeBlock.builder();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv322;
        for (Object element$iv : $this$foldIndexed$iv2) {
            void type;
            void v0;
            Object[] $this$applyIf$iv;
            n = index$iv++;
            boolean bl3 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)element$iv;
            CodeBlock.Builder builder2 = accumulator$iv;
            int index = n;
            boolean bl4 = false;
            void var19_45 = builder;
            boolean condition$iv = index > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void var22_51 = $this$applyIf$iv;
                boolean bl5 = false;
                bl = false;
                void $this$fragmentFactoryCode_u24lambda_u2d3_u24lambda_u2d2 = var22_51;
                boolean bl6 = false;
                $this$fragmentFactoryCode_u24lambda_u2d3_u24lambda_u2d2.add(", ", new Object[0]);
                v0 = var22_51;
            } else {
                v0 = $this$applyIf$iv;
            }
            $this$applyIf$iv = new Object[]{type};
            accumulator$iv = v0.add(CodeBlock.of((String)"$S", (Object[])$this$applyIf$iv));
        }
        $this$foldIndexed$iv2 = accumulator$iv.build();
        boolean initial$iv322 = false;
        $i$f$foldIndexed = false;
        CodeBlock code = $this$foldIndexed$iv2;
        boolean bl7 = false;
        if (code.isEmpty()) {
            codeBlock2 = CodeBlock.of((String)"", (Object[])new Object[0]);
        } else {
            Object item$iv$iv;
            item$iv$iv = new Object[]{ResponseField.Condition.class, ClassNames.INSTANCE.getSTRING()};
            codeBlock2 = CodeBlock.builder().add("$T.typeCondition(new $T[] {", (Object[])item$iv$iv).add(code).add("})", new Object[0]).build();
        }
        CodeBlock typeCondition = codeBlock2;
        Iterable initial$iv322 = CollectionsKt.plus((Collection)booleanConditions, typeCondition);
        boolean $i$f$filter2 = false;
        code = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CodeBlock code2 = (CodeBlock)element$iv$iv;
            boolean bl8 = false;
            if (!(!code2.isEmpty())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        CodeBlock.Builder initial$iv = CodeBlock.builder();
        boolean $i$f$foldIndexed2 = false;
        int index$iv2 = 0;
        CodeBlock.Builder accumulator$iv2 = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void code3;
            void v2;
            void $this$applyIf$iv;
            void builder3;
            int n2 = index$iv2++;
            boolean bl9 = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            builder = (CodeBlock)element$iv;
            CodeBlock.Builder index = accumulator$iv2;
            int index2 = n2;
            boolean bl10 = false;
            void condition$iv = builder3;
            boolean condition$iv2 = index2 > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv2) {
                void var23_54 = $this$applyIf$iv;
                bl = false;
                boolean bl11 = false;
                void $this$fragmentFactoryCode_u24lambda_u2d7_u24lambda_u2d6 = var23_54;
                boolean bl12 = false;
                $this$fragmentFactoryCode_u24lambda_u2d7_u24lambda_u2d6.add(",\n", new Object[0]);
                v2 = var23_54;
            } else {
                v2 = $this$applyIf$iv;
            }
            accumulator$iv2 = v2.add((CodeBlock)code3);
        }
        CodeBlock codeBlock4 = accumulator$iv2.build();
        boolean bl13 = false;
        boolean bl14 = false;
        CodeBlock code4 = codeBlock4;
        boolean bl15 = false;
        if (code4.isEmpty()) {
            objectArray = new Object[]{Collections.class, ResponseField.Condition.class};
            codeBlock = CodeBlock.of((String)"$T.<$T>emptyList()", (Object[])objectArray);
        } else {
            objectArray = new Object[]{Arrays.class, ResponseField.Condition.class};
            codeBlock = CodeBlock.builder().add("$T.<$T>asList(\n", objectArray).indent().add(code4).unindent().add("\n)", new Object[0]).build();
        }
        CodeBlock conditions = codeBlock;
        Object[] objectArray3 = new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), conditions};
        codeBlock4 = CodeBlock.of((String)"$T.$L($S, $S, $L)", (Object[])objectArray3);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock4, "of(\"\\$T.\\$L(\\$S, \\$S, \\$L)\", ResponseField::class.java, factoryMethod, irField.responseName, irField.fieldName,\n        conditions)");
        return codeBlock4;
    }

    private final CodeBlock genericFactoryCode(Field irField, String factoryMethod) {
        Object[] objectArray = new Object[]{ResponseField.class, factoryMethod, irField.getResponseName(), irField.getFieldName(), irField.argumentCodeBlock(), irField.isOptional(), this.booleanConditionsCode(irField.getConditions())};
        CodeBlock codeBlock = CodeBlock.of((String)"$T.$L($S, $S, $L, $L, $L)", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$T.\\$L(\\$S, \\$S, \\$L, \\$L, \\$L)\", ResponseField::class.java, factoryMethod,\n        irField.responseName, irField.fieldName, irField.argumentCodeBlock(), irField.isOptional(),\n        booleanConditionsCode(irField.conditions))");
        return codeBlock;
    }

    private final CodeBlock readEnumCode(CodeBlock readerParam, CodeBlock fieldParam) {
        Object[] objectArray = new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name};
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("final $T $L", objectArray);
        objectArray = new Object[]{this.fieldSpec.name};
        CodeBlock.Builder builder2 = builder.beginControlFlow("if ($LStr != null)", objectArray);
        objectArray = new Object[]{this.fieldSpec.name, this.normalizedFieldSpec.type, TypeDeclaration.Companion.getENUM_SAFE_VALUE_OF(), this.fieldSpec.name};
        CodeBlock.Builder builder3 = builder2.addStatement("$L = $T.$L($LStr)", objectArray).nextControlFlow("else", new Object[0]);
        objectArray = new Object[]{this.fieldSpec.name};
        CodeBlock readValueCode = builder3.addStatement("$L = null", objectArray).endControlFlow().build();
        Object[] objectArray2 = new Object[]{ClassNames.INSTANCE.getSTRING(), this.fieldSpec.name, readerParam, READ_METHODS.get((Object)ResponseField.Type.STRING), fieldParam};
        objectArray = CodeBlock.builder().addStatement("final $T $LStr = $L.$L($L)", objectArray2).add(readValueCode).build();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "builder()\n        .addStatement(\"final \\$T \\$LStr = \\$L.\\$L(\\$L)\", ClassNames.STRING, fieldSpec.name, readerParam,\n            READ_METHODS[ResponseField.Type.STRING], fieldParam)\n        .add(readValueCode)\n        .build()");
        return objectArray;
    }

    private final CodeBlock readScalarCode(CodeBlock readerParam, CodeBlock fieldParam) {
        Object[] objectArray = new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get((Object)this.responseFieldType), fieldParam};
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"final \\$T \\$L = \\$L.\\$L(\\$L);\\n\", normalizedFieldSpec.type, fieldSpec.name, readerParam,\n        READ_METHODS[responseFieldType], fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readCustomCode(CodeBlock readerParam, CodeBlock fieldParam) {
        Object[] objectArray = new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get((Object)this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam};
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.$L(($T) $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"final \\$T \\$L = \\$L.\\$L((\\$T) \\$L);\\n\", normalizedFieldSpec.type, fieldSpec.name, readerParam,\n        READ_METHODS[responseFieldType], ResponseField.CustomTypeField::class.java, fieldParam)");
        return codeBlock;
    }

    private final CodeBlock readObjectCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]);
        Modifier[] modifierArray = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "normalizedFieldSpec.type");
        TypeSpec.Builder builder2 = builder.superclass((TypeName)this.responseFieldObjectReaderType((TypeName)modifierArray));
        modifierArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"read").addModifiers(modifierArray).addAnnotation(Override.class).returns(this.normalizedFieldSpec.type).addParameter(RESPONSE_READER_PARAM);
        modifierArray = new Object[2];
        Object[] objectArray = this.normalizedFieldSpec.type;
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        modifierArray[0] = TestUtilsKt.mapperFieldName((ClassName)objectArray);
        modifierArray[1] = ResponseFieldSpec.RESPONSE_READER_PARAM.name;
        TypeSpec readerTypeSpec = builder2.addMethod(builder3.addStatement("return $L.map($L)", (Object[])modifierArray).build()).build();
        objectArray = new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get((Object)this.responseFieldType), fieldParam, readerTypeSpec};
        modifierArray = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "of(\"final \\$T \\$L = \\$L.\\$L(\\$L, \\$L);\\n\", normalizedFieldSpec.type, fieldSpec.name, readerParam,\n        READ_METHODS[responseFieldType], fieldParam, readerTypeSpec)");
        return modifierArray;
    }

    private final CodeBlock readListItemStatement(TypeName rawFieldType) {
        if (!TestUtilsKt.isList(rawFieldType)) {
            if (TestUtilsKt.isCustomScalarType(this.irField.getType(), this.context)) {
                return ResponseFieldSpec.readListItemStatement$readCustom(this);
            }
            if (TestUtilsKt.isScalar(rawFieldType, this.context)) {
                return ResponseFieldSpec.readListItemStatement$readScalar(rawFieldType, this);
            }
            return ResponseFieldSpec.readListItemStatement$readObject(this, rawFieldType);
        }
        return ResponseFieldSpec.readListItemStatement$readList(rawFieldType, this);
    }

    private final CodeBlock readListCode(CodeBlock readerParam, CodeBlock fieldParam) {
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(typeName, "normalizedFieldSpec.type");
        TypeName rawFieldType = TestUtilsKt.listParamType(typeName);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec readerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this.responseFieldListItemReaderType(rawFieldType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(modifierArray).addAnnotation(Override.class).returns(rawFieldType).addParameter(RESPONSE_LIST_ITEM_READER_PARAM).addCode(this.readListItemStatement(rawFieldType)).build()).build();
        Object[] objectArray = new Object[]{this.normalizedFieldSpec.type, this.fieldSpec.name, readerParam, READ_METHODS.get((Object)this.responseFieldType), fieldParam, readerTypeSpec};
        modifierArray = CodeBlock.of((String)"final $T $L = $L.$L($L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "of(\"final \\$T \\$L = \\$L.\\$L(\\$L, \\$L);\\n\", normalizedFieldSpec.type, fieldSpec.name, readerParam,\n        READ_METHODS[responseFieldType], fieldParam, readerTypeSpec)");
        return modifierArray;
    }

    private final CodeBlock readFragmentsCode() {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.normalizedFieldSpec.type;
        objectArray[1] = this.fieldSpec.name;
        TypeName typeName = this.normalizedFieldSpec.type;
        if (typeName == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.squareup.javapoet.ClassName");
        }
        objectArray[2] = TestUtilsKt.mapperFieldName((ClassName)typeName);
        objectArray[3] = ResponseFieldSpec.RESPONSE_READER_PARAM.name;
        CodeBlock codeBlock = CodeBlock.of((String)"final $T $L = $L.map($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"final \\$T \\$L = \\$L.map(\\$L);\\n\", normalizedFieldSpec.type, fieldSpec.name,\n        (normalizedFieldSpec.type as ClassName).mapperFieldName(), RESPONSE_READER_PARAM.name)");
        return codeBlock;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam, CodeBlock fieldParam) {
        Object object = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.type");
        TypeName typeName = object;
        object = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.name");
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(typeName, (String)object, false, null, 6, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.responseFieldType), fieldParam, valueCode2};
        object = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(object, "of(\"\\$L.\\$L(\\$L, \\$L);\\n\", writerParam, WRITE_METHODS[responseFieldType],\n        fieldParam, valueCode)");
        return object;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam, CodeBlock fieldParam) {
        Object object = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.type");
        TypeName typeName = object;
        object = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.name");
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(typeName, (String)object, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.responseFieldType), fieldParam, valueCode2};
        object = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(object, "of(\"\\$L.\\$L(\\$L, \\$L);\\n\", writerParam, WRITE_METHODS[responseFieldType],\n        fieldParam, valueCode)");
        return object;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam, CodeBlock fieldParam) {
        Object object = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.type");
        TypeName typeName = object;
        object = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.name");
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(typeName, (String)object, false, null, 6, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.responseFieldType), ResponseField.CustomTypeField.class, fieldParam, valueCode2};
        object = CodeBlock.of((String)"$L.$L(($T) $L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(object, "of(\"\\$L.\\$L((\\$T) \\$L, \\$L);\\n\", writerParam, WRITE_METHODS[responseFieldType],\n        ResponseField.CustomTypeField::class.java, fieldParam, valueCode)");
        return object;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller2) {
        Object object = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.type");
        TypeName typeName = object;
        object = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.name");
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(typeName, (String)object, false, new Function1<CodeBlock, CodeBlock>(marshaller2){
            final /* synthetic */ CodeBlock $marshaller;
            {
                this.$marshaller = $marshaller;
                super(1);
            }

            @NotNull
            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Object[] objectArray = new Object[]{it, this.$marshaller};
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
        }, 2, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.responseFieldType), fieldParam, valueCode2};
        object = CodeBlock.of((String)"$L.$L($L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(object, "of(\"\\$L.\\$L(\\$L, \\$L);\\n\", writerParam, WRITE_METHODS[responseFieldType], fieldParam, valueCode)");
        return object;
    }

    private final CodeBlock writeListItemStatement(TypeName listItemType, CodeBlock marshaller2) {
        CodeBlock codeBlock = TestUtilsKt.isList(listItemType) ? ResponseFieldSpec.writeListItemStatement$writeList(listItemType, this, marshaller2) : (TestUtilsKt.isCustomScalarType(this.irField.getType(), this.context) ? ResponseFieldSpec.writeListItemStatement$writeCustom(this) : (TestUtilsKt.isScalar(listItemType, this.context) ? ResponseFieldSpec.writeListItemStatement$writeScalar(listItemType, this) : ResponseFieldSpec.writeListItemStatement$writeObject(listItemType, marshaller2)));
        boolean bl = false;
        boolean bl2 = false;
        CodeBlock it = codeBlock;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{TypeName.OBJECT, ResponseFieldSpec.ITEM_VALUE_PARAM.name, ResponseFieldSpec.ITEMS_VALUE_PARAM.name};
        CodeBlock codeBlock2 = CodeBlock.builder().beginControlFlow("for ($T $L : $L)", objectArray).add(it).endControlFlow().build();
        Intrinsics.checkExpressionValueIsNotNull(codeBlock2, "when {\n      listItemType.isList() -> writeList()\n      irField.type.isCustomScalarType(context) -> writeCustom()\n      listItemType.isScalar(context) -> writeScalar()\n      else -> writeObject()\n    }.let {\n      CodeBlock.builder()\n          .beginControlFlow(\"for (\\$T \\$L : \\$L)\", TypeName.OBJECT, ITEM_VALUE_PARAM.name, ITEMS_VALUE_PARAM.name)\n          .add(it)\n          .endControlFlow()\n          .build()\n    }");
        return codeBlock2;
    }

    private final CodeBlock writeListCode(CodeBlock writerParam, CodeBlock fieldParam, CodeBlock marshaller2) {
        TypeName typeName = this.normalizedFieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(typeName, "normalizedFieldSpec.type");
        TypeName listItemType = TestUtilsKt.listParamType(typeName);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(modifierArray).addAnnotation(Override.class).addParameter(ITEMS_VALUE_PARAM).addParameter(RESPONSE_LIST_ITEM_WRITER_PARAM).addCode(this.writeListItemStatement(listItemType, marshaller2)).build()).build();
        Object[] objectArray = new Object[5];
        objectArray[0] = writerParam;
        objectArray[1] = WRITE_METHODS.get((Object)this.responseFieldType);
        objectArray[2] = fieldParam;
        Object object = this.fieldSpec.type;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.type");
        TypeName typeName2 = object;
        object = this.fieldSpec.name;
        Intrinsics.checkExpressionValueIsNotNull(object, "fieldSpec.name");
        objectArray[3] = TestUtilsKt.unwrapOptionalValue$default(typeName2, (String)object, false, null, 6, null);
        objectArray[4] = listWriterType;
        modifierArray = CodeBlock.of((String)"$L.$L($L, $L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "of(\"\\$L.\\$L(\\$L, \\$L, \\$L);\\n\", writerParam, WRITE_METHODS[responseFieldType], fieldParam,\n        fieldSpec.type.unwrapOptionalValue(fieldSpec.name), listWriterType)");
        return modifierArray;
    }

    private final CodeBlock writeFragmentCode(CodeBlock writerParam, CodeBlock marshaller2) {
        Object[] objectArray = new Object[]{this.fieldSpec.name, marshaller2, writerParam};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L.marshal(\\$L);\\n\", fieldSpec.name, marshaller, writerParam)");
        return codeBlock;
    }

    private final CodeBlock writeFragmentsCode(CodeBlock writerParam, CodeBlock marshaller2) {
        Object[] objectArray = new Object[]{this.fieldSpec.name, marshaller2, writerParam};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L.marshal($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L.marshal(\\$L);\\n\", fieldSpec.name, marshaller, writerParam)");
        return codeBlock;
    }

    private final ParameterizedTypeName responseFieldObjectReaderType(TypeName type) {
        TypeName[] typeNameArray = new TypeName[]{type};
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ObjectReader.class), (TypeName[])typeNameArray);
    }

    private final ParameterizedTypeName responseFieldListItemReaderType(TypeName type) {
        TypeName[] typeNameArray = new TypeName[]{type};
        return ParameterizedTypeName.get((ClassName)ClassName.get(ResponseReader.ListReader.class), (TypeName[])typeNameArray);
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBlock booleanConditionsCode(List<Condition> conditions) {
        CodeBlock codeBlock;
        Object[] objectArray;
        void $this$foldIndexed$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = conditions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Condition it = (Condition)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getKind(), Condition.Kind.BOOLEAN.getRawValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        CodeBlock.Builder initial$iv = CodeBlock.builder();
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        CodeBlock.Builder accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void condition;
            void v0;
            void $this$applyIf$iv;
            void builder;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Condition condition2 = (Condition)element$iv;
            CodeBlock.Builder builder2 = accumulator$iv;
            int index = n;
            boolean bl2 = false;
            Object[] objectArray2 = builder;
            boolean condition$iv = index > 0;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void var19_26 = $this$applyIf$iv;
                boolean bl3 = false;
                boolean bl4 = false;
                void $this$booleanConditionsCode_u24lambda_u2d13_u24lambda_u2d12 = var19_26;
                boolean bl5 = false;
                $this$booleanConditionsCode_u24lambda_u2d13_u24lambda_u2d12.add(",\n", new Object[0]);
                v0 = var19_26;
            } else {
                v0 = $this$applyIf$iv;
            }
            objectArray2 = new Object[]{ResponseField.Condition.class, condition.getVariableName(), condition.getInverted()};
            accumulator$iv = v0.add("$T.booleanCondition($S, $L)", objectArray2);
        }
        CodeBlock codeBlock2 = accumulator$iv.build();
        boolean bl = false;
        boolean bl6 = false;
        CodeBlock code = codeBlock2;
        boolean bl7 = false;
        if (code.isEmpty()) {
            objectArray = new Object[]{Collections.class, ResponseField.Condition.class};
            codeBlock = CodeBlock.of((String)"$T.<$T>emptyList()", (Object[])objectArray);
        } else {
            objectArray = new Object[]{Arrays.class, ResponseField.Condition.class};
            codeBlock = CodeBlock.builder().add("$T.<$T>asList(\n", objectArray).indent().add(code).unindent().add("\n)", new Object[0]).build();
        }
        CodeBlock codeBlock3 = codeBlock;
        Intrinsics.checkExpressionValueIsNotNull(codeBlock3, "conditions.filter { it.kind == Condition.Kind.BOOLEAN.rawValue }\n        .foldIndexed(CodeBlock.builder()) { index, builder, condition ->\n          builder.applyIf(index > 0) { add(\",\\n\") }.add(\n              \"\\$T.booleanCondition(\\$S, \\$L)\", ResponseField.Condition::class.java, condition.variableName, condition.inverted\n          )\n        }.build().let { code ->\n          if (code.isEmpty) {\n            CodeBlock.of(\"\\$T.<\\$T>emptyList()\", Collections::class.java, ResponseField.Condition::class.java)\n          } else {\n            CodeBlock.builder()\n                .add(\"\\$T.<\\$T>asList(\\n\", Arrays::class.java, ResponseField.Condition::class.java)\n                .indent().add(code).unindent()\n                .add(\"\\n)\")\n                .build()\n          }\n        }");
        return codeBlock3;
    }

    private static final CodeBlock readListItemStatement$readScalar(TypeName $rawFieldType, ResponseFieldSpec this$0) {
        String string;
        String readMethod;
        String string2 = SCALAR_LIST_ITEM_READ_METHODS.get($rawFieldType);
        String string3 = readMethod = string2 == null ? "readString" : string2;
        if (TestUtilsKt.isEnum($rawFieldType, this$0.context)) {
            Object[] objectArray = new Object[]{$rawFieldType, TypeDeclaration.Companion.getENUM_SAFE_VALUE_OF(), ResponseFieldSpec.RESPONSE_LIST_ITEM_READER_PARAM.name, readMethod};
            string2 = CodeBlock.of((String)"return $T.$L($L.$L());\n", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull(string2, "{\n        CodeBlock.of(\"return \\$T.\\$L(\\$L.\\$L());\\n\", rawFieldType, TypeDeclaration.ENUM_SAFE_VALUE_OF,\n            RESPONSE_LIST_ITEM_READER_PARAM.name, readMethod)\n      }");
            string = string2;
        } else {
            Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_READER_PARAM.name, readMethod};
            string2 = CodeBlock.of((String)"return $L.$L();\n", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull(string2, "{\n        CodeBlock.of(\"return \\$L.\\$L();\\n\", RESPONSE_LIST_ITEM_READER_PARAM.name, readMethod)\n      }");
            string = string2;
        }
        return string;
    }

    private static final CodeBlock readListItemStatement$readCustom(ResponseFieldSpec this$0) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this$0.context);
        String string = TestUtilsKt.normalizeGraphQlType(this$0.irField.getType(), true);
        Object[] objectArray = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "ENGLISH");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase((Locale)objectArray);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string4;
        objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_READER_PARAM.name, customScalarEnum, customScalarEnumConst};
        string = CodeBlock.of((String)"return $L.readCustomType($T.$L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(string, "of(\"return \\$L.readCustomType(\\$T.\\$L);\\n\", RESPONSE_LIST_ITEM_READER_PARAM.name,\n          customScalarEnum, customScalarEnumConst)");
        return string;
    }

    private static final CodeBlock readListItemStatement$readObject(ResponseFieldSpec this$0, TypeName $rawFieldType) {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"read").addModifiers(objectArray).addAnnotation(Override.class).returns($rawFieldType).addParameter(RESPONSE_READER_PARAM);
        objectArray = new Object[]{TestUtilsKt.mapperFieldName((ClassName)$rawFieldType), ResponseFieldSpec.RESPONSE_READER_PARAM.name};
        TypeSpec objectReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this$0.responseFieldObjectReaderType($rawFieldType)).addMethod(builder.addStatement("return $L.map($L)", objectArray).build()).build();
        Object[] objectArray2 = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_READER_PARAM.name, objectReaderTypeSpec};
        objectArray = CodeBlock.of((String)"return $L.readObject($L);\n", (Object[])objectArray2);
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "of(\"return \\$L.readObject(\\$L);\\n\", RESPONSE_LIST_ITEM_READER_PARAM.name, objectReaderTypeSpec)");
        return objectArray;
    }

    private static final CodeBlock readListItemStatement$readList(TypeName $rawFieldType, ResponseFieldSpec this$0) {
        TypeName listItemType = TestUtilsKt.listParamType($rawFieldType);
        CodeBlock readItemCode = this$0.readListItemStatement(listItemType);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec listItemReaderTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)this$0.responseFieldListItemReaderType(listItemType)).addMethod(MethodSpec.methodBuilder((String)"read").addModifiers(modifierArray).addAnnotation(Override.class).returns(listItemType).addParameter(RESPONSE_LIST_ITEM_READER_PARAM).addCode(readItemCode).build()).build();
        Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_READER_PARAM.name, listItemReaderTypeSpec};
        modifierArray = CodeBlock.of((String)"return $L.readList($L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "of(\"return \\$L.readList(\\$L);\\n\", RESPONSE_LIST_ITEM_READER_PARAM.name, listItemReaderTypeSpec)");
        return modifierArray;
    }

    private static final CodeBlock writeListItemStatement$writeScalar(TypeName $listItemType, ResponseFieldSpec this$0) {
        CodeBlock.Builder builder;
        String string = SCALAR_LIST_ITEM_WRITE_METHODS.get($listItemType);
        String writeMethod = string == null ? "writeString" : string;
        CodeBlock.Builder builder2 = CodeBlock.builder();
        boolean bl = false;
        boolean bl2 = false;
        CodeBlock.Builder it = builder2;
        boolean bl3 = false;
        if (TestUtilsKt.isEnum($listItemType, this$0.getContext())) {
            Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_WRITER_PARAM.name, writeMethod, $listItemType, ResponseFieldSpec.ITEM_VALUE_PARAM.name};
            builder = it.addStatement("$L.$L((($T) $L).rawValue())", objectArray);
        } else {
            Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_WRITER_PARAM.name, writeMethod, $listItemType, ResponseFieldSpec.ITEM_VALUE_PARAM.name};
            builder = it.addStatement("$L.$L(($T) $L)", objectArray);
        }
        string = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(string, "builder().let {\n        if (listItemType.isEnum(context)) {\n          it.addStatement(\"\\$L.\\$L(((\\$T) \\$L).rawValue())\", RESPONSE_LIST_ITEM_WRITER_PARAM.name, writeMethod,\n              listItemType, ITEM_VALUE_PARAM.name)\n        } else {\n          it.addStatement(\n              \"\\$L.\\$L((\\$T) \\$L)\", RESPONSE_LIST_ITEM_WRITER_PARAM.name, writeMethod, listItemType,\n              ITEM_VALUE_PARAM.name\n          )\n        }\n      }.build()");
        return string;
    }

    private static final CodeBlock writeListItemStatement$writeCustom(ResponseFieldSpec this$0) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this$0.context);
        String string = TestUtilsKt.normalizeGraphQlType(this$0.irField.getType(), true);
        Object[] objectArray = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "ENGLISH");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase((Locale)objectArray);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string4;
        objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_WRITER_PARAM.name, customScalarEnum, customScalarEnumConst, ResponseFieldSpec.ITEM_VALUE_PARAM.name};
        string = CodeBlock.builder().addStatement("$L.writeCustom($T.$L, $L)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull(string, "builder()\n          .addStatement(\"\\$L.writeCustom(\\$T.\\$L, \\$L)\", RESPONSE_LIST_ITEM_WRITER_PARAM.name,\n              customScalarEnum, customScalarEnumConst, ITEM_VALUE_PARAM.name)\n          .build()");
        return string;
    }

    private static final CodeBlock writeListItemStatement$writeObject(TypeName $listItemType, CodeBlock $marshaller) {
        Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_WRITER_PARAM.name, $listItemType, ResponseFieldSpec.ITEM_VALUE_PARAM.name, $marshaller};
        CodeBlock codeBlock = CodeBlock.builder().addStatement("$L.writeObject((($T) $L).$L)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "builder()\n          .addStatement(\"\\$L.writeObject(((\\$T) \\$L).\\$L)\", RESPONSE_LIST_ITEM_WRITER_PARAM.name, listItemType,\n              ITEM_VALUE_PARAM.name, marshaller)\n          .build()");
        return codeBlock;
    }

    private static final CodeBlock writeListItemStatement$writeList(TypeName $listItemType, ResponseFieldSpec this$0, CodeBlock $marshaller) {
        TypeName rawFieldType = TestUtilsKt.listParamType($listItemType);
        CodeBlock readItemCode = this$0.writeListItemStatement(rawFieldType, $marshaller);
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec listWriterType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((Type)((Object)ResponseWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(modifierArray).addAnnotation(Override.class).addParameter(ITEMS_VALUE_PARAM).addParameter(RESPONSE_LIST_ITEM_WRITER_PARAM).addCode(readItemCode).build()).build();
        Object[] objectArray = new Object[]{ResponseFieldSpec.RESPONSE_LIST_ITEM_WRITER_PARAM.name, ClassNames.INSTANCE.getLIST(), ResponseFieldSpec.ITEM_VALUE_PARAM.name, listWriterType};
        modifierArray = CodeBlock.builder().addStatement("$L.writeList(($T) $L, $L)", objectArray).build();
        Intrinsics.checkExpressionValueIsNotNull(modifierArray, "builder()\n          .addStatement(\"\\$L.writeList((\\$T) \\$L, \\$L)\", RESPONSE_LIST_ITEM_WRITER_PARAM.name, ClassNames.LIST,\n              ITEM_VALUE_PARAM.name, listWriterType)\n          .build()");
        return modifierArray;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(ResponseField.Type.STRING, "forString"), TuplesKt.to(ResponseField.Type.INT, "forInt"), TuplesKt.to(ResponseField.Type.LONG, "forLong"), TuplesKt.to(ResponseField.Type.DOUBLE, "forDouble"), TuplesKt.to(ResponseField.Type.BOOLEAN, "forBoolean"), TuplesKt.to(ResponseField.Type.ENUM, "forString"), TuplesKt.to(ResponseField.Type.OBJECT, "forObject"), TuplesKt.to(ResponseField.Type.LIST, "forList"), TuplesKt.to(ResponseField.Type.CUSTOM, "forCustomType"), TuplesKt.to(ResponseField.Type.FRAGMENT, "forFragment"), TuplesKt.to(ResponseField.Type.FRAGMENTS, "forString")};
        FACTORY_METHODS = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(ResponseField.Type.STRING, "readString"), TuplesKt.to(ResponseField.Type.INT, "readInt"), TuplesKt.to(ResponseField.Type.LONG, "readLong"), TuplesKt.to(ResponseField.Type.DOUBLE, "readDouble"), TuplesKt.to(ResponseField.Type.BOOLEAN, "readBoolean"), TuplesKt.to(ResponseField.Type.ENUM, "readString"), TuplesKt.to(ResponseField.Type.OBJECT, "readObject"), TuplesKt.to(ResponseField.Type.LIST, "readList"), TuplesKt.to(ResponseField.Type.CUSTOM, "readCustomType"), TuplesKt.to(ResponseField.Type.FRAGMENT, "readFragment")};
        READ_METHODS = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(ResponseField.Type.STRING, "writeString"), TuplesKt.to(ResponseField.Type.INT, "writeInt"), TuplesKt.to(ResponseField.Type.LONG, "writeLong"), TuplesKt.to(ResponseField.Type.DOUBLE, "writeDouble"), TuplesKt.to(ResponseField.Type.BOOLEAN, "writeBoolean"), TuplesKt.to(ResponseField.Type.ENUM, "writeString"), TuplesKt.to(ResponseField.Type.CUSTOM, "writeCustom"), TuplesKt.to(ResponseField.Type.OBJECT, "writeObject"), TuplesKt.to(ResponseField.Type.LIST, "writeList")};
        WRITE_METHODS = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(ClassNames.INSTANCE.getSTRING(), "readString"), TuplesKt.to(TypeName.INT, "readInt"), TuplesKt.to(TypeName.INT.box(), "readInt"), TuplesKt.to(TypeName.LONG, "readLong"), TuplesKt.to(TypeName.LONG.box(), "readLong"), TuplesKt.to(TypeName.DOUBLE, "readDouble"), TuplesKt.to(TypeName.DOUBLE.box(), "readDouble"), TuplesKt.to(TypeName.BOOLEAN, "readBoolean"), TuplesKt.to(TypeName.BOOLEAN.box(), "readBoolean")};
        SCALAR_LIST_ITEM_READ_METHODS = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(ClassNames.INSTANCE.getSTRING(), "writeString"), TuplesKt.to(TypeName.INT, "writeInt"), TuplesKt.to(TypeName.INT.box(), "writeInt"), TuplesKt.to(TypeName.LONG, "writeLong"), TuplesKt.to(TypeName.LONG.box(), "writeLong"), TuplesKt.to(TypeName.DOUBLE, "writeDouble"), TuplesKt.to(TypeName.DOUBLE.box(), "writeDouble"), TuplesKt.to(TypeName.BOOLEAN, "writeBoolean"), TuplesKt.to(TypeName.BOOLEAN.box(), "writeBoolean")};
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf(pairArray);
        RESPONSE_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.class)), (String)"reader", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_READER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseReader.ListItemReader.class)), (String)"listItemReader", (Modifier[])new Modifier[0]).build();
        ITEMS_VALUE_PARAM = ParameterSpec.builder((Type)((Type)((Object)List.class)), (String)"items", (Modifier[])new Modifier[0]).build();
        ITEM_VALUE_PARAM = ParameterSpec.builder((TypeName)((TypeName)TypeName.OBJECT), (String)"item", (Modifier[])new Modifier[0]).build();
        RESPONSE_LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((Type)((Type)((Object)ResponseWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u0010\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/compiler/ResponseFieldSpec$Companion;", "", "()V", "FACTORY_METHODS", "", "Lcom/apollographql/apollo/api/ResponseField$Type;", "", "ITEMS_VALUE_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "kotlin.jvm.PlatformType", "ITEM_VALUE_PARAM", "READ_METHODS", "RESPONSE_LIST_ITEM_READER_PARAM", "RESPONSE_LIST_ITEM_WRITER_PARAM", "RESPONSE_READER_PARAM", "SCALAR_LIST_ITEM_READ_METHODS", "Lcom/squareup/javapoet/TypeName;", "SCALAR_LIST_ITEM_WRITE_METHODS", "WRITE_METHODS", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseField.Type.values().length];
            nArray[ResponseField.Type.CUSTOM.ordinal()] = 1;
            nArray[ResponseField.Type.FRAGMENT.ordinal()] = 2;
            nArray[ResponseField.Type.STRING.ordinal()] = 3;
            nArray[ResponseField.Type.INT.ordinal()] = 4;
            nArray[ResponseField.Type.LONG.ordinal()] = 5;
            nArray[ResponseField.Type.DOUBLE.ordinal()] = 6;
            nArray[ResponseField.Type.BOOLEAN.ordinal()] = 7;
            nArray[ResponseField.Type.ENUM.ordinal()] = 8;
            nArray[ResponseField.Type.OBJECT.ordinal()] = 9;
            nArray[ResponseField.Type.LIST.ordinal()] = 10;
            nArray[ResponseField.Type.FRAGMENTS.ordinal()] = 11;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

