/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.api.internal.InputFieldWriter;
import com.apollographql.apollo.compiler.ClassNames;
import com.apollographql.apollo.compiler.CustomEnumTypeSpecBuilder;
import com.apollographql.apollo.compiler.InputFieldSpec;
import com.apollographql.apollo.compiler.JavaTypeResolver;
import com.apollographql.apollo.compiler.NullableValueType;
import com.apollographql.apollo.compiler.TestUtilsKt;
import com.apollographql.apollo.compiler.ir.CodeGenerationContext;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 %2\u00020\u0001:\u0002%&B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J \u0010!\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\u0016\u0010$\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec;", "", "type", "Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "name", "", "graphQLType", "javaType", "Lcom/squareup/javapoet/TypeName;", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "(Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;Ljava/lang/String;Ljava/lang/String;Lcom/squareup/javapoet/TypeName;Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;)V", "getContext", "()Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "getGraphQLType", "()Ljava/lang/String;", "getJavaType", "()Lcom/squareup/javapoet/TypeName;", "getName", "normalizedName", "getType", "()Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "listWriter", "Lcom/squareup/javapoet/TypeSpec;", "itemType", "listParam", "Lcom/squareup/javapoet/CodeBlock;", "itemParam", "marshaller", "writeCustomCode", "writerParam", "writeEnumCode", "writeList", "writeListItemStatement", "writeObjectCode", "writeScalarCode", "writeValueCode", "Companion", "Type", "apollo-compiler"})
public final class InputFieldSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    @NotNull
    private final String name;
    @NotNull
    private final String graphQLType;
    @NotNull
    private final TypeName javaType;
    @NotNull
    private final CodeGenerationContext context;
    @NotNull
    private final String normalizedName;
    @NotNull
    private static final Map<Type, String> WRITE_METHODS;
    @NotNull
    private static final Map<TypeName, String> SCALAR_LIST_ITEM_WRITE_METHODS;
    private static final ParameterSpec LIST_ITEM_WRITER_PARAM;

    public InputFieldSpec(@NotNull Type type, @NotNull String name, @NotNull String graphQLType, @NotNull TypeName javaType, @NotNull CodeGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(graphQLType, "graphQLType");
        Intrinsics.checkParameterIsNotNull(javaType, "javaType");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.type = type;
        this.name = name;
        this.graphQLType = graphQLType;
        this.javaType = javaType;
        this.context = context;
        this.normalizedName = TestUtilsKt.escapeJavaReservedWord(StringsKt.decapitalize(this.name));
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getGraphQLType() {
        return this.graphQLType;
    }

    @NotNull
    public final TypeName getJavaType() {
        return this.javaType;
    }

    @NotNull
    public final CodeGenerationContext getContext() {
        return this.context;
    }

    @NotNull
    public final CodeBlock writeValueCode(@NotNull CodeBlock writerParam, @NotNull CodeBlock marshaller2) {
        Type type;
        CodeBlock codeBlock;
        Intrinsics.checkParameterIsNotNull(writerParam, "writerParam");
        Intrinsics.checkParameterIsNotNull(marshaller2, "marshaller");
        Type type2 = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                codeBlock = this.writeScalarCode(writerParam);
                break;
            }
            case 6: {
                codeBlock = this.writeEnumCode(writerParam);
                break;
            }
            case 7: {
                codeBlock = this.writeCustomCode(writerParam);
                break;
            }
            case 8: {
                codeBlock = this.writeObjectCode(writerParam, marshaller2);
                break;
            }
            case 9: {
                codeBlock = this.writeList(writerParam, marshaller2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        type2 = codeBlock;
        n = 0;
        boolean bl = false;
        Type it = type2;
        boolean bl2 = false;
        if (TestUtilsKt.isOptional$default(this.getJavaType(), null, 1, null)) {
            Object[] objectArray = new Object[]{this.normalizedName};
            type = CodeBlock.builder().beginControlFlow("if ($L.defined)", objectArray).add((CodeBlock)it).endControlFlow().build();
        } else {
            type = it;
        }
        Type type3 = type;
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, "when (type) {\n      Type.STRING,\n      Type.INT,\n      Type.LONG,\n      Type.DOUBLE,\n      Type.BOOLEAN -> writeScalarCode(writerParam)\n      Type.ENUM -> writeEnumCode(writerParam)\n      Type.CUSTOM -> writeCustomCode(writerParam)\n      Type.OBJECT -> writeObjectCode(writerParam, marshaller)\n      Type.LIST -> writeList(writerParam, marshaller)\n    }.let {\n      if (javaType.isOptional()) {\n        CodeBlock.builder()\n            .beginControlFlow(\"if (\\$L.defined)\", normalizedName)\n            .add(it)\n            .endControlFlow()\n            .build()\n      } else {\n        it\n      }\n    }");
        return type3;
    }

    private final CodeBlock writeScalarCode(CodeBlock writerParam) {
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L(\\$S, \\$L);\\n\", writerParam, WRITE_METHODS[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeEnumCode(CodeBlock writerParam) {
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, writeEnumCode.valueCode.1.INSTANCE, 2, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L(\\$S, \\$L);\\n\", writerParam, WRITE_METHODS[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeCustomCode(CodeBlock writerParam) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this.context);
        String string = TestUtilsKt.normalizeGraphQlType$default(this.graphQLType, false, 2, null);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull(locale, "ENGLISH");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string4;
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 6, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, customScalarEnum, customScalarEnumConst, valueCode2};
        locale = CodeBlock.of((String)"$L.$L($S, $L.$L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(locale, "of(\"\\$L.\\$L(\\$S, \\$L.\\$L, \\$L);\\n\", writerParam, WRITE_METHODS[type],\n        name, customScalarEnum, customScalarEnumConst, valueCode)");
        return locale;
    }

    private final CodeBlock writeObjectCode(CodeBlock writerParam, CodeBlock marshaller2) {
        CodeBlock valueCode2 = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, new Function1<CodeBlock, CodeBlock>(marshaller2){
            final /* synthetic */ CodeBlock $marshaller;
            {
                this.$marshaller = $marshaller;
                super(1);
            }

            @NotNull
            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Object[] objectArray = new Object[]{it, this.$marshaller};
                CodeBlock codeBlock = CodeBlock.of((String)"$L.$L", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L\", it, marshaller)");
                return codeBlock;
            }
        }, 2, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)this.type), this.name, valueCode2};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L(\\$S, \\$L);\\n\", writerParam, WRITE_METHODS[type], name, valueCode)");
        return codeBlock;
    }

    private final CodeBlock writeList(CodeBlock writerParam, CodeBlock marshaller2) {
        CodeBlock unwrappedListValue = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, null, 4, null);
        TypeName typeName = TestUtilsKt.unwrapOptionalType(this.javaType, true);
        boolean bl = false;
        boolean bl2 = false;
        TypeName $this$writeList_u24lambda_u2d1 = typeName;
        boolean bl3 = false;
        TypeName listParamType = TestUtilsKt.isList($this$writeList_u24lambda_u2d1) ? TestUtilsKt.listParamType($this$writeList_u24lambda_u2d1) : $this$writeList_u24lambda_u2d1;
        CodeBlock listWriterCode2 = TestUtilsKt.unwrapOptionalValue$default(this.javaType, this.normalizedName, false, new Function1<CodeBlock, CodeBlock>(this, listParamType, unwrappedListValue, marshaller2){
            final /* synthetic */ InputFieldSpec this$0;
            final /* synthetic */ TypeName $listParamType;
            final /* synthetic */ CodeBlock $unwrappedListValue;
            final /* synthetic */ CodeBlock $marshaller;
            {
                this.this$0 = $receiver;
                this.$listParamType = $listParamType;
                this.$unwrappedListValue = $unwrappedListValue;
                this.$marshaller = $marshaller;
                super(1);
            }

            @NotNull
            public final CodeBlock invoke(@NotNull CodeBlock it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Object[] objectArray = new Object[]{InputFieldSpec.access$listWriter(this.this$0, this.$listParamType, this.$unwrappedListValue, "$item", this.$marshaller)};
                CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L\", listWriter(listParamType, unwrappedListValue, \"\\$item\", marshaller))");
                return codeBlock;
            }
        }, 2, null);
        Object[] objectArray = new Object[]{writerParam, WRITE_METHODS.get((Object)Type.LIST), this.name, listWriterCode2};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.$L($S, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L(\\$S, \\$L);\\n\", writerParam, WRITE_METHODS[Type.LIST], name, listWriterCode)");
        return codeBlock;
    }

    private final TypeSpec listWriter(TypeName itemType, CodeBlock listParam, String itemParam, CodeBlock marshaller2) {
        Object[] objectArray = new Object[]{itemType, itemParam, listParam};
        CodeBlock writeStatement = CodeBlock.builder().beginControlFlow("for (final $T $L : $L)", objectArray).add(this.writeListItemStatement(itemType, itemParam, marshaller2)).endControlFlow().build();
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        objectArray = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((java.lang.reflect.Type)((Object)InputFieldWriter.ListWriter.class)).addMethod(MethodSpec.methodBuilder((String)"write").addModifiers(modifierArray).addAnnotation(Override.class).addException((java.lang.reflect.Type)((Object)IOException.class)).addParameter(LIST_ITEM_WRITER_PARAM).addCode(writeStatement).build()).build();
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "anonymousClassBuilder(\"\")\n        .addSuperinterface(InputFieldWriter.ListWriter::class.java)\n        .addMethod(MethodSpec.methodBuilder(\"write\")\n            .addModifiers(Modifier.PUBLIC)\n            .addAnnotation(Override::class.java)\n            .addException(IOException::class.java)\n            .addParameter(LIST_ITEM_WRITER_PARAM)\n            .addCode(writeStatement)\n            .build()\n        )\n        .build()");
        return objectArray;
    }

    private final CodeBlock writeListItemStatement(TypeName itemType, String itemParam, CodeBlock marshaller2) {
        if (!TestUtilsKt.isList(itemType)) {
            if (TestUtilsKt.isCustomScalarType(this.graphQLType, this.context)) {
                return InputFieldSpec.writeListItemStatement$writeCustom(this, itemParam);
            }
            if (TestUtilsKt.isScalar(itemType, this.context)) {
                return InputFieldSpec.writeListItemStatement$writeScalar(itemType, this, itemParam);
            }
            return InputFieldSpec.writeListItemStatement$writeObject(itemParam, marshaller2);
        }
        return InputFieldSpec.writeListItemStatement$writeList(itemType, this, itemParam, marshaller2);
    }

    private static final CodeBlock writeListItemStatement$writeList(TypeName $itemType, InputFieldSpec this$0, String $itemParam, CodeBlock $marshaller) {
        TypeName typeName = TestUtilsKt.unwrapOptionalType($itemType, true);
        boolean bl = false;
        boolean bl2 = false;
        TypeName $this$writeListItemStatement_u24writeList_u24lambda_u2d2 = typeName;
        boolean bl3 = false;
        TypeName nestedListItemParamType = TestUtilsKt.isList($this$writeListItemStatement_u24writeList_u24lambda_u2d2) ? TestUtilsKt.listParamType($this$writeListItemStatement_u24writeList_u24lambda_u2d2) : $this$writeListItemStatement_u24writeList_u24lambda_u2d2;
        Object[] objectArray = new Object[]{$itemParam};
        CodeBlock codeBlock = CodeBlock.of((String)"$L", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L\", itemParam)");
        TypeSpec nestedListWriter = this$0.listWriter(nestedListItemParamType, codeBlock, Intrinsics.stringPlus("$", $itemParam), $marshaller);
        objectArray = new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, WRITE_METHODS.get((Object)Type.LIST), $itemParam, nestedListWriter};
        codeBlock = CodeBlock.of((String)"$L.$L($L != null ? $L : null);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\"\\$L.\\$L(\\$L != null ? \\$L : null);\\n\", LIST_ITEM_WRITER_PARAM.name, WRITE_METHODS[Type.LIST],\n          itemParam, nestedListWriter)");
        return codeBlock;
    }

    private static final CodeBlock writeListItemStatement$writeCustom(InputFieldSpec this$0, String $itemParam) {
        ClassName customScalarEnum = CustomEnumTypeSpecBuilder.Companion.className(this$0.context);
        String string = TestUtilsKt.normalizeGraphQlType(this$0.graphQLType, true);
        Object[] objectArray = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull(objectArray, "ENGLISH");
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase((Locale)objectArray);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toUpperCase(locale)");
        String customScalarEnumConst = string4;
        objectArray = new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, customScalarEnum, customScalarEnumConst, $itemParam};
        string = CodeBlock.of((String)"$L.writeCustom($T.$L, $L);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(string, "of(\"\\$L.writeCustom(\\$T.\\$L, \\$L);\\n\", LIST_ITEM_WRITER_PARAM.name, customScalarEnum,\n          customScalarEnumConst, itemParam)");
        return string;
    }

    private static final CodeBlock writeListItemStatement$writeScalar(TypeName $itemType, InputFieldSpec this$0, String $itemParam) {
        String string;
        String writeMethod;
        String string2 = SCALAR_LIST_ITEM_WRITE_METHODS.get($itemType);
        String string3 = writeMethod = string2 == null ? "writeString" : string2;
        if (TestUtilsKt.isEnum($itemType, this$0.context)) {
            Object[] objectArray = new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, writeMethod, $itemParam, $itemParam};
            string2 = CodeBlock.of((String)"$L.$L($L != null ? $L.rawValue() : null);\n", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull(string2, "{\n        CodeBlock.of(\n            \"\\$L.\\$L(\\$L != null ? \\$L.rawValue() : null);\\n\",\n            LIST_ITEM_WRITER_PARAM.name, writeMethod, itemParam, itemParam\n        )\n      }");
            string = string2;
        } else {
            Object[] objectArray = new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, writeMethod, $itemParam};
            string2 = CodeBlock.of((String)"$L.$L($L);\n", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull(string2, "{\n        CodeBlock.of(\"\\$L.\\$L(\\$L);\\n\", LIST_ITEM_WRITER_PARAM.name, writeMethod, itemParam)\n      }");
            string = string2;
        }
        return string;
    }

    private static final CodeBlock writeListItemStatement$writeObject(String $itemParam, CodeBlock $marshaller) {
        Object[] objectArray = new Object[]{InputFieldSpec.LIST_ITEM_WRITER_PARAM.name, $itemParam, $itemParam, $marshaller};
        CodeBlock codeBlock = CodeBlock.of((String)"$L.writeObject($L != null ? $L.$L : null);\n", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull(codeBlock, "of(\n          \"\\$L.writeObject(\\$L != null ? \\$L.\\$L : null);\\n\",\n          LIST_ITEM_WRITER_PARAM.name, itemParam, itemParam, marshaller\n      )");
        return codeBlock;
    }

    public static final /* synthetic */ TypeSpec access$listWriter(InputFieldSpec $this, TypeName itemType, CodeBlock listParam, String itemParam, CodeBlock marshaller2) {
        return $this.listWriter(itemType, listParam, itemParam, marshaller2);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Type.STRING, "writeString"), TuplesKt.to(Type.INT, "writeInt"), TuplesKt.to(Type.LONG, "writeLong"), TuplesKt.to(Type.DOUBLE, "writeDouble"), TuplesKt.to(Type.BOOLEAN, "writeBoolean"), TuplesKt.to(Type.ENUM, "writeString"), TuplesKt.to(Type.CUSTOM, "writeCustom"), TuplesKt.to(Type.OBJECT, "writeObject"), TuplesKt.to(Type.LIST, "writeList")};
        WRITE_METHODS = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(ClassNames.INSTANCE.getSTRING(), "writeString"), TuplesKt.to(TypeName.INT, "writeInt"), TuplesKt.to(TypeName.INT.box(), "writeInt"), TuplesKt.to(TypeName.LONG, "writeLong"), TuplesKt.to(TypeName.LONG.box(), "writeLong"), TuplesKt.to(TypeName.DOUBLE, "writeDouble"), TuplesKt.to(TypeName.DOUBLE.box(), "writeDouble"), TuplesKt.to(TypeName.BOOLEAN, "writeBoolean"), TuplesKt.to(TypeName.BOOLEAN.box(), "writeBoolean")};
        SCALAR_LIST_ITEM_WRITE_METHODS = MapsKt.mapOf(pairArray);
        LIST_ITEM_WRITER_PARAM = ParameterSpec.builder((java.lang.reflect.Type)((java.lang.reflect.Type)((Object)InputFieldWriter.ListItemWriter.class)), (String)"listItemWriter", (Modifier[])new Modifier[0]).build();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\b0\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec$Companion;", "", "()V", "LIST_ITEM_WRITER_PARAM", "Lcom/squareup/javapoet/ParameterSpec;", "kotlin.jvm.PlatformType", "SCALAR_LIST_ITEM_WRITE_METHODS", "", "Lcom/squareup/javapoet/TypeName;", "", "WRITE_METHODS", "Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "build", "Lcom/apollographql/apollo/compiler/InputFieldSpec;", "name", "graphQLType", "context", "Lcom/apollographql/apollo/compiler/ir/CodeGenerationContext;", "nullableValueType", "Lcom/apollographql/apollo/compiler/NullableValueType;", "apollo-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InputFieldSpec build(@NotNull String name, @NotNull String graphQLType, @NotNull CodeGenerationContext context, @NotNull NullableValueType nullableValueType) {
            TypeName typeName;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(graphQLType, "graphQLType");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull((Object)nullableValueType, "nullableValueType");
            TypeName javaType = JavaTypeResolver.resolve$default(new JavaTypeResolver(context, "", false, 4, null), graphQLType, false, nullableValueType, false, 10, null);
            TypeName normalizedJavaType = TestUtilsKt.unwrapOptionalType(javaType, true);
            Type type = TestUtilsKt.isList(normalizedJavaType) ? Type.LIST : (TestUtilsKt.isCustomScalarType(graphQLType, context) ? Type.CUSTOM : (TestUtilsKt.isScalar(normalizedJavaType, context) ? ((Intrinsics.areEqual(typeName = normalizedJavaType, TypeName.INT) ? true : Intrinsics.areEqual(typeName, TypeName.INT.box())) ? Type.INT : ((Intrinsics.areEqual(typeName, TypeName.LONG) ? true : Intrinsics.areEqual(typeName, TypeName.LONG.box())) ? Type.LONG : ((Intrinsics.areEqual(typeName, TypeName.DOUBLE) ? true : Intrinsics.areEqual(typeName, TypeName.DOUBLE.box())) ? Type.DOUBLE : ((Intrinsics.areEqual(typeName, TypeName.BOOLEAN) ? true : Intrinsics.areEqual(typeName, TypeName.BOOLEAN.box())) ? Type.BOOLEAN : (TestUtilsKt.isEnum(normalizedJavaType, context) ? Type.ENUM : Type.STRING))))) : Type.OBJECT));
            Type type2 = type;
            return new InputFieldSpec(type2, name, graphQLType, javaType, context);
        }

        public static /* synthetic */ InputFieldSpec build$default(Companion companion, String string, String string2, CodeGenerationContext codeGenerationContext, NullableValueType nullableValueType, int n, Object object) {
            if ((n & 8) != 0) {
                nullableValueType = NullableValueType.INPUT_TYPE;
            }
            return companion.build(string, string2, codeGenerationContext, nullableValueType);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo/compiler/InputFieldSpec$Type;", "", "(Ljava/lang/String;I)V", "STRING", "INT", "LONG", "DOUBLE", "BOOLEAN", "ENUM", "OBJECT", "LIST", "CUSTOM", "apollo-compiler"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STRING = new Type();
        public static final /* enum */ Type INT = new Type();
        public static final /* enum */ Type LONG = new Type();
        public static final /* enum */ Type DOUBLE = new Type();
        public static final /* enum */ Type BOOLEAN = new Type();
        public static final /* enum */ Type ENUM = new Type();
        public static final /* enum */ Type OBJECT = new Type();
        public static final /* enum */ Type LIST = new Type();
        public static final /* enum */ Type CUSTOM = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            Type[] typeArray = $VALUES;
            return Arrays.copyOf(typeArray, typeArray.length);
        }

        public static Type valueOf(String value) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.STRING, Type.INT, Type.LONG, Type.DOUBLE, Type.BOOLEAN, Type.ENUM, Type.OBJECT, Type.LIST, Type.CUSTOM};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.STRING.ordinal()] = 1;
            nArray[Type.INT.ordinal()] = 2;
            nArray[Type.LONG.ordinal()] = 3;
            nArray[Type.DOUBLE.ordinal()] = 4;
            nArray[Type.BOOLEAN.ordinal()] = 5;
            nArray[Type.ENUM.ordinal()] = 6;
            nArray[Type.CUSTOM.ordinal()] = 7;
            nArray[Type.OBJECT.ordinal()] = 8;
            nArray[Type.LIST.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

