/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import jakarta.xml.bind.JAXBElement;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.axis2.jaxws.wrapper.impl.JAXBWrapperException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyDescriptorPlus {
    PropertyDescriptor descriptor;
    QName xmlName = null;
    private static Log log = LogFactory.getLog(PropertyDescriptorPlus.class);
    private static final boolean DEBUG_ENABLED = log.isDebugEnabled();

    PropertyDescriptorPlus(PropertyDescriptor descriptor, QName xmlName) {
        this.descriptor = descriptor;
        this.xmlName = xmlName;
    }

    PropertyDescriptorPlus(PropertyDescriptor descriptor, String xmlName) {
        this.descriptor = descriptor;
        this.xmlName = new QName("", xmlName);
    }

    public String getXmlName() {
        return this.xmlName.getLocalPart();
    }

    public QName getXmlQName() {
        return this.xmlName;
    }

    public Class getPropertyType() {
        return this.descriptor.getPropertyType();
    }

    public String getPropertyName() {
        return this.descriptor.getName();
    }

    public Object get(Object targetBean) throws InvocationTargetException, IllegalAccessException {
        Method method;
        block7: {
            String propertyName;
            if (this.descriptor == null) {
                throw new RuntimeException(Messages.getMessage((String)"pDescrErr"));
            }
            method = this.descriptor.getReadMethod();
            if (method == null && this.descriptor.getPropertyType() == Boolean.class && (propertyName = this.descriptor.getName()) != null) {
                String methodName = "is";
                methodName = methodName + (propertyName.length() > 0 ? propertyName.substring(0, 1).toUpperCase() : "");
                methodName = methodName + (propertyName.length() > 1 ? propertyName.substring(1) : "");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Method Name =" + methodName));
                }
                try {
                    method = targetBean.getClass().getMethod(methodName, null);
                }
                catch (NoSuchMethodException e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("Method not found" + methodName));
                }
            }
        }
        if (method == null) {
            throw new RuntimeException(Messages.getMessage((String)"pDescrErr2", (String)targetBean.getClass().getName()));
        }
        Object ret = method.invoke(targetBean, null);
        if (ret != null && method.getReturnType() == JAXBElement.class) {
            ret = ((JAXBElement)ret).getValue();
        }
        return ret;
    }

    public void set(Object targetBean, Object propValue, Class dclClass) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Method writeMethod = null;
        try {
            if (propValue == null) {
                return;
            }
            writeMethod = this.descriptor.getWriteMethod();
            if (this.descriptor instanceof IndexedPropertyDescriptor) {
                this.setIndexedArray(targetBean, propValue, writeMethod);
            } else if (writeMethod == null) {
                this.setList(targetBean, propValue);
            } else if (this.descriptor.getPropertyType() == JAXBElement.class) {
                if (propValue != null) {
                    Class<?> clazz = dclClass != null ? dclClass : propValue.getClass();
                    JAXBElement element = new JAXBElement(this.xmlName, clazz, propValue);
                    this.setAtomic(targetBean, element, writeMethod);
                }
            } else {
                this.setAtomic(targetBean, propValue, writeMethod);
            }
        }
        catch (RuntimeException e) {
            if (DEBUG_ENABLED) {
                String propClass = propValue.getClass().getName();
                log.debug((Object)("An exception occurred while attempting to set a property on " + targetBean.getClass().getName()));
                log.debug((Object)("The setter method is " + writeMethod));
                log.debug((Object)("The class of the argument is :" + propClass));
                log.debug((Object)("The PropertyDescriptor is: " + this.toString()));
                log.debug((Object)("The exception is: " + e));
            }
            throw e;
        }
    }

    private void setAtomic(Object targetBean, Object propValue, Method writeMethod) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        if (propValue != null) {
            Object[] SINGLE_PARAM = new Object[]{propValue};
            writeMethod.invoke(targetBean, SINGLE_PARAM);
        } else {
            Class<?> paramType;
            Class<?>[] paramTypes = writeMethod.getParameterTypes();
            if (paramTypes != null && paramTypes.length == 1 && (paramType = paramTypes[0]).isPrimitive() && propValue == null) {
                if (DEBUG_ENABLED) {
                    log.debug((Object)"Ignoring null value for primitive type, this is the way to set default values defined in JAXBObject/xmlSchema. for primitive types");
                }
                return;
            }
        }
    }

    private void setIndexedArray(Object targetBean, Object propValue, Method writeMethod) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Class<?> paramType = writeMethod.getParameterTypes()[0];
        Object value = PropertyDescriptorPlus.asArray(propValue, paramType);
        Object[] SINGLE_PARAM = new Object[]{value};
        writeMethod.invoke(targetBean, SINGLE_PARAM);
    }

    private void setList(Object targetBean, Object propValue) throws InvocationTargetException, IllegalAccessException, JAXBWrapperException {
        Collection value = PropertyDescriptorPlus.asCollection(propValue, this.descriptor.getPropertyType());
        Collection collection = (Collection)this.get(targetBean);
        collection.clear();
        if (propValue != null) {
            collection.addAll(value);
        }
    }

    private static Collection asCollection(Object propValue, Class destType) {
        if (ConvertUtils.isConvertable(propValue, destType)) {
            return (Collection)ConvertUtils.convert(propValue, destType);
        }
        String objectClass = propValue == null ? "null" : propValue.getClass().getName();
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"convertProblem", (String)objectClass, (String)destType.getName()));
    }

    private static Object asArray(Object propValue, Class destType) {
        if (ConvertUtils.isConvertable(propValue, destType)) {
            return ConvertUtils.convert(propValue, destType);
        }
        String objectClass = propValue == null ? "null" : propValue.getClass().getName();
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"convertProblem", (String)objectClass, (String)destType.getName()));
    }

    public String toString() {
        String value = "PropertyDescriptorPlus[";
        value = value + " name=" + this.getPropertyName();
        value = value + " type=" + this.getPropertyType().getName();
        value = value + " propertyDecriptor=" + this.descriptor;
        return value + "]";
    }
}

