/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.handler.HandlerRolePlayer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HandlerUtils {
    private static Log log = LogFactory.getLog(HandlerUtils.class);

    public static List<QName> registerSOAPHandlerHeaders(MessageContext msgContext, List<Handler> handlers) {
        ArrayList<QName> understood = new ArrayList<QName>();
        if (msgContext == null) {
            return understood;
        }
        for (Handler handler : handlers) {
            Set headers;
            if (!(handler instanceof SOAPHandler)) continue;
            SOAPHandler soapHandler = (SOAPHandler)handler;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invoking getHeader() on SOAPHandler");
            }
            if ((headers = soapHandler.getHeaders()) == null) continue;
            for (QName header : headers) {
                if (understood.contains(header)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding Header QName" + header + " to uderstoodHeaderQName List"));
                }
                understood.add(header);
            }
        }
        return understood;
    }

    public static void checkMustUnderstand(MessageContext msgContext, List<QName> understood, List<String> additionalRoles) throws AxisFault {
        if (msgContext == null || !msgContext.isHeaderPresent()) {
            return;
        }
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading UnprocessedHeaderNames from Message Context properties");
        }
        ArrayList<QName> unprocessed = (ArrayList<QName>)msgContext.getProperty("unprocessedHeaderQNames");
        if (additionalRoles != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding any mustUnderstand headers based on additonal SOAP roles: " + additionalRoles));
            }
            HandlerRolePlayer handlerRolePlayer = new HandlerRolePlayer(additionalRoles);
            Iterator headerBlocks = envelope.getHeader().getHeadersToProcess((RolePlayer)handlerRolePlayer);
            while (headerBlocks.hasNext()) {
                SOAPHeaderBlock shb = (SOAPHeaderBlock)headerBlocks.next();
                if (unprocessed == null) {
                    unprocessed = new ArrayList<QName>();
                }
                if (shb.isProcessed() || !shb.getMustUnderstand()) continue;
                unprocessed.add(shb.getQName());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added header to unprocessed list: " + shb.getQName()));
            }
        }
        if (unprocessed == null || unprocessed.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"UNPROCESSED_HEADER_QNAMES not found.");
            }
            return;
        }
        if (!HandlerUtils.canUnderstand(msgContext)) {
            QName[] qNames = unprocessed.toArray(new QName[0]);
            String[] headerNames = new String[qNames.length];
            for (int i = 0; i < qNames.length; ++i) {
                headerNames[i] = "{" + qNames[i].getNamespaceURI() + "}" + qNames[i].getLocalPart();
            }
            QName faultQName = envelope.getVersion().getMustUnderstandFaultCode();
            throw new AxisFault(Messages.getMessage((String)"mustunderstandfailed2", (String[])headerNames), faultQName);
        }
        HandlerUtils.checkUnprocessed(envelope, (List<QName>)unprocessed, understood, msgContext);
        msgContext.setProperty("unprocessedHeaderQNames", null);
    }

    private static void checkUnprocessed(SOAPEnvelope envelope, List<QName> unprocessed, List<QName> understood, MessageContext msgContext) throws AxisFault {
        for (QName headerQName : unprocessed) {
            if (understood != null && !understood.isEmpty() && understood.contains(headerQName)) {
                if (!LoggingControl.debugLoggingAllowed || !log.isDebugEnabled()) continue;
                log.debug((Object)("MustUnderstand header registered as understood on AxisOperation: " + headerQName));
                continue;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("MustUnderstand header not processed or registered as understood " + headerQName));
            }
            String prefix = envelope.getNamespace().getPrefix();
            if (!msgContext.isSOAP11()) {
                if (prefix == null || "".equals(prefix)) {
                    prefix = "soapenv";
                }
                throw new AxisFault(Messages.getMessage((String)"mustunderstandfailed", (String)prefix, (String)headerQName.toString()), "MustUnderstand");
            }
            throw new AxisFault(Messages.getMessage((String)"mustunderstandfailed", (String)prefix, (String)headerQName.toString()), "MustUnderstand");
        }
    }

    private static boolean canUnderstand(MessageContext msgContext) {
        AxisService axisSvc = msgContext.getAxisService();
        if (axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription") != null) {
            Parameter param = axisSvc.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
            EndpointDescription ed = (EndpointDescription)param.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check to see if a jaxws handler is configured.");
            }
            return ed.getHandlerChain() != null;
        }
        return true;
    }

    public static boolean isHighFidelity(MessageContext mc) {
        boolean rc = HandlerUtils._isHighFidelity(mc);
        if (!rc) {
            rc = HandlerUtils._isHighFidelity(HandlerUtils.getRelatedMessageContext(mc));
        }
        return rc;
    }

    private static MessageContext getRelatedMessageContext(MessageContext mc) {
        OperationContext oc;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter getRelatedMessageContext for:" + mc));
        }
        MessageContext relatedMC = null;
        if (mc != null && (oc = mc.getOperationContext()) != null) {
            try {
                relatedMC = oc.getMessageContext("In");
                if (relatedMC == mc) {
                    relatedMC = oc.getMessageContext("Out");
                }
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit getRelatedMessageContext related messageContext is" + relatedMC));
        }
        return relatedMC;
    }

    private static boolean _isHighFidelity(MessageContext mc) {
        boolean value = false;
        if (mc == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"_isHighFidelity returns false due to missing MessageContext");
            }
            return false;
        }
        Boolean highFidelity = (Boolean)mc.getProperty("jaxws.payload.highFidelity");
        if (highFidelity != null) {
            value = highFidelity;
            if (log.isDebugEnabled()) {
                log.debug((Object)("_isHighFidelity returns " + value + " per Context property " + "jaxws.payload.highFidelity"));
            }
            return value;
        }
        Boolean jaxbStreaming = (Boolean)mc.getProperty("org.apache.axis2.jaxws.enableJAXBPayloadStreaming");
        if (jaxbStreaming != null) {
            boolean bl = value = jaxbStreaming == false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("_isHighFidelity returns " + value + " per inspection of Context property " + "org.apache.axis2.jaxws.enableJAXBPayloadStreaming"));
            }
            return value;
        }
        Parameter p = mc.getParameter("jaxws.payload.highFidelity");
        if (p != null) {
            value = JavaUtils.isTrue((Object)p.getValue());
            if (log.isDebugEnabled()) {
                log.debug((Object)("_isHighFidelity returns " + value + " per inspection of Configuration property " + "jaxws.payload.highFidelity"));
            }
            return value;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"_isHighFidelity returns the default: false");
        }
        return false;
    }
}

