/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.util.Locale;
import org.hibernate.testing.orm.junit.FailureExpected;
import org.hibernate.testing.orm.junit.FailureExpectedGroup;
import org.hibernate.testing.orm.junit.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;

public class FailureExpectedExtension
implements ExecutionCondition,
BeforeEachCallback,
AfterEachCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(FailureExpectedExtension.class);
    private static final String IS_MARKED_STORE_KEY = "IS_MARKED";
    private static final String EXPECTED_FAILURE_STORE_KEY = "EXPECTED_FAILURE";
    public static final boolean failureExpectedValidation = Boolean.getBoolean("hibernate.test.validatefailureexpected");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        log.tracef("#evaluateExecutionCondition(%s)", (Object)context.getDisplayName());
        if (!context.getElement().isPresent()) {
            throw new RuntimeException("Unable to determine how to handle given ExtensionContext : " + context.getDisplayName());
        }
        log.debugf("Evaluating context - %s [failureExpectedValidation = %s]", (Object)context.getDisplayName(), (Object)failureExpectedValidation);
        if (TestingUtil.hasEffectiveAnnotation(context, FailureExpected.class) || TestingUtil.hasEffectiveAnnotation(context, FailureExpectedGroup.class)) {
            if (failureExpectedValidation) {
                log.debugf("Executing test marked with `@FailureExpected` for validation", new Object[0]);
                return ConditionEvaluationResult.enabled((String)"@ExpectedFailure validation");
            }
            return ConditionEvaluationResult.disabled((String)"Disabled : @ExpectedFailure");
        }
        return ConditionEvaluationResult.enabled((String)"No @ExpectedFailure");
    }

    public void beforeEach(ExtensionContext context) {
        log.tracef("#beforeEach(%s)", (Object)context.getDisplayName());
        boolean markedExpectedFailure = TestingUtil.hasEffectiveAnnotation(context, FailureExpected.class) || TestingUtil.hasEffectiveAnnotation(context, FailureExpectedGroup.class);
        log.debugf("Checking for @FailureExpected [%s] - %s", (Object)context.getDisplayName(), (Object)markedExpectedFailure);
        ExtensionContext.Namespace namespace = this.generateNamespace(context);
        context.getStore(namespace).put((Object)IS_MARKED_STORE_KEY, (Object)markedExpectedFailure);
    }

    private ExtensionContext.Namespace generateNamespace(ExtensionContext context) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass().getName(), context.getRequiredTestMethod().getClass(), context.getRequiredTestMethod().getName()});
    }

    public void afterEach(ExtensionContext context) {
        log.tracef("#afterEach(%s)", (Object)context.getDisplayName());
        ExtensionContext.Store store = context.getStore(this.generateNamespace(context));
        Boolean isMarked = (Boolean)store.remove((Object)IS_MARKED_STORE_KEY);
        log.debugf("Post-handling for @FailureExpected [%s] - %s", (Object)context.getDisplayName(), (Object)isMarked);
        if (isMarked == Boolean.TRUE) {
            Throwable expectedFailure = (Throwable)store.remove((Object)EXPECTED_FAILURE_STORE_KEY);
            log.debugf("  >> Captured exception - %s", (Object)expectedFailure);
            if (expectedFailure == null) {
                throw new ExpectedFailureDidNotFail(context);
            }
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        log.tracef("#handleTestExecutionException(%s, %s)", (Object)context.getDisplayName(), (Object)throwable.getClass().getName());
        ExtensionContext.Store store = context.getStore(this.generateNamespace(context));
        Boolean isMarked = (Boolean)store.get((Object)IS_MARKED_STORE_KEY);
        log.debugf("Handling test exception [%s]; marked @FailureExcepted = %s", (Object)context.getDisplayName(), (Object)isMarked);
        if (isMarked == Boolean.TRUE) {
            store.put((Object)EXPECTED_FAILURE_STORE_KEY, (Object)throwable);
            log.debugf("  >> Stored expected failure - %s", (Object)throwable);
            return;
        }
        throw throwable;
    }

    static {
        log.debugf("FailureExpectedExtension#failureExpectedValidation = %s", (Object)failureExpectedValidation);
    }

    private static class ExpectedFailureDidNotFail
    extends RuntimeException {
        ExpectedFailureDidNotFail(ExtensionContext context) {
            super(String.format(Locale.ROOT, "`%s#%s` was marked as `@ExpectedFailure`, but did not fail", context.getRequiredTestClass().getName(), context.getRequiredTestMethod().getName()));
        }
    }
}

