/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.rome.io.impl;

import com.rometools.rome.io.impl.CFDateParser;
import com.rometools.rome.io.impl.PropertiesLoader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateParser {
    private static String[] ADDITIONAL_MASKS;
    public static CFDateParser cfDateParser;
    private static final String[] RFC822_MASKS;
    private static final String[] W3CDATETIME_MASKS;
    private static final String[] masks;
    private static final String[] ISO8601_MASKS;

    private DateParser() {
    }

    private static Date parseUsingMask(String[] masks, String sDate, Locale locale) {
        if (sDate != null) {
            sDate = sDate.trim();
        }
        ParsePosition pp = null;
        Date d = null;
        for (int i = 0; d == null && i < masks.length; ++i) {
            SimpleDateFormat df = new SimpleDateFormat(masks[i].trim(), locale);
            df.setLenient(true);
            pp = new ParsePosition(0);
            d = ((DateFormat)df).parse(sDate, pp);
            if (pp.getErrorIndex() == -1) continue;
            d = null;
        }
        return d;
    }

    public static Date parseRFC822(String sDate, Locale locale) {
        sDate = DateParser.convertUnsupportedTimeZones(sDate);
        return DateParser.parseUsingMask(RFC822_MASKS, sDate, locale);
    }

    public static Date parseISO8601(String sDate, Locale locale) {
        int tzIndex = sDate.indexOf(90);
        if (tzIndex == -1 && (tzIndex = sDate.indexOf(43)) == -1) {
            tzIndex = sDate.indexOf(45, 8);
        }
        if (tzIndex == -1) {
            tzIndex = sDate.length();
        }
        int lastIndex = sDate.lastIndexOf(46) == -1 ? tzIndex : (tzIndex - sDate.lastIndexOf(46) > 3 ? sDate.lastIndexOf(46) + 4 : tzIndex);
        String sOutDate = sDate.substring(0, lastIndex);
        if (tzIndex - sDate.lastIndexOf(46) == 3) {
            sOutDate = sOutDate + "0";
        } else if (tzIndex - sDate.lastIndexOf(46) == 2) {
            sOutDate = sOutDate + "00";
        } else if (tzIndex - sDate.lastIndexOf(46) == 1) {
            sOutDate = sOutDate + "000";
        }
        if (sOutDate.indexOf(84) == 7) {
            sOutDate = sOutDate.replace('T', 'J');
        }
        if (tzIndex == sDate.length()) {
            sOutDate = sOutDate + "GMT";
        } else if (sDate.charAt(tzIndex) == 'Z') {
            sOutDate = sOutDate + "GMT";
        } else {
            String tzString = sDate.substring(tzIndex);
            if (tzString.length() == 3) {
                tzString = tzString + ":00";
            }
            sOutDate = sOutDate + "GMT" + tzString;
        }
        return DateParser.parseUsingMask(ISO8601_MASKS, sOutDate, locale);
    }

    private static String convertUnsupportedTimeZones(String sDate) {
        List<String> unsupportedZeroOffsetTimeZones = Arrays.asList("UT", "Z");
        List<String> splitted = Arrays.asList(sDate.split(" "));
        for (String timeZone : unsupportedZeroOffsetTimeZones) {
            if (!splitted.contains(timeZone)) continue;
            return DateParser.replaceLastOccurrence(sDate, timeZone, "UTC");
        }
        return sDate;
    }

    private static String replaceLastOccurrence(String original, String target, String replacement) {
        int lastIndexOfTarget = original.lastIndexOf(target);
        if (lastIndexOfTarget == -1) {
            return original;
        }
        return new StringBuilder(original).replace(lastIndexOfTarget, lastIndexOfTarget + target.length(), replacement).toString();
    }

    public static Date parseW3CDateTime(String sDate, Locale locale) {
        int tIndex = sDate.indexOf("T");
        if (tIndex > -1) {
            int tzdIndex;
            if (sDate.endsWith("Z")) {
                sDate = sDate.substring(0, sDate.length() - 1) + "+00:00";
            }
            if ((tzdIndex = sDate.indexOf("+", tIndex)) == -1) {
                tzdIndex = sDate.indexOf("-", tIndex);
            }
            if (tzdIndex > -1) {
                String pre = sDate.substring(0, tzdIndex);
                int secFraction = pre.indexOf(",");
                if (secFraction > -1) {
                    pre = pre.substring(0, secFraction);
                }
                String post = sDate.substring(tzdIndex);
                sDate = pre + "GMT" + post;
            }
        } else {
            sDate = sDate + "T00:00GMT";
        }
        return DateParser.parseUsingMask(W3CDATETIME_MASKS, sDate, locale);
    }

    public static Date parseDate(String sDate, Locale locale) {
        String tempDate = sDate.trim();
        Date date = null;
        if (ADDITIONAL_MASKS.length > 0 && (date = DateParser.parseUsingMask(ADDITIONAL_MASKS, tempDate, locale)) != null) {
            return date;
        }
        date = DateParser.parseW3CDateTime(tempDate, locale);
        if (date == null) {
            date = DateParser.parseRFC822(tempDate, locale);
            if (date == null) {
                date = DateParser.parseISO8601(tempDate, locale);
            }
            if (date == null && cfDateParser != null) {
                try {
                    date = cfDateParser.parseDate(tempDate);
                }
                catch (Exception ex) {
                    date = null;
                }
            }
        }
        return date;
    }

    public static void registerCFDateParser(CFDateParser cf) {
        if (cfDateParser == null) {
            cfDateParser = cf;
        }
    }

    public static void removeCFDateParser() {
        cfDateParser = null;
    }

    public static String formatRFC822(Date date, Locale locale) {
        SimpleDateFormat dateFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", locale);
        dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormater.format(date);
    }

    public static String formatW3CDateTime(Date date, Locale locale) {
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", locale);
        dateFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormater.format(date);
    }

    static {
        RFC822_MASKS = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss", "EEE, dd MMM yy HH:mm z", "dd MMM yy HH:mm:ss z", "dd MMM yy HH:mm z"};
        W3CDATETIME_MASKS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd't'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd't'HH:mm:ss.SSS'z'", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd't'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd't'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'", "yyyy-MM-dd'T'HH:mmz", "yyyy-MM'T'HH:mmz", "yyyy'T'HH:mmz", "yyyy-MM-dd't'HH:mmz", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd't'HH:mm'z'"};
        masks = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd't'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd't'HH:mm:ss.SSS'z'", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd't'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'", "yyyy-MM-dd'T'HH:mmz", "yyyy-MM-dd't'HH:mmz", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd't'HH:mm'z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};
        ISO8601_MASKS = new String[]{"yyyyDDD'J'HHmmss.SSSz", "yyyyMMddHHmmss.SSSz", "yyyyMMdd'T'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyyDDD'J'HH:mm:ss.SSSz", "yyyyMMdd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyyMMdd HH:mm:ss.SSSz", "yyyyMMdd HHmmss.SSSz", "yyyy-MM-dd HH:mm:ss.SSSz", "yyyy-MM-dd HHmmss.SSSz", "yyyyDDD'J'HH:mm:ssz", "yyyyDDD'J'HHmmssz", "yyyyMMdd'T'HH:mm:ssz", "yyyyMMdd'T'HHmmssz", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HHmmssz", "yyyyMMdd HH:mm:ssz", "yyyyMMdd HHmmssz", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HHmmssz", "yyyyMMddHHmmssz"};
        ADDITIONAL_MASKS = PropertiesLoader.getPropertiesLoader().getTokenizedProperty("datetime.extra.masks", "|");
    }
}

