/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.ObjectLockRetentionConsumer;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.services.s3.model.ObjectLockRetention;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;

public class PutObjectRetentionRequestConsumer
extends ConsumerMap<PutObjectRetentionRequest.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static PutObjectRetentionRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PutObjectRetentionRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<PutObjectRetentionRequestConsumer> clazz = PutObjectRetentionRequestConsumer.class;
        synchronized (PutObjectRetentionRequestConsumer.class) {
            instance = new PutObjectRetentionRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PutObjectRetentionRequestConsumer() {
        this.put("key", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            builder.key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("versionId", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value).trim();
            ValidationUtil.validNonBlankString((String)input, (String)"versionId");
            builder.versionId(input);
        }, Collections.emptyList()));
        this.put("retention", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getMapProperty(value);
            ObjectLockRetention.Builder retentionBuilder = ObjectLockRetention.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)retentionBuilder, map, (ConsumerMap)ObjectLockRetentionConsumer.getInstance());
            builder.retention((ObjectLockRetention)retentionBuilder.build());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("requestPayer", new ConsumerValidator((builder, value) -> builder.requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("bypassGovernanceRetention", new ConsumerValidator((builder, value) -> builder.bypassGovernanceRetention(this.cast.getBooleanProperty(value)), Collections.emptyList()));
        this.put("contentMD5", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentMD5");
            builder.contentMD5(input);
        }, Collections.emptyList()));
    }
}

