/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.s3.consumer;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidationUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.s3.consumer.ObjectLockLegalHoldConsumer;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.services.s3.model.ObjectLockLegalHold;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;

public class PutObjectLegalHoldRequestConsumer
extends ConsumerMap<PutObjectLegalHoldRequest.Builder> {
    private FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private static PutObjectLegalHoldRequestConsumer instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PutObjectLegalHoldRequestConsumer getInstance() {
        if (instance != null) return instance;
        Class<PutObjectLegalHoldRequestConsumer> clazz = PutObjectLegalHoldRequestConsumer.class;
        synchronized (PutObjectLegalHoldRequestConsumer.class) {
            instance = new PutObjectLegalHoldRequestConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private PutObjectLegalHoldRequestConsumer() {
        this.put("key", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"key");
            builder.key(input);
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("versionId", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"versionId");
            builder.versionId(input);
        }, Collections.emptyList()));
        this.put("legalHold", new ConsumerValidator((builder, value) -> {
            Map map = this.cast.getMapProperty(value);
            ObjectLockLegalHold.Builder retentionBuilder = ObjectLockLegalHold.builder();
            ValidatorFiller.INSTANCE.fillObject((Object)retentionBuilder, map, (ConsumerMap)ObjectLockLegalHoldConsumer.getInstance());
            builder.legalHold((ObjectLockLegalHold)retentionBuilder.build());
        }, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put("requestPayer", new ConsumerValidator((builder, value) -> builder.requestPayer(RequestPayer.valueOf((String)this.cast.getStringProperty(value))), Collections.emptyList()));
        this.put("contentMD5", new ConsumerValidator((builder, value) -> {
            String input = this.cast.getStringProperty(value);
            ValidationUtil.validNonBlankString((String)input, (String)"contentMD5");
            builder.contentMD5(input);
        }, Collections.emptyList()));
    }
}

