/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeTask;
import coldfusion.runtime.CFPage;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.ExchangeTaskTag;
import coldfusion.tagext.net.exchange.TaskConstants;
import coldfusion.tagext.net.exchange.TaskQueryMetaData;
import java.util.ArrayList;

public class TaskQuery
extends QueryTable
implements TaskConstants {
    public void populate(ArrayList resultArray) {
        this.meta = new TaskQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        for (ExchangeTask task : resultArray) {
            Object[] colData = new Object[this.col_count];
            colData[0] = task.getId();
            colData[1] = task.getStartDate();
            colData[2] = task.getDueDate();
            colData[3] = task.getStatus();
            colData[4] = task.getPercentComplete();
            colData[5] = task.getReminderDate();
            colData[6] = task.getCompanies();
            colData[7] = task.getDateCompleted();
            colData[8] = task.getTotalWork();
            colData[9] = task.getActualWork();
            colData[10] = task.getMileage();
            colData[11] = task.getBillingInfo();
            colData[12] = task.getHasAttachment();
            colData[13] = task.getSubject();
            colData[14] = task.getMessage();
            colData[15] = task.getHtmlMessage();
            colData[16] = task.getPriority() != null ? ExchangeTaskTag.intPriorityToString(task.getPriority()) : null;
            colData[17] = task.getCategories();
            colData[18] = task.getLastModified() != null ? CFPage.CreateODBCDateTime((Object)task.getLastModified()) : null;
            this.addRow(colData);
        }
    }
}

