/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.net.exchange.CalendarConstants;
import coldfusion.tagext.net.exchange.RoomQueryMetaData;
import com.microsoft.graph.models.Room;
import com.microsoft.graph.models.RoomList;
import java.util.ArrayList;

public class RoomQuery
extends QueryTable
implements CalendarConstants {
    public void populate(ArrayList resultArray) {
        this.meta = new RoomQueryMetaData();
        this.col_count = this.meta.getColumnCount();
        this.col_names = this.meta.getColumnLabels();
        if (resultArray == null || resultArray.size() == 0) {
            this.row_count = 0;
            return;
        }
        this.ensureCapacity(resultArray.size());
        Object importance = null;
        for (Object object : resultArray) {
            Object[] colData = new Object[this.col_count];
            if (object instanceof EmailAddress) {
                EmailAddress address = (EmailAddress)object;
                colData[0] = address.getName();
                colData[1] = address.getAddress();
                colData[2] = address.getRoutingType();
                colData[3] = address.getMailboxType();
                colData[4] = address.getId();
            } else if (object instanceof Room) {
                Room room = (Room)object;
                colData[0] = room.getDisplayName();
                colData[1] = room.getEmailAddress();
                colData[2] = null;
                colData[3] = "room";
                colData[4] = room.getId();
            } else if (object instanceof RoomList) {
                RoomList roomList = (RoomList)object;
                colData[0] = roomList.getDisplayName();
                colData[1] = roomList.getEmailAddress();
                colData[2] = null;
                colData[3] = "roomList";
                colData[4] = roomList.getId();
            }
            this.addRow(colData);
        }
    }
}

