/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.webdav.AttachmentManager;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.w3c.dom.NodeList;

public class ContactManager
extends WebDAVFolderManager {
    ContactManager(WebDAVConnection con) {
        super(con);
    }

    void createContact(ExchangeContact ct) throws Throwable {
        this.createContact(ct, null, null);
    }

    void createContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        ct.setHref(this.createURI());
        this.saveContact(ct);
        if (attachedFileNames != null && attachedFileContents != null) {
            this.addAttachments(ct.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    void saveContact(ExchangeContact ct) throws Throwable {
        ContactAddress addr;
        String strXMLNSInfo = "xmlns:g=\"DAV:\" xmlns:e=\"http://schemas.microsoft.com/exchange/\" xmlns:mapi=\"http://schemas.microsoft.com/mapi/\" xmlns:x=\"xml:\" xmlns:cal=\"urn:schemas:calendar:\" xmlns:mail=\"urn:schemas:httpmail:\" xmlns:c=\"urn:schemas:contacts:\"> ";
        Object strNameInfo = "";
        String tmpStr = ct.getFirstName();
        if (tmpStr != null) {
            strNameInfo = (String)strNameInfo + "<c:givenName>" + this.encodeXMLContent(tmpStr) + "</c:givenName>";
        }
        if ((tmpStr = ct.getMiddleName()) != null) {
            strNameInfo = (String)strNameInfo + "<c:middlename>" + this.encodeXMLContent(tmpStr) + "</c:middlename>";
        }
        if ((tmpStr = ct.getLastName()) != null) {
            strNameInfo = (String)strNameInfo + "<c:sn>" + this.encodeXMLContent(tmpStr) + "</c:sn>";
        }
        if ((tmpStr = ct.getDislpayName()) != null) {
            tmpStr = this.encodeXMLContent(tmpStr);
            strNameInfo = (String)strNameInfo + "<c:fileas>" + tmpStr + "</c:fileas>";
            strNameInfo = (String)strNameInfo + "<mail:subject>" + tmpStr + "</mail:subject>";
        }
        if ((tmpStr = ct.getJobTitle()) != null) {
            strNameInfo = (String)strNameInfo + "<c:title>" + this.encodeXMLContent(tmpStr) + "</c:title>";
        }
        if ((tmpStr = ct.getCompany()) != null) {
            strNameInfo = (String)strNameInfo + "<c:o>" + this.encodeXMLContent(tmpStr) + "</c:o>";
        }
        if ((tmpStr = ct.getBusinessHomePage()) != null) {
            strNameInfo = (String)strNameInfo + "<c:businesshomepage>" + this.encodeXMLContent(tmpStr) + "</c:businesshomepage>";
        }
        if ((tmpStr = ct.getEMail1()) != null) {
            strNameInfo = (String)strNameInfo + "<c:email1>" + this.encodeXMLContent(tmpStr) + "</c:email1>";
        }
        if ((tmpStr = ct.getEMail2()) != null) {
            strNameInfo = (String)strNameInfo + "<c:email2>" + this.encodeXMLContent(tmpStr) + "</c:email2>";
        }
        if ((tmpStr = ct.getEMail3()) != null) {
            strNameInfo = (String)strNameInfo + "<c:email3>" + this.encodeXMLContent(tmpStr) + "</c:email3>";
        }
        if ((tmpStr = ct.getBusinessFax()) != null) {
            strNameInfo = (String)strNameInfo + "<c:facsimiletelephonenumber>" + this.encodeXMLContent(tmpStr) + "</c:facsimiletelephonenumber>";
        }
        if (ct.getMailingAdressType() != null) {
            strNameInfo = (String)strNameInfo + "<c:mailingaddressid>" + ct.getMailingAdressType() + "</c:mailingaddressid>";
        }
        if (ct.getBusinessAddress() != null) {
            addr = ct.getBusinessAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                strNameInfo = (String)strNameInfo + "<c:street>" + this.encodeXMLContent(tmpStr) + "</c:street>";
            }
            if ((tmpStr = addr.getCity()) != null) {
                strNameInfo = (String)strNameInfo + "<c:l>" + this.encodeXMLContent(tmpStr) + "</c:l>";
            }
            if ((tmpStr = addr.getCountry()) != null) {
                strNameInfo = (String)strNameInfo + "<c:co>" + this.encodeXMLContent(tmpStr) + "</c:co>";
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                strNameInfo = (String)strNameInfo + "<c:postalcode>" + this.encodeXMLContent(tmpStr) + "</c:postalcode>";
            }
            if ((tmpStr = addr.getState()) != null) {
                strNameInfo = (String)strNameInfo + "<c:st>" + this.encodeXMLContent(tmpStr) + "</c:st>";
            }
        }
        if (ct.getHomeAddress() != null) {
            addr = ct.getHomeAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                strNameInfo = (String)strNameInfo + "<c:homeStreet>" + this.encodeXMLContent(tmpStr) + "</c:homeStreet>";
            }
            if ((tmpStr = addr.getCity()) != null) {
                strNameInfo = (String)strNameInfo + "<c:homeCity>" + this.encodeXMLContent(tmpStr) + "</c:homeCity>";
            }
            if ((tmpStr = addr.getCountry()) != null) {
                strNameInfo = (String)strNameInfo + "<c:homeCountry>" + this.encodeXMLContent(tmpStr) + "</c:homeCountry>";
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                strNameInfo = (String)strNameInfo + "<c:homePostalCode>" + this.encodeXMLContent(tmpStr) + "</c:homePostalCode>";
            }
            if ((tmpStr = addr.getState()) != null) {
                strNameInfo = (String)strNameInfo + "<c:homeState>" + this.encodeXMLContent(tmpStr) + "</c:homeState>";
            }
        }
        if (ct.getOtherAddress() != null) {
            addr = ct.getOtherAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                strNameInfo = (String)strNameInfo + "<c:otherstreet>" + this.encodeXMLContent(tmpStr) + "</c:otherstreet>";
            }
            if ((tmpStr = addr.getCity()) != null) {
                strNameInfo = (String)strNameInfo + "<c:othercity>" + this.encodeXMLContent(tmpStr) + "</c:othercity>";
            }
            if ((tmpStr = addr.getCountry()) != null) {
                strNameInfo = (String)strNameInfo + "<c:othercountry>" + this.encodeXMLContent(tmpStr) + "</c:othercountry>";
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                strNameInfo = (String)strNameInfo + "<c:otherpostalcode>" + this.encodeXMLContent(tmpStr) + "</c:otherpostalcode>";
            }
            if ((tmpStr = addr.getState()) != null) {
                strNameInfo = (String)strNameInfo + "<c:otherstate>" + this.encodeXMLContent(tmpStr) + "</c:otherstate>";
            }
        }
        if ((tmpStr = ct.getHomePhone()) != null) {
            strNameInfo = (String)strNameInfo + "<c:homePhone>" + this.encodeXMLContent(tmpStr) + "</c:homePhone>";
        }
        if ((tmpStr = ct.getBusinessPhone()) != null) {
            strNameInfo = (String)strNameInfo + "<c:telephoneNumber>" + this.encodeXMLContent(tmpStr) + "</c:telephoneNumber>";
        }
        if ((tmpStr = ct.getMobilePhone()) != null) {
            strNameInfo = (String)strNameInfo + "<c:mobile>" + this.encodeXMLContent(tmpStr) + "</c:mobile>";
        }
        if ((tmpStr = ct.getPager()) != null) {
            strNameInfo = (String)strNameInfo + "<c:pager>" + this.encodeXMLContent(tmpStr) + "</c:pager>";
        }
        if ((tmpStr = ct.getCategories()) != null) {
            strNameInfo = (String)strNameInfo + this.createCategoriesXML(this.encodeXMLContent(tmpStr));
        }
        if ((tmpStr = ct.getDescription()) != null) {
            strNameInfo = (String)strNameInfo + "<mail:htmldescription>" + this.encodeXMLContent(tmpStr) + "</mail:htmldescription>";
        }
        if (ct.getDetails() != null) {
            ContactOtherDetails dtl = ct.getDetails();
            tmpStr = dtl.getDepartment();
            if (tmpStr != null) {
                strNameInfo = (String)strNameInfo + "<c:department>" + this.encodeXMLContent(tmpStr) + "</c:department>";
            }
            if ((tmpStr = dtl.getAssistant()) != null) {
                strNameInfo = (String)strNameInfo + "<c:secretarycn>" + this.encodeXMLContent(tmpStr) + "</c:secretarycn>";
            }
            if ((tmpStr = dtl.getManager()) != null) {
                strNameInfo = (String)strNameInfo + "<c:manager>" + this.encodeXMLContent(tmpStr) + "</c:manager>";
            }
            if ((tmpStr = dtl.getNickname()) != null) {
                strNameInfo = (String)strNameInfo + "<c:nickname>" + this.encodeXMLContent(tmpStr) + "</c:nickname>";
            }
            if ((tmpStr = dtl.getOffice()) != null) {
                strNameInfo = (String)strNameInfo + "<c:roomnumber>" + this.encodeXMLContent(tmpStr) + "</c:roomnumber>";
            }
            if ((tmpStr = dtl.getPartner()) != null) {
                strNameInfo = (String)strNameInfo + "<c:spousecn>" + this.encodeXMLContent(tmpStr) + "</c:spousecn>";
            }
            if ((tmpStr = dtl.getProfession()) != null) {
                strNameInfo = (String)strNameInfo + "<c:profession>" + this.encodeXMLContent(tmpStr) + "</c:profession>";
            }
        }
        if ((tmpStr = ct.getOtherPhone()) != null) {
            strNameInfo = (String)strNameInfo + "<c:otherTelephone>" + this.encodeXMLContent(tmpStr) + "</c:otherTelephone>";
        }
        String strBody = "<?xml version=\"1.0\"?><g:propertyupdate " + strXMLNSInfo + "<g:set> <g:prop><g:contentclass>urn:content-classes:person</g:contentclass><e:outlookmessageclass>IPM.Contact</e:outlookmessageclass>" + (String)strNameInfo + "</g:prop></g:set></g:propertyupdate>";
        int code = this.executeWebDAVMethod(PropPatchMethod.class, this.getHttpClient(), ct.getHref(), strBody, true);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting appointments");
        }
        String uid = Utils.findProperty(ct.getHref(), "uid", "DAV:", this.getHttpClient());
        if (uid == null) {
            throw new WebDAVExceptions(11, null, "Error getting UID of the new contact");
        }
        ct.setId(uid);
    }

    private String getContactURL() {
        return "\"" + this.getContactFolderUrl() + "\"";
    }

    public ArrayList getContacts(ContactFilterInfo filter) throws Throwable {
        HttpClient client;
        int code;
        int i;
        Object tmpCondition;
        ContactAddress addr;
        String selectSql = "select \"urn:schemas:contacts:initials\",\"urn:schemas:contacts:l\",\"DAV:contentclass\",\"urn:schemas:contacts:sn\",\"urn:schemas:contacts:fileas\",\"urn:schemas:contacts:location\",\"urn:schemas:contacts:givenName\",\"urn:schemas:contacts:co\",\"urn:schemas:contacts:facsimiletelephonenumber\",\"urn:schemas:contacts:mailingaddressid\",\"DAV:uid\",\"urn:schemas:contacts:middlename\",\"DAV:isfolder\",\"http://schemas.microsoft.com/exchange/outlookmessageclass\",\"DAV:creationdate\",\"urn:schemas:contacts:l\",\"urn:schemas:contacts:postalcode\",\"urn:schemas:mailheader:subject\",\"urn:schemas:contacts:co\",\"urn:schemas:contacts:st\",\"DAV:ishidden\",\"urn:schemas:httpmail:subject\",\"urn:schemas:contacts:title\",\"urn:schemas:contacts:mailingpostaladdress\",\"urn:schemas:contacts:st\",\"DAV:displayname\",\"DAV:href\",\"urn:schemas:contacts:department\",\"DAV:uid\",\"urn:schemas:contacts:personaltitle\",\"urn:schemas:contacts:o\",\"urn:schemas:contacts:businesshomepage\",\"urn:schemas:contacts:otherstreet\",\"urn:schemas:contacts:otherTelephone\",\"urn:schemas:contacts:telephoneNumber\",\"urn:schemas:contacts:mobile\",\"urn:schemas:contacts:pager\",\"http://schemas.microsoft.com/exchange/keywords-utf8\" as categories,\"urn:schemas:contacts:othermobile\",\"urn:schemas:contacts:homeCity\",\"urn:schemas:contacts:homeStreet\",\"urn:schemas:contacts:facsimiletelephonenumber\",\"urn:schemas:httpmail:hasattachment\",\"urn:schemas:contacts:cn\",\"urn:schemas:httpmail:datereceived\" as receiptTime,\"urn:schemas:contacts:street\",\"urn:schemas:contacts:profession\",\"urn:schemas:httpmail:textdescription\",\"urn:schemas:httpmail:htmldescription\",\"urn:schemas:contacts:othercountry\",\"urn:schemas:contacts:secretarycn\",\"urn:schemas:contacts:otherpostalcode\",\"urn:schemas:contacts:otherTelephone\",\"urn:schemas:contacts:homeCountry\",\"urn:schemas:contacts:othercity\",\"urn:schemas:contacts:manager\",\"urn:schemas:contacts:homeState\",\"urn:schemas:contacts:homePhone\",\"urn:schemas:contacts:roomnumber\",\"urn:schemas:contacts:homePostalCode\",\"urn:schemas:contacts:otherstate\",\"urn:schemas:contacts:postalcode\",\"urn:schemas:contacts:nickname\",\"urn:schemas:contacts:spousecn\",\"urn:schemas:contacts:telephonenumber2\",\"urn:schemas:contacts:email1\",\"urn:schemas:contacts:email2\",\"urn:schemas:contacts:email3\",\"DAV:getlastmodified\" as lastModified,\"urn:schemas:contacts:postalcode\" ";
        String fromSql = " from " + this.getContactURL() + " ";
        ArrayList<Object> conds = new ArrayList<Object>();
        String tmpStr = null;
        tmpStr = filter.getFirstName();
        if (tmpStr != null) {
            conds.add("\"urn:schemas:contacts:givenName\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getMiddleName()) != null) {
            conds.add("\"urn:schemas:contacts:middlename\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getLastName()) != null) {
            conds.add("\"urn:schemas:contacts:sn\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getDislpayName()) != null) {
            conds.add("\"urn:schemas:contacts:fileas\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getBusinessFax()) != null) {
            conds.add("\"urn:schemas:contacts:facsimiletelephonenumber\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if (filter.getMailingAdressType() != null) {
            conds.add("\"urn:schemas:contacts:mailingaddressid\" = " + filter.getMailingAdressType());
        }
        if ((tmpStr = filter.getJobTitle()) != null) {
            conds.add("\"urn:schemas:contacts:title\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getCompany()) != null) {
            conds.add("\"urn:schemas:contacts:o\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getBusinessHomePage()) != null) {
            conds.add("\"urn:schemas:contacts:businesshomepage\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getEMail1()) != null) {
            conds.add("((\"urn:schemas:contacts:email1\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:email2\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:email3\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'))");
        }
        if ((tmpStr = filter.getEMail2()) != null) {
            conds.add("((\"urn:schemas:contacts:email1\" LIKE '%" + tmpStr + "%') OR (\"urn:schemas:contacts:email2\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:email3\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'))");
        }
        if ((tmpStr = filter.getEMail3()) != null) {
            conds.add("((\"urn:schemas:contacts:email1\" LIKE '%" + tmpStr + "%') OR (\"urn:schemas:contacts:email2\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:email3\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'))");
        }
        if (filter.getBusinessAddress() != null) {
            addr = filter.getBusinessAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                conds.add("\"urn:schemas:contacts:street\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCity()) != null) {
                conds.add("\"urn:schemas:contacts:l\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCountry()) != null) {
                conds.add("\"urn:schemas:contacts:co\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                conds.add("\"urn:schemas:contacts:postalcode\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getState()) != null) {
                conds.add("\"urn:schemas:contacts:st\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
        }
        if (filter.getHomeAddress() != null) {
            addr = filter.getHomeAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                conds.add("\"urn:schemas:contacts:homeStreet\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCity()) != null) {
                conds.add("\"urn:schemas:contacts:homeCity\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCountry()) != null) {
                conds.add("\"urn:schemas:contacts:homeCountry\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                conds.add("\"urn:schemas:contacts:homePostalCode\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getState()) != null) {
                conds.add("\"urn:schemas:contacts:homeState\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
        }
        if (filter.getOtherAddress() != null) {
            addr = filter.getOtherAddress();
            tmpStr = addr.getStreet();
            if (tmpStr != null) {
                conds.add("\"urn:schemas:contacts:otherstreet\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCity()) != null) {
                conds.add("\"urn:schemas:contacts:othercity\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getCountry()) != null) {
                conds.add("\"urn:schemas:contacts:othercountry\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getPostalCode()) != null) {
                conds.add("\"urn:schemas:contacts:otherpostalcode\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = addr.getState()) != null) {
                conds.add("\"urn:schemas:contacts:otherstate\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
        }
        if ((tmpStr = filter.getHomePhone()) != null) {
            conds.add("\"urn:schemas:contacts:homePhone\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getBusinessPhone()) != null) {
            conds.add("\"urn:schemas:contacts:telephoneNumber\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getMobilePhone()) != null) {
            conds.add("\"urn:schemas:contacts:mobile\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getPager()) != null) {
            conds.add("\"urn:schemas:contacts:pager\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getCategories()) != null) {
            String[] filterCats = null;
            filterCats = Utils.splitString(tmpStr);
            tmpCondition = "(";
            for (i = 0; i < filterCats.length; ++i) {
                if (i != 0) {
                    tmpCondition = (String)tmpCondition + " AND ";
                }
                tmpCondition = (String)tmpCondition + "\"http://schemas.microsoft.com/exchange/keywords-utf8\" LIKE '%" + this.encodeXMLContent(filterCats[i]) + "%'";
            }
            tmpCondition = (String)tmpCondition + ")";
            conds.add(tmpCondition);
        }
        if ((tmpStr = filter.getOtherPhone()) != null) {
            conds.add("\"urn:schemas:contacts:otherTelephone\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if ((tmpStr = filter.getPhoneNumber()) != null) {
            conds.add("((\"urn:schemas:contacts:homePhone\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:telephoneNumber\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:mobile\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%') OR (\"urn:schemas:contacts:otherTelephone\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'))");
        }
        if ((tmpStr = filter.getDescription()) != null) {
            conds.add("\"urn:schemas:httpmail:textdescription\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
        }
        if (filter.getDetails() != null) {
            ContactOtherDetails dtl = filter.getDetails();
            tmpStr = dtl.getDepartment();
            if (tmpStr != null) {
                conds.add("\"urn:schemas:contacts:department\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getAssistant()) != null) {
                conds.add("\"urn:schemas:contacts:secretarycn\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getManager()) != null) {
                conds.add("\"urn:schemas:contacts:manager\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getNickname()) != null) {
                conds.add("\"urn:schemas:contacts:nickname\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getOffice()) != null) {
                conds.add("\"urn:schemas:contacts:roomnumber\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getPartner()) != null) {
                conds.add("\"urn:schemas:contacts:spousecn\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
            if ((tmpStr = dtl.getProfession()) != null) {
                conds.add("\"urn:schemas:contacts:profession\" LIKE '%" + this.encodeXMLContent(tmpStr) + "%'");
            }
        }
        if (filter.getFromLastModifiedDate() != null) {
            String gmtFromLastModifiedDate = Utils.localToExchangeDate(filter.getFromLastModifiedDate());
            conds.add("\"DAV:getlastmodified\" &gt;= '" + gmtFromLastModifiedDate + "' ");
        }
        if (filter.getToLastModifiedDate() != null) {
            String gmToLastModifiedDate = Utils.localToExchangeDate(filter.getToLastModifiedDate());
            conds.add("\"DAV:getlastmodified\" &lt;= '" + gmToLastModifiedDate + "' ");
        }
        String[] filterUids = null;
        tmpStr = filter.getId();
        if (tmpStr != null) {
            filterUids = Utils.splitString(tmpStr);
            tmpCondition = "(";
            for (i = 0; i < filterUids.length; ++i) {
                if (i != 0) {
                    tmpCondition = (String)tmpCondition + " OR ";
                }
                tmpCondition = (String)tmpCondition + "\"DAV:uid\" = '" + filterUids[i] + "'";
            }
            conds.add((String)tmpCondition + ")");
        }
        Object whereSql = "";
        if (conds.size() > 0) {
            for (i = 0; i < conds.size(); ++i) {
                if (i != 0) {
                    whereSql = (String)whereSql + " AND ";
                }
                whereSql = (String)whereSql + conds.get(i).toString() + " ";
            }
            whereSql = " where " + (String)whereSql;
        }
        String sql = selectSql + fromSql + (String)whereSql;
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        String searchPath = this.getContactFolderUrl();
        SearchMethod method = new SearchMethod(searchPath, xmlSql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        if (filter.getMaxRows() != -1) {
            method.setRequestHeader(new Header("Range", "rows=0-" + (filter.getMaxRows() - 1)));
        }
        if ((code = (client = this.getHttpClient()).executeMethod((HttpMethod)method)) < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting mail messages");
        }
        Enumeration enm = method.getResponses();
        ArrayList<ExchangeContact> contacts = new ArrayList<ExchangeContact>();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeContact contact = this.createContactObj(entity);
            if (contact == null) continue;
            boolean uidFound = false;
            if (filterUids != null) {
                for (int i2 = 0; i2 < filterUids.length; ++i2) {
                    if (!filterUids[i2].equals(contact.getId())) continue;
                    uidFound = true;
                    break;
                }
            } else {
                uidFound = true;
            }
            if (!uidFound) continue;
            contacts.add(contact);
        }
        return contacts;
    }

    private ExchangeContact createContactObj(ResponseEntity entity) {
        ExchangeContact ct = new ExchangeContact();
        Enumeration enm1 = entity.getProperties();
        ContactAddress businessAddress = null;
        ContactAddress homeAddress = null;
        ContactAddress otherAddress = null;
        ContactOtherDetails details = null;
        while (enm1.hasMoreElements()) {
            BaseProperty prop = (BaseProperty)enm1.nextElement();
            String propName = prop.getLocalName();
            String propValue = prop.getPropertyAsString();
            if (propValue == null || propValue.length() == 0) continue;
            if (propName.equalsIgnoreCase("l")) {
                businessAddress = businessAddress == null ? new ContactAddress() : businessAddress;
                businessAddress.setCity(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("sn")) {
                ct.setLastName(propValue);
                continue;
            }
            if (propName.equals("receiptTime")) {
                ct.setTimeReceived(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("fileas")) {
                ct.setDislpayName(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("contactslocation")) {
                ct.setLocation(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("givenName")) {
                ct.setFirstName(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("facsimiletelephonenumber")) {
                ct.setBusinessFax(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("mailingaddressid")) {
                ct.setMailingAdressType(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("co")) {
                businessAddress = businessAddress == null ? new ContactAddress() : businessAddress;
                businessAddress.setCountry(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("middlename")) {
                ct.setMiddleName(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("l")) {
                ct.setLastName(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("postalcode")) {
                businessAddress = businessAddress == null ? new ContactAddress() : businessAddress;
                businessAddress.setPostalCode(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("title")) {
                ct.setJobTitle(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("st")) {
                businessAddress = businessAddress == null ? new ContactAddress() : businessAddress;
                businessAddress.setState(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("department")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setDepartment(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("uid")) {
                ct.setId(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("personaltitle")) {
                ct.setPersonalTitle(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("o")) {
                ct.setCompany(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("street")) {
                businessAddress = businessAddress == null ? new ContactAddress() : businessAddress;
                businessAddress.setStreet(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("businesshomepage")) {
                ct.setBusinessHomePage(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("otherstreet")) {
                otherAddress = otherAddress == null ? new ContactAddress() : otherAddress;
                otherAddress.setStreet(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("telephoneNumber")) {
                ct.setBusinessPhone(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("mobile")) {
                ct.setMobilePhone(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("pager")) {
                ct.setPager(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("lastmodified")) {
                ct.setLastModified(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("categories")) {
                NodeList nodeList = prop.getElement().getChildNodes();
                if (nodeList.getLength() == 0) continue;
                Object categories = "";
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getFirstChild() == null) continue;
                    if (i != 0) {
                        categories = (String)categories + ",";
                    }
                    categories = (String)categories + nodeList.item(i).getFirstChild().getNodeValue();
                }
                ct.setCategories((String)categories);
                continue;
            }
            if (propName.equalsIgnoreCase("homeCity")) {
                homeAddress = homeAddress == null ? new ContactAddress() : homeAddress;
                homeAddress.setCity(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("homeStreet")) {
                homeAddress = homeAddress == null ? new ContactAddress() : homeAddress;
                homeAddress.setStreet(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("hasattachment")) {
                ct.setHasAttachment(ContactManager.stringToBoolean(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("profession")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setProfession(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("textdescription")) {
                ct.setMessage(propValue);
                ct.setDescription(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("htmldescription")) {
                ct.setHtmlMessage(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("othercountry")) {
                otherAddress = otherAddress == null ? new ContactAddress() : otherAddress;
                otherAddress.setCountry(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("otherpostalcode")) {
                otherAddress = otherAddress == null ? new ContactAddress() : otherAddress;
                otherAddress.setPostalCode(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("homeCountry")) {
                homeAddress = homeAddress == null ? new ContactAddress() : homeAddress;
                homeAddress.setCountry(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("othercity")) {
                otherAddress = otherAddress == null ? new ContactAddress() : otherAddress;
                otherAddress.setCity(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("manager")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setManager(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("homeState")) {
                homeAddress = homeAddress == null ? new ContactAddress() : homeAddress;
                homeAddress.setState(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("roomnumber")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setOffice(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("homePostalCode")) {
                homeAddress = homeAddress == null ? new ContactAddress() : homeAddress;
                homeAddress.setPostalCode(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("otherstate")) {
                otherAddress = otherAddress == null ? new ContactAddress() : otherAddress;
                otherAddress.setState(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("nickname")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setNickname(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("spousecn")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setPartner(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("secretarycn")) {
                details = details == null ? new ContactOtherDetails() : details;
                details.setAssistant(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("email1")) {
                ct.setEMail1(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("email2")) {
                ct.setEMail2(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("email3")) {
                ct.setEMail3(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("href")) {
                ct.setHref(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("otherTelephone")) {
                ct.setOtherPhone(propValue);
                continue;
            }
            if (!propName.equalsIgnoreCase("homePhone")) continue;
            ct.setHomePhone(propValue);
        }
        if (businessAddress != null) {
            ct.setBusinessAddress(businessAddress);
        }
        if (homeAddress != null) {
            ct.setHomeAddress(homeAddress);
        }
        if (otherAddress != null) {
            ct.setOtherAddress(otherAddress);
        }
        if (details != null) {
            ct.setDetails(details);
        }
        return ct;
    }

    public void deleteContacts(String[] uids) throws Throwable {
        if (uids == null) {
            return;
        }
        ContactFilterInfo filterInfo = new ContactFilterInfo();
        Object uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = (String)uidFilter + ",";
            }
            uidFilter = (String)uidFilter + uids[i];
        }
        filterInfo.setId((String)uidFilter);
        ArrayList cts = this.getContacts(filterInfo);
        if (cts == null || cts.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        for (ExchangeContact ct : cts) {
            this.deleteContact(ct.getHref());
        }
    }

    public void deleteContact(String href) throws Throwable {
        try {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.deleteAttachmentsFor(href);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.deleteAtHref(href);
    }

    private String createURI() {
        String strContactItem = this.loginInfo.getMailBoxName() + "_contact_" + Calendar.getInstance().getTimeInMillis() + ".eml";
        return this.getContactFolderUrl() + "/" + strContactItem;
    }

    public void modifyContacts(String[] uids, ExchangeContact ct) throws Throwable {
        if (uids == null || ct == null) {
            return;
        }
        ContactFilterInfo filterInfo = new ContactFilterInfo();
        Object uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = (String)uidFilter + ",";
            }
            uidFilter = (String)uidFilter + uids[i];
        }
        filterInfo.setId((String)uidFilter);
        ArrayList cts = this.getContacts(filterInfo);
        if (cts == null || cts.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        for (ExchangeContact oldCt : cts) {
            oldCt.setNonNullValues(ct);
            if (ct.getHref() == null) {
                ct.setHref(oldCt.getHref());
            }
            this.saveContact(oldCt);
        }
    }

    public void modifyContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        this.modifyContacts(new String[]{ct.getId()}, ct);
        if (attachedFileNames != null && attachedFileContents != null) {
            this.addAttachments(ct.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    private ExchangeContact getContact(String uid) throws Throwable {
        ContactFilterInfo filterInfo = new ContactFilterInfo();
        filterInfo.setId(uid);
        ArrayList apts = this.getContacts(filterInfo);
        if (apts.size() == 0) {
            throw new WebDAVExceptions(4, "UID " + uid + " not found");
        }
        return (ExchangeContact)apts.get(0);
    }

    public void addAttachments(String href, String[] fileNames, Object[] contents) throws Throwable {
        if (href == null) {
            return;
        }
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        atchMgr.createAttachments(href, fileNames, contents);
    }

    public ArrayList getAttachments(String uid, boolean getContent) throws Throwable {
        if (uid == null) {
            return null;
        }
        ExchangeContact ct = this.getContact(uid);
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        return atchMgr.getAttachments(ct, getContent, null);
    }

    public void deleteAttachments(String uid, String[] fileNames) throws Throwable {
        ArrayList atchmts = this.getAttachments(uid, false);
        if (atchmts == null) {
            return;
        }
        block0: for (ExchangeAttachment atch : atchmts) {
            String fileName = atch.getFileName();
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (!fileName.equals(fileNames[i])) continue;
                    this.deleteAtHref(atch.getHref());
                    continue block0;
                }
                continue;
            }
            this.deleteAtHref(atch.getHref());
        }
    }

    private String createCategoriesXML(String companies) {
        if (companies == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(companies, ",");
        Object compXml = "<e:keywords-utf8>";
        if (tokenizer.countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                compXml = (String)compXml + "<x:v>" + tokenizer.nextToken() + "</x:v>";
            }
        } else {
            compXml = (String)compXml + "<x:v></x:v>";
        }
        compXml = (String)compXml + "</e:keywords-utf8>";
        return compXml;
    }
}

