/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.webdav.AttachmentManager;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.MoveMethod;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;
import org.w3c.dom.NodeList;

public class CalendarManager
extends WebDAVFolderManager {
    public CalendarManager(WebDAVConnection con) {
        super(con);
    }

    static String createSelectSQL() {
        String sql = "select \"urn:schemas:calendar:organizer\",\"urn:schemas:calendar:method\",\"urn:schemas:calendar:sequence\",\"urn:schemas:calendar:busystatus\",\"urn:schemas:calendar:lastmodified\",\"http://schemas.microsoft.com/exchange/outlookmessageclass\",\"http://schemas.microsoft.com/mapi/apptstateflags\",\"http://schemas.microsoft.com/mapi/recurring\",\"http://schemas.microsoft.com/mapi/is_recurring\",\"http://schemas.microsoft.com/mapi/finvited\",\"http://schemas.microsoft.com/mapi/responsestatus\",\"http://schemas.microsoft.com/mapi/responsestate\",\"http://schemas.microsoft.com/mapi/response_requested\",\"http://schemas.microsoft.com/mapi/busystatus\",\"http://schemas.microsoft.com/mapi/intendedbusystatus\",\"urn:schemas:calendar:attendeestatus\",\"urn:schemas:calendar:reminderoffset\",\"urn:schemas:calendar:isorganizer\",\"urn:schemas:httpmail:htmldescription\",\"urn:schemas:httpmail:datereceived\" as receiptTime,\"http://schemas.microsoft.com/exchange/keywords-utf8\" as categories,\"http://schemas.microsoft.com/mapi/id/{00062002-0000-0000-C000-000000000046}/0x8214\" as label,\"urn:schemas:calendar:rrule\",\"DAV:contentclass\",\"urn:schemas:calendar:recurrenceid\",\"urn:schemas:calendar:recurrenceidrange\",\"urn:schemas:httpmail:textdescription\",\"urn:schemas:mailheader:from\",\"urn:schemas:mailheader:to\",\"urn:schemas:mailheader:sender\",\"urn:schemas:mailheader:subject\",\"urn:schemas:calendar:dtstart\",\"urn:schemas:calendar:dtend\",\"urn:schemas:calendar:duration\",\"urn:schemas:calendar:location\",\"urn:schemas:calendar:organizer\",\"urn:schemas:mailheader:bcc\",\"urn:schemas:calendar:uid\",\"DAV:href\",\"urn:schemas:httpmail:hasattachment\",\"urn:schemas:calendar:alldayevent\",\"urn:schemas:mailheader:importance\",\"urn:schemas:mailheader:sensitivity\",\"urn:schemas:mailheader:cc\"";
        return sql;
    }

    private String createSearchSQL(AppointmentFilterInfo filter) {
        String sql = CalendarManager.createSelectSQL() + " from " + this.getCalendarURL();
        Object whereSql = "";
        String tmpStr = null;
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add("\"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Appointment'");
        if (filter != null) {
            int i;
            Object tmpCondition;
            String[] params;
            if (filter.getFromStartTime() != null) {
                String gmtFromStartDate = Utils.localToExchangeDate(filter.getFromStartTime());
                conditions.add("\"urn:schemas:calendar:dtstart\" &gt;= '" + gmtFromStartDate + "' ");
            }
            if (filter.getToStartTime() != null) {
                String gmtToStartDate = Utils.localToExchangeDate(filter.getToStartTime());
                conditions.add("\"urn:schemas:calendar:dtstart\" &lt;= '" + gmtToStartDate + "' ");
            }
            if (filter.getFromEndTime() != null) {
                String gmtFromEndDate = Utils.localToExchangeDate(filter.getFromEndTime());
                conditions.add("\"urn:schemas:calendar:dtend\" &gt;= '" + gmtFromEndDate + "' ");
            }
            if (filter.getToEndTime() != null) {
                String gmtToEndDate = Utils.localToExchangeDate(filter.getToEndTime());
                conditions.add("\"urn:schemas:calendar:dtend\" &lt;= '" + gmtToEndDate + "' ");
            }
            if (filter.getHasAttachment() != null) {
                conditions.add("\"urn:schemas:httpmail:hasattachment\" = " + (filter.getHasAttachment() != false ? "TRUE" : "FALSE"));
            }
            if (filter.getIsAllDay() != null) {
                conditions.add("\"urn:schemas:calendar:alldayevent\" = " + (filter.getIsAllDay() != false ? "TRUE" : "FALSE"));
            }
            if (filter.getLocation() != null) {
                conditions.add("\"urn:schemas:calendar:location\" LIKE '%" + this.encodeXMLContent(filter.getLocation()) + "%'");
            }
            if (filter.getMessage() != null) {
                conditions.add("\"urn:schemas:httpmail:textdescription\" LIKE '%" + this.encodeXMLContent(filter.getMessage()) + "%'");
            }
            if (filter.getSubject() != null) {
                conditions.add("\"urn:schemas:mailheader:subject\" LIKE '%" + this.encodeXMLContent(filter.getSubject()) + "%'");
            }
            if (filter.getImportance() != null && !filter.getImportance().equalsIgnoreCase("normal")) {
                conditions.add("\"urn:schemas:mailheader:importance\" LIKE '%" + this.encodeXMLContent(filter.getImportance()) + "%'");
            }
            if (filter.getOptionalAttendees() != null) {
                params = Utils.splitString(filter.getOptionalAttendees());
                tmpCondition = "";
                for (i = 0; i < params.length; ++i) {
                    if (i != 0) {
                        tmpCondition = (String)tmpCondition + " AND ";
                    }
                    tmpCondition = (String)tmpCondition + "\"urn:schemas:mailheader:cc\" LIKE '%" + this.encodeXMLContent(params[i]) + "%'";
                }
                conditions.add(tmpCondition);
            }
            if (filter.getRequiredAttendees() != null) {
                params = Utils.splitString(filter.getRequiredAttendees());
                tmpCondition = "";
                for (i = 0; i < params.length; ++i) {
                    if (i != 0) {
                        tmpCondition = (String)tmpCondition + " AND ";
                    }
                    tmpCondition = (String)tmpCondition + "\"urn:schemas:mailheader:to\" LIKE '%" + this.encodeXMLContent(params[i]) + "%'";
                }
                conditions.add(tmpCondition);
            }
            if (filter.getResources() != null) {
                conditions.add("\"urn:schemas:mailheader:bcc\" LIKE '%" + this.encodeXMLContent(filter.getResources()) + "%'");
            }
            if (filter.getOrganizer() != null) {
                conditions.add("\"urn:schemas:calendar:organizer\" LIKE '%" + this.encodeXMLContent(filter.getOrganizer()) + "%'");
            }
            if ((tmpStr = filter.getSensitivity()) != null) {
                if (!tmpStr.equalsIgnoreCase("normal")) {
                    conditions.add("\"urn:schemas:mailheader:sensitivity\" LIKE '%" + this.encodeXMLContent(filter.getSensitivity()) + "%'");
                } else {
                    tmpStr = "(\"urn:schemas:mailheader:sensitivity\" != 'private' and \"urn:schemas:mailheader:sensitivity\" != 'personal' and \"urn:schemas:mailheader:sensitivity\" != 'company-confidential') ";
                    conditions.add(tmpStr);
                }
            }
            if (filter.getFromId() != null) {
                conditions.add("\"urn:schemas:mailheader:from\" LIKE '%" + this.encodeXMLContent(filter.getFromId()) + "%'");
            }
            if (filter.getDuration() != null) {
                conditions.add("\"urn:schemas:calendar:duration\" = " + filter.getDuration() * 60);
            }
            if (filter.getUids() != null) {
                params = Utils.splitString(filter.getUids());
                tmpCondition = "(";
                for (i = 0; i < params.length; ++i) {
                    if (i != 0) {
                        tmpCondition = (String)tmpCondition + " OR ";
                    }
                    tmpCondition = (String)tmpCondition + "\"urn:schemas:calendar:uid\" = '" + this.encodeXMLContent(params[i]) + "'";
                }
                conditions.add((String)tmpCondition + ")");
            }
            if (filter.getHref() != null) {
                conditions.add("\"DAV:href\" = '" + this.encodeXMLContent(filter.getHref()) + "'");
            }
            if (filter.getRecurringSeries() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/recurring\" = " + (filter.getRecurringSeries() == 1 ? "true" : "false"));
            }
            if (filter.getCategories() != null) {
                String[] filterCats = null;
                filterCats = Utils.splitString(filter.getCategories());
                tmpCondition = "(";
                for (i = 0; i < filterCats.length; ++i) {
                    if (i != 0) {
                        tmpCondition = (String)tmpCondition + " AND ";
                    }
                    tmpCondition = (String)tmpCondition + "\"http://schemas.microsoft.com/exchange/keywords-utf8\" LIKE '%" + this.encodeXMLContent(filterCats[i]) + "%'";
                }
                tmpCondition = (String)tmpCondition + ")";
                conditions.add(tmpCondition);
            }
            if (filter.getFromLastModifiedDate() != null) {
                String gmtFromLastModifiedDate = Utils.localToExchangeDate(filter.getFromLastModifiedDate());
                conditions.add("\"urn:schemas:calendar:lastmodified\" &gt;= '" + gmtFromLastModifiedDate + "' ");
            }
            if (filter.getToLastModifiedDate() != null) {
                String gmToLastModifiedDate = Utils.localToExchangeDate(filter.getToLastModifiedDate());
                conditions.add("\"urn:schemas:calendar:lastmodified\" &lt;= '" + gmToLastModifiedDate + "' ");
            }
            if (filter.getRecurrenceId() != null) {
                conditions.add("\"urn:schemas:calendar:recurrenceid\" = '" + this.encodeXMLContent(filter.getRecurrenceId()) + "'");
            }
            if (filter.getRecurrenceIdRange() != null) {
                conditions.add("\"urn:schemas:calendar:recurrenceidrange\" LIKE '%" + this.encodeXMLContent(filter.getRecurrenceIdRange()) + "%'");
            }
            if (filter.getLabel() != null) {
                conditions.add("\"http://schemas.microsoft.com/mapi/id/{00062002-0000-0000-C000-000000000046}/0x8214\" = CAST(\"" + filter.getLabel() + "\" as 'int')");
            }
            if (conditions.size() > 0) {
                for (int i2 = 0; i2 < conditions.size(); ++i2) {
                    if (i2 != 0) {
                        whereSql = (String)whereSql + " AND ";
                    }
                    whereSql = (String)whereSql + conditions.get(i2).toString() + " ";
                }
                sql = sql + " where " + (String)whereSql;
            }
        }
        sql = sql + " ORDER BY \"urn:schemas:calendar:dtstart\" DESC";
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        return xmlSql;
    }

    private String getCalendarURL() {
        return "\"" + this.getCalendarFolderUrl() + "\"";
    }

    static ExchangeAppointment createAppointmentObj(ResponseEntity entity, boolean isMailMeeting) {
        ExchangeAppointment apt = null;
        apt = isMailMeeting ? new ExchangeMailMeeting() : new ExchangeAppointment();
        Enumeration enm1 = entity.getProperties();
        while (enm1.hasMoreElements()) {
            BaseProperty prop = (BaseProperty)enm1.nextElement();
            String propName = prop.getLocalName();
            String propValue = prop.getPropertyAsString();
            if (propValue == null || propValue.length() == 0) continue;
            if (propName.equals("from")) {
                apt.setFromId(propValue);
                continue;
            }
            if (propName.equals("textdescription")) {
                apt.setMessage(propValue);
                continue;
            }
            if (propName.equals("htmldescription")) {
                apt.setHtmlMessage(propValue);
                continue;
            }
            if (propName.equals("to")) {
                apt.setToId(propValue);
                apt.setRequiredAttendees(propValue);
                continue;
            }
            if (propName.equals("cc")) {
                apt.setOptionalAttendees(propValue);
                continue;
            }
            if (propName.equals("subject")) {
                apt.setSubject(propValue);
                continue;
            }
            if (propName.equals("location")) {
                apt.setLocation(propValue);
                continue;
            }
            if (propName.equals("organizer")) {
                apt.setOrganizer(propValue);
                continue;
            }
            if (propName.equals("message-id")) {
                apt.setId(propValue);
                continue;
            }
            if (propName.equals("href")) {
                apt.setHref(propValue);
                continue;
            }
            if (propName.equals("bcc")) {
                apt.setResources(propValue);
                continue;
            }
            if (propName.equals("dtstart")) {
                Date startDate = Utils.exchangeToLocalDate(propValue);
                if (startDate == null) {
                    return null;
                }
                apt.setStartTime(startDate);
                continue;
            }
            if (propName.equals("dtend")) {
                apt.setEndTime(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("receiptTime")) {
                apt.setTimeReceived(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equals("duration")) {
                if (propValue == null || propValue.trim().length() <= 0) continue;
                apt.setDuration(Integer.parseInt(propValue) / 60);
                continue;
            }
            if (propName.equals("importance")) {
                apt.setImportance(propValue);
                continue;
            }
            if (propName.equals("sensitivity")) {
                apt.setSensitivity(propValue);
                continue;
            }
            if (propName.equals("hasattachment")) {
                apt.setHasAttachment(CalendarManager.stringToBoolean(propValue));
                continue;
            }
            if (!isMailMeeting && prop.getNamespaceURI() != null && prop.getNamespaceURI().equalsIgnoreCase("urn:schemas:calendar:") && propName.equals("uid")) {
                apt.setId(propValue);
                continue;
            }
            if (propName.equals("uid") && isMailMeeting) {
                ((ExchangeMailMeeting)apt).setMeetingUID(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("apptstateflags")) {
                apt.setAppStateFlag(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("is_recurring")) {
                apt.setRecurring(CalendarManager.stringToBoolean(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("recurring")) {
                apt.setRecurringSeries(CalendarManager.stringToBoolean(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("outlookmessageclass")) {
                apt.setAppointmentType(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("alldayevent")) {
                apt.setAllDay(CalendarManager.stringToBoolean(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("lastmodified")) {
                apt.setLastModified(Utils.exchangeToLocalDate(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("recurrenceid")) {
                apt.setRecurrenceId(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("recurrenceidrange")) {
                apt.setRecurrenceIdRange(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("isorganizer")) {
                apt.setIsOrganizer(CalendarManager.stringToBoolean(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("reminderoffset")) {
                apt.setReminderPeriod(Integer.parseInt(propValue) / 60);
                continue;
            }
            if (propName.equalsIgnoreCase("mailUID") && isMailMeeting) {
                ((ExchangeMailMeeting)apt).setId(propValue);
                continue;
            }
            if (propName.equals("categories")) {
                NodeList nodeList = prop.getElement().getChildNodes();
                if (nodeList.getLength() == 0) continue;
                Object categories = "";
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (nodeList.item(i).getFirstChild() == null) continue;
                    if (i != 0) {
                        categories = (String)categories + ",";
                    }
                    categories = (String)categories + nodeList.item(i).getFirstChild().getNodeValue();
                }
                apt.setCategories((String)categories);
                continue;
            }
            if (propName.equals("label")) {
                apt.setLabel(new Integer(propValue));
                continue;
            }
            if (!propName.equals("dateReceived") || !isMailMeeting) continue;
            Date dateReceived = Utils.exchangeToLocalDate(propValue);
            ((ExchangeMailMeeting)apt).setTimeReceived(dateReceived);
        }
        return apt;
    }

    public void createAppointment(ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        this.createAppointment(apt, null, null, sendNotification);
    }

    public void createAppointment(ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        apt.setAttendeeStatus(1);
        apt.setBusyStatus("BUSY");
        this.setAppointment(apt, false, sendNotification, attachedFileNames, attachedFileContents);
        if (attachedFileNames != null && attachedFileContents != null) {
            this.addAttachments(apt.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    private void addAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
        if (href == null) {
            return;
        }
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        atchMgr.createAttachments(href, fileNames, inStreams);
    }

    private ExchangeAppointment getAppointment(String uid) throws Throwable {
        AppointmentFilterInfo filterInfo = new AppointmentFilterInfo();
        filterInfo.setUids(uid);
        ArrayList apts = this.getAppointments(filterInfo);
        if (apts.size() == 0) {
            throw new WebDAVExceptions(4, "UID " + uid + " not found");
        }
        return (ExchangeAppointment)apts.get(0);
    }

    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        this.modifyAppointments(filterInfo, new String[]{apt.getId()}, apt, attachedFileNames, attachedFileContents, sendNotification);
        if (attachedFileNames != null && attachedFileContents != null) {
            this.addAttachments(apt.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    public void modifyAppointments(AppointmentFilterInfo filterInfo, String[] uids, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        if (uids == null || apt == null) {
            return;
        }
        Object uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = (String)uidFilter + ",";
            }
            uidFilter = (String)uidFilter + uids[i];
        }
        filterInfo.setUids((String)uidFilter);
        ArrayList apts = this.getAppointments(filterInfo);
        if (apts.size() == 0) {
            filterInfo.setRecurringSeries(0);
            apts = this.getAppointments(filterInfo);
        }
        if (apts == null || apts.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        for (ExchangeAppointment oldApt : apts) {
            oldApt.setNonNullValues(apt);
            if (apt.getHref() == null) {
                apt.setHref(oldApt.getHref());
            }
            this.setAppointment(oldApt, true, sendNotification, attachedFileNames, attachedFileContents);
            if (attachedFileNames == null || attachedFileContents == null) continue;
            this.addAttachments(oldApt.getHref(), attachedFileNames, attachedFileContents);
        }
    }

    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        if (apt == null || apt.getId() == null) {
            return;
        }
        filterInfo.setUids(apt.getId());
        ArrayList aptList = this.getAppointments(filterInfo);
        if (aptList == null || aptList.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        ExchangeAppointment oldApt = (ExchangeAppointment)aptList.get(0);
        oldApt.setNonNullValues(apt);
        this.setAppointment(oldApt, true, sendNotification, null, null);
    }

    private void setAppointment(ExchangeAppointment apt, boolean update, boolean sendNotification, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        Object meetingUri = null;
        String meetingRequestUri = null;
        if (update) {
            meetingUri = apt.getHref();
        } else {
            String strMtgItem = this.loginInfo.getMailBoxName() + "_meeting_" + Calendar.getInstance().getTimeInMillis() + ".eml";
            meetingUri = this.getCalendarFolderUrl() + "/" + strMtgItem;
            apt.setHref((String)meetingUri);
        }
        String strMtgRequestItem = this.loginInfo.getMailBoxName() + "_meetingrequest_" + Calendar.getInstance().getTimeInMillis() + ".eml";
        meetingRequestUri = this.getCalendarFolderUrl() + "/" + strMtgRequestItem;
        apt.setAppointmentType("IPM.Appointment");
        this.saveAppointment(apt, false);
        String uid = null;
        if (!update) {
            uid = this.findMeetingUID((String)meetingUri);
            apt.setId(uid);
        } else {
            uid = apt.getId();
        }
        if (uid == null) {
            throw new WebDAVExceptions(11, null, "Error getting UID of the meeting");
        }
        if (sendNotification) {
            String oldAptType = apt.getAppointmentType();
            String oldHref = apt.getHref();
            String oldReqAttd = apt.getRequiredAttendees();
            String oldOrg = apt.getOrganizer();
            String oldFrom = apt.getFromId();
            apt.setAppointmentType("IPM.Schedule.Meeting.Request");
            String strTo = "";
            if (oldAptType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Tent") || oldAptType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Neg") || oldAptType.equalsIgnoreCase("IPM.Schedule.Meeting.Resp.Pos")) {
                strTo = apt.getOrganizer() != null ? apt.getOrganizer() : apt.getFromId();
            } else {
                strTo = apt.getRequiredAttendees();
                if (strTo == null) {
                    strTo = apt.getOptionalAttendees();
                }
                if (strTo == null) {
                    strTo = apt.getResources();
                }
            }
            if (strTo != null) {
                apt.setRequiredAttendees(strTo);
                apt.setOrganizer(null);
                apt.setHref(meetingRequestUri);
                apt.setFromId(null);
                this.saveAppointment(apt, true);
                if (attachedFileNames != null && attachedFileContents != null) {
                    this.addAttachments(meetingRequestUri, attachedFileNames, attachedFileContents);
                }
                apt.setHref(oldHref);
                apt.setAppointmentType(oldAptType);
                apt.setRequiredAttendees(oldReqAttd);
                apt.setOrganizer(oldOrg);
                apt.setFromId(oldFrom);
                this.sendMessage(meetingRequestUri);
            }
        }
    }

    public String findMeetingUID(String meetingUri) throws Throwable {
        return Utils.findProperty(meetingUri, "uid", "urn:schemas:calendar:", this.getHttpClient());
    }

    public ArrayList getAppointments(AppointmentFilterInfo filter) throws Throwable {
        HttpClient client;
        int code;
        ArrayList<ExchangeAppointment> apts = new ArrayList<ExchangeAppointment>();
        String sql = this.createSearchSQL(filter);
        String searchPath = this.getCalendarFolderUrl();
        SearchMethod method = new SearchMethod(searchPath, sql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        if (filter.getMaxRows() != -1) {
            method.setRequestHeader(new Header("Range", "rows=0-" + (filter.getMaxRows() - 1)));
        }
        if ((code = (client = this.getHttpClient()).executeMethod((HttpMethod)method)) < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting appointments");
        }
        Enumeration enm = method.getResponses();
        String[] uids = null;
        if (filter.getUids() != null) {
            uids = Utils.splitString(filter.getUids());
        }
        String importanceFilter = null;
        String aptImportance = null;
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeAppointment apt = CalendarManager.createAppointmentObj(entity, false);
            if (apt == null) continue;
            aptImportance = apt.getImportance();
            importanceFilter = filter.getImportance();
            if (importanceFilter != null && importanceFilter.equalsIgnoreCase("normal") && aptImportance != null && !aptImportance.equalsIgnoreCase(importanceFilter) && aptImportance.length() != 0) continue;
            boolean uidFound = false;
            if (uids != null) {
                for (int i = 0; i < uids.length; ++i) {
                    if (!uids[i].equals(apt.getId())) continue;
                    uidFound = true;
                    break;
                }
            } else {
                uidFound = true;
            }
            if (!uidFound) continue;
            apts.add(apt);
        }
        return apts;
    }

    public void deleteAppointments(String[] uids, boolean notify, String message) throws Throwable {
        if (uids == null) {
            return;
        }
        AppointmentFilterInfo filterInfo = new AppointmentFilterInfo();
        Object uidFilter = "";
        for (int i = 0; i < uids.length; ++i) {
            if (i != 0) {
                uidFilter = (String)uidFilter + ",";
            }
            uidFilter = (String)uidFilter + uids[i];
        }
        filterInfo.setUids((String)uidFilter);
        ArrayList apts = this.getAppointments(filterInfo);
        if (apts == null || apts.size() == 0) {
            throw new WebDAVExceptions(4, null, "UID not found");
        }
        for (ExchangeAppointment apt : apts) {
            this.deleteAppointment(apt.getHref());
            if (!notify) continue;
            this.notifyDelete(apt, message);
        }
    }

    void notifyDelete(ExchangeAppointment apt, String message) throws Throwable {
        String strMtgRequestItem = this.loginInfo.getMailBoxName() + "_meetingrequest_" + Calendar.getInstance().getTimeInMillis() + ".eml";
        String meetingRequestUri = this.getCalendarFolderUrl() + "/" + strMtgRequestItem;
        String oldAptType = apt.getAppointmentType();
        String oldMessage = apt.getMessage();
        String oldHref = apt.getHref();
        String oldReqAttd = apt.getRequiredAttendees();
        String oldOrg = apt.getOrganizer();
        String oldFrom = apt.getFromId();
        apt.setAppointmentType("IPM.Schedule.Meeting.Canceled");
        apt.setMessage(message);
        String strTo = "";
        strTo = apt.getRequiredAttendees();
        if (strTo == null) {
            strTo = apt.getOptionalAttendees();
        }
        if (strTo != null) {
            apt.setOrganizer(null);
            apt.setHref(meetingRequestUri);
            this.saveAppointment(apt, true);
            apt.setHref(oldHref);
            apt.setAppointmentType(oldAptType);
            apt.setRequiredAttendees(oldReqAttd);
            apt.setOrganizer(oldOrg);
            apt.setFromId(oldFrom);
            apt.setMessage(oldMessage);
            this.sendMessage(meetingRequestUri);
        }
    }

    public void deleteAppointment(String href) throws Throwable {
        try {
            AttachmentManager atchMgr = new AttachmentManager(this.connection);
            atchMgr.deleteAttachmentsFor(href);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.deleteAtHref(href);
    }

    public void responseToMeetingRequest(String uid, int responseCode, boolean sendResponse, String responseMessage) throws Throwable {
        ArrayList aptList = null;
        ExchangeAppointment apt = null;
        Object[] results = this.getLatestMeetingRequest(uid);
        apt = (ExchangeAppointment)results[0];
        ArrayList inboxRequests = null;
        if (apt != null) {
            aptList = new ArrayList();
            aptList.add(apt);
            if (results[1] != null) {
                inboxRequests = (ArrayList)results[1];
            }
        } else {
            AppointmentFilterInfo filterInfo = new AppointmentFilterInfo();
            filterInfo.setUids(uid);
            filterInfo.setRecurringSeries(1);
            aptList = this.getAppointments(filterInfo);
            if (aptList.size() == 0) {
                filterInfo.setRecurringSeries(0);
                aptList = this.getAppointments(filterInfo);
            }
            if (aptList == null || aptList.size() == 0) {
                throw new WebDAVExceptions(4, "uid", "UID " + uid + " not found");
            }
        }
        for (int i = 0; i < aptList.size(); ++i) {
            apt = (ExchangeAppointment)aptList.get(i);
            String oldHref = apt.getHref();
            if (responseCode == 4) {
                this.deleteAppointment(apt.getHref());
                try {
                    this.deleteAppointments(new String[]{uid}, false, null);
                }
                catch (Throwable throwable) {}
            } else {
                if (responseCode == 2) {
                    apt.setBusyStatus("TENTATIVE");
                } else if (responseCode == 3) {
                    apt.setBusyStatus("BUSY");
                }
                apt.setReplyTime(Calendar.getInstance().getTime());
                apt.setAttendeeStatus(responseCode);
                if (inboxRequests != null) {
                    String seperator2;
                    int sepIndex;
                    apt.setAppointmentType("IPM.Appointment");
                    String strMtgItem = this.loginInfo.getMailBoxName() + "_meeting_" + Calendar.getInstance().getTimeInMillis() + ".eml";
                    String meetingUri = this.getCalendarFolderUrl() + "/" + strMtgItem;
                    String txtDescription = apt.getMessage();
                    if (txtDescription != null && (sepIndex = txtDescription.indexOf(seperator2 = "*~*~*~*~*~*~*~*~*~*\n")) >= 0) {
                        apt.setMessage(txtDescription.substring(sepIndex + seperator2.length()));
                    }
                    apt.setHref(meetingUri);
                    try {
                        this.deleteAppointments(new String[]{apt.getId()}, false, null);
                    }
                    catch (Throwable seperator2) {
                        // empty catch block
                    }
                }
                this.saveAppointment(apt, true);
            }
            if (sendResponse) {
                String oldAptType = apt.getAppointmentType();
                String oldMsg = apt.getMessage();
                String responseType = null;
                responseType = responseCode == 2 ? "IPM.Schedule.Meeting.Resp.Tent" : (responseCode == 4 ? "IPM.Schedule.Meeting.Resp.Neg" : "IPM.Schedule.Meeting.Resp.Pos");
                apt.setAppointmentType(responseType);
                apt.setMessage(responseMessage);
                String strTo = "";
                strTo = apt.getOrganizer() != null ? apt.getOrganizer() : apt.getFromId();
                apt.setRequiredAttendees(strTo);
                apt.setFromId(null);
                apt.setOrganizer(null);
                String strMtgItem = this.loginInfo.getMailBoxName() + "_meeting_" + Calendar.getInstance().getTimeInMillis() + ".eml";
                String meetingUri = this.getDraftFolderUrl() + strMtgItem;
                apt.setHref(meetingUri);
                this.saveAppointment(apt, true);
                this.sendMessage(meetingUri);
                apt.setAppointmentType(oldAptType);
                apt.setMessage(oldMsg);
            }
            apt.setHref(oldHref);
        }
        if (responseCode != 4 && inboxRequests != null) {
            this.deleteMeetingRequests(inboxRequests);
        }
    }

    private void saveAppointment(ExchangeAppointment apt, boolean isMeeting) throws Throwable {
        boolean isRecurring;
        Integer tmpInt;
        boolean isAllDay;
        String meetingUri = apt.getHref();
        String strXMLNSInfo = "xmlns:g=\"DAV:\" xmlns:e=\"http://schemas.microsoft.com/exchange/\" xmlns:mapi=\"http://schemas.microsoft.com/mapi/\" xmlns:mapit=\"http://schemas.microsoft.com/mapi/proptag/\" xmlns:x=\"xml:\" xmlns:cal=\"urn:schemas:calendar:\" xmlns:dt=\"urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/\" xmlns:header=\"urn:schemas:mailheader:\" xmlns:mail=\"urn:schemas:httpmail:\" xmlns:mapi_id=\"http://schemas.microsoft.com/mapi/id/{00062002-0000-0000-C000-000000000046}/\" ";
        Object strCalInfo = "";
        Date startDate = apt.getStartTime();
        Date endDate = apt.getEndTime();
        boolean bl = isAllDay = apt.isAllDay() != null ? apt.isAllDay() : false;
        if (isAllDay && startDate != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(startDate);
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            startDate = cal1.getTime();
            if (endDate != null) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(endDate);
                cal2.set(11, 24);
                cal2.set(12, 0);
                cal2.set(13, 0);
                cal2.set(14, 0);
                endDate = cal2.getTime();
            } else {
                cal1.set(11, 24);
                endDate = cal1.getTime();
            }
            strCalInfo = (String)strCalInfo + "<cal:alldayevent dt:dt=\"boolean\">1</cal:alldayevent> ";
        }
        Object recurringInfo = "";
        if (apt.getRecurrenceInfo() != null) {
            Date tmpDate;
            Object[] results = apt.getRecurrenceInfo().recurrenceInfoToRuleString(apt.getStartTime(), apt.getEndTime());
            recurringInfo = results[0].toString();
            if (results[1] != null && !(tmpDate = (Date)results[1]).equals(startDate)) {
                long timeDiff = endDate.getTime() - startDate.getTime();
                startDate = tmpDate;
                endDate.setTime(startDate.getTime() + timeDiff);
            }
            recurringInfo = (String)recurringInfo + "<mapi:is_recurring dt:dt=\"boolean\">0</mapi:is_recurring>";
            recurringInfo = (String)recurringInfo + "<mapi:recurring dt:dt=\"boolean\">1</mapi:recurring>";
        }
        if (startDate != null && endDate != null && startDate.compareTo(endDate) > 0) {
            throw new WebDAVExceptions(8, "Start date must not be later than the end date");
        }
        String strStartDate = Utils.localToLongExchangeDate(startDate);
        String strEndDate = Utils.localToLongExchangeDate(endDate);
        String tmpStr = apt.getLocation();
        if (tmpStr != null) {
            strCalInfo = (String)strCalInfo + "<cal:location>" + this.encodeXMLContent(tmpStr) + "</cal:location>";
        }
        if ((tmpStr = strStartDate) != null) {
            strCalInfo = (String)strCalInfo + "<cal:dtstart dt:dt=\"dateTime.tz\">" + tmpStr + "</cal:dtstart>";
        }
        if ((tmpStr = strEndDate) != null) {
            strCalInfo = (String)strCalInfo + "<cal:dtend dt:dt=\"dateTime.tz\">" + tmpStr + "</cal:dtend>";
        }
        if ((tmpStr = apt.getBusyStatus()) != null) {
            strCalInfo = (String)strCalInfo + "<cal:busystatus>" + this.encodeXMLContent(tmpStr) + "</cal:busystatus>";
        }
        if ((tmpStr = apt.getOrganizer()) != null) {
            strCalInfo = (String)strCalInfo + "<cal:organizer>" + this.encodeXMLContent(tmpStr) + "</cal:organizer>";
        }
        if (apt.getAttendeeStatus() != null) {
            strCalInfo = (String)strCalInfo + "<cal:attendeestatus dt:dt=\"int\">" + apt.getAttendeeStatus() + "</cal:attendeestatus>";
        }
        if (apt.getReplyTime() != null) {
            strCalInfo = (String)strCalInfo + "<cal:replytime dt:dt=\"dateTime.tz\">" + Utils.localToLongExchangeDate(apt.getReplyTime()) + "</cal:replytime>";
        }
        if (apt.getId() != null) {
            strCalInfo = (String)strCalInfo + "<cal:uid>" + apt.getId() + "</cal:uid> ";
        }
        strCalInfo = (String)strCalInfo + "<cal:meetingstatus>CONFIRMED</cal:meetingstatus><cal:alldayevent dt:dt=\"boolean\">" + (apt.isAllDay() != null ? (apt.isAllDay().booleanValue() ? "1" : "0") : "0") + "</cal:alldayevent><cal:responserequested dt:dt=\"boolean\">1</cal:responserequested>";
        int timeZoneId = -1;
        timeZoneId = apt.getTimeZoneId() != null ? apt.getTimeZoneId() : Utils.guessCDOTimeZoneId(Calendar.getInstance().getTimeZone());
        if (timeZoneId > 0) {
            strCalInfo = (String)strCalInfo + "<cal:timezoneid>" + timeZoneId + "</cal:timezoneid>";
        }
        Object strHeaderInfo = "";
        tmpStr = apt.getRequiredAttendees();
        if (tmpStr != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:to>" + this.encodeXMLContent(tmpStr) + "</header:to>";
        }
        if ((tmpStr = apt.getResources()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:bcc>" + this.encodeXMLContent(tmpStr) + "</header:bcc>";
        }
        if ((tmpStr = apt.getOptionalAttendees()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:cc>" + this.encodeXMLContent(tmpStr) + "</header:cc>";
        }
        if ((tmpStr = apt.getFromId()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:from>" + this.encodeXMLContent(tmpStr) + "</header:from>";
        }
        if ((tmpStr = apt.getSensitivity()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:sensitivity>" + this.encodeXMLContent(tmpStr) + "</header:sensitivity>";
        }
        if ((tmpStr = apt.getImportance()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<header:importance>" + this.encodeXMLContent(tmpStr) + "</header:importance>";
        }
        if ((tmpInt = apt.getReminderPeriod()) != null) {
            strHeaderInfo = (String)strHeaderInfo + "<cal:reminderoffset>" + tmpInt * 60 + "</cal:reminderoffset>";
        }
        Object strMailInfo = "";
        tmpStr = apt.getSubject();
        if (tmpStr != null) {
            strMailInfo = (String)strMailInfo + "<mail:subject>" + this.encodeXMLContent(tmpStr) + "</mail:subject>";
        }
        if ((tmpStr = apt.getMessage()) != null) {
            strMailInfo = (String)strMailInfo + "<mail:htmldescription>" + this.encodeXMLContent(tmpStr) + "</mail:htmldescription>";
        }
        Object strMapiInfo = "<mapi:finvited dt:dt=\"boolean\">1</mapi:finvited>";
        String appointmentType = "IPM.Appointment";
        tmpStr = apt.getAppointmentType();
        if (tmpStr != null) {
            appointmentType = tmpStr;
        }
        String instanceType = "";
        boolean bl2 = isRecurring = apt.isRecurringSeries() != null && apt.isRecurringSeries() != false;
        instanceType = appointmentType.equalsIgnoreCase("IPM.Appointment") ? (isRecurring ? "1" : "0") : (isRecurring ? "2" : "0");
        String contentClass = null;
        if (!appointmentType.equalsIgnoreCase("IPM.Appointment")) {
            strMapiInfo = (String)strMapiInfo + "<mapi:responsestatus dt:dt=\"int\">1</mapi:responsestatus><mapi:responsestate dt:dt=\"int\">0</mapi:responsestate><mapi:response_requested dt:dt=\"boolean\">1</mapi:response_requested><mapi:busystatus dt:dt=\"int\">1</mapi:busystatus><mapi:intendedbusystatus dt:dt=\"int\">2</mapi:intendedbusystatus>";
            contentClass = "urn:content-classes:calendarmessage";
        } else {
            contentClass = "urn:content-classes:appointment";
        }
        if (apt.getResponseCode() != null) {
            strMapiInfo = (String)strMapiInfo + "<mapi_id:0x8218 dt:dt=\"int\">" + apt.getResponseCode() + "</mapi_id:0x8218>";
        }
        String appStateFlags = null;
        if (isMeeting) {
            appStateFlags = isRecurring ? "1" : "3";
        } else {
            String requiredAttendees = apt.getRequiredAttendees();
            String optionalAttendees = apt.getOptionalAttendees();
            appStateFlags = !(requiredAttendees != null && requiredAttendees.trim().length() != 0 || optionalAttendees != null && optionalAttendees.trim().length() != 0) ? "0" : "1";
        }
        strMapiInfo = (String)strMapiInfo + "<mapi:apptstateflags dt:dt=\"int\">" + appStateFlags + "</mapi:apptstateflags>";
        if (apt.getCategories() != null) {
            strMapiInfo = (String)strMapiInfo + this.createCategoriesXML(this.encodeXMLContent(apt.getCategories()));
        }
        if (apt.getLabel() != null) {
            strMapiInfo = (String)strMapiInfo + "<mapi_id:0x8214 dt:dt=\"int\">" + apt.getLabel() + "</mapi_id:0x8214>";
        }
        String strMtgRequest = "<?xml version=\"1.0\"?><g:propertyupdate " + strXMLNSInfo + "><g:set><g:prop><g:contentclass>" + contentClass + "</g:contentclass><e:outlookmessageclass>" + appointmentType + "</e:outlookmessageclass>" + (String)strMailInfo + (String)strCalInfo + "<cal:instancetype dt:dt=\"int\">" + instanceType + "</cal:instancetype>" + (String)recurringInfo + (String)strHeaderInfo + (String)strMapiInfo + "</g:prop></g:set></g:propertyupdate>";
        int code = this.executeWebDAVMethod(PropPatchMethod.class, this.getHttpClient(), meetingUri, strMtgRequest, true);
        if (code < 200 || code >= 300) {
            throw new WebDAVExceptions(2, code, null, "Error creating/updating calendar event");
        }
    }

    private void sendMessage(String meetingUri) throws Throwable {
        String strSubmissionUri = this.loginInfo.getExchangeUrl() + "/##DavMailSubmissionURI##/";
        MoveMethod moveMethod = new MoveMethod(meetingUri);
        moveMethod.setDestination(strSubmissionUri);
        moveMethod.setRequestHeader("Content-Type", "message/rfc822");
        int code = this.client.executeMethod((HttpMethod)moveMethod);
        if (code < 200 || code >= 300) {
            throw new WebDAVExceptions(2, code, null, "Error creating calendar event");
        }
    }

    private void deleteMeetingRequests(ArrayList meetingRequests) throws Throwable {
        if (meetingRequests == null || meetingRequests.size() == 0) {
            return;
        }
        for (int i = 0; i < meetingRequests.size(); ++i) {
            String href = ((ExchangeAppointment)meetingRequests.get(i)).getHref();
            this.deleteAppointment(href);
        }
    }

    private Object[] getLatestMeetingRequest(String uid) throws Throwable {
        if (uid == null) {
            throw new WebDAVExceptions(4, "Invalid UId");
        }
        String sql = CalendarManager.createSelectSQL() + " from " + this.getInboxURL() + " where \"http://schemas.microsoft.com/exchange/outlookmessageclass\" = 'IPM.Schedule.Meeting.Request' and \"urn:schemas:calendar:uid\" = '" + uid + "' ";
        String xmlSql = "<?xml version=\"1.0\"?><d:searchrequest xmlns:d=\"DAV:\"><d:sql> " + sql + "</d:sql> </d:searchrequest> ";
        ArrayList<ExchangeAppointment> apts = new ArrayList<ExchangeAppointment>();
        String searchPath = this.getInboxURL();
        SearchMethod method = new SearchMethod(searchPath, xmlSql);
        method.setRequestHeader(new Header("Depth", "1"));
        method.setRequestHeader(new Header("Translate", "f"));
        HttpClient client = this.getHttpClient();
        int code = client.executeMethod((HttpMethod)method);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error getting mail messages");
        }
        Enumeration enm = method.getResponses();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            ExchangeAppointment apt = CalendarManager.createAppointmentObj(entity, false);
            if (apt == null) continue;
            apts.add(apt);
        }
        Object[] results = new Object[]{null, apts};
        if (apts == null || apts.size() == 0) {
            return results;
        }
        if (apts.size() == 1) {
            results[0] = apts.get(0);
            return results;
        }
        ExchangeAppointment latestApt = null;
        Date lastDate = null;
        for (int i = 0; i < apts.size(); ++i) {
            if (lastDate == null) {
                latestApt = (ExchangeAppointment)apts.get(i);
                lastDate = latestApt.getLastModified();
                continue;
            }
            Date modifiedDate = ((ExchangeAppointment)apts.get(i)).getLastModified();
            if (modifiedDate == null || lastDate == null || lastDate.compareTo(modifiedDate) >= 0) continue;
            latestApt = (ExchangeAppointment)apts.get(i);
            lastDate = latestApt.getLastModified();
        }
        results[0] = latestApt;
        return results;
    }

    private String getInboxURL() {
        return "\"" + this.getInboxFolderUrl() + "/\"";
    }

    public ArrayList getAttachments(String uid, boolean getContent) throws Throwable {
        if (uid == null) {
            return null;
        }
        ExchangeAppointment apt = this.getAppointment(uid);
        AttachmentManager atchMgr = new AttachmentManager(this.connection);
        return atchMgr.getAttachments(apt, getContent, null);
    }

    public void deleteAttachments(String uid, String[] fileNames) throws Throwable {
        ArrayList atchmts = this.getAttachments(uid, false);
        if (atchmts == null) {
            return;
        }
        block0: for (ExchangeAttachment atch : atchmts) {
            String fileName = atch.getFileName();
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    if (!fileName.equals(fileNames[i])) continue;
                    this.deleteAtHref(atch.getHref());
                    continue block0;
                }
                continue;
            }
            this.deleteAtHref(atch.getHref());
        }
    }

    public static Date validateRecurrenceStartDate(Date startDate, String week, String weekDay, int month) {
        GregorianCalendar aDateCal = new GregorianCalendar();
        aDateCal.setTime(startDate);
        int aDateMonth = aDateCal.get(2);
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        int requiredMonth = month - 1;
        cal.set(2, requiredMonth);
        cal.set(1, aDateCal.get(1));
        if (requiredMonth < aDateMonth) {
            ((Calendar)cal).roll(1, true);
        }
        if (weekDay.equalsIgnoreCase("MO")) {
            cal.set(7, 2);
        } else if (weekDay.equalsIgnoreCase("TU")) {
            cal.set(7, 3);
        } else if (weekDay.equalsIgnoreCase("WE")) {
            cal.set(7, 4);
        } else if (weekDay.equalsIgnoreCase("TH")) {
            cal.set(7, 5);
        } else if (weekDay.equalsIgnoreCase("FR")) {
            cal.set(7, 6);
        } else if (weekDay.equalsIgnoreCase("SA")) {
            cal.set(7, 7);
        } else if (weekDay.equalsIgnoreCase("SU")) {
            cal.set(7, 1);
        } else {
            throw new IllegalArgumentException();
        }
        int requiredWeek = 1;
        if (week.equalsIgnoreCase("first")) {
            requiredWeek = 1;
        } else if (week.equalsIgnoreCase("second")) {
            requiredWeek = 2;
        } else if (week.equalsIgnoreCase("third")) {
            requiredWeek = 3;
        } else if (week.equalsIgnoreCase("fourth") || week.equalsIgnoreCase("last")) {
            requiredWeek = 4;
        } else {
            throw new IllegalArgumentException();
        }
        cal.set(8, requiredWeek);
        if (requiredWeek == 4 && cal.get(5) + 7 <= ((Calendar)cal).getActualMaximum(5)) {
            ((Calendar)cal).roll(5, 7);
        }
        if (startDate.after(cal.getTime())) {
            cal.set(5, 1);
            ((Calendar)cal).roll(1, true);
            return CalendarManager.validateRecurrenceStartDate(cal.getTime(), week, weekDay, month);
        }
        return cal.getTime();
    }

    public static Date validateRecurrenceStartDate(Date startDate, String week, String weekDay) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        if (weekDay.equalsIgnoreCase("MO")) {
            cal.set(7, 2);
        } else if (weekDay.equalsIgnoreCase("TU")) {
            cal.set(7, 3);
        } else if (weekDay.equalsIgnoreCase("WE")) {
            cal.set(7, 4);
        } else if (weekDay.equalsIgnoreCase("TH")) {
            cal.set(7, 5);
        } else if (weekDay.equalsIgnoreCase("FR")) {
            cal.set(7, 6);
        } else if (weekDay.equalsIgnoreCase("SA")) {
            cal.set(7, 7);
        } else if (weekDay.equalsIgnoreCase("SU")) {
            cal.set(7, 1);
        } else {
            throw new IllegalArgumentException();
        }
        int requiredWeek = 1;
        if (week.equalsIgnoreCase("first")) {
            requiredWeek = 1;
        } else if (week.equalsIgnoreCase("second")) {
            requiredWeek = 2;
        } else if (week.equalsIgnoreCase("third")) {
            requiredWeek = 3;
        } else if (week.equalsIgnoreCase("fourth") || week.equalsIgnoreCase("last")) {
            requiredWeek = 4;
        } else {
            throw new IllegalArgumentException();
        }
        cal.set(8, requiredWeek);
        if (requiredWeek == 4 && cal.get(5) + 7 <= ((Calendar)cal).getActualMaximum(5)) {
            ((Calendar)cal).roll(5, 7);
        }
        if (startDate.after(cal.getTime())) {
            cal.set(5, 1);
            if (cal.get(2) == 11) {
                ((Calendar)cal).roll(1, true);
            }
            ((Calendar)cal).roll(2, true);
            return CalendarManager.validateRecurrenceStartDate(cal.getTime(), week, weekDay);
        }
        return cal.getTime();
    }

    private String createCategoriesXML(String companies) {
        if (companies == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(companies, ",");
        Object compXml = "<e:keywords-utf8>";
        if (tokenizer.countTokens() > 0) {
            while (tokenizer.hasMoreTokens()) {
                compXml = (String)compXml + "<x:v>" + tokenizer.nextToken() + "</x:v>";
            }
        } else {
            compXml = (String)compXml + "<x:v></x:v>";
        }
        compXml = (String)compXml + "</e:keywords-utf8>";
        return compXml;
    }
}

