/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.webdav.WebDAVLoginInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpURL;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.WebdavState;

class CFWebDAVResource
extends WebdavResource {
    HashMap cookieMap = null;
    HttpURL httpUrl = null;
    String cookieMatchingDomain = null;
    String cookieMatchingPath = null;
    WebDAVLoginInfo loginInfo = null;

    public CFWebDAVResource(HttpURL url, WebDAVLoginInfo loginInfo, boolean debug) throws IOException {
        this.httpUrl = url;
        this.setDebug(debug ? 1 : 0);
        this.loginInfo = loginInfo;
        this.setHttpURL(url);
    }

    public CFWebDAVResource(HttpURL url, String cookies, WebDAVLoginInfo loginInfo, String path, boolean debug) throws IOException {
        this.setDebug(debug ? 1 : 0);
        this.httpUrl = url;
        this.cookieMatchingDomain = loginInfo.getExchangeHost();
        this.cookieMatchingPath = path;
        this.cookieMap = this.parseCookies(cookies);
        this.loginInfo = loginInfo;
        this.setHttpURL(url);
    }

    public HttpClient getSessionInstance(HttpURL httpURL, boolean reset) throws IOException {
        HttpClient client = super.getSessionInstance(httpURL, reset);
        if (this.loginInfo.getProxyHost() != null && this.loginInfo.getProxyPort() != -1) {
            HostConfiguration hostConfig = client.getHostConfiguration();
            hostConfig.setProxy(this.loginInfo.getProxyHost(), this.loginInfo.getProxyPort());
        }
        if (this.cookieMap != null) {
            WebdavState state = new WebdavState();
            try {
                this.setCookies(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            client.setState((HttpState)state);
        }
        return client;
    }

    private void setCookies(WebdavState state) throws Exception {
        if (this.cookieMap == null) {
            return;
        }
        Iterator it = this.cookieMap.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            String value = this.cookieMap.get(name).toString();
            state.addCookie(new Cookie(this.cookieMatchingDomain, name, value, this.cookieMatchingPath, -1, false));
        }
    }

    private HashMap parseCookies(String cookies) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        StringTokenizer tokenizer1 = new StringTokenizer(cookies, "\n");
        while (tokenizer1.hasMoreElements()) {
            String line = tokenizer1.nextElement().toString();
            StringTokenizer tokenizer2 = new StringTokenizer(line, ";");
            while (tokenizer2.hasMoreElements()) {
                String value;
                String name;
                String cookieStr = tokenizer2.nextElement().toString();
                int index = cookieStr.indexOf(61);
                if (index >= 0) {
                    int index1;
                    name = cookieStr.substring(0, index);
                    value = null;
                    if (name.trim().equals("path") && (index1 = cookieStr.indexOf("cadata=")) > 0) {
                        value = cookieStr.substring(index1 + "cadata=".length());
                        name = "cadata";
                    }
                    if (value == null) {
                        value = cookieStr.substring(index + 1);
                    }
                } else {
                    name = cookieStr;
                    value = "";
                }
                if (!name.equalsIgnoreCase("sessionid") && !name.equalsIgnoreCase("cadata")) continue;
                cookieMap.put(name, value);
            }
        }
        return cookieMap;
    }
}

