/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webdav;

import coldfusion.exchange.ExchangeAbstractObject;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.webdav.EnumAttsMethod;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webdav.WebDAVConnection;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVFolderManager;
import coldfusion.exchange.webservice.Exchange2007AttachmentManager;
import coldfusion.util.MimeTypeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.methods.PropPatchMethod;

public class AttachmentManager
extends WebDAVFolderManager {
    AttachmentManager(WebDAVConnection con) {
        super(con);
    }

    ArrayList getAttachments(String href) throws Throwable {
        ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
        Object[] results = this.executWebDAVMethodHelper(EnumAttsMethod.class, this.getHttpClient(), href, null, true);
        int code = (Integer)results[0];
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error enumerating attachments");
        }
        EnumAttsMethod method = (EnumAttsMethod)((Object)results[1]);
        Enumeration enm = method.getResponses();
        while (enm.hasMoreElements()) {
            ResponseEntity entity = (ResponseEntity)enm.nextElement();
            ExchangeAttachment atch = this.createAttachmentObj(entity);
            atch.setHref(entity.getHref());
            attachments.add(atch);
        }
        return attachments;
    }

    ArrayList getAttachments(ExchangeAbstractObject exchObj, boolean getContent, String folderPath) throws Throwable {
        String href = exchObj.getHref();
        ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
        Object[] results = this.executWebDAVMethodHelper(EnumAttsMethod.class, this.getHttpClient(), href, null, true);
        int code = (Integer)results[0];
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error enumerating attachments");
        }
        EnumAttsMethod method = (EnumAttsMethod)((Object)results[1]);
        Enumeration enm = method.getResponses();
        WebDAVExceptions webDAVException = null;
        while (enm.hasMoreElements()) {
            ResponseEntity entity = (ResponseEntity)enm.nextElement();
            ExchangeAttachment atch = this.createAttachmentObj(entity);
            String attachmentHRef = Utils.encodeForBracket(entity.getHref());
            atch.setHref(attachmentHRef);
            if (getContent && webDAVException == null) {
                results = this.executeHttpMethod(GetMethod.class, this.getHttpClient(), attachmentHRef, true);
                code = (Integer)results[0];
                GetMethod getMethod = (GetMethod)results[1];
                if (code < 200 || code > 300) {
                    webDAVException = new WebDAVExceptions(2, code, null, "Error getting attachments - " + entity.getHref());
                    if (code != 501) {
                        throw webDAVException;
                    }
                }
                atch.setFileContent(getMethod.getResponseBodyAsStream());
            }
            attachments.add(atch);
        }
        if (webDAVException != null) {
            ArrayList atchmts2007 = null;
            try {
                atchmts2007 = this.getAttachmentsForExchange2007(exchObj, folderPath);
            }
            catch (Throwable t) {
                throw webDAVException;
            }
            for (ExchangeAttachment atch : attachments) {
                ArrayList lst;
                if (atch.isMessage().booleanValue()) {
                    atchmts2007.add(atch);
                }
                if (atch.getCID() == null || (lst = this.findAttachmentInArray(atchmts2007, atch)).size() != 1) continue;
                ExchangeAttachment wsAtch = (ExchangeAttachment)lst.get(0);
                wsAtch.setCID(atch.getCID());
            }
            return atchmts2007;
        }
        return attachments;
    }

    private ArrayList findAttachmentInArray(ArrayList wsAtchmts, ExchangeAttachment atch) {
        ArrayList<ExchangeAttachment> resultArray = new ArrayList<ExchangeAttachment>();
        for (ExchangeAttachment wsAtchmt : wsAtchmts) {
            if (!wsAtchmt.getFileName().equals(atch.getFileName())) continue;
            resultArray.add(wsAtchmt);
        }
        return resultArray;
    }

    private ArrayList getAttachmentsForExchange2007(ExchangeAbstractObject exchObj, String folderPath) throws Throwable {
        Exchange2007AttachmentManager atchMgr = new Exchange2007AttachmentManager(this.connection);
        return atchMgr.getAttachments(exchObj, folderPath);
    }

    void deleteAttachment(String href) throws Throwable {
        this.deleteAtHref(href);
    }

    void deleteAttachmentsFor(String href) throws Throwable {
        ArrayList atchs = this.getAttachments(href);
        if (atchs == null || atchs.size() == 0) {
            return;
        }
        for (int i = 0; i < atchs.size(); ++i) {
            ExchangeAttachment atch = (ExchangeAttachment)atchs.get(i);
            try {
                this.deleteAtHref(atch.getHref());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    void crateAttachment(String href, String fileName, byte[] content) throws Throwable {
        Object uri = null;
        uri = fileName != null ? href + "/" + fileName : href + "/attach" + Calendar.getInstance().getTimeInMillis();
        uri = Utils.getEncodedHref((String)uri);
        PutMethod putMethod = new PutMethod((String)uri);
        putMethod.setRequestBody((InputStream)new ByteArrayInputStream(content));
        HttpClient client = this.getHttpClient();
        int code = client.executeMethod((HttpMethod)putMethod);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error adding attachment");
        }
        String mimeType = MimeTypeUtils.guessMimeType((String)fileName);
        if (mimeType == null) {
            return;
        }
        String strXMLNSInfo = "xmlns:g=\"DAV:\" xmlns:d=\"http://schemas.microsoft.com/mapi/proptag/\" xmlns:x=\"xml:\" xmlns:mail=\"urn:schemas:httpmail:\" ";
        String strAtchTypeRequest = "<?xml version=\"1.0\"?><g:propertyupdate " + strXMLNSInfo + "><g:set><g:prop><d:x370e001f>" + mimeType + "</d:x370e001f></g:prop></g:set></g:propertyupdate>";
        code = this.executeWebDAVMethod(PropPatchMethod.class, this.getHttpClient(), (String)uri, strAtchTypeRequest, true);
        if (code < 200 || code > 300) {
            throw new WebDAVExceptions(2, code, null, "Error setting mime-type of the attachment");
        }
    }

    void createAttachments(String href, String[] fileNames, Object[] contents) throws Throwable {
        if (fileNames.length != contents.length) {
            throw new WebDAVExceptions(9, "Error adding attachments. Number of filenames do not match number of attachments");
        }
        for (int i = 0; i < fileNames.length; ++i) {
            if (!(contents[i] instanceof byte[])) {
                throw new WebDAVExceptions(10, "Invalid argument value to createAttachments. Contnet of the file should be byte[]");
            }
            this.crateAttachment(href, fileNames[i], (byte[])contents[i]);
        }
    }

    private ExchangeAttachment createAttachmentObj(ResponseEntity entity) {
        ExchangeAttachment atch = new ExchangeAttachment();
        Enumeration enm1 = entity.getProperties();
        while (enm1.hasMoreElements()) {
            BaseProperty prop = (BaseProperty)enm1.nextElement();
            String propName = prop.getLocalName();
            String propValue = prop.getPropertyAsString();
            if (propValue == null || propValue.length() == 0) continue;
            if (propName.equalsIgnoreCase("x3703001f")) {
                atch.setFileExt(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("x3704001f")) {
                atch.setShortFileName(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("x37050003")) {
                if (Integer.parseInt(propValue) == 5) {
                    atch.setMessage(true);
                    continue;
                }
                atch.setMessage(false);
                continue;
            }
            if (propName.equalsIgnoreCase("x370e001f")) {
                atch.setMimeType(propValue);
                continue;
            }
            if (propName.equalsIgnoreCase("x0e200003")) {
                atch.setFileSize(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("x0e210003")) {
                atch.setAttachmentNum(Integer.parseInt(propValue));
                continue;
            }
            if (propName.equalsIgnoreCase("attachmentfilename")) {
                atch.setFileName(propValue);
                continue;
            }
            if (!propName.equalsIgnoreCase("x3712001f")) continue;
            atch.setCID(propValue);
        }
        return atch;
    }
}

