/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.microsoft.graph.AbstractServiceManager;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.QueryType;
import coldfusion.runtime.Cast;
import coldfusion.util.MimeTypeUtils;
import coldfusion.util.RB;
import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.models.AttachmentBase;
import com.microsoft.graph.models.AttachmentBaseCollectionResponse;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.OpenTypeExtension;
import com.microsoft.graph.models.TaskFileAttachment;
import com.microsoft.graph.models.TaskStatus;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.models.TodoTaskCollectionResponse;
import com.microsoft.graph.models.TodoTaskList;
import com.microsoft.graph.models.TodoTaskListCollectionResponse;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TaskManager
extends AbstractServiceManager {
    private static volatile TaskManager instance = null;
    private final String defaultTodoListId;
    private final String QUERY_EXPANDER = "($filter=id eq 'Com.Adobe.ColdFusion.ActualWork' or id eq 'Com.Adobe.ColdFusion.TotalWork' or id eq 'Com.Adobe.ColdFusion.BillingInfo' or id eq 'Com.Adobe.ColdFusion.Mileage' or id eq 'Com.Adobe.ColdFusion.Companies' or id eq 'Com.Adobe.ColdFusion.PercentCompleted')";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance(GraphServiceClient graphServiceClient) {
        if (instance == null) {
            Class<TaskManager> clazz = TaskManager.class;
            // MONITORENTER : coldfusion.exchange.microsoft.graph.TaskManager.class
            if (instance == null) {
                instance = new TaskManager(graphServiceClient);
            }
            // MONITOREXIT : clazz
        }
        TaskManager.instance.graphServiceClient = graphServiceClient;
        return instance;
    }

    protected TaskManager(GraphServiceClient client) {
        super(client);
        TodoTaskListCollectionResponse todoTaskLists = this.graphServiceClient.me().todo().lists().get(requestConfiguration -> {
            requestConfiguration.queryParameters.filter = "displayName eq 'Tasks'";
        });
        this.defaultTodoListId = ((TodoTaskList)todoTaskLists.getValue().get(0)).getId();
    }

    public void create(ExchangeTask exchangeTask, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        TodoTask task = this.createTask(exchangeTask);
        TodoTask postedTask = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().post(task);
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Extension extension : this.getExtensions(exchangeTask)) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(postedTask.getId()).extensions().toPostRequestInformation(extension));
        }
        BatchResponseContent batchResponseContent = this.executeBatchOperation(batchRequestContent);
        if (attachedFileNames != null && attachedFileContents != null) {
            List<TaskFileAttachment> attachments = this.getTaskAttachments(attachedFileNames, attachedFileContents);
            for (TaskFileAttachment attachment : attachments) {
                this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(postedTask.getId()).attachments().post((AttachmentBase)attachment);
            }
        }
        exchangeTask.setId(postedTask.getId());
    }

    public ArrayList<ExchangeTask> get(TaskFilterInfo filter) throws ReflectiveOperationException {
        ArrayList<ExchangeTask> exchangeTasks = new ArrayList<ExchangeTask>();
        String id = filter.getId();
        if (!this.isNullOrEmpty(id)) {
            this.splitCommaSeperatedString(id).forEach(uid -> {
                TodoTask todoTask = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).get(requestConfig -> {
                    requestConfig.queryParameters.expand = new String[]{"extensions($filter=id eq 'Com.Adobe.ColdFusion.ActualWork' or id eq 'Com.Adobe.ColdFusion.TotalWork' or id eq 'Com.Adobe.ColdFusion.BillingInfo' or id eq 'Com.Adobe.ColdFusion.Mileage' or id eq 'Com.Adobe.ColdFusion.Companies' or id eq 'Com.Adobe.ColdFusion.PercentCompleted')"};
                });
                exchangeTasks.add(this.createTask(todoTask));
            });
        } else {
            String filterParameter = this.getFilter(filter);
            int maxRows = filter.getMaxRows();
            ArrayList taskList = new ArrayList();
            if (maxRows == -1) {
                tasks = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().get(requestConfiguration -> {
                    requestConfiguration.queryParameters.filter = filterParameter;
                    requestConfiguration.queryParameters.expand = new String[]{"extensions($filter=id eq 'Com.Adobe.ColdFusion.ActualWork' or id eq 'Com.Adobe.ColdFusion.TotalWork' or id eq 'Com.Adobe.ColdFusion.BillingInfo' or id eq 'Com.Adobe.ColdFusion.Mileage' or id eq 'Com.Adobe.ColdFusion.Companies' or id eq 'Com.Adobe.ColdFusion.PercentCompleted')"};
                });
                TaskManager.iterateCollection(taskList, this.graphServiceClient, requestInfo -> {
                    requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                    requestInfo.addQueryParameter("%24expand", (Object)new String[]{"extensions($filter=id eq 'Com.Adobe.ColdFusion.ActualWork' or id eq 'Com.Adobe.ColdFusion.TotalWork' or id eq 'Com.Adobe.ColdFusion.BillingInfo' or id eq 'Com.Adobe.ColdFusion.Mileage' or id eq 'Com.Adobe.ColdFusion.Companies' or id eq 'Com.Adobe.ColdFusion.PercentCompleted')"});
                    return requestInfo;
                }, tasks, TodoTaskCollectionResponse::createFromDiscriminatorValue);
            } else {
                tasks = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().get(requestConfiguration -> {
                    requestConfiguration.queryParameters.filter = filterParameter;
                    requestConfiguration.queryParameters.expand = new String[]{"extensions($filter=id eq 'Com.Adobe.ColdFusion.ActualWork' or id eq 'Com.Adobe.ColdFusion.TotalWork' or id eq 'Com.Adobe.ColdFusion.BillingInfo' or id eq 'Com.Adobe.ColdFusion.Mileage' or id eq 'Com.Adobe.ColdFusion.Companies' or id eq 'Com.Adobe.ColdFusion.PercentCompleted')"};
                    requestConfiguration.queryParameters.top = maxRows;
                });
                taskList.addAll(tasks.getValue());
            }
            for (TodoTask task : taskList) {
                exchangeTasks.add(this.createTask(task));
            }
        }
        return exchangeTasks;
    }

    public void modify(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        TodoTask todoTask = this.createTask(task);
        this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(task.getId()).patch(todoTask);
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Extension extension : this.getExtensions(task)) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(task.getId()).extensions().byExtensionId(extension.getId()).toPatchRequestInformation(extension));
        }
        BatchResponseContent batchResponseContent = this.executeBatchOperation(batchRequestContent);
        if (attachedFileNames != null && attachedFileContents != null) {
            List<TaskFileAttachment> attachments = this.getTaskAttachments(attachedFileNames, attachedFileContents);
            for (TaskFileAttachment attachment : attachments) {
                this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(task.getId()).attachments().post((AttachmentBase)attachment);
            }
        }
    }

    public void delete(String[] uids) throws IOException {
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (String uid : uids) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).toDeleteRequestInformation());
        }
        this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }

    public ArrayList<ExchangeAttachment> getAttachments(String uid) throws IOException {
        AttachmentBaseCollectionResponse attachmentCollectionResponse = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).attachments().get();
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        HashSet<String> requestIdSet = new HashSet<String>();
        for (AttachmentBase attachmentBase : attachmentCollectionResponse.getValue()) {
            requestIdSet.add(batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).attachments().byAttachmentBaseId(attachmentBase.getId()).toGetRequestInformation()));
        }
        BatchResponseContent batchResponseContent = this.executeBatchOperation(batchRequestContent);
        ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
        for (String requestId : requestIdSet) {
            AttachmentBase attachment = (AttachmentBase)batchResponseContent.getResponseById(requestId, AttachmentBase::createFromDiscriminatorValue);
            attachments.add(this.getExchangeAttachment(attachment.getId(), attachment.getSize(), attachment.getName(), attachment.getContentType(), ((TaskFileAttachment)attachment).getContentBytes()));
        }
        return attachments;
    }

    public void deleteAttachments(String uid, String[] fileNames) throws IOException {
        AttachmentBaseCollectionResponse attachmentCollectionResponse = this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).attachments().get(requestConfig -> this.getFilterToDeleteAttachments(fileNames).ifPresent(filter -> {
            requestConfig.queryParameters.filter = filter;
        }));
        for (AttachmentBase attachmentBase : attachmentCollectionResponse.getValue()) {
            this.graphServiceClient.me().todo().lists().byTodoTaskListId(this.defaultTodoListId).tasks().byTodoTaskId(uid).attachments().byAttachmentBaseId(attachmentBase.getId()).delete();
        }
    }

    private Extension getExtension(String id, String key, Object value) {
        OpenTypeExtension extension = new OpenTypeExtension();
        extension.setOdataType("microsoft.graph.openTypeExtension");
        extension.setExtensionName(id);
        extension.setId(id);
        HashMap<String, Object> additionalData = new HashMap<String, Object>();
        additionalData.put(key, value);
        extension.setAdditionalData(additionalData);
        return extension;
    }

    private List<Extension> getExtensions(ExchangeTask exchangeTask) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        this.setIfPresent(exchangeTask.getActualWork(), actualWork -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.ActualWork", "actualWork", actualWork)));
        this.setIfPresent(exchangeTask.getTotalWork(), totalWork -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.TotalWork", "totalWork", totalWork)));
        this.setIfPresent(exchangeTask.getBillingInfo(), billingInfo -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.BillingInfo", "billingInfo", billingInfo)));
        this.setIfPresent(exchangeTask.getMileage(), mileage -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.Mileage", "mileage", mileage)));
        this.setIfPresent(exchangeTask.getCompanies(), companies -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.Companies", "companies", companies)));
        this.setIfPresent(exchangeTask.getPercentComplete(), percentCompleted -> extensions.add(this.getExtension("Com.Adobe.ColdFusion.PercentCompleted", "percentCompleted", percentCompleted)));
        return extensions;
    }

    private TodoTask createTask(ExchangeTask exchangeTask) {
        TodoTask task = new TodoTask();
        this.normalizeTask(exchangeTask);
        if (exchangeTask.getDateCompleted() != null) {
            task.setCompletedDateTime(this.getDateTime(ZonedDateTime.ofInstant(exchangeTask.getDateCompleted().toInstant(), ZoneId.systemDefault())));
        }
        this.setIfPresent(exchangeTask.getStatus(), status -> task.setStatus(this.getStatus((String)status)));
        this.setIfPresent(exchangeTask.getSubject(), arg_0 -> ((TodoTask)task).setTitle(arg_0));
        this.setIfPresent(exchangeTask.getMessage(), message -> this.createItemBody(BodyType.Text, (String)message), arg_0 -> ((TodoTask)task).setBody(arg_0));
        this.setIfPresent(exchangeTask.getHtmlMessage(), message -> this.createItemBody(BodyType.Html, (String)message), arg_0 -> ((TodoTask)task).setBody(arg_0));
        String categories = exchangeTask.getCategories();
        if (categories != null) {
            task.setCategories(this.splitCommaSeperatedString(categories));
        }
        if (exchangeTask.getDueDate() != null) {
            task.setDueDateTime(this.getDateTime(ZonedDateTime.ofInstant(exchangeTask.getDueDate().toInstant(), ZoneId.systemDefault())));
        }
        if (exchangeTask.getReminderDate() != null) {
            task.setIsReminderOn(Boolean.valueOf(true));
            task.setReminderDateTime(this.getDateTime(ZonedDateTime.ofInstant(exchangeTask.getReminderDate().toInstant(), ZoneId.systemDefault())));
        }
        if (exchangeTask.getStartDate() != null) {
            task.setStartDateTime(this.getDateTime(ZonedDateTime.ofInstant(exchangeTask.getStartDate().toInstant(), ZoneId.systemDefault())));
        }
        this.setIfPresent(exchangeTask.getPriority(), priority -> task.setImportance(this.getPriority((Integer)priority)));
        this.setIfPresent(exchangeTask.getIsReminderSet(), arg_0 -> ((TodoTask)task).setIsReminderOn(arg_0));
        return task;
    }

    private ExchangeTask createTask(TodoTask task) {
        String categories;
        ExchangeTask exchangeTask = new ExchangeTask();
        if (task.getCompletedDateTime() != null) {
            exchangeTask.setDateCompleted(this.getDateTime(task.getCompletedDateTime()));
        }
        exchangeTask.setStatus(this.getStatus(task.getStatus()));
        exchangeTask.setPriority(this.getPriority(task.getImportance()));
        if (task.getStartDateTime() != null) {
            exchangeTask.setStartDate(this.getDateTime(task.getStartDateTime()));
        }
        if (task.getDueDateTime() != null) {
            exchangeTask.setDueDate(this.getDateTime(task.getDueDateTime()));
        }
        if (task.getReminderDateTime() != null) {
            exchangeTask.setReminderDate(this.getDateTime(task.getReminderDateTime()));
        }
        List categoriesList = task.getCategories();
        StringBuilder categoriesBuilder = new StringBuilder();
        if (categoriesList != null) {
            for (String category : categoriesList) {
                if (category == null) continue;
                categoriesBuilder.append(category).append(",");
            }
        }
        if ((categories = categoriesBuilder.toString()).length() > 0) {
            exchangeTask.setCategories(categories.substring(0, categories.length() - 1));
        }
        exchangeTask.setIsReminderSet(task.getIsReminderOn());
        exchangeTask.setId(task.getId());
        exchangeTask.setSubject(task.getTitle());
        ItemBody itemBody = task.getBody();
        if (itemBody != null) {
            switch (itemBody.getContentType()) {
                case Html: {
                    exchangeTask.setHtmlMessage(itemBody.getContent());
                    break;
                }
                default: {
                    exchangeTask.setMessage(itemBody.getContent());
                }
            }
        }
        exchangeTask.setHasAttachment(task.getHasAttachments());
        if (task.getLastModifiedDateTime() != null) {
            exchangeTask.setLastModified(Date.from(task.getLastModifiedDateTime().atZoneSameInstant(ZoneId.systemDefault()).toInstant()));
        }
        this.setIfPresent(task.getExtensions(), extensions -> extensions.size() > 0 ? extensions : null, extensions -> {
            for (Extension extension : extensions) {
                Map additionalData = extension.getAdditionalData();
                switch (extension.getId()) {
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.ActualWork": {
                        this.setIfPresent(additionalData.get("actualWork"), Cast::_int, exchangeTask::setActualWork);
                        break;
                    }
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.TotalWork": {
                        this.setIfPresent(additionalData.get("totalWork"), Cast::_int, exchangeTask::setTotalWork);
                        break;
                    }
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.BillingInfo": {
                        this.setIfPresent((String)additionalData.get("billingInfo"), exchangeTask::setBillingInfo);
                        break;
                    }
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.Companies": {
                        this.setIfPresent((String)additionalData.get("companies"), exchangeTask::setCompanies);
                        break;
                    }
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.Mileage": {
                        this.setIfPresent((String)additionalData.get("mileage"), exchangeTask::setMileage);
                        break;
                    }
                    case "microsoft.graph.openTypeExtension.Com.Adobe.ColdFusion.PercentCompleted": {
                        this.setIfPresent(additionalData.get("percentCompleted"), Cast::_float, exchangeTask::setPercentComplete);
                    }
                }
            }
        });
        return exchangeTask;
    }

    private String getFilter(TaskFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        this.setIfPresent(filter.getFromDateCompleted(), dateCompleted -> QueryType.GE.getQuery(new String[]{"completedDateTime", "dateTime"}, this.getDateStringISO((Date)dateCompleted), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToDateCompleted(), dateCompleted -> QueryType.LE.getQuery(new String[]{"completedDateTime", "dateTime"}, this.getDateStringISO((Date)dateCompleted), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromDueDate(), dueDate -> QueryType.GE.getQuery(new String[]{"dueDateTime", "dateTime"}, this.getDateStringISO((Date)dueDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToDueDate(), dueDate -> QueryType.LE.getQuery(new String[]{"dueDateTime", "dateTime"}, this.getDateStringISO((Date)dueDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromReminderDate(), reminderDate -> QueryType.GE.getQuery(new String[]{"reminderDateTime", "dateTime"}, this.getDateStringISO((Date)reminderDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToReminderDate(), reminderDate -> QueryType.LE.getQuery(new String[]{"reminderDateTime", "dateTime"}, this.getDateStringISO((Date)reminderDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromStartDate(), startDate -> QueryType.GE.getQuery(new String[]{"startDateTime", "dateTime"}, this.getDateStringISO((Date)startDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToStartDate(), startDate -> QueryType.LE.getQuery(new String[]{"startDateTime", "dateTime"}, this.getDateStringISO((Date)startDate), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getIsReminderSet(), isReminderSet -> QueryType.EQ.getQuery("isReminderOn", isReminderSet.toString()), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getStatus(), status -> QueryType.EQ.getQuery("status", this.getStatus((String)status).getValue(), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getPriority(), priority -> QueryType.EQ.getQuery("importance", this.getPriority((Integer)priority).getValue(), true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getSubject(), subject -> QueryType.CONTAINS.getQuery("title", (String)subject, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMessage(), message -> QueryType.CONTAINS.getQuery(new String[]{"body", "content"}, (String)message, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromLastModifiedDate(), lastModifiedDate -> QueryType.GE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToLastModifiedDate(), lastModifiedDate -> QueryType.LE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getCategories(), value -> {
            List<String> categoriesList = this.splitCommaSeperatedString((String)value);
            StringBuilder queryBuilder = new StringBuilder();
            categoriesList.forEach(category -> queryBuilder.append(this.getAnyFilter((String)category, QueryType.EQ, new String[]{"i"}, "categories")).append(QueryType.AND.getSpaced()));
            return queryBuilder.toString();
        }, filterBuilder::append);
        return filterBuilder.length() > 0 ? this.trimAnd(filterBuilder.toString()) : filterBuilder.toString();
    }

    private TaskStatus getStatus(String status) {
        if (status == null) {
            return TaskStatus.NotStarted;
        }
        String NOT_STARTED = "not_started";
        String IN_PROGRESS = "in_progress";
        String COMPLETED = "completed";
        String WAITING = "waiting";
        String DEFERRED = "deferred";
        return switch (status.toLowerCase()) {
            case "not_started" -> TaskStatus.NotStarted;
            case "in_progress" -> TaskStatus.InProgress;
            case "completed" -> TaskStatus.Completed;
            case "waiting" -> TaskStatus.WaitingOnOthers;
            case "deferred" -> TaskStatus.Deferred;
            default -> TaskStatus.NotStarted;
        };
    }

    private String getStatus(TaskStatus taskStatus) {
        if (taskStatus == null) {
            return "Invalid";
        }
        return switch (taskStatus) {
            case TaskStatus.NotStarted -> "Not_Started";
            case TaskStatus.InProgress -> "In_Progress";
            case TaskStatus.Completed -> "Completed";
            case TaskStatus.Deferred -> "Deferred";
            case TaskStatus.WaitingOnOthers -> "Waiting";
            default -> "Invalid";
        };
    }

    private Integer getPriority(Importance importance) {
        if (importance == null) {
            return 1;
        }
        return switch (importance) {
            case Importance.Low -> 0;
            case Importance.Normal -> 1;
            case Importance.High -> 2;
            default -> -1;
        };
    }

    private Importance getPriority(Integer priority) {
        if (priority == null) {
            return Importance.Normal;
        }
        return switch (priority) {
            case 0 -> Importance.Low;
            case 1 -> Importance.Normal;
            case 2 -> Importance.High;
            default -> Importance.Normal;
        };
    }

    private void normalizeTask(ExchangeTask task) {
        String status = task.getStatus();
        Float percentage = task.getPercentComplete();
        Date completeDate = task.getDateCompleted();
        if (status != null) {
            if ("Completed".equalsIgnoreCase(status)) {
                task.setPercentComplete(100.0f);
                if (completeDate == null) {
                    task.setDateCompleted(Date.from(ZonedDateTime.now().toInstant()));
                }
            } else if (!"Not_Started".equalsIgnoreCase(status)) {
                task.setDateCompleted(null);
                if (percentage != null && percentage.floatValue() >= 100.0f) {
                    task.setPercentComplete(0.0f);
                }
            } else {
                task.setDateCompleted(null);
                task.setPercentComplete(0.0f);
            }
        } else if (percentage != null) {
            if (percentage.floatValue() >= 100.0f) {
                task.setStatus("Completed");
                task.setPercentComplete(100.0f);
                if (completeDate == null) {
                    task.setDateCompleted(Date.from(ZonedDateTime.now().toInstant()));
                }
            } else {
                task.setDateCompleted(null);
                if (percentage.floatValue() > 0.0f) {
                    task.setStatus("In_Progress");
                } else {
                    task.setStatus("Not_Started");
                    task.setPercentComplete(0.0f);
                }
            }
        } else if (completeDate != null) {
            task.setStatus("Completed");
            task.setPercentComplete(100.0f);
            task.setDateCompleted(completeDate);
        }
        if (task.getDateCompleted() != null && task.getIsReminderSet() != null && task.getIsReminderSet().booleanValue()) {
            task.setIsReminderSet(Boolean.FALSE);
        }
    }

    private List<TaskFileAttachment> getTaskAttachments(String[] attachedFileNames, Object[] attachedFileContents) {
        ArrayList<TaskFileAttachment> attachments = new ArrayList<TaskFileAttachment>();
        if (attachedFileNames.length != attachedFileContents.length) {
            throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentCountMismatch", (Object[])new Object[]{attachedFileNames.length, attachedFileContents.length}));
        }
        for (int i = 0; i < attachedFileNames.length; ++i) {
            if (!(attachedFileContents[i] instanceof byte[])) {
                throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.attachmentInvalidType", (Object[])new Object[]{attachedFileNames[i], attachedFileContents[i]}));
            }
            TaskFileAttachment fileAttachment = new TaskFileAttachment();
            fileAttachment.setContentBytes((byte[])attachedFileContents[i]);
            fileAttachment.setName(attachedFileNames[i]);
            String mimeType = MimeTypeUtils.guessMimeType((String)attachedFileNames[i]);
            if (null != mimeType) {
                fileAttachment.setContentType(mimeType);
            }
            attachments.add(fileAttachment);
        }
        return attachments;
    }
}

