/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.DeleteType;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeFolderInfo;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.microsoft.graph.CalendarManager;
import coldfusion.exchange.microsoft.graph.ContactManager;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.GraphLoginInfo;
import coldfusion.exchange.microsoft.graph.MailManager;
import coldfusion.exchange.microsoft.graph.TaskManager;
import coldfusion.exchange.microsoft.graph.TokenAuthenticationProvider;
import coldfusion.exchange.webservice.AvailabilityData;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.util.RB;
import com.microsoft.graph.core.requests.BaseGraphRequestAdapter;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GraphConnection
extends ExchangeConnection {
    private GraphServiceClient graphServiceClient;
    private boolean isOpen = false;

    public GraphConnection(ExchangeLoginInfo loginInfo) {
        super(loginInfo);
    }

    @Override
    public void closeConnection() {
        this.graphServiceClient = null;
        this.isOpen = false;
    }

    @Override
    public void login() throws Throwable {
        this.graphServiceClient = new GraphServiceClient((RequestAdapter)new BaseGraphRequestAdapter((AuthenticationProvider)new TokenAuthenticationProvider(((GraphLoginInfo)this.getLoginInfo()).getAccessToken(), ((GraphLoginInfo)this.getLoginInfo()).getRefreshToken()), this.getLoginInfo().getExchangeHost()));
        this.isOpen = true;
    }

    @Override
    public void logoff() {
        this.closeConnection();
    }

    @Override
    public void createContact(ExchangeContact contact) {
        this.createContact(contact, null, null);
    }

    @Override
    public void createContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) {
        try {
            ContactManager.getInstance(this.graphServiceClient).create(ct, attachedFileNames, attachedFileContents);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCreatingContact"), ex);
        }
    }

    @Override
    public ArrayList<ExchangeContact> getContacts(ContactFilterInfo filter) throws Throwable {
        try {
            return ContactManager.getInstance(this.graphServiceClient).get(filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingContacts"), ex);
        }
    }

    @Override
    public void modifyContacts(String[] uids, ExchangeContact contact) throws Throwable {
        try {
            ContactManager.getInstance(this.graphServiceClient).modify(uids[0], contact, null, null);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingContact"), ex);
        }
    }

    @Override
    public void deleteContacts(String[] uids) throws Throwable {
        try {
            ContactManager.getInstance(this.graphServiceClient).delete(uids);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingContacts"), ex);
        }
    }

    @Override
    public void addContactAttachments(String uid, String[] fileNames, Object[] inStreams) throws Throwable {
    }

    @Override
    public ArrayList<ExchangeAttachment> getContactAttachments(String uid, boolean getContent) throws Throwable {
        try {
            return ContactManager.getInstance(this.graphServiceClient).getAttachments(uid);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAttachmentsFromContact"), e);
        }
    }

    @Override
    public void deleteContactAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            ContactManager.getInstance(this.graphServiceClient).deleteAttachments(uid);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingAttachmentsFromContact"), e);
        }
    }

    @Override
    public void modifyContact(ExchangeContact ct, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            ContactManager.getInstance(this.graphServiceClient).modify(ct.getId(), ct, attachedFileNames, attachedFileContents);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingContact"), ex);
        }
    }

    @Override
    public void responseToMeetingRequest(String uid, int responseCode, boolean sendResponse, String responseMessage) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).respond(uid, responseCode, sendResponse, responseMessage);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorRespondingToRequest"), ex);
        }
    }

    @Override
    public ArrayList<ExchangeAppointment> getAppointments(AppointmentFilterInfo filter) throws Throwable {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).get(filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAppointments"), ex);
        }
    }

    @Override
    public ArrayList<ExchangeAppointment> getAppointmentOccurences(AppointmentFilterInfo filter) throws Throwable {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).getOccurrences(filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAppointments"), ex);
        }
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, boolean sendNotification) throws Throwable {
        this.createAppointment(apt, null, null, sendNotification);
    }

    @Override
    public void deleteAppointments(String[] uids, boolean notify, String message) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).delete(uids, notify, message);
        }
        catch (RuntimeException e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingAppointments"), e);
        }
    }

    @Override
    public void modifyAppointments(AppointmentFilterInfo filterInfo, String[] uids, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).modify(apt.getId(), apt, attachedFileNames, attachedFileContents);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingAppointment"), e);
        }
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, boolean sendNotification) throws Throwable {
    }

    @Override
    public void deleteAppointment(String href) throws Throwable {
    }

    @Override
    public void createAppointment(ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).create(apt, attachedFileNames, attachedFileContents);
        }
        catch (RuntimeException e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCreatingAppointments"), e);
        }
    }

    @Override
    public void modifyAppointment(AppointmentFilterInfo filterInfo, ExchangeAppointment apt, String[] attachedFileNames, Object[] attachedFileContents, boolean sendNotification) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).modify(apt.getId(), apt, attachedFileNames, attachedFileContents);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingAppointment"), e);
        }
    }

    @Override
    public ArrayList<ExchangeAttachment> getAppointmentAttachments(String uid, boolean getContent) throws Throwable {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).getAttachments(uid, getContent);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAttachmentsFromAppointment"), e);
        }
    }

    @Override
    public void deleteAppointmentAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            CalendarManager.getInstance(this.graphServiceClient).deleteAttachments(uid, fileNames);
        }
        catch (Exception e) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingAttachmentsFromAppointment"), e);
        }
    }

    @Override
    public ArrayList<ExchangeTask> getTasks(TaskFilterInfo filter) throws Throwable {
        try {
            return TaskManager.getInstance(this.graphServiceClient).get(filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingTasks"), ex);
        }
    }

    @Override
    public void modifyTask(ExchangeTask task) throws Throwable {
        this.modifyTask(task, null, null);
    }

    @Override
    public void modifyTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            TaskManager.getInstance(this.graphServiceClient).modify(task, attachedFileNames, attachedFileContents);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingTask"), ex);
        }
    }

    @Override
    public void createTask(ExchangeTask task) throws Throwable {
        this.createTask(task, null, null);
    }

    @Override
    public void createTask(ExchangeTask task, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            TaskManager.getInstance(this.graphServiceClient).create(task, attachedFileNames, attachedFileContents);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCreatingTask"), ex);
        }
    }

    @Override
    public void deleteTasks(String[] uids) throws Throwable {
        try {
            TaskManager.getInstance(this.graphServiceClient).delete(uids);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingTasks"), ex);
        }
    }

    @Override
    public void addTaskAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
    }

    @Override
    public ArrayList<ExchangeAttachment> getTaskAttachments(String uid, boolean getContent) throws Throwable {
        try {
            return TaskManager.getInstance(this.graphServiceClient).getAttachments(uid);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAttachmentsFromTask"), ex);
        }
    }

    @Override
    public void deleteTaskAttachments(String uid, String[] fileNames) throws Throwable {
        try {
            TaskManager.getInstance(this.graphServiceClient).deleteAttachments(uid, fileNames);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingAttachmentsFromTask"), ex);
        }
    }

    @Override
    public ArrayList<ExchangeMessage> getMessages(MessageFilterInfo filter) throws Throwable {
        try {
            return MailManager.getInstance(this.graphServiceClient).getMessage(filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingMessages"), ex);
        }
    }

    @Override
    public void createMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
    }

    @Override
    public void modifyMessage(ExchangeMessage msg) throws Throwable {
        this.modifyMessage(msg, null, null);
    }

    @Override
    public void modifyMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws Throwable {
        try {
            MailManager.getInstance(this.graphServiceClient).modifyMessage(msg, attachedFileNames, attachedFileContents);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingMessage"), ex);
        }
    }

    @Override
    public void deleteMessages(String[] uids) throws Throwable {
    }

    @Override
    public void deleteMessages(String[] uids, String messageFolder) throws Throwable {
        try {
            MailManager.getInstance(this.graphServiceClient).deleteMessages(uids, messageFolder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingMessages"), ex);
        }
    }

    @Override
    public void addMessageAttachments(String href, String[] fileNames, Object[] inStreams) throws Throwable {
    }

    @Override
    public ArrayList<ExchangeAttachment> getMessageAttachments(String uid, boolean getContent) throws Throwable {
        return this.getMessageAttachments(uid, getContent, null);
    }

    @Override
    public ArrayList<ExchangeAttachment> getMessageAttachments(String uid, boolean getContent, String messageFolder) throws Throwable {
        try {
            return MailManager.getInstance(this.graphServiceClient).getMessageAttachments(uid, getContent, messageFolder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingAttachmentsFromMessage"), ex);
        }
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames) throws Throwable {
        this.deleteMessageAttachments(uid, fileNames, null);
    }

    @Override
    public void deleteMessageAttachments(String uid, String[] fileNames, String messageFolder) throws Throwable {
        try {
            MailManager.getInstance(this.graphServiceClient).deleteMessageAttachments(uid, fileNames, messageFolder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingMessages"), ex);
        }
    }

    @Override
    public ArrayList<ExchangeMailMeeting> getMessageMeetingInfo(String meetingUID, String mailUID) throws Throwable {
        try {
            return MailManager.getInstance(this.graphServiceClient).getMessageMeetingInfo(meetingUID, mailUID);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingMeetingInfo"), ex);
        }
    }

    @Override
    public void moveMessages(MessageFilterInfo filter, String destinationFolder) throws Throwable {
        try {
            if (destinationFolder == null) {
                throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.InvalidDestinationFolder"));
            }
            MailManager.getInstance(this.graphServiceClient).moveMessages(filter, destinationFolder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorMovingMessages"), ex);
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public ArrayList<ExchangeFolderInfo> getSubFolders(String folderName, boolean recurse) throws Throwable {
        try {
            return MailManager.getInstance(this.graphServiceClient).getChildFolders(folderName, recurse);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingSubFolders"), ex);
        }
    }

    @Override
    public void createFolder(String parentFolderId, ExchangeFolderExtendedInfo folder) throws Throwable {
        try {
            MailManager.getInstance(this.graphServiceClient).createFolder(parentFolderId, folder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCreatingFolder", (Object)folder.getDisplayName()), ex);
        }
    }

    @Override
    public ExchangeFolder getExchangeFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        try {
            return MailManager.getInstance(this.graphServiceClient).getFolderInfo(folderIdentifier, needsResolution, pathSeparatorRegex, false);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingFolder", (Object)folderIdentifier), ex);
        }
    }

    @Override
    public ExchangeFolderExtendedInfo getExchangeExtendedFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex) {
        try {
            return (ExchangeFolderExtendedInfo)MailManager.getInstance(this.graphServiceClient).getFolderInfo(folderIdentifier, needsResolution, pathSeparatorRegex, true);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingFolder", (Object)folderIdentifier), ex);
        }
    }

    @Override
    public ArrayList<ExchangeFolder> getSubFolders(String parentFolderId, FolderFilterInfo filter) {
        try {
            return MailManager.getInstance(this.graphServiceClient).getChildFolders(parentFolderId, filter);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingSubFolders"), ex);
        }
    }

    @Override
    public String copyFolder(String sourceFolderId, String destinationFolderId) {
        try {
            return MailManager.getInstance(this.graphServiceClient).copyFolder(sourceFolderId, destinationFolderId);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCopyingFolder"), ex);
        }
    }

    @Override
    public void deleteFolder(String[] folderIds, DeleteType type) {
        try {
            MailManager.getInstance(this.graphServiceClient).deleteFolder(folderIds, type);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingFolder"), ex);
        }
    }

    @Override
    public String moveFolder(String sourceFolderId, String destinationFolderId) {
        try {
            return MailManager.getInstance(this.graphServiceClient).moveFolder(sourceFolderId, destinationFolderId);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorMovingFolder"), ex);
        }
    }

    @Override
    public void updateFolder(String folderId, ExchangeFolderExtendedInfo folder) {
        try {
            MailManager.getInstance(this.graphServiceClient).updateFolder(folderId, folder);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorModifyingFolder"), ex);
        }
    }

    @Override
    public void emptyFolder(String folderId, DeleteType type, boolean deleteSubFolder) {
    }

    @Override
    public ArrayList getRoomList() {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).getRoomList();
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingRoomList"), ex);
        }
    }

    @Override
    public ArrayList getRooms(EmailAddress emailAddress) {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).getRooms(emailAddress);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingRooms"), ex);
        }
    }

    @Override
    public CFUserAvailability getUserAvailability(List<String> attendees, Date startDate, Date endDate, AvailabilityData type) {
        try {
            return CalendarManager.getInstance(this.graphServiceClient).getUserAvailability(attendees, startDate, endDate, type);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorGettingUserAvailability"), ex);
        }
    }

    @Override
    public ArrayList getConversations(String folderId, CFConversationFilter filter) {
        return null;
    }

    @Override
    public void copyConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        try {
            MailManager.getInstance(this.graphServiceClient).copyConversations(conversationFolderId, destinationFolderId, conversationId);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorCopyingConversations"), ex);
        }
    }

    @Override
    public void moveConversations(String conversationFolderId, String destinationFolderId, String conversationId) {
        try {
            MailManager.getInstance(this.graphServiceClient).moveConversations(conversationFolderId, destinationFolderId, conversationId);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorMovingConversations"), ex);
        }
    }

    @Override
    public void setReadStateToConversations(String conversationFolderId, String conversationId, boolean read) {
        try {
            MailManager.getInstance(this.graphServiceClient).setReadStateToConversations(conversationFolderId, conversationId, read);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorSettingReadStateToConversations"), ex);
        }
    }

    @Override
    public void deleteConversations(String conversationFolderId, String conversationId, DeleteType deleteType) {
        try {
            MailManager.getInstance(this.graphServiceClient).deleteConversations(conversationFolderId, conversationId, deleteType);
        }
        catch (Exception ex) {
            throw new GraphException(RB.getString(GraphConnection.class, (String)"GraphConnection.errorDeletingConversations"), ex);
        }
    }
}

