/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.image;

import coldfusion.image.Image;
import coldfusion.image.ImageHelper;
import coldfusion.image.ImageReader;
import coldfusion.image.ImageWriter;
import coldfusion.osgi.services.ImageService;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.server.SystemInfo;
import jakarta.servlet.jsp.PageContext;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;

public class ImageServiceImpl
implements ImageService {
    public Struct ImageGetExifMetadata(Object image, NeoPageContext pageContext) {
        return ((Image)image).getExifMetadata((PageContext)pageContext);
    }

    public String getReadableFormats() {
        String formats = SystemInfo.isMac() ? ImageReader.getReadableFormatsForOSX() : ImageReader.getReadableFormats();
        return formats;
    }

    public String getWriteableFormats() {
        String formats = SystemInfo.isMac() ? ImageWriter.getWritableFormatsForOSX() : ImageWriter.getWritableFormats();
        return formats;
    }

    public boolean isImage(Object value) {
        return value instanceof Image;
    }

    public boolean isImageFile(String value, NeoPageContext pageContext) {
        boolean isImage = false;
        try {
            new Image(value, (PageContext)pageContext);
            isImage = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isImage;
    }

    public Struct info(Object image) {
        return ((Image)image).info();
    }

    public BufferedImage getBufferedImage(Object image) {
        return ((Image)image).getCurrentImage();
    }

    public byte[] getImageBytes(Object image) {
        return ((Image)image).getImageBytes(null);
    }

    public Object newImage() {
        return new Image();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newImage(Object source, NeoPageContext pageContext) {
        Image newImage = null;
        if (source == null) {
            throw new CFPage.InvalidInputTypeException();
        }
        if (source instanceof Image) {
            return new Image((Image)source, true);
        }
        if (source instanceof byte[]) {
            return new Image((byte[])source);
        }
        if (source instanceof String) {
            return new Image((String)source, (PageContext)pageContext);
        }
        if (source instanceof BufferedImage) {
            return new Image((BufferedImage)source);
        }
        if (!(source instanceof JavaProxy)) throw new CFPage.InvalidInputTypeException();
        Object bImg = ((JavaProxy)source).getObject();
        if (!(bImg instanceof BufferedImage)) throw new CFPage.InvalidInputTypeException();
        return new Image((BufferedImage)bImg);
    }

    public void write(Object image, String destination, float quality, boolean overwrite, NeoPageContext pageContext, boolean progressive) {
        ((Image)image).write(destination, quality, overwrite, (PageContext)pageContext, progressive);
    }

    public Object readBase64(String data) {
        Image image = new Image();
        image.readBase64(data);
        return image;
    }

    public void writeBase64(Object image, String path, String format, boolean inHTMLFormat, boolean overwrite) {
        ((Image)image).writeBase64(path, format, inHTMLFormat, overwrite);
    }

    public Object imageNew(String source, int width, int height, String type) {
        return new Image(source, width, height, type);
    }

    public Object imageNew(String source, int width, int height, String type, String canvascolor) {
        return new Image(source, width, height, type, canvascolor);
    }

    public void clearRect(Object image, int x, int y, int width, int height) {
        ((Image)image).clearRect(x, y, width, height);
    }

    public void setDrawingTranparency(Object image, double percent) {
        ((Image)image).setDrawingTranparency(percent);
    }

    public int getWidth(Object image) {
        return ((Image)image).getWidth();
    }

    public int getHeight(Object image) {
        return ((Image)image).getHeight();
    }

    public void setColor(Object image, String color) {
        ((Image)image).setColor(color);
    }

    public void setXorMode(Object image, String color) {
        ((Image)image).setXorMode(color);
    }

    public void setAntiAliasing(Object image, String antialias) {
        ((Image)image).setAntiAliasing(antialias);
    }

    public void shearAxis(Object image, double shx, double shy) {
        ((Image)image).shearAxis(shx, shy);
    }

    public void rotateAxis(Object image, int x, int y, double angle) {
        ((Image)image).rotateAxis(x, y, angle);
    }

    public void rotateAxis(Object image, double angle) {
        ((Image)image).rotateAxis(angle);
    }

    public void translateAxis(Object image, int x, int y) {
        ((Image)image).translateAxis(x, y);
    }

    public void shear(Object image, float shear, String direction, String object) {
        ((Image)image).shear(shear, direction, object);
    }

    public Object copyArea(Object image, int x, int y, int width, int height) {
        return ((Image)image).copyArea(x, y, width, height);
    }

    public Object copyArea(Object image, int x, int y, int width, int height, int dx, int dy) {
        return ((Image)image).copyArea(x, y, width, height, dx, dy);
    }

    public Object imageRead(String path, NeoPageContext pageContext) {
        return new Image(path, (PageContext)pageContext);
    }

    public void overlay(Object image1, Object image2, String rule, String alpha) {
        ((Image)image1).overlay((Image)image2, rule, alpha);
    }

    public Object makeColorTransparent(Object img, Object color) {
        Image image = (Image)img;
        Image newImage = null;
        if (color instanceof String) {
            newImage = image.makeColorTransparent(Collections.singletonList((String)color));
        } else if (color instanceof List) {
            newImage = image.makeColorTransparent((List)color);
        }
        return newImage;
    }

    public Struct getExifMetadata(Object image, NeoPageContext pageContext) {
        return ((Image)image).getExifMetadata((PageContext)pageContext);
    }

    public Struct drawString(Object image, String string, int x, int y, Struct attr) {
        return ((Image)image).drawString(string, x, y, attr);
    }

    public void paste(Object image1, Object image2, int x, int y) {
        ((Image)image1).paste((Image)image2, x, y);
    }

    public void invert(Object image) {
        ((Image)image).invert();
    }

    public Object makeTranslucent(Object image, double percent) {
        return ((Image)image).makeTranslucent(percent);
    }

    public void setBackground(Object image, String color) {
        ((Image)image).setBackground(color);
    }

    public void crop(Object image, float x, float y, float width, float height) {
        ((Image)image).crop(x, y, width, height);
    }

    public Struct getImageMetadata(Object image, NeoPageContext pageContext) {
        return ((Image)image).getImageMetadata((PageContext)pageContext);
    }

    public Struct getIptcMetadata(Object image, NeoPageContext pageContext) {
        return ((Image)image).getIptcMetadata((PageContext)pageContext);
    }

    public String getExifTag(Object image, String tagname, NeoPageContext pageContext) {
        return ((Image)image).getExifTag(tagname, (PageContext)pageContext);
    }

    public String getIptcTag(Object image, String tagname, NeoPageContext pageContext) {
        return ((Image)image).getIptcTag(tagname, (PageContext)pageContext);
    }

    public void drawRect(Object image, int x, int y, int width, int height, boolean filled) {
        ((Image)image).drawRect(x, y, width, height, filled);
    }

    public void drawRoundRect(Object image, int x, int y, int width, int height, int arcWidth, int arcHeight, boolean filled) {
        ((Image)image).drawRoundRect(x, y, width, height, arcWidth, arcHeight, filled);
    }

    public void drawLines(Object image, int[] x, int[] y, boolean isPolygon, boolean filled) {
        ((Image)image).drawLines(x, y, isPolygon, filled);
    }

    public void addBorder(Object image, int thickness, String a, String b) {
        ((Image)image).addBorder(thickness, a, b);
    }

    public void draw3DRect(Object image, int x, int y, int width, int height, boolean raised, boolean filled) {
        ((Image)image).draw3DRect(x, y, width, height, raised, filled);
    }

    public void grayscale(Object image) {
        ((Image)image).grayscale();
    }

    public void drawCubicCurve(Object image, double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        ((Image)image).drawCubicCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }

    public void drawQuadraticCurve(Object image, double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        ((Image)image).drawQuadraticCurve(x1, y1, ctrlx, ctrly, x2, y2);
    }

    public void setDrawingStroke(Object image, Struct attributeCollection) {
        ((Image)image).setDrawingStroke(attributeCollection);
    }

    public void drawLine(Object image, int x1, int y1, int x2, int y2) {
        ((Image)image).drawLine(x1, y1, x2, y2);
    }

    public void drawPoint(Object image, int x, int y) {
        ((Image)image).drawPoint(x, y);
    }

    public void drawArc(Object image, int x, int y, int width, int height, int startAngle, int arcAngle, boolean filled) {
        ((Image)image).drawArc(x, y, width, height, startAngle, arcAngle, filled);
    }

    public void drawOval(Object image, int x, int y, int width, int height, boolean filled) {
        ((Image)image).drawOval(x, y, width, height, filled);
    }

    public void rotate(Object img, float angle, Object object) {
        Image image = (Image)img;
        image.rotate(image.getWidth() / 2, image.getHeight() / 2, angle, (String)object);
    }

    public void blur(Object image, int blurRadius) {
        ((Image)image).blur(blurRadius);
    }

    public void flip(Object image, String transpose) {
        ((Image)image).flip(transpose);
    }

    public void resize(Object image, String width, String height, String interpolation, double blurFactor) {
        String x = Image.HIGHESTQUALITY;
        ((Image)image).resize(width, height, interpolation, blurFactor);
    }

    public void resize(Object image, String width, String height, String interpolation) {
        ((Image)image).resize(width, height, interpolation);
    }

    public void scaleToFit(Object image, String fitWidth, String fitHeight, String interpolation, double blurFactor) {
        ((Image)image).scaleToFit(fitWidth, fitHeight, interpolation, blurFactor);
    }

    public void scaleToFit(Object image, String fitWidth, String fitHeight, String interpolation) {
        ((Image)image).scaleToFit(fitWidth, fitHeight, interpolation);
    }

    public void translate(Object image, int x, int y, String interpolation) {
        ((Image)image).translate(x, y, interpolation);
    }

    public void sharpen(Object image, float gain) {
        ((Image)image).sharpen(gain);
    }

    public Object createCaptcha(int height, int width, String text, String difficulty, String fonts, int fontsize) {
        return ImageHelper.createCaptcha(height, width, text, difficulty, fonts, fontsize);
    }

    public void rotate(Object image, float x, float y, float angle, String interpolation) {
        ((Image)image).rotate(x, y, angle, interpolation);
    }

    public Object castImage(Object x) {
        return (Image)x;
    }

    public String getSrcFormat(Object binObj) {
        return ((Image)binObj).getSrcFormat();
    }

    public boolean isImageAssignable(Class t) {
        return t.isAssignableFrom(Image.class);
    }

    public Object convertImage(Object image, boolean isBase64, PageContext pageContext) throws Exception {
        Image img;
        block8: {
            img = null;
            if (image instanceof Image) {
                img = new Image((Image)image);
            } else {
                try {
                    if (image.getClass().isArray() || image instanceof byte[]) {
                        img = new Image((byte[])image);
                        break block8;
                    }
                    if (image instanceof String) {
                        if (isBase64) {
                            Image tempImg = new Image();
                            tempImg.readBase64((String)image);
                            img = tempImg;
                        } else {
                            img = new Image((String)image, pageContext);
                        }
                        break block8;
                    }
                    throw new Exception();
                }
                catch (ClassCastException cex) {
                    throw new Exception();
                }
            }
        }
        return img;
    }

    public Class<?> getImageClass() {
        return Image.class;
    }
}

