/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.project.file.base.jelly;

import com.zerog.ia.project.file.base.jelly.XMLIterator;
import com.zerog.xml.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;

public class JellyReader {
    private File templateFile;
    private JellyContext context;
    private ExpressionFactory jexlFactory = new JexlExpressionFactory();
    private Map<File, Flexeraax3> xmlCache = new HashMap<File, Flexeraax3>();

    public void readXML(File file, File file2, Map map) throws ParseException {
        this.templateFile = file;
        this.context = new JellyContext();
        this.context.setVariables(map);
        Flexeraax3 flexeraax3 = this.readXML(file);
        Flexeraax3 flexeraax32 = this.readXML(file2);
        this.parseElement(new XMLIterator(flexeraax3), new XMLIterator(flexeraax32));
        map.putAll(this.context.getVariables());
    }

    private Flexeraax3 readXML(String string) throws ParseException {
        return this.readXML(new File(string));
    }

    private Flexeraax3 readXML(File file) throws ParseException {
        if (this.xmlCache.containsKey(file)) {
            return this.xmlCache.get(file);
        }
        Flexeraax6 flexeraax6 = null;
        try {
            flexeraax6 = new Flexeraax6(file);
        }
        catch (IOException iOException) {
            throw new ParseException("Can not open file: " + file.getAbsolutePath());
        }
        Flexeraax3 flexeraax3 = flexeraax6.aa();
        this.xmlCache.put(file, flexeraax3);
        return flexeraax3;
    }

    private void parseElement(XMLIterator xMLIterator, XMLIterator xMLIterator2) throws ParseException {
        while (xMLIterator.hasNext()) {
            Flexeraax3 flexeraax3 = xMLIterator.next();
            Flexeraax3 flexeraax32 = null;
            if (this.isJellyElement(flexeraax3)) {
                this.parseJellyTag(xMLIterator, xMLIterator2);
                continue;
            }
            if (!xMLIterator2.hasNext()) continue;
            flexeraax32 = xMLIterator2.next();
            if (flexeraax3.aw(flexeraax32)) {
                this.parseAttributes(flexeraax3, flexeraax32);
                this.parseContent(flexeraax3, flexeraax32);
                continue;
            }
            throw new ParseException("Expecting to find element '" + flexeraax3 + "' but found '" + flexeraax32 + "'");
        }
    }

    private void parseAttributes(Flexeraax3 flexeraax3, Flexeraax3 flexeraax32) throws ParseException {
        String[] stringArray = flexeraax3.bb().ab();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = flexeraax3.bb().aa()[i];
            String string2 = flexeraax32.bb().ad(string);
            this.assignValue(stringArray[i], string2);
        }
    }

    private void parseContent(Flexeraax3 flexeraax3, Flexeraax3 flexeraax32) throws ParseException {
        if (!this.isEmpty(flexeraax3.a7())) {
            if (flexeraax32.a7() != null) {
                this.assignValue(flexeraax3.a7(), flexeraax32.a7());
            }
            if (flexeraax32.a9() != null) {
                this.assignValue(flexeraax3.a7(), flexeraax32.ba());
            }
        }
    }

    private void parseJellyTag(XMLIterator xMLIterator, XMLIterator xMLIterator2) throws ParseException {
        Flexeraax3 flexeraax3 = xMLIterator.current();
        if (!flexeraax3.au().equals("jelly") && !flexeraax3.au().equals("whitespace")) {
            if (flexeraax3.au().equals("if")) {
                if (flexeraax3.ax()) {
                    this.parseContent(flexeraax3, xMLIterator2.current());
                } else {
                    if (this.shouldParseContainerTag(flexeraax3, xMLIterator2)) {
                        this.parseContainerTag(flexeraax3, xMLIterator2);
                    }
                    xMLIterator.skipChildren();
                }
            } else if (flexeraax3.au().equals("forEach")) {
                if (xMLIterator.current().ax()) {
                    this.parseContent(flexeraax3, xMLIterator2.current());
                } else {
                    String string = flexeraax3.be("var");
                    String string2 = flexeraax3.be("items");
                    Object object = this.evaluateExpression(string2);
                    if (object instanceof Enumeration) {
                        Enumeration enumeration = (Enumeration)object;
                        while (this.shouldParseContainerTag(flexeraax3, xMLIterator2)) {
                            try {
                                this.context.setVariable(string, enumeration.nextElement());
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                            this.parseContainerTag(flexeraax3, xMLIterator2);
                        }
                    } else if (object instanceof Iterator) {
                        Iterator iterator = (Iterator)object;
                        while (this.shouldParseContainerTag(flexeraax3, xMLIterator2)) {
                            try {
                                this.context.setVariable(string, iterator.next());
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                            this.parseContainerTag(flexeraax3, xMLIterator2);
                        }
                    }
                    xMLIterator.skipChildren();
                }
            } else if (flexeraax3.au().equals("switch")) {
                for (Flexeraax3 flexeraax32 : flexeraax3.an()) {
                    if (!this.shouldParseContainerTag(flexeraax32, xMLIterator2)) continue;
                    this.parseContainerTag(flexeraax32, xMLIterator2);
                }
                xMLIterator.skipChildren();
            } else if (flexeraax3.au().equals("import")) {
                Flexeraax3 flexeraax33 = this.loadSubTemplate(flexeraax3.be("uri"));
                XMLIterator xMLIterator3 = new XMLIterator(xMLIterator2.next(), true);
                this.parseContainerTag(flexeraax33, xMLIterator3);
                xMLIterator2.skipChildren();
                xMLIterator.skipChildren();
            } else if (flexeraax3.au().equals("set")) {
                String string = flexeraax3.be("var");
                Object object = this.evaluateExpression(flexeraax3.be("value"));
                this.assignValue(string, object);
            } else if (flexeraax3.au().equals("expr")) {
                this.evaluateExpression(flexeraax3.be("value"));
            } else if (flexeraax3.au().equals("new")) {
                String string = flexeraax3.be("className");
                String string3 = flexeraax3.be("var");
                this.context.setVariable(string3, this.createInstance(string));
            } else {
                throw new ParseException("Unable to handle Jelly tag: " + flexeraax3.au());
            }
        }
    }

    private boolean shouldParseContainerTag(Flexeraax3 flexeraax3, XMLIterator xMLIterator) throws ParseException {
        return xMLIterator.peekNext() != null && this.tagContainsAsFirstSubElement(flexeraax3, xMLIterator.peekNext());
    }

    private void parseContainerTag(Flexeraax3 flexeraax3, XMLIterator xMLIterator) throws ParseException {
        XMLIterator xMLIterator2 = new XMLIterator(flexeraax3, false);
        this.parseElement(xMLIterator2, xMLIterator);
    }

    private Flexeraax3 loadSubTemplate(String string) throws ParseException {
        File file = new File(string);
        if (file.isAbsolute()) {
            return this.readXML(string);
        }
        return this.readXML(new File(this.templateFile.getParent(), string));
    }

    private boolean tagsAreTheSame(Flexeraax3 flexeraax3, Flexeraax3 flexeraax32) {
        if (flexeraax3.aw(flexeraax32)) {
            if (flexeraax32.an() != null && flexeraax3.an() == null) {
                return false;
            }
            List<String> list = Arrays.asList(flexeraax3.bb().aa());
            for (int i = 0; i < flexeraax32.bb().aa().length; ++i) {
                String string = flexeraax32.bb().aa()[i];
                String string2 = flexeraax32.be(string);
                String string3 = flexeraax3.be(string);
                if (!list.contains(string)) {
                    return false;
                }
                if (this.isExpression(string3) || string2.equals(string3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean tagContainsAsFirstSubElement(Flexeraax3 flexeraax3, Flexeraax3 flexeraax32) throws ParseException {
        block5: {
            if (flexeraax3.ax()) break block5;
            for (Flexeraax3 flexeraax33 : flexeraax3.an()) {
                block6: {
                    String string;
                    block8: {
                        block7: {
                            if (!this.isJellyElement(flexeraax33)) break block6;
                            string = flexeraax33.au();
                            if (string.equals("if")) break block7;
                            if (!string.equals("forEach")) break block8;
                        }
                        if (this.tagContainsAsFirstSubElement(flexeraax33, flexeraax32)) {
                            return true;
                        }
                    }
                    if (!string.equals("import")) continue;
                    Flexeraax3 flexeraax34 = this.loadSubTemplate(flexeraax33.be("uri"));
                    if (!this.tagContainsAsFirstSubElement(flexeraax34, flexeraax32)) continue;
                    return true;
                }
                return this.tagsAreTheSame(flexeraax33, flexeraax32);
            }
        }
        return false;
    }

    private Object createInstance(String string) throws ParseException {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new ParseException("Can not create instance of " + string);
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignValue(String string, Object object) throws ParseException {
        if (this.isEmpty(string) || object == null) return;
        string = this.prepareExpression(string);
        if (string.indexOf(".") > -1) {
            try {
                String string2 = string.substring(0, string.indexOf("."));
                if (this.context.getVariable(string2) == null) return;
                Object object2 = this.context.getVariable(string2);
                BeanUtils.setProperty((Object)object2, (String)string.substring(string.indexOf(".") + 1), (Object)object);
                return;
            }
            catch (Exception exception) {
                throw new ParseException("Error assigning '" + object + "' to '" + string + "'");
            }
        } else {
            this.context.setVariable(string, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJellyElement(Flexeraax3 flexeraax3) {
        String string = flexeraax3.ap();
        if (string == null) {
            return false;
        }
        if (string.equals("j")) return true;
        if (!string.equals("x")) return false;
        return true;
    }

    private boolean isExpression(String string) {
        int n = string.indexOf("${");
        int n2 = string.indexOf("}");
        return n >= 0 && n2 > n + 2;
    }

    private String prepareExpression(String string) throws ParseException {
        int n = string.indexOf("${");
        int n2 = string.indexOf("}");
        if (n >= 0 && n2 > n + 2) {
            return string.substring(n + 2, n2);
        }
        return string;
    }

    private Object evaluateExpression(String string) throws ParseException {
        if (this.isExpression(string)) {
            string = this.prepareExpression(string);
            try {
                return this.jexlFactory.createExpression(string).evaluate(this.context);
            }
            catch (Throwable throwable) {
                throw new ParseException("Expression is empty or malformed: " + string);
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEmpty(String string) {
        if (string == null) return true;
        if (!"".equals(string.trim())) return false;
        return true;
    }
}

