/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rules;

import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Rule;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PlatformChk
extends Rule {
    public static final String WINDOWS_PLATFORM = "^Windows.*";
    public static final String GENERIC_RULE_DISP_STRING = "CP";
    public Vector installOnPlatformList = new Vector(8, 1);
    public Vector allPlatforms;
    public Vector doNotInstallOnPlatformList = new Vector(25, 1);

    public static String[] getSerializableProperties() {
        String[] stringArray = new String[4];
        stringArray[0] = "installOnPlatformList";
        stringArray[1] = "doNotInstallOnPlatformList";
        stringArray[2] = "ruleId";
        stringArray[3] = "expressionID";
        return stringArray;
    }

    public PlatformChk() {
        this.generateAndSetRuleId();
        this.allPlatforms = this.ae();
        this.doNotInstallOnPlatformList = (Vector)this.allPlatforms.clone();
        this.doNotInstallOnPlatformList.remove("Windows NT");
        this.doNotInstallOnPlatformList.remove("Windows 2000");
        this.doNotInstallOnPlatformList.remove("Windows XP");
        this.doNotInstallOnPlatformList.remove("Windows 2003");
        this.doNotInstallOnPlatformList.remove("Windows Vista");
        this.doNotInstallOnPlatformList.remove("Windows 7");
        this.doNotInstallOnPlatformList.remove("Windows 8");
        this.doNotInstallOnPlatformList.remove("Windows 10");
        this.doNotInstallOnPlatformList.remove("Windows 11");
        this.doNotInstallOnPlatformList.remove("Windows 2016");
        this.doNotInstallOnPlatformList.remove("Windows 2019");
        this.doNotInstallOnPlatformList.remove("Windows 2022");
        this.doNotInstallOnPlatformList.remove("Windows 2025");
    }

    public static boolean isCompatibleWith(InstallPiece installPiece) {
        return true;
    }

    public void addToInstallOnPlatformList(String string) {
        if (!this.installOnPlatformList.contains(string)) {
            this.installOnPlatformList.addElement(string);
        }
        if (this.doNotInstallOnPlatformList.contains(string)) {
            this.doNotInstallOnPlatformList.removeElement(string);
        }
    }

    public void removeFromInstallOnPlatformList(String string) {
        this.installOnPlatformList.removeElement(string);
    }

    public void addToDoNotInstallOnPlatformList(String string) {
        this.doNotInstallOnPlatformList.addElement(string);
        if (!this.doNotInstallOnPlatformList.contains(string)) {
            this.doNotInstallOnPlatformList.addElement(string);
        }
        if (this.installOnPlatformList.contains(string)) {
            this.installOnPlatformList.removeElement(string);
        }
    }

    public void removeFromDoNotInstallOnPlatformList(String string) {
        this.doNotInstallOnPlatformList.removeElement(string);
    }

    public void setInstallOnPlatformList(Vector vector) {
        this.installOnPlatformList = vector;
    }

    public void setDoNotInstallOnPlatformList(Vector vector) {
        this.doNotInstallOnPlatformList = vector;
    }

    public Vector getInstallOnPlatformList() {
        return this.installOnPlatformList;
    }

    public Vector getDoNotInstallOnPlatformList() {
        return this.doNotInstallOnPlatformList;
    }

    public Vector getUnusedPlatforms() {
        Vector vector = this.ae();
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.installOnPlatformList.contains(vector.get(i)) || this.doNotInstallOnPlatformList.contains(this.allPlatforms.get(i))) continue;
            vector2.add(vector.get(i));
        }
        return vector2;
    }

    public String getReportDescription(int n) {
        Enumeration enumeration;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(80);
        int n3 = this.installOnPlatformList.size();
        int n4 = this.doNotInstallOnPlatformList.size();
        if (n3 == 0) {
            return stringBuffer.append("Do not install on any platforms.").toString();
        }
        if (n4 == 0) {
            return stringBuffer.append("Install on all platforms.").toString();
        }
        if (n3 > 0) {
            stringBuffer.append("Install on ");
            n2 = 0;
            enumeration = this.installOnPlatformList.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                if (++n2 >= n3) continue;
                stringBuffer.append(", ");
            }
        }
        if (n4 > 0) {
            stringBuffer.append("; do not install on ");
            n2 = 0;
            enumeration = this.doNotInstallOnPlatformList.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                if (++n2 >= n4) continue;
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    public boolean aa() {
        return Beans.isDesignTime();
    }

    public boolean ab(String string) {
        if (ZGUtil.runningOnPlatform(string)) {
            return true;
        }
        if (Flexeraavu.aj(string)) {
            return ZGUtil.runningOnPlatform(string, true);
        }
        return false;
    }

    @Override
    public boolean checkSelf(Hashtable hashtable) {
        if (!this.aa()) {
            Enumeration enumeration = this.doNotInstallOnPlatformList.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.ab((String)enumeration.nextElement())) continue;
                return false;
            }
            enumeration = this.installOnPlatformList.elements();
            while (enumeration.hasMoreElements()) {
                if (!this.ab((String)enumeration.nextElement())) continue;
                return true;
            }
            return this.installOnPlatformList.contains("Unlisted Platforms");
        }
        if (hashtable != null) {
            if (this.ad(hashtable)) {
                return true;
            }
            return this.installOnPlatformList.contains("Unlisted Platforms");
        }
        return true;
    }

    public boolean ad(Hashtable hashtable) {
        Enumeration enumeration = this.installOnPlatformList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) {
                return true;
            }
            if (!Flexeraavu.aj(string)) continue;
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (!string2.matches(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBeDisplayed() {
        return true;
    }

    @Override
    public boolean hasInstallPermissions() {
        return true;
    }

    private Vector ae() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Windows NT");
        vector.addElement("Windows 2000");
        vector.addElement("Windows XP");
        vector.addElement("Windows 2003");
        vector.addElement("Windows Vista");
        vector.addElement("Windows 7");
        vector.addElement("Windows 8");
        vector.addElement("Windows 10");
        vector.addElement("Windows 11");
        vector.addElement("Windows 2016");
        vector.addElement("Windows 2019");
        vector.addElement("Windows 2022");
        vector.addElement("Windows 2025");
        vector.addElement(WINDOWS_PLATFORM);
        vector.addElement("Mac OS X");
        vector.addElement("Solaris");
        vector.addElement("SunOS");
        vector.addElement("HP-UX");
        vector.addElement("Linux");
        vector.addElement("AIX");
        vector.addElement("FreeBSD");
        vector.addElement("NetWare");
        vector.addElement("OS/400");
        vector.addElement("Unlisted Platforms");
        return vector;
    }

    @Override
    public String getGenericDisplayString() {
        return GENERIC_RULE_DISP_STRING;
    }

    static {
        ClassInfoManager.aa(PlatformChk.class, IAResourceBundle.getValue("Designer.Rule.PlatformChk.visualName"), null);
    }
}

