/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.jdirect.Struct;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.generated.RectStruct;
import com.apple.mrj.macos.toolbox.Pattern;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.Shape;
import java.awt.Rectangle;

public class Rect
implements Shape {
    RectStruct data;

    RectStruct getRect() {
        return this.data;
    }

    void initialize() {
        this.data = new RectStruct();
    }

    public Rect() {
        this.initialize();
    }

    public Rect(RectStruct rectStruct) {
        this.data = rectStruct;
    }

    public Rect(int n, int n2, int n3, int n4) {
        this();
        this.set((short)n, (short)n2, (short)n3, (short)n4);
    }

    public Rect(Point point, Point point2) {
        this();
        this.set(point.getH(), point.getV(), point2.getH(), point2.getV());
    }

    public Rect(Rect rect) {
        this();
        this.set(rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public Rect(Rectangle rectangle) {
        this();
        this.set((short)rectangle.x, (short)rectangle.y, (short)(rectangle.width + rectangle.x), (short)(rectangle.y + rectangle.height));
    }

    public Rectangle asRectangle() {
        return new Rectangle(this.getLeft(), this.getTop(), this.getRight() - this.getLeft(), this.getBottom() - this.getTop());
    }

    protected Rect(Struct struct) {
        this(struct, 0);
    }

    protected Rect(Struct struct, int n) {
        this.data = new RectStruct(struct, n);
    }

    public final short getTop() {
        return this.data.getTop();
    }

    public final short getLeft() {
        return this.data.getLeft();
    }

    public final short getBottom() {
        return this.data.getBottom();
    }

    public final short getRight() {
        return this.data.getRight();
    }

    public final void setTop(short s) {
        this.data.setTop(s);
    }

    public final void setLeft(short s) {
        this.data.setLeft(s);
    }

    public final void setBottom(short s) {
        this.data.setBottom(s);
    }

    public final void setRight(short s) {
        this.data.setRight(s);
    }

    public final void setTop(int n) {
        this.setTop((short)n);
    }

    public final void setLeft(int n) {
        this.setLeft((short)n);
    }

    public final void setBottom(int n) {
        this.setBottom((short)n);
    }

    public final void setRight(int n) {
        this.setRight((short)n);
    }

    public final void setWidth(short s) {
        this.setRight((short)(s + this.getLeft()));
    }

    public final void setHeight(short s) {
        this.setBottom((short)(s + this.getTop()));
    }

    public final byte[] getBytes() {
        return this.data.getByteArray();
    }

    public void set(short s, short s2, short s3, short s4) {
        QuickdrawFunctions.SetRect(this.getRect(), s, s2, s3, s4);
    }

    public void set(Rect rect) {
        QuickdrawFunctions.SetRect(this.getRect(), rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom());
    }

    public void set(Rectangle rectangle) {
        QuickdrawFunctions.SetRect(this.getRect(), (short)rectangle.x, (short)rectangle.y, (short)(rectangle.width + rectangle.x), (short)(rectangle.y + rectangle.height));
    }

    public Point topLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    public Point topRight() {
        return new Point(this.getRight(), this.getTop());
    }

    public Point bottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    public Point bottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    public short getWidth() {
        return (short)(this.getRight() - this.getLeft());
    }

    public short getHeight() {
        return (short)(this.getBottom() - this.getTop());
    }

    private boolean between(short s, short s2, short s3) {
        return s <= s2 && s2 <= s3;
    }

    public boolean touches(Rect rect) {
        return !(!this.between(this.getTop(), rect.getTop(), this.getBottom()) && !this.between(this.getTop(), rect.getBottom(), this.getBottom()) || !this.between(this.getLeft(), rect.getLeft(), this.getRight()) && !this.between(this.getLeft(), rect.getRight(), this.getRight()));
    }

    public boolean contains(Point point) {
        return QuickdrawFunctions.PtInRect(point.getPoint(), this.getRect());
    }

    public void moveTo(short s, short s2) {
        QuickdrawFunctions.OffsetRect(this.getRect(), (short)(s - this.getLeft()), (short)(s2 - this.getTop()));
    }

    public void offset(short s, short s2) {
        QuickdrawFunctions.OffsetRect(this.getRect(), s, s2);
    }

    public void inset(short s, short s2) {
        QuickdrawFunctions.InsetRect(this.getRect(), s, s2);
    }

    public boolean sect(Rect rect, Rect rect2) {
        return QuickdrawFunctions.SectRect(this.getRect(), rect.getRect(), rect2.getRect());
    }

    public boolean sect(Rect rect) {
        return this.sect(rect, this);
    }

    public void union(Rect rect, Rect rect2) {
        QuickdrawFunctions.UnionRect(this.getRect(), rect.getRect(), rect2.getRect());
    }

    public void union(Rect rect) {
        this.union(rect, this);
    }

    public boolean equal(Rect rect) {
        return QuickdrawFunctions.EqualRect(this.getRect(), rect.getRect());
    }

    public boolean empty() {
        return QuickdrawFunctions.EmptyRect(this.getRect());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [l " + this.getLeft() + ", t " + this.getTop() + ", r " + this.getRight() + ", b " + this.getBottom() + "]";
    }

    public void frame() {
        QuickdrawFunctions.FrameRect(this.getRect());
    }

    public void paint() {
        QuickdrawFunctions.PaintRect(this.getRect());
    }

    public void fill(Pattern pattern) {
        QuickdrawFunctions.FillRect(this.getRect(), pattern.getPattern());
    }

    public void erase() {
        QuickdrawFunctions.EraseRect(this.getRect());
    }

    public void invert() {
        QuickdrawFunctions.InvertRect(this.getRect());
    }

    public void frame(short s, short s2) {
        QuickdrawFunctions.FrameRoundRect(this.getRect(), s, s2);
    }

    public void paint(short s, short s2) {
        QuickdrawFunctions.PaintRoundRect(this.getRect(), s, s2);
    }

    public void fill(short s, short s2, Pattern pattern) {
        QuickdrawFunctions.FillRoundRect(this.getRect(), s, s2, pattern.getPattern());
    }

    public void erase(short s, short s2) {
        QuickdrawFunctions.EraseRoundRect(this.getRect(), s, s2);
    }

    public void invert(short s, short s2) {
        QuickdrawFunctions.InvertRoundRect(this.getRect(), s, s2);
    }
}

