/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.FontConstants;
import com.apple.mrj.macos.generated.FontFunctions;
import com.apple.mrj.macos.generated.QuickdrawTextFunctions;
import com.apple.mrj.macos.toolbox.ControlFontStyle;
import com.apple.mrj.macos.toolbox.FontInfo;
import com.apple.mrj.macos.toolbox.TextUtilities;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.WindowRef;

public class QuickdrawFont
implements FontConstants {
    short font;
    short style;
    short size;
    short mode;
    FontInfo fontInfo;
    static QuickdrawFont SystemFont = new QuickdrawFont(0, 0, 0);
    static QuickdrawFont ApplicationFont = new QuickdrawFont(1, 0, 0);

    public QuickdrawFont(short s, short s2, short s3, short s4) {
        this.font = s;
        this.style = s2;
        this.size = s3;
        this.mode = s4;
    }

    public QuickdrawFont(String string, short s, short s2) {
        this(QuickdrawFont.getFontNum(string), s, s2);
    }

    public QuickdrawFont(short s, short s2, short s3) {
        this(s, s2, s3, 0);
    }

    public QuickdrawFont(ControlFontStyle controlFontStyle) {
        this(controlFontStyle.getFont(), controlFontStyle.getStyle(), controlFontStyle.getSizeField(), controlFontStyle.getMode());
    }

    public FontInfo getFontInfo() {
        if (this.fontInfo == null) {
            this.fontInfo = new FontInfo(this);
        }
        return this.fontInfo;
    }

    public short getFont() {
        return this.font;
    }

    public short getStyle() {
        return this.style;
    }

    public short getSizeField() {
        return this.size;
    }

    public short getMode() {
        return this.mode;
    }

    public static short getFontNum(String string) {
        short[] sArray = new short[1];
        FontFunctions.GetFNum(TranslateString.asPascalBytes(string), sArray);
        return sArray[0];
    }

    public static QuickdrawFont getSystemFont() {
        return SystemFont;
    }

    public static QuickdrawFont getApplicationFont() {
        return ApplicationFont;
    }

    public int getWidth(String string, short s, short s2) {
        return this.getWidth(TranslateString.asBytes(string), s, s2);
    }

    public int getWidth(char[] cArray, short s, short s2) {
        return this.getWidth(TranslateString.asBytes(cArray), s, s2);
    }

    public int getWidth(byte[] byArray, short s, short s2) {
        WindowRef windowRef = WindowRef.getFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.currentFont();
        this.install();
        short s3 = QuickdrawTextFunctions.TextWidth(byArray, s, s2);
        quickdrawFont.install();
        return s3;
    }

    public void measureText(short s, byte[] byArray, byte[] byArray2) {
        WindowRef windowRef = WindowRef.getFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.currentFont();
        this.install();
        TextUtilities.measureText(s, byArray, byArray2);
        quickdrawFont.install();
    }

    public void draw(byte[] byArray, short s, short s2) {
        WindowRef windowRef = WindowRef.getFrontWindow();
        QuickdrawFont quickdrawFont = windowRef.currentFont();
        this.install();
        TextUtilities.draw(byArray, s, s2);
        quickdrawFont.install();
    }

    public short ascent() {
        return this.getFontInfo().getAscent();
    }

    public short descent() {
        return this.getFontInfo().getDescent();
    }

    public short widMax() {
        return this.getFontInfo().getWidMax();
    }

    public short leading() {
        return this.getFontInfo().getLeading();
    }

    public short height() {
        return this.getFontInfo().getHeight();
    }

    public void install() {
        QuickdrawTextFunctions.TextFont(this.font);
        QuickdrawTextFunctions.TextFace(this.style);
        QuickdrawTextFunctions.TextSize(this.size);
        QuickdrawTextFunctions.TextMode(this.mode);
    }

    public void set(ControlFontStyle controlFontStyle) {
        this.set(controlFontStyle.getFont(), controlFontStyle.getStyle(), controlFontStyle.getSizeField(), controlFontStyle.getMode());
    }

    public void set(short s, short s2, short s3, short s4) {
        this.font = s;
        this.style = s2;
        this.size = s3;
        this.mode = s4;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [font=" + this.font + ",style=" + this.style + ",size=" + this.size + ",mode=" + this.mode + "]";
    }
}

