/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.toolbox.CharsHandle;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.TEHandle;
import com.apple.mrj.macos.toolbox.WindowRef;

public class ProtectedTextEdit
extends TEHandle {
    CharsHandle actualText;
    short replaceChar;

    private void initialize(char c) {
        this.actualText = new CharsHandle();
        this.actualText.allocateHandle(0, false);
        this.replaceChar = (short)c;
    }

    public ProtectedTextEdit(char c, TEHandle tEHandle) {
        super(tEHandle.getTEHandle());
        tEHandle.data = null;
        this.initialize(c);
    }

    public ProtectedTextEdit(char c, Rect rect, Rect rect2, boolean bl, WindowRef windowRef) {
        super(rect, rect2, bl, windowRef);
        this.initialize(c);
    }

    public ProtectedTextEdit(char c, Rect rect, boolean bl, WindowRef windowRef) {
        super(rect, bl, windowRef);
        this.initialize(c);
    }

    public void setReplaceChar(char c) {
        this.replaceChar = (short)c;
    }

    private short min(short s, short s2) {
        return s < s2 ? s : s2;
    }

    private void backspace() {
        short s = this.min(this.getSelStart(), this.getSelEnd());
        int n = this.getSelStart() - this.getSelEnd();
        if (n < 0) {
            n = -n;
        }
        this.getText().munger(s, null, n, new byte[1], 0);
    }

    byte[] protectedInsert(byte[] byArray, int n) {
        this.getText().munger(this.min(this.getSelStart(), this.getSelEnd()), null, n, byArray, n);
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = (byte)this.replaceChar;
            ++n2;
        }
        return byArray2;
    }

    short protectedKey(short s) {
        if (s < 32) {
            if (s == 8) {
                this.backspace();
            }
            return s;
        }
        byte[] byArray = new byte[]{(byte)s};
        this.getText().munger(this.min(this.getSelStart(), this.getSelEnd()), null, 1, byArray, 1);
        return this.replaceChar;
    }

    public CharsHandle getText() {
        return this.actualText;
    }

    public void key(short s) {
        super.key(this.protectedKey(s));
    }

    public void insert(byte[] byArray, int n) {
        super.insert(this.protectedInsert(byArray, n), n);
    }

    public void copy() {
    }

    public void cut() {
    }

    public void paste() {
    }
}

