/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.ProcessInfoRecStruct;
import com.apple.mrj.macos.toolbox.FSSpec;
import com.apple.mrj.macos.toolbox.ProcessSerialNumber;
import com.apple.mrj.macos.toolbox.Ptr;
import com.apple.mrj.macos.toolbox.TranslateString;

public class ProcessInfoRec {
    ProcessInfoRecStruct data;
    Ptr itsNamePtr = new Ptr(256, true);
    Ptr itsAppSpecPtr = new Ptr(70, true);

    ProcessInfoRecStruct getProcessInfoRec() {
        return this.data;
    }

    public ProcessInfoRec() {
        this.data = new ProcessInfoRecStruct();
        this.setProcessName(this.itsNamePtr.getPointer());
        this.setProcessAppSpec(this.itsAppSpecPtr.getPointer());
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return TranslateString.pascalByteArrayToString(this.itsNamePtr.getBytes());
    }

    public FSSpec getAppSpec() {
        return new FSSpec(this.itsAppSpecPtr);
    }

    public final void setProcessName(int n) {
        this.data.setProcessName(n);
    }

    public final void setProcessAppSpec(int n) {
        this.data.setProcessAppSpec(n);
    }

    public final int getProcessType() {
        return this.data.getProcessType();
    }

    public final int getProcessSignature() {
        return this.data.getProcessSignature();
    }

    public final int getProcessMode() {
        return this.data.getProcessMode();
    }

    public final int getProcessLocation() {
        return this.data.getProcessLocation();
    }

    public final int getProcessSize() {
        return this.data.getProcessSize();
    }

    public final int getProcessFreeMem() {
        return this.data.getProcessFreeMem();
    }

    public final ProcessSerialNumber getProcessLauncher() {
        return new ProcessSerialNumber(this.data.getProcessLauncher());
    }
}

