/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.macos.toolbox;

import com.apple.mrj.macos.generated.GrafPortStruct;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.generated.QuickdrawTextFunctions;
import com.apple.mrj.macos.toolbox.Arc;
import com.apple.mrj.macos.toolbox.FontInfo;
import com.apple.mrj.macos.toolbox.Pattern;
import com.apple.mrj.macos.toolbox.PenState;
import com.apple.mrj.macos.toolbox.Point;
import com.apple.mrj.macos.toolbox.PolyHandle;
import com.apple.mrj.macos.toolbox.Ptr;
import com.apple.mrj.macos.toolbox.QuickdrawFont;
import com.apple.mrj.macos.toolbox.RGBColor;
import com.apple.mrj.macos.toolbox.Rect;
import com.apple.mrj.macos.toolbox.Region;
import com.apple.mrj.macos.toolbox.Shape;
import com.apple.mrj.macos.toolbox.TextUtilities;
import com.apple.mrj.macos.toolbox.TranslateString;
import com.apple.mrj.macos.toolbox.WindowRef;

public class GrafPtr {
    GrafPortStruct data;
    private Region clipRgn;

    public GrafPtr() {
        this.initialize();
    }

    public GrafPtr(int n) {
        this.initialize(n);
    }

    GrafPortStruct getGrafPort() {
        return this.data;
    }

    public int getPointer() {
        return this.data.getPointer();
    }

    protected void initialize() {
        this.data = new GrafPortStruct(GrafPtr.getPort());
    }

    protected void initialize(int n) {
        this.data = new GrafPortStruct(n);
    }

    public void setOrigin(short s, short s2) {
        QuickdrawFunctions.SetOrigin(s, s2);
    }

    public Point getOrigin() {
        return new Point(this.getGrafPort(), 24);
    }

    public WindowRef getWindowRef() {
        return (WindowRef)this;
    }

    public boolean hitTest(Point point) {
        return this.getBounds().contains(point);
    }

    public Rect getBounds() {
        return new Rect(this.data.getPortRect());
    }

    public void getClip(Region region) {
        region.copy(this.getClip());
    }

    public void getClip(Rect rect) {
        rect.set(this.getClip().getBounds());
    }

    public void clip(Region region) {
        this.getClip().copy(region);
    }

    public void resetClip() {
        Rect rect = new Rect(-32767, -32767, Short.MAX_VALUE, Short.MAX_VALUE);
        this.clip(rect);
    }

    public void clip(Rect rect) {
        this.setPort();
        QuickdrawFunctions.ClipRect(rect.getRect());
    }

    private short txFont() {
        return this.data.getTxFont();
    }

    private short txFace() {
        return this.data.getTxFace();
    }

    private short txMode() {
        return this.data.getTxMode();
    }

    private short txSize() {
        return this.data.getTxSize();
    }

    public QuickdrawFont currentFont() {
        return new QuickdrawFont(this.txFont(), this.txFace(), this.txSize(), this.txMode());
    }

    public QuickdrawFont currentFont(QuickdrawFont quickdrawFont) {
        quickdrawFont.set(this.txFont(), this.txFace(), this.txSize(), this.txMode());
        return quickdrawFont;
    }

    public FontInfo getFontInfo() {
        return new FontInfo(this);
    }

    public static int getPort() {
        int[] nArray = new int[1];
        QuickdrawFunctions.GetPort(nArray);
        return nArray[0];
    }

    public void setPort() {
        QuickdrawFunctions.SetPort(this.getGrafPort());
    }

    public int draw(String string, short s, short s2) {
        return this.draw(TranslateString.asPtr(string), s, s2);
    }

    public int draw(Ptr ptr, short s, short s2) {
        return this.draw(ptr.getBytes(), s, s2, (short)0, (short)ptr.getSize());
    }

    public int draw(char[] cArray, short s, short s2, short s3, short s4) {
        return 0;
    }

    public int draw(byte[] byArray, short s, short s2, short s3, short s4) {
        short s5 = 0;
        this.setPort();
        PenState.moveTo(s, s2);
        s5 = QuickdrawTextFunctions.TextWidth(byArray, s3, s4);
        TextUtilities.draw(byArray, s3, s4);
        return s5;
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.setPort();
        PenState.moveTo((short)n, (short)n2);
        PenState.lineTo((short)n, (short)n2);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.setPort();
        PolyHandle.drawPolyline(nArray, nArray2, n);
    }

    public void frame(Shape shape) {
        this.setPort();
        shape.frame();
    }

    public void paint(Shape shape) {
        this.setPort();
        shape.paint();
    }

    public void fill(Shape shape, Pattern pattern) {
        this.setPort();
        shape.fill(pattern);
    }

    public void erase(Shape shape) {
        this.setPort();
        shape.erase();
    }

    public void invert(Shape shape) {
        this.setPort();
        shape.invert();
    }

    public void frame(Rect rect, short s, short s2) {
        this.setPort();
        rect.frame(s, s2);
    }

    public void paint(Rect rect, short s, short s2) {
        this.setPort();
        rect.paint(s, s2);
    }

    public void fill(Rect rect, short s, short s2, Pattern pattern) {
        this.setPort();
        rect.fill(s, s2, pattern);
    }

    public void erase(Rect rect, short s, short s2) {
        this.setPort();
        rect.erase(s, s2);
    }

    public void invert(Rect rect, short s, short s2) {
        this.setPort();
        rect.invert(s, s2);
    }

    public void frame(Arc arc, short s, short s2) {
        this.setPort();
        arc.frame(s, s2);
    }

    public void paint(Arc arc, short s, short s2) {
        this.setPort();
        arc.paint(s, s2);
    }

    public void fill(Arc arc, short s, short s2, Pattern pattern) {
        this.setPort();
        arc.fill(s, s2, pattern);
    }

    public void erase(Arc arc, short s, short s2) {
        this.setPort();
        arc.erase(s, s2);
    }

    public void invert(Arc arc, short s, short s2) {
        this.setPort();
        arc.invert(s, s2);
    }

    public void setFont(QuickdrawFont quickdrawFont) {
        if (quickdrawFont != null) {
            this.setPort();
            quickdrawFont.install();
        }
    }

    public void setForeColor(RGBColor rGBColor) {
        this.setPort();
        rGBColor.setForeColor();
    }

    public void setBackColor(RGBColor rGBColor) {
        this.setPort();
        rGBColor.setBackColor();
    }

    public RGBColor getForeColor() {
        this.setPort();
        return RGBColor.getForeColor();
    }

    public RGBColor getBackColor() {
        this.setPort();
        return RGBColor.getBackColor();
    }

    Region getClipRgn() {
        return this.getClip();
    }

    private Region getClip() {
        if (this.clipRgn == null) {
            this.clipRgn = new Region(this.data.getClipRgn());
        }
        return this.clipRgn;
    }
}

