/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.jdirect;

import com.apple.mrj.internal.jdirect.Accessor;
import com.apple.mrj.jdirect.Struct;

public abstract class ByteArrayStruct
extends Struct {
    protected byte[] bytes;

    protected ByteArrayStruct(int n) {
        this.bytes = new byte[n];
    }

    protected final boolean getBooleanAt(int n) {
        return Accessor.getBooleanFromArray(this.bytes, n);
    }

    protected final byte getByteAt(int n) {
        return this.bytes[n];
    }

    protected final char getCharAt(int n) {
        return Accessor.getCharFromArray(this.bytes, n);
    }

    protected final short getShortAt(int n) {
        return Accessor.getShortFromArray(this.bytes, n);
    }

    protected final int getIntAt(int n) {
        return Accessor.getIntFromArray(this.bytes, n);
    }

    protected final long getLongAt(int n) {
        return Accessor.getLongFromArray(this.bytes, n);
    }

    protected final float getFloatAt(int n) {
        return Accessor.getFloatFromArray(this.bytes, n);
    }

    protected final double getDoubleAt(int n) {
        return Accessor.getDoubleFromArray(this.bytes, n);
    }

    protected final void setBooleanAt(int n, boolean bl) {
        Accessor.setBooleanInArray(this.bytes, n, bl);
    }

    protected final void setByteAt(int n, byte by) {
        this.bytes[n] = by;
    }

    protected final void setCharAt(int n, char c) {
        Accessor.setCharInArray(this.bytes, n, c);
    }

    protected final void setShortAt(int n, short s) {
        Accessor.setShortInArray(this.bytes, n, s);
    }

    protected final void setIntAt(int n, int n2) {
        Accessor.setIntInArray(this.bytes, n, n2);
    }

    protected final void setLongAt(int n, long l) {
        Accessor.setLongInArray(this.bytes, n, l);
    }

    protected final void setFloatAt(int n, float f) {
        Accessor.setFloatInArray(this.bytes, n, f);
    }

    protected final void setDoubleAt(int n, double d) {
        Accessor.setDoubleInArray(this.bytes, n, d);
    }

    protected void setBytesAt(int n, byte[] byArray) {
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            this.bytes[n + n3] = byArray[n3];
            ++n3;
        }
    }

    protected void setStructAt(int n, Struct struct) {
        int n2 = struct.getSize();
        byte[] byArray = struct.getBytesAt(0, n2);
        int n3 = 0;
        while (n3 < n2) {
            this.bytes[n + n3] = byArray[n3];
            ++n3;
        }
    }

    public byte[] getBytesAt(int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = this.bytes[n + n3];
            ++n3;
        }
        return byArray;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.bytes.length];
        int n = 0;
        while (n < this.bytes.length) {
            byArray[n] = this.bytes[n];
            ++n;
        }
        return byArray;
    }

    public final byte[] getByteArray() {
        return this.bytes;
    }

    public final int getSize() {
        return this.bytes.length;
    }
}

