/*
 * Decompiled with CFR 0.152.
 */
package com.apple.memory;

import com.apple.MacOS.MacOSLibraries;
import com.apple.memory.MemoryObject;
import com.apple.memory.PointerObject;

public class HandleObject
extends MemoryObject {
    protected int handle;
    protected boolean locked;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public HandleObject() {
        this.handle = 0;
    }

    public HandleObject(int n) {
        this.handle = n;
    }

    public synchronized PointerObject PointerAt(int n, int n2) {
        if (!this.locked) {
            this.Lock();
        }
        int n3 = HandleObject.getIntAt(this.handle, n);
        return new PointerObject(n3, n2);
    }

    public final byte[] getBytes() {
        int n = this.getSize();
        byte[] byArray = new byte[n];
        this.getBytesAt(0, n, byArray, 0);
        return byArray;
    }

    protected void getBytesAt(int n, int n2, byte[] byArray, int n3) {
        boolean bl = this.Lock();
        HandleObject.copyBytes(HandleObject.getIntAt(this.handle, 0), n, byArray, n3, n2);
        if (!bl) {
            this.Unlock();
        }
    }

    public void getBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.getSize();
        if (n + n3 > n4 || n2 + n3 > byArray.length || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.getBytesAt(n, n3, byArray, n2);
    }

    public final synchronized void setBytesAt(int n, int n2, byte[] byArray, int n3) {
        boolean bl = this.Lock();
        HandleObject.copyBytes(byArray, n3, HandleObject.getIntAt(this.handle, 0), n, n2);
        if (!bl) {
            this.Unlock();
        }
    }

    public void setBytes(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.getSize();
        if (n + n3 > n4 || n2 + n3 > byArray.length || n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setBytesAt(n, n3, byArray, n2);
    }

    public int getSize() {
        return HandleObject.GetHandleSize(this.handle);
    }

    public void setSize(int n) {
        HandleObject.SetHandleSize(this.handle, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof HandleObject) {
            HandleObject handleObject = (HandleObject)object;
            return this.handle == handleObject.handle;
        }
        return false;
    }

    public boolean handleInMemory() {
        return HandleObject.getIntAt(this.handle, 0) != 0;
    }

    public synchronized boolean Lock() {
        boolean bl = this.locked;
        if (!bl) {
            HandleObject.HLock(this.handle);
            this.locked = true;
        }
        return bl;
    }

    public synchronized boolean LockHigh() {
        boolean bl = this.locked;
        if (!bl) {
            HandleObject.HLockHi(this.handle);
            this.locked = true;
        }
        return bl;
    }

    public synchronized void Unlock() {
        HandleObject.HUnlock(this.handle);
        this.locked = false;
    }

    public final byte getByteAt(int n) {
        return HandleObject.getByteAtAt(this.handle, n);
    }

    public final short getShortAt(int n) {
        return HandleObject.getShortAtAt(this.handle, n);
    }

    public final int getIntAt(int n) {
        return HandleObject.getIntAtAt(this.handle, n);
    }

    public final long getLongAt(int n) {
        return HandleObject.getLongAtAt(this.handle, n);
    }

    public final float getFloatAt(int n) {
        return HandleObject.getFloatAtAt(this.handle, n);
    }

    public final double getDoubleAt(int n) {
        return HandleObject.getDoubleAtAt(this.handle, n);
    }

    public final void setByteAt(int n, byte by) {
        HandleObject.setByteAtAt(this.handle, n, by);
    }

    public final void setShortAt(int n, short s) {
        HandleObject.setShortAtAt(this.handle, n, s);
    }

    public final void setIntAt(int n, int n2) {
        HandleObject.setIntAtAt(this.handle, n, n2);
    }

    public final void setLongAt(int n, long l) {
        HandleObject.setLongAtAt(this.handle, n, l);
    }

    public final void setFloatAt(int n, float f) {
        HandleObject.setFloatAtAt(this.handle, n, f);
    }

    public final void setDoubleAt(int n, double d) {
        HandleObject.setDoubleAtAt(this.handle, n, d);
    }

    public final int getHandle() {
        return this.handle;
    }

    public final void setHandle(int n) {
        this.handle = n;
    }

    private static native int getIntAt(int var0, int var1);

    private static native int getPointerTo(int var0, int var1);

    private static native byte getByteAtAt(int var0, int var1);

    private static native short getShortAtAt(int var0, int var1);

    private static native int getIntAtAt(int var0, int var1);

    private static native long getLongAtAt(int var0, int var1);

    private static native float getFloatAtAt(int var0, int var1);

    private static native double getDoubleAtAt(int var0, int var1);

    private static native void setByteAtAt(int var0, int var1, byte var2);

    private static native void setShortAtAt(int var0, int var1, short var2);

    private static native void setIntAtAt(int var0, int var1, int var2);

    private static native void setLongAtAt(int var0, int var1, long var2);

    private static native void setFloatAtAt(int var0, int var1, float var2);

    private static native void setDoubleAtAt(int var0, int var1, double var2);

    private static native void HLock(int var0);

    private static native void HLockHi(int var0);

    private static native void HUnlock(int var0);

    protected static native int GetHandleSize(int var0);

    protected static native void SetHandleSize(int var0, int var1);

    private static native void copyBytes(byte[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void copyBytes(byte[] var0, int var1, int var2, int var3, int var4);

    private static native void copyBytes(int var0, int var1, byte[] var2, int var3, int var4);

    private static native void copyBytes(int var0, int var1, int var2, int var3, int var4);
}

