/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.ControlActionUPP;
import com.apple.MacOS.ControlHandle;
import com.apple.MacOS.Point;
import com.apple.MacOS.QuickdrawFont;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Str255;
import com.apple.MacOS.ToolboxObject;
import com.apple.MacOS.WindowRef;

public class ControlHandleWFont
extends ControlHandle
implements ToolboxObject {
    QuickdrawFont qdFont;
    QuickdrawFont currentFont;
    WindowRef win;

    public ControlHandleWFont(WindowRef windowRef, Rect rect, Str255 str255, short s, QuickdrawFont quickdrawFont) {
        super(windowRef, rect, str255, (short)(s + 8));
        this.qdFont = quickdrawFont;
        this.win = this.getWindowRef();
    }

    public void setFont(QuickdrawFont quickdrawFont) {
        this.qdFont = quickdrawFont;
    }

    public QuickdrawFont getFont() {
        return this.qdFont;
    }

    private void setup() {
        this.win.SetPort();
        this.currentFont = this.win.CurrentFont();
        this.qdFont.install();
    }

    private void restore() {
        this.currentFont.install();
    }

    public void Show() {
        this.setup();
        super.Show();
        this.restore();
    }

    public void Draw() {
        this.setup();
        super.Draw();
        this.restore();
    }

    public short Track(Point point, ControlActionUPP controlActionUPP) {
        this.setup();
        short s = super.Track(point, controlActionUPP);
        this.restore();
        return s;
    }

    public void SetValue(short s) {
        this.setup();
        super.SetValue(s);
        this.restore();
    }

    public void SetMinimum(short s) {
        this.setup();
        super.SetMinimum(s);
        this.restore();
    }

    public void SetMaximum(short s) {
        this.setup();
        super.SetMaximum(s);
        this.restore();
    }

    public void SetTitle(String string) {
        this.setup();
        super.SetTitle(string);
        this.restore();
    }

    public void Move(short s, short s2) {
        this.setup();
        super.Move(s, s2);
        this.restore();
    }

    public void Size(short s, short s2) {
        this.setup();
        super.Size(s, s2);
        this.restore();
    }

    public void Hilite(short s) {
        this.setup();
        super.Hilite(s);
        this.restore();
    }

    public void Drag(Point point, Rect rect, Rect rect2, short s) {
        this.setup();
        super.Drag(point, rect, rect2, s);
        this.restore();
    }

    public void SetBounds(Rect rect) {
        this.setup();
        super.SetBounds(rect);
        this.restore();
    }
}

