/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.ControlActionUPP;
import com.apple.MacOS.ControlManager;
import com.apple.MacOS.Handle;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.MemoryUtils;
import com.apple.MacOS.Point;
import com.apple.MacOS.Rect;
import com.apple.MacOS.Region;
import com.apple.MacOS.Str255;
import com.apple.MacOS.ToolboxObject;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.UniversalProcPtr;
import com.apple.MacOS.WindowRef;

public class ControlHandle
extends ControlManager
implements ToolboxObject {
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    public static ControlHandle GetOwnedControl(int n, Handle handle) {
        if (n != 0) {
            return new ControlHandle(n, handle);
        }
        return null;
    }

    public ControlHandle(int n, Handle handle) {
        super(n, handle);
    }

    public ControlHandle(short s, WindowRef windowRef) {
        this.setHandle(ControlHandle.GetNewControl(s, windowRef.getPointer()));
    }

    public ControlHandle(WindowRef windowRef, Rect rect, Str255 str255, boolean bl, short s, short s2, short s3, short s4, int n) {
        super(ControlHandle.NewControl(windowRef.getPointer(), rect, str255.getBytes(), bl, s, s2, s3, s4, n));
    }

    public ControlHandle(WindowRef windowRef, Rect rect, Str255 str255, short s) {
        this(windowRef, rect, str255, true, 0, 0, 1, s, 0);
    }

    public ControlHandle(WindowRef windowRef, Rect rect, boolean bl, short s, short s2, short s3, int n) {
        this(windowRef, rect, new Str255(), bl, s, s2, s3, 16, n);
    }

    public static int MaxControlValue() {
        return Short.MAX_VALUE;
    }

    public WindowRef getWindowRef() {
        return new WindowRef(this.getIntAt(4));
    }

    public Rect getBounds() {
        return MemoryUtils.RectAt(this, 8);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[label '" + this.GetTitle() + "', min " + this.GetMinimum() + ", max " + this.GetMaximum() + ", value " + this.GetValue() + "]";
    }

    public void IsVisible(boolean bl) {
        if (bl) {
            this.Show();
        } else {
            this.Hide();
        }
    }

    public void IsHilited(boolean bl) {
        this.Hilite((short)(bl ? 0 : 255));
    }

    public void Show() {
        ControlHandle.ShowControl(this.getHandle());
    }

    public void Update(Region region) {
        this.Draw();
    }

    public void Draw() {
        ControlHandle.Draw1Control(this.getHandle());
    }

    public short Find(Point point, WindowRef windowRef) {
        return ControlHandle.FindControl(point, windowRef.getPointer(), this.getHandle());
    }

    public short Track(Point point, ControlActionUPP controlActionUPP) {
        return ControlHandle.TrackControl(this.getHandle(), point, UniversalProcPtr.getUPP(controlActionUPP));
    }

    public short Track(Point point) {
        return this.Track(point, null);
    }

    public short Test(Point point) {
        return ControlHandle.TestControl(this.getHandle(), point);
    }

    public boolean HitTest(Point point) {
        return this.getBounds().Contains(point);
    }

    public void SetValue(short s) {
        ControlHandle.SetControlValue(this.getHandle(), s);
    }

    public void SetMinimum(short s) {
        ControlHandle.SetControlMinimum(this.getHandle(), s);
    }

    public void SetMaximum(short s) {
        ControlHandle.SetControlMaximum(this.getHandle(), s);
    }

    public void SetTitle(String string) {
        ControlHandle.SetControlTitle(this.getHandle(), TranslateString.asPascalBytes(string));
    }

    public void Hide() {
        ControlHandle.HideControl(this.getHandle());
    }

    public void Move(short s, short s2) {
        ControlHandle.MoveControl(this.getHandle(), s, s2);
    }

    public void Size(short s, short s2) {
        ControlHandle.SizeControl(this.getHandle(), s, s2);
    }

    public void Hilite(short s) {
        ControlHandle.HiliteControl(this.getHandle(), s);
    }

    public void Drag(Point point, Rect rect, Rect rect2, short s) {
        ControlHandle.DragControl(this.getHandle(), point, rect, rect2, s);
    }

    public void SetAction(ControlActionUPP controlActionUPP) {
        ControlHandle.SetControlAction(this.getHandle(), controlActionUPP == null ? 0 : UniversalProcPtr.getUPP(controlActionUPP));
    }

    public void SetActionNone() {
        ControlHandle.SetControlAction(this.getHandle(), -1);
    }

    public void SetColor(int n) {
        ControlHandle.SetControlColor(this.getHandle(), n);
    }

    public void SetBounds(Rect rect) {
        this.Move(rect.getLeft(), rect.getTop());
        this.Size(rect.Width(), rect.Height());
    }

    public Rect GetBounds() {
        return this.getBounds();
    }

    public Point GetOrigin() {
        return this.getBounds().topLeft();
    }

    public short GetValue() {
        return ControlHandle.GetControlValue(this.getHandle());
    }

    public short GetMinimum() {
        return ControlHandle.GetControlMinimum(this.getHandle());
    }

    public short GetMaximum() {
        return ControlHandle.GetControlMaximum(this.getHandle());
    }

    public String GetTitle() {
        Str255 str255 = new Str255();
        ControlHandle.GetControlTitle(this.getHandle(), str255.getBytes());
        return str255.toString();
    }

    public int GetReference() {
        return ControlHandle.GetControlReference(this.getHandle());
    }

    public void SetReference(int n) {
        ControlHandle.SetControlReference(this.getHandle(), n);
    }

    public int GetData() {
        return this.getIntAt(28);
    }

    public short GetVariant() {
        return ControlHandle.GetControlVariant(this.getHandle());
    }

    public boolean GetAuxiliaryRecord(int n) {
        return ControlHandle.GetAuxiliaryControlRecord(this.getHandle(), n);
    }

    protected void FreeHandle(int n) {
        ControlHandle.DisposeControl(n);
    }

    private static native int GetNewControl(short var0, int var1);

    private static native int NewControl(int var0, Rect var1, byte[] var2, boolean var3, short var4, short var5, short var6, short var7, int var8);

    private static native void ShowControl(int var0);

    private static native void Draw1Control(int var0);

    private static native short FindControl(Point var0, int var1, int var2);

    private static native short TrackControl(int var0, Point var1, int var2);

    private static native short TestControl(int var0, Point var1);

    private static native void SetControlValue(int var0, short var1);

    private static native void SetControlMinimum(int var0, short var1);

    private static native void SetControlMaximum(int var0, short var1);

    private static native void SetControlTitle(int var0, byte[] var1);

    private static native void HideControl(int var0);

    private static native void MoveControl(int var0, short var1, short var2);

    private static native void SizeControl(int var0, short var1, short var2);

    private static native void HiliteControl(int var0, short var1);

    private static native void DragControl(int var0, Point var1, Rect var2, Rect var3, short var4);

    private static native void SetControlAction(int var0, int var1);

    private static native void SetControlColor(int var0, int var1);

    private static native short GetControlValue(int var0);

    private static native short GetControlMinimum(int var0);

    private static native short GetControlMaximum(int var0);

    private static native void GetControlTitle(int var0, byte[] var1);

    private static native int GetControlReference(int var0);

    private static native void SetControlReference(int var0, int var1);

    private static native int GetControlAction(int var0);

    private static native short GetControlVariant(int var0);

    private static native boolean GetAuxiliaryControlRecord(int var0, int var1);

    private static native void DisposeControl(int var0);
}

