/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSError;
import com.apple.memory.HandleObject;
import java.io.File;

public class Alias
extends HandleObject {
    public Alias(String string) {
        this(new File(string));
    }

    public Alias(File file) {
        this(new FSSpec(file));
    }

    public Alias(FSSpec fSSpec) {
        int[] nArray = new int[1];
        MacOSError.CheckResult(Alias.NewAliasMinimal(fSSpec.getBytes(), nArray));
        this.setHandle(nArray[0]);
    }

    public FSSpec toSpec() {
        return Alias.resolveAlias(this);
    }

    public static FSSpec resolveAlias(HandleObject handleObject) {
        FSSpec fSSpec = new FSSpec();
        boolean[] blArray = new boolean[1];
        MacOSError.CheckResult(Alias.ResolveAlias(null, handleObject.getHandle(), fSSpec.getBytes(), blArray));
        return fSSpec;
    }

    public static FSSpec resolveAlias(FSSpec fSSpec, HandleObject handleObject) {
        FSSpec fSSpec2 = new FSSpec();
        boolean[] blArray = new boolean[1];
        MacOSError.CheckResult(Alias.ResolveAlias(fSSpec.getBytes(), handleObject.getHandle(), fSSpec2.getBytes(), blArray));
        return fSSpec2;
    }

    private static native short ResolveAlias(byte[] var0, int var1, byte[] var2, boolean[] var3);

    private static native short NewAlias(byte[] var0, byte[] var1, int[] var2);

    private static native short NewAliasMinimal(byte[] var0, int[] var1);
}

