/*
 * Decompiled with CFR 0.152.
 */
package com.apple.MacOS;

import com.apple.MacOS.AEDescList;
import com.apple.MacOS.AERecord;
import com.apple.MacOS.AEValue;
import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSError;
import com.apple.MacOS.MacOSLibraries;
import com.apple.MacOS.OSUtils;
import com.apple.MacOS.TranslateString;
import com.apple.MacOS.ae;
import com.apple.memory.HandleObject;
import com.apple.memory.MemoryObject;
import com.apple.memory.StructObject;
import java.io.File;

public class AEDesc
extends StructObject
implements ae {
    public static final int sizeOfAEDesc = 8;
    protected int descriptorType;
    protected int dataHandle;
    protected HandleObject handle;
    protected boolean owner;
    private static String[] kNativeLibraryNames = MacOSLibraries.kInterfaceLibNames;

    protected void finalize() throws Throwable {
        if (this.owner) {
            AEDesc.AEDisposeDesc(this);
        }
        super.finalize();
    }

    public AEDesc() {
        this.descriptorType = ae.typeNull;
        this.dataHandle = 0;
        this.handle = null;
        this.owner = true;
    }

    protected AEDesc(MemoryObject memoryObject) {
        this.descriptorType = memoryObject.getIntAt(0);
        this.dataHandle = memoryObject.getIntAt(4);
        this.handle = null;
        this.owner = false;
    }

    protected synchronized void Relinquish(MemoryObject memoryObject) {
        memoryObject.setIntAt(0, this.descriptorType);
        memoryObject.setIntAt(4, this.dataHandle);
        this.descriptorType = ae.typeNull;
        this.handle = null;
        this.dataHandle = 0;
    }

    public AEDesc(AEDesc aEDesc) {
        this();
        this.Copy(aEDesc);
    }

    public AEDesc(int n, HandleObject handleObject) {
        this();
        this.descriptorType = n;
        this.dataHandle = handleObject.getHandle();
        this.handle = handleObject;
        this.owner = false;
    }

    private void Create(int n, byte[] byArray) {
        MacOSError.CheckResult(AEDesc.AECreateDesc(n, byArray, byArray.length, this));
    }

    private void Create(int n, AEValue aEValue) {
        this.Create(n, aEValue.getBytes());
    }

    public void Copy(AEDesc aEDesc) {
        this.setDescriptorType(aEDesc.getDescriptorType());
        HandleObject handleObject = aEDesc.getDataHandle();
        HandleObject handleObject2 = this.getDataHandle();
        MacOSError.CheckResult(AEDesc.AEDuplicateDesc(aEDesc, this));
    }

    public AEDesc(String string) {
        this();
        this.Create(ae.typeChar, TranslateString.asBytes(string));
    }

    public AEDesc(int n, String string) {
        this();
        AEDesc aEDesc = new AEDesc(string);
        MacOSError.CheckResult(AEDesc.AECoerceDesc(aEDesc, n, this));
    }

    public AEDesc(int n, int n2) {
        this(n2);
        this.setDescriptorType(n);
    }

    public AEDesc(int n, byte[] byArray) {
        this();
        this.Create(n, byArray);
    }

    public AEDesc(boolean bl) {
        this();
        this.Create(ae.typeBoolean, new AEValue((short)(bl ? 1 : 0)));
    }

    public AEDesc(double d) {
        this((float)d);
    }

    public AEDesc(float f) {
        this();
        this.Create(ae.typeFloat, new AEValue(f));
    }

    public AEDesc(short s) {
        this();
        this.Create(ae.typeShortInteger, new AEValue(s));
    }

    public AEDesc(int n) {
        this();
        this.Create(ae.typeLongInteger, new AEValue(n));
    }

    public AEDesc(long l) {
        this((int)l);
    }

    public AEDesc(File file) {
        this();
        this.Create(ae.typeFSS, new FSSpec(file).getBytes());
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    protected void setDescriptorType(int n) {
        this.descriptorType = n;
    }

    public synchronized HandleObject getDataHandle() {
        if (this.handle == null) {
            this.handle = new HandleObject(this.dataHandle);
        } else {
            this.handle.setHandle(this.dataHandle);
        }
        return this.handle;
    }

    protected synchronized void setDataHandle(int n) {
        this.dataHandle = n;
    }

    public final boolean isList() {
        return this.getDescriptorType() == ae.typeAEList;
    }

    public AEDescList getList() {
        return new AEDescList(this);
    }

    public final boolean isRecord() {
        return this.getDescriptorType() == ae.typeAERecord;
    }

    public AERecord getRecord() {
        return new AERecord(this);
    }

    public String toString() {
        try {
            AEDesc aEDesc = this.coerceTo(ae.typeChar);
            int n = aEDesc.dataSize();
            byte[] byArray = new byte[n];
            aEDesc.extractData(byArray, 0, byArray.length);
            return new String(byArray);
        }
        catch (MacOSError macOSError) {
            return "AEDesc['" + OSUtils.osTypeToString(this.descriptorType) + "']";
        }
    }

    public AEDesc coerceTo(int n) {
        AEDesc aEDesc = new AEDesc();
        MacOSError.CheckResult(AEDesc.AECoerceDesc(this, n, aEDesc));
        return aEDesc;
    }

    public int dataSize() {
        return this.getDataHandle().getSize();
    }

    public void extractData(byte[] byArray, int n, int n2) {
        HandleObject handleObject = this.getDataHandle();
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = handleObject.getByteAt(n3 + n);
            ++n3;
        }
    }

    public boolean getBooleanValue() {
        HandleObject handleObject = this.getDataHandle();
        return handleObject.getShortAt(0) != 0;
    }

    public double getDoubleValue() {
        HandleObject handleObject = this.getDataHandle();
        return handleObject.getFloatAt(0);
    }

    public short getShortValue() {
        HandleObject handleObject = this.getDataHandle();
        return handleObject.getShortAt(0);
    }

    public int getIntValue() {
        HandleObject handleObject = this.getDataHandle();
        return handleObject.getIntAt(0);
    }

    public File getFileValue() {
        return new File(this.toString());
    }

    protected static native int AECreateDesc(int var0, byte[] var1, int var2, AEDesc var3);

    protected static native int AEDisposeDesc(AEDesc var0);

    protected static native int AECoerceDesc(AEDesc var0, int var1, AEDesc var2);

    protected static native int AEDuplicateDesc(AEDesc var0, AEDesc var1);
}

