/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ia.action;

import com.adobe.utils.Executes;
import com.adobe.utils.InstanceList;
import com.zerog.ia.api.pub.CustomCodeAction;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.api.pub.UninstallerProxy;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;

public class ServersStartStopAction
extends CustomCodeAction {
    String defaultInstName = installerProxy.substitute("$CF_DEF_INST_NAME$");
    String isWindows = installerProxy.substitute("$IS_WINDOWS$");
    String cfVersion = installerProxy.substitute("$COLDFUSION_VERSION$");

    @Override
    public String getInstallStatusMessage() {
        return null;
    }

    @Override
    public String getUninstallStatusMessage() {
        return null;
    }

    @Override
    public void install(InstallerProxy arg0) throws InstallException {
        this.stop();
    }

    @Override
    public void uninstall(UninstallerProxy installerProxy) throws InstallException {
        this.stop();
    }

    protected void stop() {
        String hfJettyScriptPath;
        String serviceNameFromXML;
        String instList = installerProxy.substitute("$INSTANCE_LIST$");
        String servInstXML = installerProxy.substitute("$SERVER_INST_XML$");
        Map<String, String> fullServerMaps = InstanceList.getInst(servInstXML);
        Object defaultInstServiceName = this.cfVersion + " Application Server";
        Map<String, String> instanceServiceMap = null;
        if (this.isWindows.equals("true") && (serviceNameFromXML = (instanceServiceMap = InstanceList.getInstanceServiceMap(servInstXML)).get(this.defaultInstName)) != null) {
            defaultInstServiceName = serviceNameFromXML;
        }
        StringTokenizer tokens = new StringTokenizer(instList, ",");
        while (tokens.hasMoreElements()) {
            String inst = (String)tokens.nextElement();
            String instanceRoot = fullServerMaps.get(inst);
            if (!new File(instanceRoot).exists()) continue;
            if (this.isWindows.equals("true")) {
                Object serviceName = instanceServiceMap.get(inst);
                if (inst.equals(this.defaultInstName)) {
                    serviceName = "\"" + (String)defaultInstServiceName + "\"";
                } else if (serviceName == null || ((String)serviceName).trim().isEmpty()) {
                    serviceName = "\"" + (String)defaultInstServiceName + " " + inst + "\"";
                }
                String stopServiceCommand = "sc stop " + (String)serviceName;
                String qcServiceCommand = "sc qc " + (String)serviceName;
                boolean isServiceRunning = true;
                boolean isServiceExists = Executes.isServiceExists(qcServiceCommand, instanceRoot, installerProxy);
                if (isServiceExists) {
                    String queryServiceCommand = "sc query " + (String)serviceName;
                    isServiceRunning = Executes.isServiceRunning(queryServiceCommand, installerProxy);
                    if (isServiceRunning) {
                        installerProxy.setVariable("$" + inst + "PRE_INST_TIME_SVC_RUNNING$", "true");
                    } else {
                        installerProxy.setVariable("$" + inst + "PRE_INST_TIME_SVC_RUNNING$", "false");
                    }
                } else {
                    installerProxy.setVariable("$" + inst + "PRE_INST_TIME_SVC_RUNNING$", "false");
                    isServiceRunning = false;
                }
                if (isServiceRunning) {
                    Executes.exec(stopServiceCommand, true, installerProxy);
                    continue;
                }
                String stopCommand = instanceRoot + "/bin/coldfusion stop";
                Executes.exec(stopCommand, true, installerProxy);
                continue;
            }
            String installerUI = installerProxy.substitute("$INSTALLER_UI$");
            Object stopCommand = "";
            stopCommand = installerUI != null && installerUI.equals("SILENT") && File.separatorChar == '/' ? instanceRoot + "/bin/coldfusion_hf stop" : instanceRoot + "/bin/coldfusion stop";
            Executes.exec((String)stopCommand, true, installerProxy);
        }
        if (installerProxy.substitute("$HOTFIX_APIMANAGER$").equals("true") && installerProxy.substitute("$APIMANAGER_EXISTS$").equals("true")) {
            String apiManagerRootPath = installerProxy.substitute("$APIMANAGER_PATH$");
            String apiManagerInvm = installerProxy.substitute("$APIMANAGER_INVM$");
            if (this.isWindows.equals("true")) {
                if (apiManagerInvm.contains("false")) {
                    String stopAPIManagerServiceCommand = "sc stop " + installerProxy.substitute("$HOTFIX_APIMANAGER_SERVICENAME$");
                    Executes.exec(stopAPIManagerServiceCommand, true, installerProxy);
                }
                String stopAnalyticsServiceCommand = "sc stop " + installerProxy.substitute("$HOTFIX_ANALYTICS_SERVICENAME$");
                Executes.exec(stopAnalyticsServiceCommand, true, installerProxy);
                String stopDatastoreServiceCommand = "sc stop " + installerProxy.substitute("$HOTFIX_DATASTORE_SERVICENAME$");
                Executes.exec(stopDatastoreServiceCommand, true, installerProxy);
                Executes.exec(apiManagerRootPath + "/bin/stop.bat", true, installerProxy);
            } else {
                if (apiManagerInvm.contains("false")) {
                    String[] APIMcmd = new String[]{"/bin/sh", "-c", "ps -ef | grep Groot | grep -v grep|awk '{print $2}'|xargs kill -9"};
                    Executes.execStringArray(APIMcmd, true, installerProxy);
                }
                String[] DScmd = new String[]{"/bin/sh", "-c", "ps -ef | grep redis | grep -v grep|awk '{print $2}'|xargs kill -9"};
                Executes.execStringArray(DScmd, true, installerProxy);
                String[] AScmd = new String[]{"/bin/sh", "-c", "ps -ef | grep elasticsearch | grep -v grep|awk '{print $2}'|xargs kill -9"};
                Executes.execStringArray(AScmd, true, installerProxy);
            }
        }
        String restartOdbc = installerProxy.substitute("$RESTART_ODBC$");
        String restartJetty = installerProxy.substitute("$RESTART_JETTY$");
        String restartDotnet = installerProxy.substitute("$RESTART_DOTNET$");
        if (this.isWindows.equals("true")) {
            if (restartOdbc != null && restartOdbc.equals("true")) {
                String odbcServiceSrvName = "\"" + this.cfVersion + " ODBC Server\"";
                String odbcServiceAgentName = "\"" + this.cfVersion + " ODBC Agent\"";
                Executes.exec("sc stop " + odbcServiceSrvName, true, installerProxy);
                Executes.exec("sc stop " + odbcServiceAgentName, true, installerProxy);
            }
            if (restartJetty != null && restartJetty.equals("true")) {
                String addOnServiceName = installerProxy.substitute("$JETTY_SERVICENAME$");
                Executes.exec("sc stop " + addOnServiceName, true, installerProxy);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (restartDotnet != null && restartDotnet.equals("true")) {
                String dotnetServiceName = "\"" + this.cfVersion + " .NET Service\"";
                Executes.exec("sc stop " + dotnetServiceName, true, installerProxy);
            }
        } else if (restartJetty != null && restartJetty.equals("true") && (hfJettyScriptPath = installerProxy.substitute("$JETTY_SCRIPT_PATH$")) != null && new File(hfJettyScriptPath).exists()) {
            Executes.exec(hfJettyScriptPath + " stop", true, installerProxy);
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

