/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.microsoft.graph;

import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.microsoft.graph.GraphServiceConstants;
import coldfusion.microsoft.graph.RequestConfigurator;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.CustomSecurityAttributeValue;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class GraphServiceUtils {
    private static final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;

    public static Optional<OffsetDateTime> getDateTimeProperty(Object value) {
        return Optional.ofNullable(value).map(var -> OffsetDateTime.ofInstant(cast.getInstantProperty(var), ZoneId.systemDefault()));
    }

    public static Optional<String> getStringProperty(Object value) {
        return Optional.ofNullable(value).map(arg_0 -> ((FieldTypecastUtil)cast).getStringProperty(arg_0));
    }

    public static Optional<Integer> getIntegerProperty(Object value) {
        return Optional.ofNullable(value).map(arg_0 -> ((FieldTypecastUtil)cast).getIntegerProperty(arg_0));
    }

    public static Optional<Boolean> getBooleanProperty(Object value) {
        return Optional.ofNullable(value).map(arg_0 -> ((FieldTypecastUtil)cast).getBooleanProperty(arg_0));
    }

    public static Optional<List<String>> getStringListProperty(Object value) {
        return Optional.ofNullable(value).map(arg_0 -> ((FieldTypecastUtil)cast).getStringListProperty(arg_0));
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean needsAutoPagination(Integer size) {
        if (size == null) {
            return false;
        }
        return size < 0 || size > GraphServiceConstants.MAX_PAGE_SIZE;
    }

    public static Optional<CustomSecurityAttributeValue> getCustomSecurityAttributes(Object value) {
        return Optional.ofNullable(value).map(nonNullValue -> {
            Map mapProperty = cast.getStringObjectMapProperty(value);
            CustomSecurityAttributeValue customSecurityAttributeValue = new CustomSecurityAttributeValue();
            customSecurityAttributeValue.setAdditionalData(mapProperty);
            return customSecurityAttributeValue;
        });
    }

    public static String buildRawUrl(RequestConfigurator requestConfigurator) {
        return GraphServiceUtils.buildRawUrl(requestConfigurator, false);
    }

    public static String buildRawUrl(RequestConfigurator requestConfigurator, boolean isDelta) {
        String url;
        StringJoiner queryParams = new StringJoiner("&");
        String string = url = isDelta ? "https://graph.microsoft.com/v1.0/users/delta" : "https://graph.microsoft.com/v1.0/users";
        if (!isDelta) {
            queryParams.add("$count=true");
        }
        Optional.ofNullable(requestConfigurator.getFilter()).ifPresent(value -> queryParams.add("$filter=" + value));
        Optional.ofNullable(requestConfigurator.getOrderBy()).ifPresent(value -> queryParams.add("$orderby=" + Arrays.toString(value)));
        Optional.ofNullable(requestConfigurator.getSearch()).ifPresent(value -> queryParams.add("$search=\"" + value + "\""));
        Optional.ofNullable(requestConfigurator.getSelect()).ifPresent(value -> queryParams.add("$select=" + Arrays.toString(value)));
        Optional.ofNullable(requestConfigurator.getTop()).ifPresent(value -> queryParams.add("$top=" + value));
        Optional.ofNullable(requestConfigurator.getSkipToken()).ifPresent(value -> queryParams.add("$skiptoken=" + value));
        Optional.ofNullable(requestConfigurator.getDeltaToken()).ifPresent(value -> queryParams.add("$deltatoken=" + value));
        return queryParams.length() > 0 ? url + "?" + queryParams : url;
    }

    public static <TEntity extends Parsable, TCollectionPage extends Parsable & AdditionalDataHolder> PageIterator<TEntity, TCollectionPage> getPageIterator(@Nonnull GraphServiceClient gc, UnaryOperator<RequestInformation> requestInformationUnaryOperator, TCollectionPage pageResponse, @Nonnull ParsableFactory<TCollectionPage> collectionPageFactory, @Nonnull Function<TEntity, Boolean> processPageItemCallback) throws ReflectiveOperationException {
        if (pageResponse == null) {
            return null;
        }
        return new PageIterator.Builder().client((IBaseClient)gc).collectionPage(pageResponse).collectionPageFactory(collectionPageFactory).requestConfigurator(requestInformationUnaryOperator).processPageItemCallback(processPageItemCallback).build();
    }

    public static Optional<String> parseDeltaLinkForDeltaToken(String deltaLink) {
        int index = deltaLink.indexOf("$deltatoken=");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(deltaLink.substring(index + 12));
    }

    public static Optional<String> parseNextLinkForSkipToken(String nextLink) {
        int index = nextLink.indexOf("$skiptoken=");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(nextLink.substring(index + 11));
    }
}

