/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.graphql.graphqlClient;

import coldfusion.filter.FusionContext;
import coldfusion.graphql.client.CustomScalar;
import coldfusion.graphql.graphqlClient.AuthorizationInterceptor;
import coldfusion.graphql.graphqlClient.CFGraphQLClient;
import coldfusion.graphql.graphqlClient.CFGraphQLClientException;
import coldfusion.graphql.graphqlClient.CFGraphQLUtils;
import coldfusion.graphql.graphqlClient.GraphQLCallImpl;
import coldfusion.graphql.graphqlClient.GraphQLSubscriptionCallImpl;
import coldfusion.graphql.graphqlClient.PMTGraphQlApis;
import coldfusion.graphql.graphqlClient.PMTUtilsForGraphQlClient;
import coldfusion.graphql.graphqlClient.config.CFGraphQLConfig;
import coldfusion.graphql.graphqlClient.custom.CFGraphQLCustomScalar;
import coldfusion.graphql.graphqlClient.custom.CFGraphQLCustomTypeAdapter;
import coldfusion.log.CFLogs;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.IdleResourceCallback;
import com.apollographql.apollo.api.CustomTypeAdapter;
import com.apollographql.apollo.api.CustomTypeValue;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStoreOperation;
import com.apollographql.apollo.cache.normalized.NormalizedCacheFactory;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorFactory;
import com.apollographql.apollo.internal.subscription.SubscriptionManager;
import com.apollographql.apollo.subscription.OnSubscriptionManagerStateChangeListener;
import com.apollographql.apollo.subscription.SubscriptionConnectionParams;
import com.apollographql.apollo.subscription.SubscriptionManagerState;
import com.apollographql.apollo.subscription.SubscriptionTransport;
import com.apollographql.apollo.subscription.WebSocketSubscriptionTransport;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class CFGraphQLClientImpl
implements CFGraphQLClient {
    public static final String CFGRAPHQLCLIENT = "graphqlclient";
    private String ROOT = null;
    private ApolloClient apolloClient;
    private ApolloClient.Builder apolloClientBuilder = ApolloClient.builder();
    private CFGraphQLConfig cfGraphQLConfig;

    public CFGraphQLClientImpl(Object config) {
        if (!(config instanceof Struct) && !(config instanceof Map)) {
            throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"INVALID_CLIENT_CONFIG_EXCEPTION"));
        }
        this.getCFGraphQLClient((Map)config);
        this.cfGraphQLConfig = (CFGraphQLConfig)ServiceFactory.getGraphQLConfigService().transformToGraphQLConfig((Struct)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApolloClient getCFGraphQLClient(Map<String, Object> serverConfiguration) {
        ApolloClient currentClient = this.apolloClient;
        if (currentClient == null) {
            CFGraphQLClientImpl cFGraphQLClientImpl = this;
            synchronized (cFGraphQLClientImpl) {
                currentClient = this.apolloClient;
                if (currentClient == null) {
                    this.apolloClient = currentClient = this.initializeGraphQLClientFromServerConfig(serverConfiguration);
                }
            }
        }
        return currentClient;
    }

    private ApolloClient initializeGraphQLClientFromServerConfig(Map<String, Object> serverConfigurartion) {
        block50: for (String key : serverConfigurartion.keySet()) {
            switch (key.toLowerCase()) {
                case "root_package_name": {
                    this.ROOT = serverConfigurartion.get(key) + ".";
                    break;
                }
                case "service_url": {
                    if (CFGraphQLUtils.isNullOrEmpty((String)serverConfigurartion.get(key))) {
                        throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"INVALID_CONFIG_PARAM_EXCEPTION", (Object)key));
                    }
                    this.apolloClientBuilder.serverUrl((String)serverConfigurartion.get(key));
                    break;
                }
                case "http_url": {
                    this.apolloClientBuilder.serverUrl((HttpUrl)serverConfigurartion.get(key));
                    break;
                }
                case "headers": {
                    Map headers = null;
                    try {
                        headers = (Map)serverConfigurartion.get(key);
                    }
                    catch (Exception exception) {
                        throw new CFGraphQLClientException(exception.getMessage(), exception);
                    }
                    if (headers == null) continue block50;
                    this.apolloClientBuilder.okHttpClient(new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationInterceptor(headers)).build());
                    break;
                }
                case "websocket_url": {
                    Map headers = null;
                    try {
                        headers = (Map)serverConfigurartion.get("headers");
                    }
                    catch (Exception exception) {
                        throw new CFGraphQLClientException(exception.getMessage(), exception);
                    }
                    OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationInterceptor(headers)).build();
                    this.apolloClientBuilder.subscriptionTransportFactory((SubscriptionTransport.Factory)new WebSocketSubscriptionTransport.Factory((String)serverConfigurartion.get(key), (WebSocket.Factory)okHttpClient));
                    break;
                }
                case "interceptor": {
                    this.apolloClientBuilder.addApplicationInterceptor((ApolloInterceptor)serverConfigurartion.get(key));
                    break;
                }
                case "batching_configuration": {
                    Struct batchingConfig = (Struct)serverConfigurartion.get(key);
                    if (!batchingConfig.containsKey((Object)"enabled") || !Cast._boolean((Object)batchingConfig.get((Object)"enabled"))) continue block50;
                    this.apolloClientBuilder.batchingConfiguration(CFGraphQLUtils.prepareBatchConfigFromClientConfig(batchingConfig));
                    break;
                }
                case "cache_headers": {
                    this.apolloClientBuilder.defaultCacheHeaders((CacheHeaders)serverConfigurartion.get(key));
                    break;
                }
                case "cache_policy": {
                    this.apolloClientBuilder.defaultHttpCachePolicy((HttpCachePolicy.Policy)serverConfigurartion.get(key));
                    break;
                }
                case "response_fetcher": {
                    this.apolloClientBuilder.defaultResponseFetcher((ResponseFetcher)serverConfigurartion.get(key));
                    break;
                }
                case "http_cache": {
                    this.apolloClientBuilder.httpCache((HttpCache)serverConfigurartion.get(key));
                    break;
                }
                case "normalized_cache": {
                    this.apolloClientBuilder.normalizedCache((NormalizedCacheFactory)serverConfigurartion.get(key));
                    break;
                }
                case "custom_types": {
                    try {
                        this.addCustomTypeAdapters((Map)serverConfigurartion.get(key));
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"TYPE_NOT_FOUND_EXCEPTION", (Object)key), classNotFoundException);
                    }
                }
                case "subscription_connection_params": {
                    this.apolloClientBuilder.subscriptionConnectionParams(new SubscriptionConnectionParams((Map)serverConfigurartion.get(key)));
                    break;
                }
                case "subscription_connection_timeout": {
                    this.apolloClientBuilder.subscriptionHeartbeatTimeout(((Long)((Map)serverConfigurartion.get(key)).get("subscription_heartbeat_timeout")).longValue(), CFGraphQLUtils.getSubscriptionHeartBeatTimeUnit((String)((Map)serverConfigurartion.get(key)).get("subscription_heartbeat_timeunit")));
                    break;
                }
                case "subscription_configuration": {
                    Map headers = null;
                    try {
                        headers = (Map)serverConfigurartion.get("headers");
                    }
                    catch (Exception exception) {
                        throw new CFGraphQLClientException(exception.getMessage(), exception);
                    }
                    Map subscriptionParams = (Map)serverConfigurartion.get("subscription_configuration");
                    if (subscriptionParams.get("websocket_url") == null) continue block50;
                    OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthorizationInterceptor(headers)).build();
                    this.apolloClientBuilder.subscriptionTransportFactory((SubscriptionTransport.Factory)new WebSocketSubscriptionTransport.Factory((String)subscriptionParams.get("websocket_url"), (WebSocket.Factory)okHttpClient));
                    this.apolloClientBuilder.subscriptionHeartbeatTimeout(Cast._long(subscriptionParams.get("subscription_heartbeat_timeout"), (boolean)false), CFGraphQLUtils.getSubscriptionHeartBeatTimeUnit((String)subscriptionParams.get("subscription_heartbeat_timeunit")));
                    break;
                }
                case "client_name": {
                    break;
                }
                case "service_name": {
                    break;
                }
                case "raw_http_client": {
                    break;
                }
                default: {
                    throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"INVALID_CONFIG_PARAM_EXCEPTION", (Object)key));
                }
            }
        }
        return this.apolloClientBuilder.build();
    }

    @Override
    public CustomScalar createCustomScalar(String type, Object value) {
        try {
            ScalarType customTypeEnum = (ScalarType)Enum.valueOf(Class.forName(this.ROOT + "type.CustomType"), type.toUpperCase());
            return new CFGraphQLCustomScalar(customTypeEnum, value);
        }
        catch (ClassNotFoundException e) {
            throw this.logException(type, e, "TYPE_NOT_FOUND_EXCEPTION");
        }
    }

    private void addCustomTypeAdapters(Map map) throws ClassNotFoundException {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Map typeMethods = (Map)entry.getValue();
                final ScalarType customTypeEnum = (ScalarType)Enum.valueOf(Class.forName(this.ROOT + "type.CustomType"), key.toUpperCase());
                UDFMethod decode = (UDFMethod)typeMethods.get("decode");
                UDFMethod encode = (UDFMethod)typeMethods.get("encode");
                CFGraphQLCustomTypeAdapter adapter = new CFGraphQLCustomTypeAdapter(encode, decode, FusionContext.getCurrent(), FusionContext.getCurrent().pageContext, customTypeEnum){

                    public CustomTypeValue<?> encode(CustomScalar object) {
                        try {
                            CFGraphQLCustomScalar scalarObject = (CFGraphQLCustomScalar)this.invokeUDF(this.getEncode(), object);
                            return CustomTypeValue.fromRawValue((Object)scalarObject.getValue());
                        }
                        catch (Throwable e) {
                            CFLogs.APPLICATION_LOG.error((Object)RB.getString(CFGraphQLClientImpl.class, (String)"ENCODE_EXCEPTION"), e);
                            return null;
                        }
                    }

                    public CustomScalar decode(CustomTypeValue<?> object) {
                        try {
                            return this.invokeUDF(this.getDecode(), object.value);
                        }
                        catch (Throwable e) {
                            CFLogs.APPLICATION_LOG.error((Object)RB.getString(CFGraphQLClientImpl.class, (String)"DECODE_EXCEPTION"), e);
                            return null;
                        }
                    }

                    private CustomScalar invokeUDF(UDFMethod method, Object param) throws CloneNotSupportedException, Throwable {
                        FusionContext fusContext = this.getFusionContext();
                        NeoPageContext pageContext = this.getPageContext();
                        FusionContext.setCurrent((FusionContext)fusContext);
                        fusContext.pageContext = pageContext;
                        pageContext.setFusionContext(fusContext);
                        CFPage page = (CFPage)((CFPage)fusContext.pageContext.getPage())._clone();
                        page.pageContext = pageContext;
                        pageContext.setPage((Object)page);
                        pageContext.initializeWith((Object)page, (PageContext)pageContext, pageContext.getVariableScope());
                        Object result = method.invoke(null, method.getName(), (Object)page, new Object[]{param});
                        pageContext = null;
                        fusContext = null;
                        FusionContext.setCurrent(null);
                        return new CFGraphQLCustomScalar(customTypeEnum, result);
                    }
                };
                this.apolloClientBuilder.addCustomTypeAdapter(customTypeEnum, (CustomTypeAdapter)adapter);
            }
        }
    }

    @Override
    public boolean serverOk() {
        try {
            return this.apolloClient.activeCallsCount() >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getSchema(String path) {
        try {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (IOException ioException) {
            throw new CFGraphQLClientException(RB.getString(CFGraphQLClientImpl.class, (String)"GET_SCHEMA_EXCEPTION", (Object)path), ioException);
        }
    }

    @Override
    public int activeCallsCount() {
        return this.apolloClient.activeCallsCount();
    }

    @Override
    public ApolloClient.Builder newBuilder() {
        return this.apolloClient.newBuilder();
    }

    @Override
    public void addOnSubscriptionManagerStateChangeListener(OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.apolloClient.addOnSubscriptionManagerStateChangeListener(onStateChangeListener);
    }

    @Override
    public void removeOnSubscriptionManagerStateChangeListener(OnSubscriptionManagerStateChangeListener onStateChangeListener) {
        this.apolloClient.removeOnSubscriptionManagerStateChangeListener(onStateChangeListener);
    }

    @Override
    public void clearHttpCache() {
        this.apolloClient.clearHttpCache();
    }

    @Override
    public void clearNormalizedCache() {
        this.apolloClient.clearNormalizedCache();
    }

    @Override
    public void clearNormalizedCache(ApolloStoreOperation.Callback<Boolean> callback) {
        this.apolloClient.clearNormalizedCache(callback);
    }

    @Override
    public void disableSubscriptions() {
        this.apolloClient.disableSubscriptions();
    }

    @Override
    public void enableSubscriptions() {
        this.apolloClient.enableSubscriptions();
    }

    @Override
    public List<ApolloInterceptorFactory> getApplicationInterceptorFactories() {
        return this.apolloClient.getApplicationInterceptorFactories();
    }

    @Override
    public List<ApolloInterceptor> getApplicationInterceptors() {
        return this.apolloClient.getApplicationInterceptors();
    }

    @Override
    public HttpCache getHttpCache() {
        return this.apolloClient.getHttpCache();
    }

    @Override
    public ScalarTypeAdapters getScalarTypeAdapters() {
        return this.apolloClient.getScalarTypeAdapters();
    }

    @Override
    public HttpUrl getServerUrl() {
        return this.apolloClient.getServerUrl();
    }

    @Override
    public SubscriptionManager getSubscriptionManager() {
        return this.apolloClient.getSubscriptionManager();
    }

    @Override
    public SubscriptionManagerState getSubscriptionManagerState() {
        return this.apolloClient.getSubscriptionManagerState();
    }

    @Override
    public void idleCallback(IdleResourceCallback idleResourceCallback) {
        this.apolloClient.idleCallback(idleResourceCallback);
    }

    @Override
    public void startBatchPoller() {
        this.apolloClient.startBatchPoller();
    }

    @Override
    public void stopBatchPoller() {
        this.apolloClient.stopBatchPoller();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public GraphQLCallImpl query(String opName, Object params) {
        GraphQLCallImpl responseObject;
        TagAttributeList tempAttributeList;
        block6: {
            GraphQLCallImpl graphQLCallImpl;
            Map paramValues = CFGraphQLUtils.validateParameters(params);
            tempAttributeList = null;
            responseObject = null;
            CFGraphQLUtils.checkNotNull("Query Parameters", paramValues);
            try {
                Constructor<?>[] clazzDeclaredConstructors;
                tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_query, tagAttributeList, this.cfGraphQLConfig.getServiceName(), this.cfGraphQLConfig.getClientName(), this.cfGraphQLConfig.getGraphQLServiceURL());
                Class<?> clazz = this.getClassForOperation(opName, "Query");
                Constructor<?>[] constructorArray = clazzDeclaredConstructors = clazz.getDeclaredConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                if (n2 >= n) break block6;
                Constructor<?> constructorIter = constructorArray[n2];
                Object clazzObj = null;
                clazzObj = constructorIter.getParameters() != null && constructorIter.getParameterCount() > 0 ? CFGraphQLUtils.invokeParameterizedConstructor(paramValues, constructorIter) : (Object)constructorIter.newInstance(new Object[0]);
                graphQLCallImpl = responseObject = new GraphQLCallImpl((ApolloCall)this.apolloClient.query((Query)clazzObj), this.cfGraphQLConfig);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_query, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
            }
            catch (ClassNotFoundException ex) {
                this.logThrowMonitorException(opName, ex, "QUERY_OPERATION_NOT_FOUND_EXCEPTION", tempAttributeList);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_query, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
            }
            catch (Throwable ex2) {
                this.logThrowMonitorException(opName, ex2, "QUERY_EXCEPTION", tempAttributeList);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_query, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
                {
                    catch (Throwable throwable) {
                        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_query, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
                        throw throwable;
                    }
                }
            }
            return graphQLCallImpl;
        }
        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_query, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
        return null;
    }

    private Class<?> getClassForOperation(String operationName, String operationType) throws ClassNotFoundException {
        if (operationName.endsWith(operationType)) {
            operationType = "";
        }
        String classpath = this.ROOT + operationName + operationType;
        return Class.forName(classpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public GraphQLCallImpl mutation(String opName, Object params) {
        GraphQLCallImpl responseObject;
        TagAttributeList tempAttributeList;
        block6: {
            GraphQLCallImpl graphQLCallImpl;
            Map paramValues = CFGraphQLUtils.validateParameters(params);
            tempAttributeList = null;
            responseObject = null;
            CFGraphQLUtils.checkNotNull("Mutation Parameters", paramValues);
            try {
                Constructor<?>[] clazzDeclaredConstructors;
                tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_mutation, tagAttributeList, this.cfGraphQLConfig.getServiceName(), this.cfGraphQLConfig.getClientName(), this.cfGraphQLConfig.getGraphQLServiceURL());
                Class<?> clazz = this.getClassForOperation(opName, "Mutation");
                Constructor<?>[] constructorArray = clazzDeclaredConstructors = clazz.getDeclaredConstructors();
                int n = constructorArray.length;
                int n2 = 0;
                if (n2 >= n) break block6;
                Constructor<?> constructorIter = constructorArray[n2];
                Object clazzObj = null;
                clazzObj = constructorIter.getParameters() != null && constructorIter.getParameterCount() > 0 ? CFGraphQLUtils.invokeParameterizedConstructor(paramValues, constructorIter) : (Object)constructorIter.newInstance(new Object[0]);
                graphQLCallImpl = responseObject = new GraphQLCallImpl((ApolloCall)this.apolloClient.mutate((Mutation)clazzObj), this.cfGraphQLConfig);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_mutation, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
            }
            catch (ClassNotFoundException ex) {
                this.logThrowMonitorException(opName, ex, "MUTATION_OPERATION_NOT_FOUND_EXCEPTION", tempAttributeList);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_mutation, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
            }
            catch (Throwable ex2) {
                this.logThrowMonitorException(opName, ex2, "MUTATION_EXCEPTION", tempAttributeList);
                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_mutation, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
                {
                    catch (Throwable throwable) {
                        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_mutation, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
                        throw throwable;
                    }
                }
            }
            return graphQLCallImpl;
        }
        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_mutation, tempAttributeList, opName, params, responseObject != null ? responseObject.operation().queryDocument() : "", responseObject != null ? responseObject.operation().operationId() : "");
        return null;
    }

    private void logThrowMonitorException(String opName, Throwable ex, String key, TagAttributeList pmtAttributeList) {
        CFGraphQLClientException exception = this.logException(opName, ex, key);
        if (pmtAttributeList != null) {
            PMTUtilsForGraphQlClient.catchErrorMetrics(exception, pmtAttributeList);
        }
        throw exception;
    }

    private CFGraphQLClientException logException(String opName, Throwable ex, String key) {
        String message = RB.getString(CFGraphQLClientImpl.class, (String)key, (Object)(opName + ":" + ex.getMessage()));
        CFGraphQLClientException exception = new CFGraphQLClientException(ex.getClass().getName(), message, ex);
        CFLogs.APPLICATION_LOG.error((Throwable)exception);
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public GraphQLSubscriptionCallImpl subscribe(String opName, Object params) {
        TagAttributeList tempAttributeList;
        block8: {
            GraphQLSubscriptionCallImpl graphQLSubscriptionCallImpl;
            block9: {
                Map paramValues = CFGraphQLUtils.validateParameters(params);
                tempAttributeList = null;
                CFGraphQLUtils.checkNotNull("Subscription Parameters", paramValues);
                try {
                    Constructor<?>[] clazzDeclaredConstructors;
                    tempAttributeList = PMTUtilsForGraphQlClient.startGraphQlMonitoring(PMTGraphQlApis.GraphQL_subscription, tagAttributeList, this.cfGraphQLConfig.getServiceName(), this.cfGraphQLConfig.getClientName(), this.cfGraphQLConfig.getGraphQLServiceURL());
                    Class<?> clazz = this.getClassForOperation(opName, "Subscription");
                    Constructor<?>[] constructorArray = clazzDeclaredConstructors = clazz.getDeclaredConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    if (n2 >= n) break block8;
                    Constructor<?> constructorIter = constructorArray[n2];
                    Object clazzObj = null;
                    clazzObj = constructorIter.getParameters() != null && constructorIter.getParameterCount() > 0 ? CFGraphQLUtils.invokeParameterizedConstructor(paramValues, constructorIter) : (Object)constructorIter.newInstance(new Object[0]);
                    graphQLSubscriptionCallImpl = new GraphQLSubscriptionCallImpl(this.apolloClient.subscribe((Subscription)clazzObj), this.cfGraphQLConfig, opName);
                    if (tempAttributeList == null) break block9;
                }
                catch (ClassNotFoundException ex) {
                    block10: {
                        this.logThrowMonitorException(opName, ex, "SUBSCRIBE_OPERATION_NOT_FOUND_EXCEPTION", tempAttributeList);
                        if (tempAttributeList == null) break block10;
                        tempAttributeList.addTagAttribute("operation_type", (Object)PMTGraphQlApis.GraphQL_subscription);
                    }
                    PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_subscription, tempAttributeList, opName, params, "", "");
                }
                catch (Throwable ex2) {
                    block11: {
                        this.logThrowMonitorException(opName, ex2, "SUBSCRIBE_EXCEPTION", tempAttributeList);
                        if (tempAttributeList == null) break block11;
                        {
                            catch (Throwable throwable) {
                                if (tempAttributeList != null) {
                                    tempAttributeList.addTagAttribute("operation_type", (Object)PMTGraphQlApis.GraphQL_subscription);
                                }
                                PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_subscription, tempAttributeList, opName, params, "", "");
                                throw throwable;
                            }
                        }
                        tempAttributeList.addTagAttribute("operation_type", (Object)PMTGraphQlApis.GraphQL_subscription);
                    }
                    PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_subscription, tempAttributeList, opName, params, "", "");
                }
                tempAttributeList.addTagAttribute("operation_type", (Object)PMTGraphQlApis.GraphQL_subscription);
            }
            PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_subscription, tempAttributeList, opName, params, "", "");
            return graphQLSubscriptionCallImpl;
        }
        if (tempAttributeList != null) {
            tempAttributeList.addTagAttribute("operation_type", (Object)PMTGraphQlApis.GraphQL_subscription);
        }
        PMTUtilsForGraphQlClient.endGraphQlmonitoring(PMTGraphQlApis.GraphQL_subscription, tempAttributeList, opName, params, "", "");
        return null;
    }

    @Override
    public void downloadSchema(String serverUrl, String path) {
    }

    public String getName() {
        return CFGRAPHQLCLIENT;
    }

    @Override
    public void shutDown() {
        this.apolloClient = null;
        this.stopBatchPoller();
    }

    public ApolloClient getApolloClient() {
        return this.apolloClient;
    }

    public void setApolloClient(ApolloClient apolloClient) {
        this.apolloClient = apolloClient;
    }

    public CFGraphQLConfig getCfGraphQLConfig() {
        return this.cfGraphQLConfig;
    }
}

