/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.document;

import coldfusion.server.ServiceFactory;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DImageElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.ThePilot;
import ice.storm.Viewport;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.net.URL;

public class DocumentImageRetriever {
    private MediaTracker mediaTracker = null;
    private int image_id = 0;
    private URL baseUrl = null;
    private long requestTimeOut = ServiceFactory.getRuntimeService().getRequestTimeoutLimit() * 1000L;

    public DocumentImageRetriever() {
        this.mediaTracker = new MediaTracker(new DocuemntFakeComponent());
    }

    public void retrieveImageSrc(Viewport v) {
        if (v != null && v.getPilot() instanceof ThePilot) {
            ThePilot pilot = (ThePilot)v.getPilot();
            this.baseUrl = v.getBaseURL();
            DDocument doc = (DDocument)pilot.getDocument();
            this.fetch((DElement)doc.getFirstChild(), 1);
            this.waitForImages();
        }
    }

    private void fetch(DElement e, int tab) {
        for (DNode n = (DNode)e.getFirstChild(); n != null; n = (DNode)n.getNextSibling()) {
            if (!(n instanceof DElement)) continue;
            if (n instanceof DImageElement) {
                DImageElement element = (DImageElement)n;
                String src = element.getSrc();
                this.processImageSrc(src);
            } else {
                String type = ((DElement)n).getAttribute("type");
                String data = ((DElement)n).getAttribute("data");
                if (type != null && data != null && (type = type.trim().toLowerCase()).startsWith("image")) {
                    this.processImageSrc(data);
                }
            }
            this.fetch((DElement)n, tab + 1);
        }
    }

    private void processImageSrc(String src) {
        URL url = null;
        try {
            File f = new File(src);
            url = !f.isFile() ? new URL(this.baseUrl, src) : f.toURL();
            Object content = url.getContent();
            Image image = null;
            image = content instanceof ImageProducer ? Toolkit.getDefaultToolkit().createImage((ImageProducer)content) : Toolkit.getDefaultToolkit().createImage((byte[])content);
            this.addImageToTracker(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void addImageToTracker(Image image) {
        int imgid = ++this.image_id;
        this.mediaTracker.addImage(image, imgid);
        try {
            this.mediaTracker.waitForID(imgid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void waitForImages() {
        try {
            this.mediaTracker.waitForAll(this.requestTimeOut);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class DocuemntFakeComponent
    extends Component {
        private DocuemntFakeComponent() {
        }
    }
}

