/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Viewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import org.w3c.dom.html.HTMLCollection;

public class VisitedLinks
implements PropertyChangeListener {
    private Hashtable visited = new Hashtable();

    public void propertyChange(PropertyChangeEvent e) {
        Viewport v = (Viewport)e.getSource();
        String name = e.getPropertyName();
        if (name.equals("contentLoading")) {
            String val = (String)e.getNewValue();
            if (val.equals("request")) {
                ContentLoader cl = (ContentLoader)e.getOldValue();
                String url = cl.getLocation();
                if (url != null) {
                    this.visited.put(url, "visited");
                }
            } else if (val.equals("end")) {
                this.traverseLinks(v);
            }
        }
    }

    public void clearLinks() {
        this.visited.clear();
    }

    private void traverseLinks(Viewport view) {
        if (view.getPilot() instanceof ThePilot) {
            boolean mustRefresh = false;
            ThePilot pilot = (ThePilot)view.getPilot();
            DDocument doc = (DDocument)pilot.getDocument();
            HTMLCollection list = doc.getLinks();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.getLength(); ++i) {
                DAnchorElement elem;
                if (!(list.item(i) instanceof DAnchorElement) || !this.visited.containsKey((elem = (DAnchorElement)list.item(i)).getHref())) continue;
                mustRefresh = true;
                elem.setVisited(true);
            }
            if (mustRefresh) {
                pilot.refresh();
            }
        }
    }
}

