/*
 * Decompiled with CFR 0.152.
 */
package ice.browser;

import ice.browser.HintDisplayer;
import ice.browser.MyCallback_swing;
import ice.browser.Tooltip;
import ice.pilots.html4.ThePilot;
import ice.storm.Hint;
import ice.storm.Pilot;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.w3c.dom.events.EventListener;

class BrowserFrame_swing
extends JInternalFrame
implements ActionListener,
PropertyChangeListener,
InternalFrameListener {
    private MyCallback_swing master;
    private String viewportName;
    private JTextField loc;
    private JPanel panel;
    private String prevLoc;
    private Tooltip tooltip;

    BrowserFrame_swing(MyCallback_swing master, Viewport viewport) {
        super(viewport.getName(), true, true, true, true);
        this.master = master;
        this.viewportName = viewport.getId();
        this.addInternalFrameListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        master.base.addPropertyChangeListener((PropertyChangeListener)this, this.viewportName);
        this.loc = new JTextField("", 30);
        this.loc.setBackground(Color.white);
        this.loc.setForeground(Color.black);
        this.loc.addActionListener(this);
        this.panel = new JPanel();
        this.getContentPane().add((Component)this.loc, "South");
        this.getContentPane().add((Component)this.panel, "Center");
    }

    void setTooltip(Tooltip t) {
        this.tooltip = t;
    }

    JPanel getPanel() {
        return this.panel;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.loc) {
            int colon;
            String vname = this.viewportName;
            String str = this.loc.getText();
            int i = str.indexOf(124);
            if (i >= 0) {
                vname = str.substring(0, i);
                str = str.substring(i + 1);
            }
            if ((colon = str.indexOf(58)) < 0) {
                int slash = str.indexOf(47);
                str = slash == 0 ? "file://localhost" + str : "http://" + str;
            }
            this.master.base.renderContent(str, null, vname);
            if (!vname.equals(this.viewportName)) {
                this.loc.setText(this.prevLoc);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Pilot p;
        String val;
        Viewport v = (Viewport)e.getSource();
        boolean isMyView = v.getId().equals(this.viewportName);
        String name = e.getPropertyName();
        if (name == "hint") {
            Hint hint = (Hint)e.getNewValue();
            HintDisplayer.display(hint, this.master.base, v);
        } else if (name == "title") {
            if (isMyView) {
                String val2 = (String)e.getNewValue();
                this.setTitle("ICEbrowser - " + val2);
            }
        } else if (name == "location") {
            if (isMyView) {
                String val3 = (String)e.getNewValue();
                this.loc.setText(val3);
                this.prevLoc = this.loc.getText();
            }
        } else if (name != "statusLine" && name != "contentLoadingProgress" && name == "pilotLoading" && (val = (String)e.getNewValue()) == "end" && this.tooltip != null && (p = v.getPilot()) instanceof ThePilot) {
            ThePilot pp = (ThePilot)p;
            pp.addPersistentDOMEventListener("mouseover", (EventListener)this.tooltip, true);
            pp.addPersistentDOMEventListener("mouseout", (EventListener)this.tooltip, true);
        }
    }

    public void internalFrameActivated(InternalFrameEvent e) {
    }

    public void internalFrameClosed(InternalFrameEvent e) {
    }

    public void internalFrameClosing(InternalFrameEvent e) {
        this.master.base.closeViewport(this.viewportName);
    }

    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    public void internalFrameIconified(InternalFrameEvent e) {
    }

    public void internalFrameOpened(InternalFrameEvent e) {
    }
}

