/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.cursor;

import coldfusion.log.Logger;
import coldfusion.nosql.NoSQLQueryDetails;
import coldfusion.nosql.mongo.CFMongoCollection;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.BsonUtils;
import coldfusion.nosql.mongo.cursor.CFMongoFindIterator;
import coldfusion.nosql.mongo.cursor.CFMongoIteratorImpl;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.util.UDFUtil;
import coldfusion.server.NoSQLService;
import coldfusion.server.ServiceFactory;
import com.mongodb.CursorType;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import jakarta.servlet.jsp.PageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

@GenerateCFNamedInvoke
public class CFMongoFindIteratorImpl<T>
extends CFMongoIteratorImpl<T>
implements CFMongoFindIterator<T>,
NamedInvokable {
    private Bson hint;
    private int limit;
    private int skip;
    private long maxTimeMS;
    private Collation collation;
    private Bson filter;
    private CFMongoCollection collection;
    private String cacheId;
    private String cacheRegion;
    private Long cachedWithin;
    private Date cachedAfter;
    private NoSQLQueryDetails noSQLQueryDetails;
    Map<String, Object> queryParamMap;
    public static final String CACHED = "cached";
    private Logger logger = ServiceFactory.getLoggingService().getLogger("coldfusion.cursor");
    private static InvokeNamedMethodInvocationMap<CFMongoFindIteratorImpl> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    public CFMongoFindIteratorImpl(CFMongoCollection collection, FindIterable<T> iterable) {
        this(collection, iterable, null);
    }

    public CFMongoFindIteratorImpl(CFMongoCollection collection, FindIterable<T> iterable, Bson filter) {
        super(iterable);
        this.collection = collection;
        this.filter = filter;
        this.noSQLQueryDetails = new NoSQLQueryDetails();
        this.queryParamMap = new HashMap<String, Object>();
    }

    @Override
    public CFMongoFindIterator<T> filter(Map<?, ?> filter) {
        ((FindIterable)this.iterable).filter((Bson)BsonUtils.to(filter));
        this.queryParamMap.put("filter", filter);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> limit(Object limit) {
        this.limit = Cast._int((Object)limit);
        ((FindIterable)this.iterable).limit(this.limit);
        this.queryParamMap.put("limit", limit);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> skip(Object skip) {
        this.skip = Cast._int((Object)skip);
        ((FindIterable)this.iterable).skip(this.skip);
        this.queryParamMap.put("skip", skip);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> maxTimeMS(Object maxTime) {
        this.maxTimeMS = Cast._long((Object)maxTime);
        ((FindIterable)this.iterable).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        this.queryParamMap.put("maxTimeMS", maxTime);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> maxAwaitTime(Object maxAwaitTime) {
        ((FindIterable)this.iterable).maxAwaitTime(Cast._long((Object)maxAwaitTime), TimeUnit.MILLISECONDS);
        this.queryParamMap.put("maxAwaitTime", maxAwaitTime);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> modifiers(Map<?, ?> modifiers) {
        ((FindIterable)this.iterable).modifiers((Bson)BsonUtils.to(modifiers));
        this.queryParamMap.put("modifiers", modifiers);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> projection(Map<?, ?> projection) {
        ((FindIterable)this.iterable).projection((Bson)BsonUtils.to(projection));
        this.queryParamMap.put("projection", projection);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> sort(Map<?, ?> sort) {
        ((FindIterable)this.iterable).sort((Bson)BsonUtils.to(sort));
        this.queryParamMap.put("sort", sort);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> noCursorTimeout(Object noCursorTimeout) {
        ((FindIterable)this.iterable).noCursorTimeout(Cast._boolean((Object)noCursorTimeout));
        this.queryParamMap.put("noCursorTimeout", noCursorTimeout);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> oplogReplay(Object oplogReplay) {
        ((FindIterable)this.iterable).oplogReplay(Cast._boolean((Object)oplogReplay));
        this.queryParamMap.put("oplogReplay", oplogReplay);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> partial(Object partial) {
        ((FindIterable)this.iterable).partial(Cast._boolean((Object)partial));
        this.queryParamMap.put("partial", partial);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> tailable(Map config) {
        boolean awaitData;
        Object object;
        if (config != null && (object = config.get("awaitData")) != null && (awaitData = Cast._boolean(object))) {
            ((FindIterable)this.iterable).cursorType(CursorType.TailableAwait);
            return this;
        }
        ((FindIterable)this.iterable).cursorType(CursorType.Tailable);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> batchSize(int batchSize) {
        ((FindIterable)this.iterable).batchSize(Cast._int((long)batchSize));
        this.queryParamMap.put("batchSize", batchSize);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> collation(Map<?, ?> collation) {
        Collation collationObj;
        this.collation = collationObj = MongoUtils.getCollation(collation);
        ((FindIterable)this.iterable).collation(collationObj);
        this.queryParamMap.put("collation", collationObj);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> comment(String comment) {
        ((FindIterable)this.iterable).comment(comment);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> hint(Map<?, ?> hint) {
        this.hint = BsonUtils.to(hint);
        ((FindIterable)this.iterable).hint(this.hint);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> max(Map<?, ?> max) {
        ((FindIterable)this.iterable).max((Bson)BsonUtils.to(max));
        this.queryParamMap.put("max", max);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> min(Map<?, ?> min) {
        ((FindIterable)this.iterable).min((Bson)BsonUtils.to(min));
        this.queryParamMap.put("min", min);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> maxScan(Object maxScan) {
        ((FindIterable)this.iterable).maxScan(Cast._long((Object)maxScan));
        this.queryParamMap.put("maxScan", maxScan);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> returnKey(Object returnKey) {
        ((FindIterable)this.iterable).returnKey(Cast._boolean((Object)returnKey));
        this.queryParamMap.put("returnKey", returnKey);
        return this;
    }

    @Override
    public CFMongoFindIterator<T> showRecordId(Object showRecordId) {
        ((FindIterable)this.iterable).showRecordId(Cast._boolean((Object)showRecordId));
        this.queryParamMap.put("showRecordId", showRecordId);
        return this;
    }

    public CFMongoFindIterator<T> cacheId(String cacheId) {
        this.cacheId = cacheId;
        this.noSQLQueryDetails.setCacheId(cacheId);
        return this;
    }

    public CFMongoFindIterator<T> cacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    public CFMongoFindIterator<T> cachedWithin(Double cachedWithin) {
        this.cachedWithin = new Long((long)(cachedWithin * 8.64E7));
        return this;
    }

    public CFMongoFindIterator<T> cachedAfter(Date cachedAfter) {
        this.cachedAfter = cachedAfter;
        return this;
    }

    @Override
    public long count() {
        CountOptions countOptions = new CountOptions();
        countOptions.hint(this.hint);
        countOptions.collation(this.collation);
        countOptions.limit(this.limit);
        countOptions.skip(this.skip);
        countOptions.maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        return this.collection.__count(countOptions, this.filter);
    }

    private void fillNoSQLQueryDetails() {
        if (this.noSQLQueryDetails == null) {
            this.noSQLQueryDetails = new NoSQLQueryDetails();
        }
        this.noSQLQueryDetails.setDsnName((String)this.collection.getDb().getSvc().getDataSourceSettings().get("NAME"));
        this.noSQLQueryDetails.setDbType((String)this.collection.getDb().getSvc().getDataSourceSettings().get("TYPE"));
        this.noSQLQueryDetails.setCacheId(this.cacheId);
        this.noSQLQueryDetails.setParameterObj(this.queryParamMap);
        this.noSQLQueryDetails.setHashCode();
    }

    private boolean toBeCached() {
        boolean toBeCached = false;
        if (this.cachedAfter != null && System.currentTimeMillis() > this.cachedAfter.getTime()) {
            toBeCached = true;
        }
        if (this.cachedWithin != null) {
            toBeCached = true;
        }
        return toBeCached;
    }

    private void setCachedMetadataProperty(Array res, boolean oldValue, boolean newValue) {
        if (res.metadata != null) {
            if (res.metadata.containsKey(CACHED) && (Boolean)res.metadata.get(CACHED) == oldValue) {
                res.metadata.replace(CACHED, newValue);
            } else if (!res.metadata.containsKey(CACHED)) {
                res.addToMetaData(CACHED, (Object)newValue);
            }
        } else {
            res.addToMetaData(CACHED, (Object)newValue);
        }
    }

    @Override
    public Array toArray() {
        this.fillNoSQLQueryDetails();
        if (this.toBeCached()) {
            NoSQLService noSQLService = ServiceFactory.getNoSQLService((boolean)true);
            Object results = noSQLService.getCachedQuery(this.noSQLQueryDetails, this.cacheRegion, this.cachedWithin);
            if (results == null) {
                results = super.toArray();
                this.setCachedMetadataProperty((Array)results, true, false);
                noSQLService.setCachedQuery(this.noSQLQueryDetails, this.noSQLQueryDetails.getHashCode(), results, this.cachedWithin, this.cachedAfter != null, this.cacheId, this.cacheRegion);
            } else {
                this.setCachedMetadataProperty((Array)results, false, true);
            }
            return (Array)results;
        }
        Array res = super.toArray();
        this.setCachedMetadataProperty(res, true, false);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(UDFMethod closureFunc) {
        block7: {
            block5: {
                Object results;
                CFPage cfpage;
                int i;
                block6: {
                    this.fillNoSQLQueryDetails();
                    if (!this.toBeCached()) break block5;
                    i = 1;
                    cfpage = UDFUtil.getCurrentPage();
                    NoSQLService noSQLService = ServiceFactory.getNoSQLService((boolean)true);
                    results = noSQLService.getCachedQuery(this.noSQLQueryDetails, this.cacheRegion, this.cachedWithin);
                    if (results != null) break block6;
                    ArrayList<Object> cacheResults = new ArrayList<Object>();
                    Object[] args = new Object[2];
                    MongoCursor cursor = this.iterable.cursor();
                    try {
                        while (cursor.hasNext()) {
                            Object item = cursor.next();
                            cacheResults.add(item);
                            args[0] = item;
                            args[1] = i++;
                            UDFUtil.applyFunction((UDFMethod)closureFunc, (Object[])args, (CFPage)cfpage);
                        }
                    }
                    catch (Throwable throwable) {
                        noSQLService.setCachedQuery(this.noSQLQueryDetails, this.noSQLQueryDetails.getHashCode(), cacheResults, this.cachedWithin, this.cachedAfter != null, this.cacheId, this.cacheRegion);
                        cursor.close();
                        throw throwable;
                    }
                    noSQLService.setCachedQuery(this.noSQLQueryDetails, this.noSQLQueryDetails.getHashCode(), cacheResults, this.cachedWithin, this.cachedAfter != null, this.cacheId, this.cacheRegion);
                    cursor.close();
                    break block7;
                }
                if (results instanceof List) {
                    i = 1;
                    Object[] args = new Object[2];
                    for (Object res : (List)results) {
                        args[0] = res;
                        args[1] = i++;
                        UDFUtil.applyFunction((UDFMethod)closureFunc, (Object[])args, (CFPage)cfpage);
                    }
                }
                break block7;
            }
            super.forEach(closureFunc);
        }
    }

    @Override
    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("cursor service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("cursor service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"filter", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"filter"}, args);
                    return obj.filter(Cast._Map((Object)argColl.get((Object)"filter")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("filter", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"limit", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"limit"}, args);
                    return obj.limit(argColl.get((Object)"limit"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("limit", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"skip", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"skip"}, args);
                    return obj.skip(argColl.get((Object)"skip"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("skip", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"maxTimeMS", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"maxTime"}, args);
                    return obj.maxTimeMS(argColl.get((Object)"maxTime"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("maxTimeMS", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"maxAwaitTime", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"maxAwaitTime"}, args);
                    return obj.maxAwaitTime(argColl.get((Object)"maxAwaitTime"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("maxAwaitTime", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"modifiers", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"modifiers"}, args);
                    return obj.modifiers(Cast._Map((Object)argColl.get((Object)"modifiers")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("modifiers", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"projection", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"projection"}, args);
                    return obj.projection(Cast._Map((Object)argColl.get((Object)"projection")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("projection", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"sort", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"sort"}, args);
                    return obj.sort(Cast._Map((Object)argColl.get((Object)"sort")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("sort", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"noCursorTimeout", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"noCursorTimeout"}, args);
                    return obj.noCursorTimeout(argColl.get((Object)"noCursorTimeout"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("noCursorTimeout", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"oplogReplay", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"oplogReplay"}, args);
                    return obj.oplogReplay(argColl.get((Object)"oplogReplay"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("oplogReplay", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"partial", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"partial"}, args);
                    return obj.partial(argColl.get((Object)"partial"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("partial", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"tailable", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"config"}, args);
                    return obj.tailable(Cast._Map((Object)argColl.get((Object)"config")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("tailable", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"batchSize", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"batchSize"}, args);
                    return obj.batchSize(Cast._int((Object)argColl.get((Object)"batchSize"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("batchSize", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"collation", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"collation"}, args);
                    return obj.collation(Cast._Map((Object)argColl.get((Object)"collation")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("collation", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"comment", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"comment"}, args);
                    return obj.comment(Cast._String((Object)argColl.get((Object)"comment")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("comment", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"hint", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"hint"}, args);
                    return obj.hint(Cast._Map((Object)argColl.get((Object)"hint")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("hint", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"max", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"max"}, args);
                    return obj.max(Cast._Map((Object)argColl.get((Object)"max")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("max", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"min", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"min"}, args);
                    return obj.min(Cast._Map((Object)argColl.get((Object)"min")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("min", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"maxScan", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"maxScan"}, args);
                    return obj.maxScan(argColl.get((Object)"maxScan"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("maxScan", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"returnKey", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"returnKey"}, args);
                    return obj.returnKey(argColl.get((Object)"returnKey"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("returnKey", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"showRecordId", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"showRecordId"}, args);
                    return obj.showRecordId(argColl.get((Object)"showRecordId"));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("showRecordId", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cacheId", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"cacheId"}, args);
                    return obj.cacheId(Cast._String((Object)argColl.get((Object)"cacheId")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cacheId", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cacheRegion", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"cacheRegion"}, args);
                    return obj.cacheRegion(Cast._String((Object)argColl.get((Object)"cacheRegion")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cacheRegion", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cachedWithin", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"cachedWithin"}, args);
                    return obj.cachedWithin(Cast._double((Object)argColl.get((Object)"cachedWithin"), (boolean)false));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cachedWithin", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"cachedAfter", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"cachedAfter"}, args);
                    return obj.cachedAfter(Cast._Date((Object)argColl.get((Object)"cachedAfter")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("cachedAfter", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"count", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.count();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("count", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"toArray", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.toArray();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("toArray", obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"forEach", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"closureFunc"}, args);
                    obj.forEach((UDFMethod)Cast._castForInvokeGen((Object)argColl.get((Object)"closureFunc"), UDFMethod.class));
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("forEach", obj);
        });
    }
}

