/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.nosql.NoSQLPasswordDecryptor;
import coldfusion.nosql.mongo.MongoConfigException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.codecs.CFMongoCodecProvider;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ListFunc;
import coldfusion.security.SSLConfig;
import coldfusion.security.SSLUtils;
import coldfusion.util.RB;
import com.mongodb.AuthenticationMechanism;
import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.gridfs.codecs.GridFSFileCodec;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.BsonDocument;
import org.bson.Transformer;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.jsr310.Jsr310CodecProvider;

public final class MongoClientSettingsBuilder {
    private static List providerList;
    public static final CodecRegistry DEFAULT_CODEC_REGISTRY;
    private static final String INVALID_CREDENTIALS = "InvalidCredentials";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String SERVICE_NAME = "SERVICE_NAME";
    public static final String $EXTERNAL = "$external";
    public static final String CANONICALIZE_HOST_NAME = "canonicalize_host_name";
    public static final String PASSWORD = "password";
    public static final String AUTHSOURCE = "authSource";
    public static final String AUTH_MECHANISM = "authMechanism";
    public static final String AUTH_MECHANISM_PROPS = "authMechanismProperties";
    public static final String USERNAME = "username";
    public static final String GSSAPISERVICENAME = "gssapiServiceName";
    public static final String SNAPPY = "snappy";
    public static final String ZLIB = "zlib";
    public static final String ZLIB_COMPRESSION_LEVEL = "zlibCompressionLevel";
    public static final String COMPRESSORS = "compressors";
    public static final String APPLICATION_NAME = "appName";
    public static final String KEEP_ALIVE = "keepAlive";
    public static final String SEND_BUFFER_SIZE = "sendBufferSize";
    public static final String RECEIVE_BUFFER_SIZE = "receiveBufferSize";
    public static final String READ_TIMEOUT = "readTimeout";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String MIN_HEARTBEAT_FREQUENCY = "minHeartbeatFrequency";
    public static final String HEARTBEAT_FREQUENCY = "heartbeatFrequency";
    public static final String ENABLE_SSL = "ssl";
    public static final String INVALID_HOST_NAME_ALLOWED = "invalidHostNameAllowed";
    public static final String SSL_STORE_PROVIDER = "sslStoreProvider";
    public static final String SSL_KEY_STORE_PROVIDER = "sslKeyStoreProvider";
    public static final String SSL_TRUST_STORE_TYPE = "sslTrustStoreType";
    public static final String SSL_KEY_STORE_TYPE = "sslKeyStoreType";
    public static final String SSL_TRUST_STORE_PASSWORD = "sslTrustStorePassword";
    public static final String SSL_KEY_STORE_PASSWORD = "sslKeyStorePassword";
    public static final String SSL_TRUST_STORE = "sslTrustStore";
    public static final String SSL_KEYSTORE = "sslKeystore";
    public static final String SSL_PROTOCOL = "sslprotocol";
    public static final String MAINTENANCE_FREQUENCY = "maintenanceFrequency";
    public static final String MAINTENANCE_INITIAL_DELAY = "maintenanceInitialDelay";
    public static final String MAX_CONNECTION_IDLE_TIME = "maxConnectionIdleTime";
    public static final String MAX_CONNECTION_LIFE_TIME = "maxConnectionLifeTime";
    public static final String MAX_WAIT_TIME = "waitQueueTimeout";
    public static final String MAX_WAIT_QUEUE_SIZE = "maxWaitQueueSize";
    public static final String MIN_SIZE = "minPoolSize";
    public static final String MAX_SIZE = "maxPoolSize";
    public static final String REPLICA_SET = "replicaSet";
    public static final String SERVER_SELECTION_TIMEOUT = "serverSelectionTimeout";
    public static final String LOCAL_THRESHOLD = "localThreshold";
    public static final String CLUSTER_TYPE = "clusterType";
    public static final String CASE_SENSITIVITY = "caseSensitivity";
    private ConnectionString mongoConnectionStr;
    private final Map<?, ?> configMap;
    private NoSQLPasswordDecryptor passwordDecryptor;

    public MongoClientSettingsBuilder(Map<?, ?> configMap) {
        this.configMap = configMap;
    }

    public MongoClientSettingsBuilder withPasswordDecryptor(NoSQLPasswordDecryptor passwordDecryptor) {
        this.passwordDecryptor = passwordDecryptor;
        return this;
    }

    private String decryptPassword(String password) {
        if (password != null && this.passwordDecryptor != null) {
            return this.passwordDecryptor.decryptPassword(password);
        }
        return password;
    }

    private static boolean isMongoConnectionString(String temp) {
        return temp != null && (temp.toLowerCase().startsWith("mongodb://") || temp.startsWith("mongodb+srv://"));
    }

    public MongoClientSettings buildSettings() {
        ReadPreference cStringReadPref;
        ReadPreference readPreference;
        WriteConcern cStringWConcern;
        WriteConcern writeConcern;
        MongoClientSettings.Builder builder = MongoClientSettings.builder();
        Object temp = MongoUtils.getStringProperty(HOST, this.configMap);
        if (temp != null && !(temp instanceof String)) {
            throw new MongoConfigException("InvalidMongoHost", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidhost"));
        }
        if (MongoClientSettingsBuilder.isMongoConnectionString((String)temp)) {
            this.mongoConnectionStr = new ConnectionString((String)temp);
        }
        if (this.mongoConnectionStr != null) {
            builder.applyConnectionString(this.mongoConnectionStr);
        }
        if ((writeConcern = MongoUtils.getWriteConcern(this.configMap, cStringWConcern = this.mongoConnectionStr != null ? this.mongoConnectionStr.getWriteConcern() : null)) != null) {
            builder.writeConcern(writeConcern);
        }
        if ((readPreference = MongoUtils.getReadPreference(this.configMap, cStringReadPref = this.mongoConnectionStr != null ? this.mongoConnectionStr.getReadPreference() : null)) != null) {
            builder.readPreference(readPreference);
        }
        if ((temp = MongoUtils.getReadConcern(this.configMap)) != null) {
            builder.readConcern((ReadConcern)temp);
        }
        if ((temp = MongoUtils.getBooleanProperty(CASE_SENSITIVITY, this.configMap)) != null && ((Boolean)temp).booleanValue()) {
            providerList = new ArrayList();
            providerList.add(new CFMongoCodecProvider((Boolean)temp));
            providerList.add(new ValueCodecProvider());
            providerList.add(new BsonValueCodecProvider());
            providerList.add(new DBRefCodecProvider());
            providerList.add(new DBObjectCodecProvider());
            providerList.add(new DocumentCodecProvider((Transformer)new DocumentToDBRefTransformer()));
            providerList.add(new IterableCodecProvider((Transformer)new DocumentToDBRefTransformer()));
            providerList.add(new MapCodecProvider((Transformer)new DocumentToDBRefTransformer()));
            providerList.add(new GeoJsonCodecProvider());
            providerList.add(new CFGridFSFileCodecProvider());
            providerList.add(new Jsr310CodecProvider());
            CodecRegistry CASE_CODEC_REGISTRY = CodecRegistries.fromProviders((List)providerList);
            builder.applyToServerSettings((Block)new ServerSettingsBlock()).applyToSocketSettings((Block)new SocketSettingsBlock()).applyToSslSettings((Block)new SSLSettingsBlock()).applyToConnectionPoolSettings((Block)new ConnectionPoolSettingsBlock()).applyToClusterSettings((Block)new ClusterSettingsBlock()).codecRegistry(CASE_CODEC_REGISTRY);
        } else {
            builder.applyToServerSettings((Block)new ServerSettingsBlock()).applyToSocketSettings((Block)new SocketSettingsBlock()).applyToSslSettings((Block)new SSLSettingsBlock()).applyToConnectionPoolSettings((Block)new ConnectionPoolSettingsBlock()).applyToClusterSettings((Block)new ClusterSettingsBlock()).codecRegistry(DEFAULT_CODEC_REGISTRY);
        }
        MongoCredential credentials = this.getMongoCredential(this.configMap, this.mongoConnectionStr != null ? this.mongoConnectionStr.getDatabase() : null);
        if (credentials != null) {
            builder.credential(credentials);
        }
        if ((temp = MongoUtils.getStringProperty(APPLICATION_NAME, this.configMap)) != null) {
            builder.applicationName((String)temp);
        }
        if ((temp = MongoUtils.getRetryWrites(this.configMap)) != null) {
            builder.retryWrites(((Boolean)temp).booleanValue());
        }
        if ((temp = MongoUtils.getStringProperty(COMPRESSORS, this.configMap)) != null) {
            ArrayList<MongoCompressor> mongoCompressors = new ArrayList<MongoCompressor>(2);
            if (ListFunc.ListContainsNoCase((String)((String)temp), (String)SNAPPY, (String)",", (boolean)true) > 0) {
                mongoCompressors.add(MongoCompressor.createSnappyCompressor());
            }
            if (ListFunc.ListContainsNoCase((String)((String)temp), (String)ZLIB, (String)",", (boolean)true) > 0) {
                MongoCompressor zlibCompressor = MongoCompressor.createZlibCompressor();
                temp = MongoUtils.getIntegerProperty(ZLIB_COMPRESSION_LEVEL, this.configMap);
                if (temp != null) {
                    Integer intValue = (Integer)temp;
                    if (intValue < -1 || intValue > 9) {
                        throw new MongoConfigException("InvalidConfig", RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.invalidzliblevel"));
                    }
                    zlibCompressor.withProperty("LEVEL", (Object)intValue);
                }
                mongoCompressors.add(zlibCompressor);
            }
            if (mongoCompressors.size() > 0) {
                builder.compressorList(mongoCompressors);
            }
        }
        return builder.build();
    }

    public MongoCredential getMongoCredential(Map<?, ?> configMap, String database) {
        Map authMechanismProps;
        char[] passwordchar;
        String userName = MongoUtils.getStringProperty(USERNAME, configMap);
        String authMechanismName = MongoUtils.getStringProperty(AUTH_MECHANISM, configMap);
        String password = this.decryptPassword(MongoUtils.getStringProperty(PASSWORD, configMap));
        AuthenticationMechanism mechanism = null;
        MongoCredential cStringCredential = this.mongoConnectionStr != null ? this.mongoConnectionStr.getCredential() : null;
        try {
            if (authMechanismName != null) {
                if (!authMechanismName.equalsIgnoreCase("usernamepassword")) {
                    mechanism = AuthenticationMechanism.fromMechanismName((String)authMechanismName.toUpperCase());
                }
            } else {
                mechanism = cStringCredential != null ? cStringCredential.getAuthenticationMechanism() : null;
            }
        }
        catch (IllegalArgumentException e) {
            throw new MongoConfigException(INVALID_CREDENTIALS, RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.invalidauthmechanism", (Object)authMechanismName));
        }
        if (userName == null && cStringCredential != null) {
            userName = cStringCredential.getUserName();
        }
        if (password == null && cStringCredential != null && (passwordchar = cStringCredential.getPassword()) != null) {
            password = new String(passwordchar);
        }
        if (mechanism != null && mechanism != AuthenticationMechanism.MONGODB_X509 && userName == null) {
            throw new MongoConfigException(INVALID_CREDENTIALS, RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.nousername"));
        }
        if ((mechanism == AuthenticationMechanism.PLAIN || mechanism == AuthenticationMechanism.MONGODB_CR || mechanism == AuthenticationMechanism.SCRAM_SHA_1 || mechanism == AuthenticationMechanism.SCRAM_SHA_256) && password == null) {
            throw new MongoConfigException(INVALID_CREDENTIALS, RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.nopassword"));
        }
        if ((mechanism == AuthenticationMechanism.GSSAPI || mechanism == AuthenticationMechanism.MONGODB_X509) && password != null) {
            throw new MongoConfigException(INVALID_CREDENTIALS, RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.nopasswordauthmechanism"));
        }
        String authSource = MongoUtils.getStringProperty(AUTHSOURCE, configMap);
        if (authSource == null && cStringCredential != null) {
            authSource = cStringCredential.getSource();
        }
        MongoCredential credential = null;
        if (mechanism != null) {
            String gssapiServiceName = (String)configMap.get(GSSAPISERVICENAME);
            if (gssapiServiceName == null && cStringCredential != null) {
                gssapiServiceName = (String)cStringCredential.getMechanismProperty(GSSAPISERVICENAME, null);
            }
            credential = MongoClientSettingsBuilder.createMongoCredentialWithMechanism(mechanism, userName, password != null ? password.toCharArray() : null, authSource, gssapiServiceName, database);
        } else if (userName != null) {
            credential = MongoCredential.createCredential((String)userName, (String)MongoClientSettingsBuilder.getNotNull(authSource, database != null ? database : "admin"), (char[])(password != null ? password.toCharArray() : null));
        }
        if (credential != null && (authMechanismProps = (Map)configMap.get(AUTH_MECHANISM_PROPS)) != null) {
            for (Map.Entry entry : authMechanismProps.entrySet()) {
                String key = ((String)entry.getKey()).trim().toLowerCase();
                if (!key.equals(CANONICALIZE_HOST_NAME)) {
                    credential = credential.withMechanismProperty(key, (Object)Cast._boolean(entry.getValue()));
                    continue;
                }
                credential = credential.withMechanismProperty(key, entry.getValue());
            }
        }
        return credential;
    }

    private static MongoCredential createMongoCredentialWithMechanism(AuthenticationMechanism mechanism, String userName, char[] password, String authSource, String gssapiServiceName, String database) {
        String mechanismAuthSource;
        MongoCredential credential = null;
        switch (mechanism) {
            case PLAIN: {
                mechanismAuthSource = MongoClientSettingsBuilder.getNotNull(authSource, database != null ? database : $EXTERNAL);
                break;
            }
            case GSSAPI: 
            case MONGODB_X509: {
                mechanismAuthSource = MongoClientSettingsBuilder.getNotNull(authSource, $EXTERNAL);
                if (mechanismAuthSource.equals($EXTERNAL)) break;
                throw new MongoConfigException("InvalidAuthSource", RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.invalidauthsource", (Object)mechanism));
            }
            default: {
                mechanismAuthSource = MongoClientSettingsBuilder.getNotNull(authSource, database != null ? database : "admin");
            }
        }
        switch (mechanism) {
            case GSSAPI: {
                credential = MongoCredential.createGSSAPICredential((String)userName);
                if (gssapiServiceName == null) break;
                credential = credential.withMechanismProperty(SERVICE_NAME, (Object)gssapiServiceName);
                break;
            }
            case PLAIN: {
                credential = MongoCredential.createPlainCredential((String)userName, (String)mechanismAuthSource, (char[])password);
                break;
            }
            case MONGODB_CR: {
                credential = MongoCredential.createMongoCRCredential((String)userName, (String)mechanismAuthSource, (char[])password);
                break;
            }
            case MONGODB_X509: {
                credential = MongoCredential.createMongoX509Credential((String)userName);
                break;
            }
            case SCRAM_SHA_1: {
                credential = MongoCredential.createScramSha1Credential((String)userName, (String)mechanismAuthSource, (char[])password);
                break;
            }
            case SCRAM_SHA_256: {
                credential = MongoCredential.createScramSha256Credential((String)userName, (String)mechanismAuthSource, (char[])password);
            }
        }
        return credential;
    }

    private static String getNotNull(String authSource, String defaultAuthSource) {
        return authSource != null ? authSource : defaultAuthSource;
    }

    static {
        DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new CFMongoCodecProvider(), new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DBObjectCodecProvider(), new DocumentCodecProvider((Transformer)new DocumentToDBRefTransformer()), new IterableCodecProvider((Transformer)new DocumentToDBRefTransformer()), new MapCodecProvider((Transformer)new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new CFGridFSFileCodecProvider(), new Jsr310CodecProvider()));
    }

    private static class CFGridFSFileCodecProvider
    implements CodecProvider {
        private CFGridFSFileCodecProvider() {
        }

        public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
            if (clazz.equals(GridFSFile.class)) {
                return new GridFSFileCodec((CodecRegistry)new BSONDocumentCodecRegistry(registry));
            }
            return null;
        }

        private static class BSONDocumentCodecRegistry
        implements CodecRegistry {
            private CodecRegistry registry;

            public BSONDocumentCodecRegistry(CodecRegistry registry) {
                this.registry = registry;
            }

            public <T> Codec<T> get(Class<T> clazz) {
                if (clazz == BsonDocument.class) {
                    return new BsonDocumentCodec(this.registry);
                }
                return this.registry.get(clazz);
            }
        }
    }

    private class ServerSettingsBlock
    implements Block<ServerSettings.Builder> {
        private ServerSettingsBlock() {
        }

        public void apply(ServerSettings.Builder serverSettingsBuilder) {
            Object temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.HEARTBEAT_FREQUENCY);
            if (temp != null) {
                serverSettingsBuilder.heartbeatFrequency(Cast._long((Object)temp, (boolean)false), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MIN_HEARTBEAT_FREQUENCY)) != null) {
                serverSettingsBuilder.minHeartbeatFrequency(Cast._long((Object)temp, (boolean)false), TimeUnit.MILLISECONDS);
            }
        }
    }

    private class SocketSettingsBlock
    implements Block<SocketSettings.Builder> {
        private SocketSettingsBlock() {
        }

        public void apply(SocketSettings.Builder socketSettingsBuilder) {
            Object temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.CONNECT_TIMEOUT);
            if (temp != null) {
                socketSettingsBuilder.connectTimeout(MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.CONNECT_TIMEOUT, temp).intValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.READ_TIMEOUT)) != null) {
                socketSettingsBuilder.readTimeout(MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.READ_TIMEOUT, temp).intValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.RECEIVE_BUFFER_SIZE, MongoClientSettingsBuilder.this.configMap)) != null) {
                socketSettingsBuilder.receiveBufferSize(((Integer)temp).intValue());
            }
            if ((temp = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.SEND_BUFFER_SIZE, MongoClientSettingsBuilder.this.configMap)) != null) {
                socketSettingsBuilder.sendBufferSize(((Integer)temp).intValue());
            }
            if ((temp = MongoUtils.getBooleanProperty(MongoClientSettingsBuilder.KEEP_ALIVE, MongoClientSettingsBuilder.this.configMap)) != null) {
                socketSettingsBuilder.keepAlive(((Boolean)temp).booleanValue());
            }
        }
    }

    private class SSLSettingsBlock
    implements Block<SslSettings.Builder> {
        private SSLSettingsBlock() {
        }

        public void apply(SslSettings.Builder SslSettingsBuilder) {
            Boolean temp = MongoUtils.getBooleanProperty(MongoClientSettingsBuilder.ENABLE_SSL, MongoClientSettingsBuilder.this.configMap);
            if (temp != null) {
                SslSettingsBuilder.enabled(temp.booleanValue());
            }
            if ((temp = MongoUtils.getBooleanProperty(MongoClientSettingsBuilder.INVALID_HOST_NAME_ALLOWED, MongoClientSettingsBuilder.this.configMap)) != null) {
                SslSettingsBuilder.invalidHostNameAllowed(temp.booleanValue());
            }
            String sslKeyStore = MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_KEYSTORE, MongoClientSettingsBuilder.this.configMap);
            String sslTrustStore = MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_TRUST_STORE, MongoClientSettingsBuilder.this.configMap);
            if (sslKeyStore != null || sslTrustStore != null) {
                SSLConfig sslConfig = new SSLConfig();
                sslConfig.setKeyStorePath(sslKeyStore);
                sslConfig.setKeyStorePassword(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_KEY_STORE_PASSWORD, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setKeyStoreType(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_KEY_STORE_TYPE, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setKeyStoreProvider(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_KEY_STORE_PROVIDER, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setTrustStorePath(sslTrustStore);
                sslConfig.setTrustStorePassword(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_TRUST_STORE_PASSWORD, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setTrustStoreType(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_TRUST_STORE_TYPE, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setTrustStoreProvider(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_KEY_STORE_PROVIDER, MongoClientSettingsBuilder.this.configMap));
                sslConfig.setProtocol(MongoUtils.getStringProperty(MongoClientSettingsBuilder.SSL_PROTOCOL, MongoClientSettingsBuilder.this.configMap));
                try {
                    SSLContext sslContext = SSLUtils.getSslContext((SSLConfig)sslConfig);
                    SslSettingsBuilder.context(sslContext);
                }
                catch (Exception e) {
                    throw new MongoConfigException("SSLConfigError", e);
                }
            }
        }
    }

    private class ConnectionPoolSettingsBlock
    implements Block<ConnectionPoolSettings.Builder> {
        private ConnectionPoolSettingsBlock() {
        }

        public void apply(ConnectionPoolSettings.Builder connectionPoolSettingsBuilder) {
            Integer minSize;
            Object temp = MongoUtils.getPositiveIntegerProperty(MongoClientSettingsBuilder.MAX_SIZE, MongoClientSettingsBuilder.this.configMap);
            if (temp != null) {
                connectionPoolSettingsBuilder.maxSize(((Integer)temp).intValue());
            }
            if ((minSize = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.MIN_SIZE, MongoClientSettingsBuilder.this.configMap)) != null) {
                connectionPoolSettingsBuilder.minSize(minSize.intValue());
            }
            if (minSize != null && temp != null && minSize > (Integer)temp) {
                throw new MongoConfigException("InvalidConfig", RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.minmaxconnpool"));
            }
            temp = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.MAX_WAIT_QUEUE_SIZE, MongoClientSettingsBuilder.this.configMap);
            if (temp != null) {
                connectionPoolSettingsBuilder.maxWaitQueueSize(((Integer)temp).intValue());
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MAX_WAIT_TIME)) != null) {
                connectionPoolSettingsBuilder.maxWaitTime(MongoUtils.getLongProperty(MongoClientSettingsBuilder.MAX_WAIT_TIME, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MAX_CONNECTION_LIFE_TIME)) != null) {
                connectionPoolSettingsBuilder.maxConnectionLifeTime(MongoUtils.getLongProperty(MongoClientSettingsBuilder.MAX_CONNECTION_LIFE_TIME, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MAX_CONNECTION_IDLE_TIME)) != null) {
                connectionPoolSettingsBuilder.maxConnectionIdleTime(MongoUtils.getLongProperty(MongoClientSettingsBuilder.MAX_CONNECTION_IDLE_TIME, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MAINTENANCE_INITIAL_DELAY)) != null) {
                connectionPoolSettingsBuilder.maintenanceInitialDelay(MongoUtils.getLongProperty(MongoClientSettingsBuilder.MAINTENANCE_INITIAL_DELAY, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.MAINTENANCE_FREQUENCY)) != null) {
                connectionPoolSettingsBuilder.maintenanceFrequency(MongoUtils.getLongProperty(MongoClientSettingsBuilder.MAINTENANCE_FREQUENCY, temp).longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private class ClusterSettingsBlock
    implements Block<ClusterSettings.Builder> {
        private ClusterSettingsBlock() {
        }

        public void apply(ClusterSettings.Builder clusterSettingsBuilder) {
            String servers;
            Integer port;
            Object temp = MongoUtils.getStringProperty(MongoClientSettingsBuilder.REPLICA_SET, MongoClientSettingsBuilder.this.configMap);
            if (temp != null) {
                clusterSettingsBuilder.requiredReplicaSetName((String)temp);
            }
            if ((port = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.PORT, MongoClientSettingsBuilder.this.configMap)) != null) {
                this.validatePort(port);
            }
            if ((servers = MongoUtils.getStringProperty(MongoClientSettingsBuilder.HOST, MongoClientSettingsBuilder.this.configMap)) != null && !MongoClientSettingsBuilder.isMongoConnectionString(servers)) {
                List<ServerAddress> serverAddresses = this.getServers(servers, port);
                if (temp == null && serverAddresses.size() == 1) {
                    clusterSettingsBuilder.mode(ClusterConnectionMode.SINGLE);
                }
                clusterSettingsBuilder.hosts(serverAddresses);
            }
            if ((temp = MongoUtils.getStringProperty(MongoClientSettingsBuilder.CLUSTER_TYPE, MongoClientSettingsBuilder.this.configMap)) != null) {
                clusterSettingsBuilder.requiredClusterType(ClusterType.valueOf((String)((String)temp).toUpperCase()));
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.SERVER_SELECTION_TIMEOUT)) == null) {
                temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.CONNECT_TIMEOUT);
            }
            if (temp != null) {
                clusterSettingsBuilder.serverSelectionTimeout(MongoUtils.getLongProperty(MongoClientSettingsBuilder.SERVER_SELECTION_TIMEOUT, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getTimeSetting(MongoClientSettingsBuilder.this.configMap, MongoClientSettingsBuilder.LOCAL_THRESHOLD)) != null) {
                clusterSettingsBuilder.localThreshold(MongoUtils.getLongProperty(MongoClientSettingsBuilder.LOCAL_THRESHOLD, temp).longValue(), TimeUnit.MILLISECONDS);
            }
            if ((temp = MongoUtils.getIntegerProperty(MongoClientSettingsBuilder.MAX_WAIT_QUEUE_SIZE, MongoClientSettingsBuilder.this.configMap)) != null) {
                clusterSettingsBuilder.maxWaitQueueSize(((Integer)temp).intValue());
            }
        }

        private List<ServerAddress> getServers(String serversStr, Integer defaultPort) {
            List<ServerAddress> servers = this.parseServers(serversStr.split(","), defaultPort);
            if (servers.size() == 0) {
                throw new MongoConfigException("InvalidConfig", RB.getString(MongoClientSettingsBuilder.class, (String)"coldfusion.mongodb.emptyhost"));
            }
            return servers;
        }

        private List<ServerAddress> parseServers(String[] rawHosts, Integer defaultPort) {
            ArrayList<ServerAddress> hosts = new ArrayList<ServerAddress>();
            for (String host : rawHosts) {
                int port;
                if (host.length() == 0) continue;
                if (host.endsWith(".sock")) {
                    try {
                        hosts.add((ServerAddress)new UnixServerAddress(URLDecoder.decode(host, StandardCharsets.UTF_8.name())));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new MongoConfigException("InvalidHost", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidunixhost", (Object)host, (Object)e.getMessage()));
                    }
                }
                if (host.startsWith("[")) {
                    if (!host.contains("]")) {
                        throw new MongoConfigException("InvalidHost", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidipv6", (Object)host));
                    }
                    int idx = host.indexOf("]:");
                    if (idx != -1) {
                        port = this.validatePort(host, host.substring(idx + 2));
                        hosts.add(new ServerAddress(host, port));
                        continue;
                    }
                    if (defaultPort != null) {
                        hosts.add(new ServerAddress(host, defaultPort.intValue()));
                        continue;
                    }
                    hosts.add(new ServerAddress(host));
                    continue;
                }
                int colonCount = host.length() - host.replace(":", "").length();
                if (colonCount > 1) {
                    throw new MongoConfigException("InvalidHost", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidipv6colons", (Object)host));
                }
                if (colonCount == 1) {
                    port = this.validatePort(host, host.substring(host.indexOf(":") + 1));
                    hosts.add(new ServerAddress(host, port));
                    continue;
                }
                if (defaultPort != null) {
                    hosts.add(new ServerAddress(host, defaultPort.intValue()));
                    continue;
                }
                hosts.add(new ServerAddress(host));
            }
            return hosts;
        }

        private void validatePort(int port) {
            if (port <= 0 || port > 65535) {
                throw new MongoConfigException("InvalidPort", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidport", (Object)port));
            }
        }

        private int validatePort(String host, String port) {
            boolean invalidPort = false;
            int portInt = -1;
            try {
                portInt = Integer.parseInt(port);
                if (portInt <= 0 || portInt > 65535) {
                    invalidPort = true;
                }
            }
            catch (NumberFormatException e) {
                invalidPort = true;
            }
            if (invalidPort) {
                throw new MongoConfigException("InvalidHost", RB.getString((Object)this, (String)"coldfusion.mongodb.invalidhostport", (Object)host, (Object)port));
            }
            return portInt;
        }
    }
}

