/*
 * Decompiled with CFR 0.152.
 */
package com.zingchart;

import com.zingchart.Canvas;
import com.zingchart.CanvasGradient;
import com.zingchart.CanvasPattern;
import com.zingchart.Image;
import com.zingchart.State;
import com.zingchart.TextStyle;
import com.zingchart.Utils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Context2d
extends ScriptableObject {
    private static final long serialVersionUID = 438270592527335642L;
    private Canvas canvas;
    private Stack<State> stack = new Stack();
    private State state = new State();
    private GeneralPath path = new GeneralPath();
    private TextStyle textStyle;
    private boolean bMoveTo = false;

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setState(State state) {
        this.state.fillStyle = state.fillStyle;
        this.state.strokeStyle = state.strokeStyle;
        this.state.lineWidth = state.lineWidth;
        this.state.lineJoin = state.lineJoin;
        this.state.lineCap = state.lineCap;
        this.state.miterLimit = state.miterLimit;
        this.state.globalAlpha = state.globalAlpha;
        this.state.globalCompositeOperation = state.globalCompositeOperation;
        this.state.transform = state.transform;
        if (state.transform != null) {
            this.getCanvas().getGraphics().setTransform(state.transform);
        }
    }

    public State getState() {
        return this.state;
    }

    public void jsSet_font(String string) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        String string3 = "";
        if (string.indexOf("bold") != -1) {
            bl = true;
            string = string.replace("bold", "");
        }
        if (string.indexOf("italic") != -1) {
            bl2 = true;
            string = string.replace("italic", "");
        }
        String[] stringArray = string.split(" ");
        String string4 = ",px,pt,mm,cm,in,pc,";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().isEmpty()) continue;
            String string5 = stringArray[i].trim();
            if (string4.indexOf("," + string5.substring(string5.length() - 2, string5.length()) + ",") == -1) continue;
            string2 = stringArray[i].trim();
            string = string.replace(string2, "");
        }
        this.textStyle.fontFamily = string3 = string.trim();
        this.textStyle.fontSize = string2;
        this.textStyle.fontVariant = bl2 ? "italic" : "none";
        this.textStyle.fontWeight = bl ? "bold" : "regular";
    }

    public String jsGet_font() {
        return "";
    }

    public void jsSet_textAlign(String string) {
        this.textStyle.textAlign = string;
    }

    public String jsGet_textAlign() {
        return this.textStyle.textAlign;
    }

    public void jsSet_textBaseline(String string) {
    }

    public String jsGet_textBaseline() {
        return "";
    }

    public void jsFunction_strokeText(String string, double d, double d2) {
        this.jsFunction_fillText(string, d, d2);
    }

    public int jsFunction_getStringWidth(String string) {
        FontMetrics fontMetrics = this.getTextStyle().getMetrics();
        return fontMetrics.stringWidth(string);
    }

    public void jsFunction_fillText(String string, double d, double d2) {
        FontMetrics fontMetrics = this.getTextStyle().getMetrics();
        String string2 = this.textStyle.textAlign;
        if ("center".equals(string2)) {
            d -= (double)(fontMetrics.stringWidth(string) / 2);
        } else if ("right".equals(string2)) {
            d -= (double)fontMetrics.stringWidth(string);
        }
        d2 = d2 + (double)fontMetrics.getLeading() + (double)fontMetrics.getAscent();
        String string3 = this.textStyle.verticalAlign;
        if ("baseline".equals(string3)) {
            d2 = d2 - (double)fontMetrics.getLeading() + (double)fontMetrics.getAscent();
        } else if ("text-top".equals(string3)) {
            d2 -= (double)fontMetrics.getLeading();
        } else if ("middle".equals(string3)) {
            d2 = d2 - (double)fontMetrics.getLeading() - (double)(fontMetrics.getAscent() / 2);
        } else if ("bottom".equals(string3) || "text-bottom".equals(string3)) {
            d2 -= (double)fontMetrics.getHeight();
        }
        this.getCanvas().getGraphics().setColor(Utils.parseColor(this.getState().fillStyle.toString()));
        this.getCanvas().getGraphics().setFont(this.getTextStyle().getFont());
        this.getCanvas().getGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.getCanvas().getGraphics().drawString(string, (int)d, (int)d2);
    }

    public void jsFunction_drawImage(Object object, double d, double d2, double d3, double d4) {
        if (object.getClass().getName() == "com.zingchart.Canvas") {
            this.getCanvas().getImage().createGraphics().drawImage(((Canvas)object).getImage(), (int)d, (int)d2, (int)d3, (int)d4, null);
        } else if (object.getClass().getName() == "com.zingchart.Image") {
            this.getCanvas().getGraphics().drawImage(((Image)object).image, (int)d, (int)d2, (int)d3, (int)d4, null);
        }
    }

    public void jsFunction_drawImageRect(Object object, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (object.getClass().getName() == "com.zingchart.Canvas") {
            this.getCanvas().getImage().createGraphics().drawImage(((Canvas)object).getImage(), (int)d, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6, (int)d7, (int)d8, null);
        } else if (object.getClass().getName() == "com.zingchart.Image") {
            this.getCanvas().getGraphics().drawImage(((Image)object).image, (int)d, (int)d2, (int)d3, (int)d4, (int)d5, (int)d6, (int)d7, (int)d8, null);
        }
    }

    public void jsSet_fillStyle(Object object) {
        this.state.fillStyle = object;
        Paint paint = null;
        if (this.state.fillStyle instanceof String) {
            paint = Utils.parseColor(this.state.fillStyle.toString());
        } else if (this.state.fillStyle instanceof CanvasGradient) {
            paint = ((CanvasGradient)this.state.fillStyle).getPaint();
        } else if (this.state.fillStyle instanceof CanvasPattern) {
            paint = ((CanvasPattern)this.state.fillStyle).getPaint();
        }
        this.state.fillPaint = paint;
    }

    public Object jsGet_fillStyle() {
        return this.state.fillStyle;
    }

    public void jsSet_strokeStyle(Object object) {
        this.state.strokeStyle = object;
        Paint paint = null;
        if (this.state.strokeStyle instanceof String) {
            paint = Utils.parseColor(this.state.strokeStyle.toString());
        } else if (this.state.strokeStyle instanceof CanvasGradient) {
            paint = ((CanvasGradient)this.state.strokeStyle).getPaint();
        }
        this.state.strokePaint = paint;
    }

    public Object jsGet_strokeStyle() {
        return this.state.strokeStyle;
    }

    public void jsSet_lineWidth(int n) {
        this.state.lineWidth = n;
    }

    public int jsGet_lineWidth() {
        return this.state.lineWidth;
    }

    public void jsSet_lineCap(String string) {
        this.state.lineCap = string;
    }

    public String jsGet_lineCap() {
        return this.state.lineCap;
    }

    public void jsSet_lineJoin(String string) {
        this.state.lineJoin = string;
    }

    public String jsGet_lineJoin() {
        return this.state.lineJoin;
    }

    public void jsSet_miterLimit(double d) {
        this.state.miterLimit = (float)d;
    }

    public double jsGet_miterLimit() {
        return this.state.miterLimit;
    }

    public AlphaComposite setupComposite(String string) {
        int n = "source-atop".equals(this.state.globalCompositeOperation) ? 10 : ("source-in".equals(this.state.globalCompositeOperation) ? 5 : ("source-out".equals(this.state.globalCompositeOperation) ? 7 : ("destination-atop".equals(this.state.globalCompositeOperation) ? 10 : ("destination-in".equals(this.state.globalCompositeOperation) ? 6 : ("destination-out".equals(this.state.globalCompositeOperation) ? 8 : ("destination-over".equals(this.state.globalCompositeOperation) ? 4 : ("xor".equals(this.state.globalCompositeOperation) ? 12 : ("over".equals(this.state.globalCompositeOperation) ? 1 : 3))))))));
        return AlphaComposite.getInstance(n, this.state.globalAlpha);
    }

    public void jsSet_globalAlpha(Object object) {
        this.state.globalAlpha = Float.parseFloat(object.toString());
        this.applyComposite();
    }

    public float jsGet_globalAlpha() {
        return this.state.globalAlpha;
    }

    public void jsSet_globalCompositeOperation(String string) {
        this.state.globalCompositeOperation = string;
        this.applyComposite();
    }

    public void applyComposite() {
        AlphaComposite alphaComposite = this.setupComposite(this.state.globalCompositeOperation);
        this.getCanvas().getGraphics().setComposite(alphaComposite);
    }

    public void jsFunction_fillRect(int n, int n2, int n3, int n4) {
        this.getCanvas().getGraphics().setPaint(this.state.fillPaint);
        this.getCanvas().getGraphics().fillRect(n, n2, n3, n4);
    }

    public void jsFunction_strokeRect(int n, int n2, int n3, int n4) {
        this.getCanvas().getGraphics().setPaint(this.state.strokePaint);
        this.getCanvas().getGraphics().setStroke(this.setupStroke());
        this.getCanvas().getGraphics().drawRect(n, n2, n3, n4);
    }

    public Scriptable jsFunction_createLinearGradient(double d, double d2, double d3, double d4) {
        Object[] objectArray = new Object[]{Float.valueOf((float)d), Float.valueOf((float)d2), Float.valueOf(-1.0f), Float.valueOf((float)d3), Float.valueOf((float)d4), Float.valueOf(-1.0f)};
        Scriptable scriptable = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasGradient", objectArray);
        return scriptable;
    }

    public Scriptable jsFunction_createRadialGradient(double d, double d2, double d3, double d4, double d5, double d6) {
        Object[] objectArray = new Object[]{Float.valueOf((float)d), Float.valueOf((float)d2), Float.valueOf((float)d3), Float.valueOf((float)d4), Float.valueOf((float)d5), Float.valueOf((float)d6)};
        Scriptable scriptable = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasGradient", objectArray);
        return scriptable;
    }

    public Scriptable jsFunction_createPattern(Image image, String string, int n, int n2) {
        Object[] objectArray = new Object[]{image, string, n, n2};
        Scriptable scriptable = Context.getCurrentContext().newObject(this.getCanvas().getParentScope(), "CanvasPattern", objectArray);
        return scriptable;
    }

    public void jsFunction_beginPath() {
        this.path = new GeneralPath();
        this.bMoveTo = false;
    }

    public void jsFunction_closePath() {
        if (this.bMoveTo) {
            this.bMoveTo = false;
            this.path.closePath();
        }
    }

    public void jsFunction_clip() {
        this.getCanvas().getGraphics().setClip(this.path);
    }

    public void jsFunction_moveTo(double d, double d2) {
        this.bMoveTo = true;
        Point2D.Float float_ = new Point2D.Float((float)d, (float)d2);
        this.getCanvas().getGraphics().getTransform().transform(float_, float_);
        this.path.moveTo(Math.max(0.0f, (float)((Point2D)float_).getX()), Math.max(0.0f, (float)((Point2D)float_).getY()));
    }

    public void jsFunction_lineTo(double d, double d2) {
        Point2D.Float float_ = new Point2D.Float((float)d, (float)d2);
        this.getCanvas().getGraphics().getTransform().transform(float_, float_);
        if (!this.bMoveTo) {
            this.path.moveTo(Math.max(0.0f, (float)((Point2D)float_).getX()), Math.max(0.0f, (float)((Point2D)float_).getY()));
        }
        this.path.lineTo(Math.max(0.0f, (float)((Point2D)float_).getX()), Math.max(0.0f, (float)((Point2D)float_).getY()));
    }

    public void jsFunction_quadraticCurveTo(double d, double d2, double d3, double d4) {
        float[] fArray = new float[]{(float)d, (float)d2, (float)d3, (float)d4};
        this.getCanvas().getGraphics().getTransform().transform(fArray, 0, fArray, 0, 2);
        this.path.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public void jsFunction_bezierCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        float[] fArray = new float[]{(float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6};
        this.getCanvas().getGraphics().getTransform().transform(fArray, 0, fArray, 0, 3);
        this.path.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public void jsFunction_arcTo(double d, double d2, double d3, double d4, double d5) {
    }

    public void jsFunction_rect(double d, double d2, double d3, double d4) {
        this.path.append(new Rectangle2D.Double(d, d2, d3, d4), true);
    }

    public void jsFunction_arc(double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6;
        boolean bl2 = !bl;
        double d7 = Math.PI * 2;
        while (d4 < 0.0) {
            d4 += d7;
        }
        while (d4 > d7) {
            d4 -= d7;
        }
        while (d5 < 0.0) {
            d5 += d7;
        }
        while (d5 > d7) {
            d5 -= d7;
        }
        if (bl2) {
            if (d4 > d5) {
                d5 += d7;
            }
        } else if (d4 < d5) {
            d5 -= d7;
        }
        if ((d6 = d4 - d5) == 0.0) {
            d6 = Math.PI * 2;
        }
        d4 = -d4;
        this.path.append(this.getCanvas().getGraphics().getTransform().createTransformedShape(new Arc2D.Double(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3, Math.toDegrees(d4), Math.toDegrees(d6), 0)), true);
    }

    public void jsFunction_fill() {
        AffineTransform affineTransform = this.getCanvas().getGraphics().getTransform();
        this.getCanvas().getGraphics().setTransform(new AffineTransform());
        this.getCanvas().getGraphics().setPaint(this.state.fillPaint);
        this.getCanvas().getGraphics().fill(this.path);
        this.getCanvas().getGraphics().setTransform(affineTransform);
    }

    public void jsFunction_stroke() {
        try {
            this.getCanvas().getGraphics().setColor(Utils.parseColor(this.getState().strokeStyle.toString()));
            this.getCanvas().getGraphics().setStroke(this.setupStroke());
            this.getCanvas().getGraphics().draw(this.getCanvas().getGraphics().getTransform().createInverse().createTransformedShape(this.path));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public BasicStroke setupStroke() {
        int n = this.state.lineCap.equals("round") ? 1 : (this.state.lineCap.equals("square") ? 2 : 0);
        int n2 = this.state.lineJoin.equals("round") ? 1 : (this.state.lineJoin.equals("bevel") ? 2 : 0);
        BasicStroke basicStroke = new BasicStroke(this.getState().lineWidth, n, n2, this.state.miterLimit);
        return basicStroke;
    }

    public void jsFunction_save() {
        State state = new State();
        state.fillStyle = this.state.fillStyle;
        state.strokeStyle = this.state.strokeStyle;
        state.lineWidth = this.state.lineWidth;
        state.lineCap = this.state.lineCap;
        state.lineJoin = this.state.lineJoin;
        state.miterLimit = this.state.miterLimit;
        state.globalAlpha = this.state.globalAlpha;
        state.globalCompositeOperation = this.state.globalCompositeOperation;
        state.transform = this.getCanvas().getGraphics().getTransform();
        this.stack.push(state);
    }

    public void jsFunction_restore() {
        this.getCanvas().getGraphics().setClip(null);
        this.setState(this.stack.pop());
        this.applyComposite();
    }

    public void jsFunction_scale(double d, double d2) {
        this.getCanvas().getGraphics().scale(d, d2);
    }

    public void jsFunction_rotate(double d) {
        this.getCanvas().getGraphics().rotate(d);
    }

    public void jsFunction_translate(double d, double d2) {
        this.getCanvas().getGraphics().translate(d, d2);
    }

    public void jsFunction_transform(double d, double d2, double d3, double d4, double d5, double d6) {
        AffineTransform affineTransform = new AffineTransform(d, d2, d3, d4, d5, d6);
        this.getCanvas().getGraphics().transform(affineTransform);
    }

    public void jsFunction_setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.getCanvas().getGraphics().setTransform(new AffineTransform(d, d2, d3, d4, d5, d6));
    }

    public Context2d() {
        this.setState(new State());
        this.setTextStyle(new TextStyle(this));
    }

    @Override
    public String getClassName() {
        return "Context2d";
    }
}

