/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.document;

import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.document.AuthenticationFailedException;
import coldfusion.document.DocumentInvalidHeaderFooterSizeException;
import coldfusion.document.DocumentInvalidMimeTypeException;
import coldfusion.document.DocumentInvalidSrcException;
import coldfusion.document.DocumentMargin;
import coldfusion.document.DocumentProcessTimeOutException;
import coldfusion.document.DocumentProcessor;
import coldfusion.document.DocumentRenderException;
import coldfusion.document.spi.DocumentProperties;
import coldfusion.document.spi.DocumentSectionProperties;
import coldfusion.document.spi.HeaderFooterContentProvider;
import coldfusion.document.spi.core.URLConnectionSettings;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.tagext.lang.DocumentTagException;
import coldfusion.tagext.net.ResolvePage;
import coldfusion.vfs.VFSFileFactory;
import com.icesoft.util.PageDecorator.HeaderFooterDecoration;
import jakarta.servlet.jsp.tagext.BodyTag;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class DocumentSectionTag
extends ChildTag
implements BodyTag {
    private static final long serialVersionUID = 1L;
    private DocumentTag docParentTag = null;
    private double margintop = -1.0;
    private double marginbottom = -1.0;
    private double marginleft = -1.0;
    private double marginright = -1.0;
    private String content = null;
    private String src;
    private File sourceFile;
    private URL srcUrl;
    private String srcfile;
    private String mimetype;
    private String name;
    private DocumentSectionProperties docSectionProps;
    private String authUser;
    private String authPassword;
    private String userAgent;
    private int scaleToFit = -1;
    private HeaderFooterContentProvider header;
    private HeaderFooterContentProvider footer;

    public DocumentSectionTag() {
        super(DocumentTag.class);
    }

    public double getMargintop() {
        return this.margintop;
    }

    public void setMargintop(double m) {
        this.margintop = m;
    }

    public double getMarginbottom() {
        return this.marginbottom;
    }

    public void setMarginbottom(double m) {
        this.marginbottom = m;
    }

    public double getMarginleft() {
        return this.marginleft;
    }

    public void setMarginleft(double m) {
        this.marginleft = m;
    }

    public double getMarginright() {
        return this.marginright;
    }

    public void setMarginright(double m) {
        this.marginright = m;
    }

    public void setSrc(String src) {
        if (src == null || src.trim().length() == 0) {
            throw new DocumentInvalidSrcException(src);
        }
        File f = VFSFileFactory.getFileObject((String)(src = src.trim()));
        if (f.isAbsolute() && f.exists()) {
            this.sourceFile = f;
        } else {
            try {
                this.srcUrl = new URL(this.resolveURL(src));
            }
            catch (MalformedURLException e) {
                throw new DocumentInvalidSrcException(src);
            }
        }
        this.src = src;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrcfile(String file) {
        if (file == null || file.trim().length() == 0) {
            throw new DocumentInvalidSrcException("");
        }
        this.srcfile = file = file.trim();
        File f = VFSFileFactory.getFileObject((String)file);
        if (!f.isAbsolute() || !f.exists()) {
            throw new DocumentInvalidSrcException(file);
        }
        this.sourceFile = f;
    }

    public String getSrcfile() {
        return this.srcfile;
    }

    public void setMimetype(String mimeType) {
        if (mimeType == null || mimeType.trim().length() == 0 || mimeType.indexOf("/") == -1) {
            throw new DocumentInvalidMimeTypeException(mimeType);
        }
        this.mimetype = mimeType;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthUser() {
        return this.authUser;
    }

    public void setAuthUser(String authUser) {
        this.authUser = authUser;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean isScaleToFit() {
        return this.scaleToFit == 1;
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit ? 1 : 0;
    }

    private String resolveURL(String src) {
        ResolvePage rp = new ResolvePage();
        String baseUrlStr = null;
        try {
            baseUrlStr = this.getBaseURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String parentUrl = rp.prepareUrl(baseUrlStr);
        String actualBaseUrl = rp.baseUrl(baseUrlStr);
        String contextUrl = actualBaseUrl + this.request.getContextPath();
        String resolvedUrl = rp.resolveUrl(src, parentUrl, contextUrl);
        return resolvedUrl == null ? src : resolvedUrl;
    }

    private String getBaseURL() throws MalformedURLException {
        if (this.request instanceof DummyHttpServletRequest) {
            String url = ((DummyHttpServletRequest)this.request).getPathTranslated();
            return VFSFileFactory.getFileObject((String)url).toURL().toString();
        }
        return this.request.getRequestURL().toString();
    }

    protected void setAncestor(Tag t) {
        this.docParentTag = (DocumentTag)t;
    }

    public int doStartTag() throws DocumentTagException {
        DocumentMargin margin;
        this.onTagStart();
        this.docParentTag.setHaveSectionTag();
        DocumentProperties docProps = this.docParentTag.getDocumentProperties();
        for (Tag parentTag = this.getParent(); parentTag != null && !(parentTag instanceof DocumentTag); parentTag = parentTag.getParent()) {
            if (!(parentTag instanceof DocumentSectionTag)) continue;
            throw new NestedDocumentSectionTagExeption();
        }
        int shiftPageCount = 0;
        if (this.docParentTag.hasChildPDFFormTag() && this.docParentTag.getPdfFormPageCount() != 0) {
            shiftPageCount = this.docParentTag.getPdfFormPageCount();
            this.docParentTag.setPdfFormPageCount(0);
        }
        if (this.marginleft != -1.0 || this.marginright != -1.0 || this.margintop != -1.0 || this.marginbottom != -1.0) {
            margin = new DocumentMargin();
            boolean bInch = this.docParentTag.getUnit().equalsIgnoreCase("in");
            if (this.margintop != -1.0) {
                margin.setTop(bInch ? this.margintop : this.margintop / 2.54);
            }
            if (this.marginbottom != -1.0) {
                margin.setBottom(bInch ? this.marginbottom : this.marginbottom / 2.54);
            }
            if (this.marginleft != -1.0) {
                margin.setLeft(bInch ? this.marginleft : this.marginleft / 2.54);
            }
            if (this.marginright != -1.0) {
                margin.setRight(bInch ? this.marginright : this.marginright / 2.54);
            }
        } else {
            margin = this.docParentTag.getMargin();
        }
        this.docSectionProps = docProps.createDocumentSection(margin, this.name, shiftPageCount);
        if (this.name != null) {
            this.docSectionProps.setSectionName(this.name);
        }
        if (this.scaleToFit != -1) {
            this.docSectionProps.setScaleToFit(this.scaleToFit == 1);
        } else {
            this.docSectionProps.setScaleToFit(this.docParentTag.getScaleToFit());
        }
        return 2;
    }

    public int doAfterBody() throws DocumentTagException {
        boolean hasContent;
        if (this.bodyContent != null) {
            this.content = this.bodyContent.getString().trim();
            this.bodyContent.clearBody();
        }
        boolean bl = hasContent = this.content != null && this.content.length() > 0;
        if (hasContent || this.srcUrl != null || this.sourceFile != null) {
            try {
                this._processContent();
            }
            catch (DocumentProcessor.TimeOutException te) {
                throw new DocumentProcessTimeOutException(te.getTimeout());
            }
            catch (DocumentProcessor.RenderException ex) {
                throw new DocumentRenderException(ex.getMessage());
            }
            catch (DocumentProcessor.AuthenticationFailedException ex) {
                throw new AuthenticationFailedException(ex.getURL());
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof HeaderFooterDecoration.InvalidHeaderFooterSizeException) {
                    HeaderFooterDecoration.InvalidHeaderFooterSizeException hfEx = (HeaderFooterDecoration.InvalidHeaderFooterSizeException)cause;
                    throw new DocumentInvalidHeaderFooterSizeException(hfEx.getType(), hfEx.getSize());
                }
                throw new DocumentTagException(e);
            }
        }
        return 0;
    }

    private void _processContent() throws Exception {
        if (System.getSecurityManager() == null) {
            this.processContent();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        DocumentSectionTag.this.processContent();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    public void setHeaderContentProvider(HeaderFooterContentProvider header) {
        this.header = header;
    }

    public void setFooterContentProvider(HeaderFooterContentProvider footer) {
        this.footer = footer;
    }

    private void processContent() throws Exception {
        URLConnectionSettings urlConnectionSettings = this.getURLConnectionSettings();
        DocumentProcessor dr = new DocumentProcessor(urlConnectionSettings);
        dr.setDocumentProperties(this.docParentTag.getDocumentProperties());
        dr.setDocSectionProps(this.docSectionProps);
        dr.setExporter(this.docParentTag.getExporter());
        HeaderFooterContentProvider headerProvider = this.header == null ? this.docParentTag.getHeaderProvider() : this.header;
        HeaderFooterContentProvider footerProvider = this.footer == null ? this.docParentTag.getFooterProvider() : this.footer;
        dr.setHeaderContentProvider(headerProvider);
        dr.setFooterContentProvider(footerProvider);
        dr.setPageNoCallbackHandler(this.docParentTag.getPageNoCallbackHandler());
        if (ServiceFactory.getRuntimeService().timeoutRequests()) {
            long requestTimeOut = ServiceFactory.getRuntimeService().getRequestTimeoutLimit() * 1000L;
            dr.setRequestTimeOut(requestTimeOut);
        }
        URL base = this.docParentTag.getBaseURL();
        if (this.content != null && this.content.length() > 0) {
            dr.processContent(this.content, base, this.docParentTag.getCharset(), this.docParentTag.getSectionQueue());
        } else if (this.srcUrl != null) {
            dr.processContent(this.srcUrl, null, this.mimetype, base, this.docParentTag.getSectionQueue());
        } else {
            dr.processContent(this.sourceFile, null, this.mimetype, base, this.docParentTag.getSectionQueue());
        }
    }

    private URLConnectionSettings getURLConnectionSettings() {
        URLConnectionSettings urlConnectionSettings = this.docParentTag.getURLConnectionSettings();
        if (this.authUser != null || this.userAgent != null) {
            urlConnectionSettings = (URLConnectionSettings)urlConnectionSettings.clone();
            if (this.authUser != null) {
                urlConnectionSettings.setAuthUserName(this.authUser);
                urlConnectionSettings.setAuthPassword(this.authPassword);
            }
            if (this.userAgent != null) {
                urlConnectionSettings.setUserAgent(this.userAgent);
            }
        }
        return urlConnectionSettings;
    }

    public int doEndTag() throws DocumentTagException {
        this.onTagEnd();
        return 6;
    }

    public void release() {
        this.docParentTag = null;
        this.content = null;
        this.margintop = -1.0;
        this.marginbottom = -1.0;
        this.marginleft = -1.0;
        this.marginright = -1.0;
        this.src = null;
        this.sourceFile = null;
        this.srcUrl = null;
        this.srcfile = null;
        this.mimetype = null;
        this.name = null;
        this.docSectionProps = null;
        this.authUser = null;
        this.authPassword = null;
        this.userAgent = null;
        this.header = null;
        this.footer = null;
        super.release();
    }

    public static class NestedDocumentSectionTagExeption
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }
}

