/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sequelink.parameters;

import java.io.IOException;
import java.sql.SQLException;
import macromedia.jdbc.sequelink.parameters.SequeLinkParameter;
import macromedia.jdbc.slbase.BaseExceptions;
import macromedia.jdbc.slbase.BaseTimestamp;
import macromedia.sequelink.ctxt.stmt.StatementContext;
import macromedia.sequelink.ssp.SspInputStream;
import macromedia.sequelink.ssp.SspOutputStream;
import macromedia.slutil.UtilException;

public class SequeLinkTimestampParameter
extends SequeLinkParameter {
    public SequeLinkTimestampParameter(StatementContext statementContext, int n2, int n3, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n2, 93, 0, n3, baseExceptions);
        this.baseDataType = 13;
    }

    protected void setBindInfo() {
        this.sqlnkType = 10;
        this.sqlnkSize = 11;
    }

    protected void convertDataIn() throws SQLException {
        BaseTimestamp baseTimestamp = this.bdIn.getTimestamp(this.exceptions);
        this.bdIn.setTimestamp(baseTimestamp);
    }

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        BaseTimestamp baseTimestamp = this.bdIn.getTimestampNoConvert();
        sspOutputStream.writeSSPInt16(baseTimestamp.getYear());
        sspOutputStream.writeSSPInt8(baseTimestamp.getMonth() + 1);
        sspOutputStream.writeSSPInt8(baseTimestamp.getDate());
        sspOutputStream.writeSSPInt8(baseTimestamp.getHours());
        sspOutputStream.writeSSPInt8(baseTimestamp.getMinutes());
        sspOutputStream.writeSSPInt8(baseTimestamp.getSeconds());
        sspOutputStream.writeSSPFullInt32(baseTimestamp.getNanos());
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        this.bdOut.setTimestamp(new BaseTimestamp(sspInputStream.readSSPInt16(), sspInputStream.readSSPInt8() - 1, sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPInt8(), sspInputStream.readSSPFullInt32(), null));
    }
}

