/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.AbstractECLookupTable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECConstants;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECCurve;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECFieldElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECLookupTable;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.ECPoint;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.sec.SecT409FieldElement;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.ec.custom.sec.SecT409R1Point;
import macromedia.jdbc.oracle.externals.org.bouncycastle.math.raw.Nat448;
import macromedia.jdbc.oracle.externals.org.bouncycastle.util.encoders.Hex;

public class SecT409R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT409R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT409R1_AFFINE_ZS = new ECFieldElement[]{new SecT409FieldElement(ECConstants.ONE)};
    protected SecT409R1Point infinity = new SecT409R1Point(this, null, null);

    public SecT409R1Curve() {
        super(409, 87, 0, 0);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("0021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545F")));
        this.order = new BigInteger(1, Hex.decodeStrict("010000000000000000000000000000000000000000000000000001E2AAD6A612F33307BE5FA47C3C9E052F838164CD37D9A21173"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecT409R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFieldSize() {
        return 409;
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT409FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT409R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT409R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 409;
    }

    public boolean isTrinomial() {
        return true;
    }

    public int getK1() {
        return 87;
    }

    public int getK2() {
        return 0;
    }

    public int getK3() {
        return 0;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, final int n3) {
        final long[] lArray = new long[n3 * 7 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n4);
            Nat448.copy64(((SecT409FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n4 += 7);
            n4 += 7;
        }
        return new AbstractECLookupTable(){

            @Override
            public int getSize() {
                return n3;
            }

            @Override
            public ECPoint lookup(int n2) {
                long[] lArray3 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n32 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    long l2 = (i2 ^ n2) - 1 >> 31;
                    for (int i3 = 0; i3 < 7; ++i3) {
                        int n4 = i3;
                        lArray3[n4] = lArray3[n4] ^ lArray[n32 + i3] & l2;
                        int n5 = i3;
                        lArray2[n5] = lArray2[n5] ^ lArray[n32 + 7 + i3] & l2;
                    }
                    n32 += 14;
                }
                return this.createPoint(lArray3, lArray2);
            }

            @Override
            public ECPoint lookupVar(int n2) {
                long[] lArray3 = Nat448.create64();
                long[] lArray2 = Nat448.create64();
                int n32 = n2 * 7 * 2;
                for (int i2 = 0; i2 < 7; ++i2) {
                    lArray3[i2] = lArray[n32 + i2];
                    lArray2[i2] = lArray[n32 + 7 + i2];
                }
                return this.createPoint(lArray3, lArray2);
            }

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                return SecT409R1Curve.this.createRawPoint(new SecT409FieldElement(lArray3), new SecT409FieldElement(lArray2), SECT409R1_AFFINE_ZS);
            }
        };
    }
}

