/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2008 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

package coldfusion.tagext.mail;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.tagext.ChildTag;
import coldfusion.tagext.InvalidTagAttributeException;
import coldfusion.tagext.ResourceNotFoundException;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.mail.core.*;
import coldfusion.mail.mod.MailImpl;

import java.io.File;
import java.net.URL;
import java.util.Map;

import javax.mail.internet.InternetAddress;
import javax.naming.InitialContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

/**
 * Can either attach a file or add a header to a message. It is nested within a cfmail tag.
 * You can use more than one cfmailparam tag within a cfmail tag.
 *
 * @tag mailparam
 * @tagbody empty
 * @author Clement Wong, Tom Jordahl
 */
final public class MailParamTag extends ChildTag
{
	public MailParamTag()
	{
		super(MailTag.class);
	}

	/**
	 * Required if you do not specify the file attribute. Specifies the name of the header. Header names are case insensitive.
	 * This attribute is mutually exclusive with the file attribute.
	 * @tagattribute
	 * @required no
	 * @rtexprvalue yes
	 */
    public void setName(String h) {
        name = h;
    }

    public String getName() {
        return name;
    }
	/**
	 * Optional. Indicates the value of the header.
	 * @tagattribute
	 * @required no
	 * @rtexprvalue yes
	 */
    public void setValue(String v) {
        value = Utils.stripCRLF(v);
    }

     public String getValue() {
        return value;
    }
	/**
	 * Required if you do not specify the name attribute.
	 * Attaches the specified file to the message.
	 * This attribute is mutually exclusive with the name attribute.
	 * @tagattribute
	 * @required no
	 * @rtexprvalue yes
	 */
    public void setFile(String url) {
        userEnterSetFileName = url;
    }

    private void setFileHelper(String url)
    {
        String charset = null;
        String url_save = url;
        
        if (decode)
        {
            try
            {
                charset = pageContext.getResponse().getCharacterEncoding();
                if (charset != null)
                    url = coldfusion.util.URLDecoder.decode(url, charset);
                else
                    url = coldfusion.util.URLDecoder.decode(url);

            }
            catch (Exception e)
            {
                url = url_save;
            }
        }
        url_obj = resolveUrl(url);
        if(url != null && url_obj == null) {
		  // If the string doesn't represent a URL, no point in decoding it
		  url = url_save;
          file_obj = VFSFileFactory.getFileObject(url);
          if(!file_obj.isFile()) {// CAUTION: The isfile check here ensures sandbox security of the file getting attached in the email.
             try {
                 file_obj =  new File(pageContext.getServletContext().getRealPath(url));
             }catch(Exception ex) {
                throw new ResourceNotFoundException(url);
             }

             if(!file_obj.isFile()) {// CAUTION: The isfile check here ensures sandbox security of the file getting attached in the email.
                 Map mappings = coldfusion.server.ServiceFactory.getRuntimeService().getMappings();
                 String _url = url.replace('\\', '/');
                 int index = _url.indexOf('/', 1);
                 char firstChar = _url.charAt(0);

                 String curVirtPath = null;
                 String subPath = null;

                 if(index > 0) {
                    if (firstChar != '/')
                      curVirtPath = "/" + _url.substring(0, index);
                    else
                       curVirtPath = _url.substring(0, index);

                    subPath = _url.substring(index);
                 }

                if(curVirtPath != null && subPath != null) {
                        String curPhysPath = (String) mappings.get( curVirtPath );
                        if(curPhysPath != null) file_obj = VFSFileFactory.getFileObject(curPhysPath+subPath);
                }
             }

          }
        }
    }

    public String getFile() {
        return userEnterSetFileName;
    }


    /**
     * Optional. Specify variable for file attachment
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setContent(Object binObj)
    {
        String charset=t!=null?t.getCharset():null;
        bin_obj= Cast._Binary(binObj, charset);
        if(bin_obj == null)
            throw new UnsupportedMimeAttachException("content");
    }

   /**
     * @tagattribute
     * @required false
     * @rtexprvalue true
     */
    public void setRemove(boolean b)
    {
        this.removeAttachment = Boolean.valueOf(b);
    }


    /**
     * Optional. Specify the MimeType of the file attachment
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setType(String t) {
        file_type = Utils.stripCRLF(t);
    }

    /**
     * Optional. Specify the Content-ID header of a file attachment
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setContentID(String id) {
        if (id.startsWith("<") && id.endsWith(">"))
        {
            ContentID = Utils.stripCRLF(id);
        }
        else
        {
            ContentID = "<" + Utils.stripCRLF(id) + ">";
        }
    }

    /**
     * Optional. Specify the Content-Disposition header for a file attachment
     * @tagattribute
     * @required no
     * @rtexprvalue yes
     */
    public void setDisposition(String s) {
        ContentDispo = Utils.stripCRLF(s);
    }
    
    public String getFileName()
    {
        return fileName;
    }

    /**
     * @tagattribute
     * @required false
     * @rtexprvalue true
     */
    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    /**
     * @tagattribute
     * @required false
     * @rtexprvalue true
     */
    public void setDecode(boolean decode)
    {
        this.decode = decode;
    }

    protected URL resolveUrl(String url)
	{
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        String path = (String)req.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = req.getServletPath();
        }
        return resolveUrl(path, url);
    }

    private URL resolveUrl(String refpath, String url)
	{
        URL u = null;
        if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://")) {
            try {
                u = new URL(url);
            } catch (Exception ex) {
                return null;
            }
        } else if (url.startsWith("java:comp/env/url")) {
            try {
                InitialContext ctx = new InitialContext();
                u = (URL)ctx.lookup(url);
            } catch (Exception ex) {
                return null;
            }
        } else {
            if (!url.startsWith("/"))
            {
                  int last = refpath.lastIndexOf("/");
                  if(last != -1)
                  {
                      url = refpath.substring(0, last) + "/" + url;                	  
                  }
            }
            try {
                u = pageContext.getServletContext().getResource(url);
            } catch (Exception ex) {
                return null;
            }
        }
        return u;
    }


    private String name;
    private String value;
    private URL url_obj;
    private byte[] bin_obj;  // attach binary content. Added to suppport file and pdf var directly
    private File file_obj;
    private String file_type;
    private coldfusion.mail.mod.MailImpl impl;
    private MailTag t;
    private String userEnterSetFileName;
    private String ContentID;
    private String ContentDispo;
    private Boolean removeAttachment= null;
    private String fileName;
    private boolean decode = true;

    public void release() {
        name = null;
        value = null;
        url_obj = null;
        bin_obj = null;
        file_obj = null;
        file_type = null;
        impl = null;
        t = null;
        ContentID = null;
        ContentDispo = null;
        removeAttachment = null;
        fileName = null;
        decode = true;
        super.release();
        onTagEnd();
    }

    protected void setAncestor(Tag t)
	{
		this.t = (MailTag) t;
    }

    public int doStartTag() throws JspException
	{
        onTagStart();
        // we need not validate file in setFile when content is being used
        if(bin_obj==null && userEnterSetFileName !=null)
            setFileHelper(userEnterSetFileName);  
        impl = t.getMailImpl();

        // check for attachments only if name value is not specified or name equals mimeattach
        if(name==null || name.equalsIgnoreCase("mimeattach"))
        {
            // validation for setfile if bin_obj is not specified (brought to here coz user can specify any filename for vars)
            if (bin_obj == null && (url_obj == null && (file_obj == null || !file_obj.isFile())))
                throw new ResourceNotFoundException(userEnterSetFileName);
        }

        // reordering to give var higher priority (if by chance we get a url_obj while the intention was to set file name)
        if (bin_obj != null)
        {
            //validate if file name has been specified with variable sent as attachment
         if (userEnterSetFileName == null && fileName == null)
         {
            throw new MailFileAttachException();
         }
            try {
                // We create temp file to store content, we have to remove it no matter what is in remove.
                impl.setAttachment(bin_obj,(fileName == null || fileName.isEmpty()) ? userEnterSetFileName : fileName, file_type, ContentDispo, ContentID,Boolean.TRUE,pageContext);
            } catch (Exception ex) {
                throw new MailAttachmentException(ex);
            }
        }
        else if (url_obj != null) {
            try {
                impl.setAttachment(url_obj, file_type, ContentDispo, ContentID, fileName);
            } catch (Exception ex) {
                throw new MailAttachmentException(ex);
            }
        }
        else if (file_obj != null) {
            try {
                // if removeAttchment is null take it from its parent cfmail
                Boolean remove=removeAttachment== null?t.getRemoveAttachment():removeAttachment;
                impl.setAttachment(file_obj, file_type, ContentDispo, ContentID,remove, fileName);
            } catch (Exception ex) {
                throw new MailAttachmentException(ex);
            }
        } else if (name != null && name.length() != 0 && value != null) {
            if (name.equalsIgnoreCase("from")) {
                InternetAddress[] fromAddress = MailImpl.setInternetAddress(value);
                if(fromAddress != null && value.trim().length() > 0 ) {
                      impl.setSender(fromAddress[0]);
                }
            } else if (name.equalsIgnoreCase("to")) {
                impl.setRecipient(MailImpl.setInternetAddress(value));
            } else if (name.equalsIgnoreCase("cc")) {
                impl.setCc(MailImpl.setInternetAddress(value));
            } else if (name.equalsIgnoreCase("bcc")) {
                impl.setBcc(MailImpl.setInternetAddress(value));
            } else if (name.equalsIgnoreCase("subject")) {
                impl.setSubject(value);
            } else if (name.equalsIgnoreCase("type") || name.equalsIgnoreCase("content-type")) {
                impl.setContentType(value, null);
            } else if (name.equalsIgnoreCase("mimeattach")) {
                File file = VFSFileFactory.getFileObject(value);
                if(file.isFile()) {
                  try {
                    impl.setAttachment(file, file_type, ContentDispo, ContentID,removeAttachment, fileName);
                    } catch (Exception ex) {
                    throw new MailAttachmentException(ex);
                    }
                  }else {
                    try {
                      impl.setAttachment(new File(pageContext.getServletContext().getRealPath(value)), file_type, ContentDispo, ContentID,removeAttachment, fileName);
                    }catch(Exception ex) {
                      throw new MailAttachmentException(ex);
                    }
                }
            } else if (name.equalsIgnoreCase("mailerid")) {
                try {
                  impl.setHeader("X-Mailer", value);
                } catch (Exception ex) {
                  throw new MailHeaderException(ex);
                }
            } else if (name.equalsIgnoreCase("Message-ID")) {
                try {
                  impl.setMessage_id(value);  
                } catch (Exception ex) {
                  throw new MailHeaderException(ex);
                }
            } else {
                try {
                    impl.setHeader(name, value);
                } catch (Exception ex) {
                    throw new MailHeaderException(ex);
                }
            }
        } else {
            throw new InvalidTagAttributeException("CFMAILPARAM", "name", name);
        }

        return SKIP_BODY;
    }

    /**
     * Attribute validation error in the cfmailparam tag.
     * varfilename should be specified while using variables for file.
     */
    public class MailFileAttachException extends ApplicationException {

        public MailFileAttachException()
        {
        }
    }
}

