/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2001-2020 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

//@author Uday Ogra

package coldfusion.mail.mod;

import java.io.File;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import coldfusion.osgi.services.PrintService;
import coldfusion.server.CFService;
import coldfusion.server.MailSpoolService;
import coldfusion.server.felix.FelixConstants;
import coldfusion.server.felix.FelixUtil;


public class MailServiceActivator implements BundleActivator {
	private ServiceRegistration serviceReg;
	private String bundleName = FelixConstants.MAIL_BUNDLE;

	public void start(BundleContext context) {
		File mconfig = CFService.getFile("neo-mail.xml");
		MailSpoolService mss = new MailSpooler(mconfig, CFService._rootdir,
				CFService.context);
		serviceReg = FelixUtil.startBundle(context, bundleName,
				MailSpoolService.class.getName(), mss, null);

	}

	public void stop(BundleContext context) {
		FelixUtil.stopBundle(bundleName, context, serviceReg);
	}

}