package coldfusion.print;

import org.jpedal.PdfDecoder;
import org.jpedal.PdfDecoderInt;
import org.jpedal.exception.PdfFontException;
import org.jpedal.fonts.FontMappings;

import coldfusion.log.CFLogs;
import coldfusion.osgi.services.PrintService;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;

public class PrintServiceImpl implements PrintService {
	public Struct getInfo(NeoPageContext pageContext, String printer) {
		return PrinterInfo.getInfo(pageContext, printer);
	}

	public Object[] getPrinters() {
		return PrinterInfo.getPrinters();
	}

	public void setFontSubstitutionMode() {
		FontMappings
				.setFontSubstitutionMode(PdfDecoder.SUBSTITUTE_FONT_USING_POSTSCRIPT_NAME);

	}

	public void setFontDirs(String[] fontDirs) {
		FontMappings.setFontDirs(fontDirs);

	}

	public void addFontFile(String name, String parent) {
		FontMappings.addFontFile(name, parent);
	}

	public void init(Object o) {
		PdfDecoderInt decode_pdf = (PdfDecoderInt) o;
		
		// Try MyriadPro. Since this is an Adobe font which we don't ship as of
		// CF8, it might not be installed.
		try {
			FontMappings.setDefaultDisplayFont("MyriadPro");
			return;
		} catch (PdfFontException e1) {
			CFLogs.SERVER_LOG.debug(e1);
		}

		// Didn't find Myriad Pro so try Arial.
		try {
			FontMappings.setDefaultDisplayFont("Arial");
			return;
		} catch (PdfFontException e2) {
			CFLogs.SERVER_LOG.debug(e2);
		}
	}
}