/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cookie;
import ice.net.CookieManagerSettings;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CookieManager
extends VetoableChangeSupport {
    private Vector cookies = new Vector();
    boolean enabled = true;
    private int maxCookieSize = 4096;
    private int maxNumberOfCookies = 1024;
    private int sizeOfAllCookies = -1;
    private int maxSizeOfAllCookies = 100000;
    private boolean cookieExpirationBufferEnabled;
    private boolean persistPrivateCookies;

    public CookieManager() {
        this(new CookieManagerSettings());
    }

    public CookieManager(CookieManagerSettings cookieManagerSettings) {
        super("Dummy");
        this.cookieExpirationBufferEnabled = cookieManagerSettings.isCookieExpirationBufferEnabled();
        this.persistPrivateCookies = cookieManagerSettings.shouldPersistPrivateCookies();
    }

    public CookieManager(HttpSession httpSession) {
        super("Dummy");
        this.cookieExpirationBufferEnabled = httpSession.ieCookieExpiresForgive;
    }

    public boolean isCookieExpirationBufferEnabled() {
        return this.cookieExpirationBufferEnabled;
    }

    public boolean shouldPersistPrivateCookies() {
        return this.persistPrivateCookies;
    }

    public int getMaxTotalCookieSize() {
        return this.maxSizeOfAllCookies;
    }

    public void setMaxTotalCookieSize(int newSize) {
        this.maxSizeOfAllCookies = newSize;
    }

    public void setMaxCookieSize(int newSize) {
        this.maxCookieSize = newSize;
    }

    public int getMaxCookieSize() {
        return this.maxCookieSize;
    }

    public void setMaxNumberOfCookies(int maxCount) {
        this.maxNumberOfCookies = maxCount;
    }

    public int getMaxNumberOfCookies() {
        return this.maxNumberOfCookies;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Enumeration elements() {
        return this.cookies.elements();
    }

    public Cookie[] getAllCookies() {
        int n = this.cookies.size();
        if (n == 0) {
            return null;
        }
        Cookie[] tmpArray = new Cookie[n];
        for (int i = 0; i < n; ++i) {
            tmpArray[i] = (Cookie)this.cookies.elementAt(i);
        }
        return tmpArray;
    }

    protected boolean extractAllCookies(URL url, URLConnection urlConnection) {
        if (!this.enabled) {
            return false;
        }
        boolean _result = false;
        String[] _fieldValues = ((HttpURLConnection)urlConnection).getResponse().getFieldValues("Set-Cookie");
        for (int i = 0; i < _fieldValues.length; ++i) {
            Cookie _cookie;
            if (_fieldValues[i].length() > this.maxCookieSize) {
                return false;
            }
            boolean _isPrivate = this.checkPrivate(urlConnection);
            if (this.cookies.size() >= this.maxNumberOfCookies) {
                _cookie = (Cookie)this.cookies.elementAt(0);
                this.sizeOfAllCookies -= _cookie.size();
                this.cookies.removeElementAt(0);
            }
            if ((_cookie = Cookie.parseFromString(url, _fieldValues[i])) == null) continue;
            _cookie.setPrivate(_isPrivate);
            this.addCookie(_cookie);
            _result = true;
        }
        return _result;
    }

    public synchronized void removeAllCookies() {
        this.cookies.removeAllElements();
        this.sizeOfAllCookies = 0;
    }

    public synchronized void removeAllSessionCookies() {
        int n = this.cookies.size();
        for (int i = 0; i != n; ++i) {
            Cookie cookie = (Cookie)this.cookies.elementAt(i);
            if (!cookie.isSessionCookie()) continue;
            this.sizeOfAllCookies -= cookie.size();
            this.cookies.removeElementAt(i);
            --i;
        }
    }

    public synchronized void removeAllExpiredCookies() {
        int n = this.cookies.size();
        for (int i = 0; i != n; ++i) {
            Cookie cookie = (Cookie)this.cookies.elementAt(i);
            if (!cookie.isExpired()) continue;
            this.sizeOfAllCookies -= cookie.size();
            this.cookies.removeElementAt(i);
            --i;
        }
    }

    public synchronized void addCookie(Cookie c) {
        int n = this.cookies.size();
        for (int i = 0; i < n; ++i) {
            Cookie cc = (Cookie)this.cookies.elementAt(i);
            boolean domainIsEqualEnough = false;
            boolean pathIsEqualEnough = false;
            if (cc.getDomain().indexOf(c.getDomain()) != -1 || cc.getDomain().equals(c.getDomain())) {
                domainIsEqualEnough = true;
            }
            if (c.path == null) {
                pathIsEqualEnough = true;
            } else if (c.path.equals(cc.path) || cc.path.indexOf(c.path) != -1) {
                pathIsEqualEnough = true;
            }
            if (!domainIsEqualEnough || !pathIsEqualEnough || !c.name.equals(cc.name)) continue;
            if (this.checkAccept(cc, c)) {
                if (cc.isPrivate()) {
                    c.setPrivate(true);
                }
                this.sizeOfAllCookies -= cc.size();
                this.sizeOfAllCookies += c.size();
                this.cookies.setElementAt(c, i);
            }
            return;
        }
        if (this.checkAccept(null, c)) {
            boolean replace = false;
            boolean ditch = false;
            if (this.cookies.size() > this.maxNumberOfCookies) {
                replace = true;
            }
            if (c.size() > this.maxCookieSize) {
                ditch = true;
            }
            if (this.sizeOfAllCookies + c.size() > this.maxSizeOfAllCookies) {
                replace = true;
            }
            if (ditch) {
                return;
            }
            if (replace) {
                if (this.sizeOfAllCookies < 0) {
                    return;
                }
                if (this.cookies.size() != 0) {
                    Cookie k = (Cookie)this.cookies.elementAt(0);
                    this.sizeOfAllCookies -= k.size();
                    this.sizeOfAllCookies += c.size();
                    this.cookies.setElementAt(c, 0);
                    return;
                }
            }
            if (this.sizeOfAllCookies < 0) {
                this.sizeOfAllCookies = 0;
            }
            this.sizeOfAllCookies += c.size();
            this.cookies.addElement(c);
        }
    }

    private boolean checkAccept(Cookie oldCookie, Cookie newCookie) {
        try {
            this.fireVetoableChange("Cookie", oldCookie, newCookie);
        }
        catch (PropertyVetoException e) {
            return false;
        }
        return true;
    }

    protected void applyAllCookies(URL url, URLConnection uc) {
        String str = this.getCookieStr(url);
        if (str != null && str.length() != 0) {
            if (((HttpURLConnection)uc).isConnected()) {
                ((HttpURLConnection)uc).disconnect();
            }
            uc.setRequestProperty("Cookie", str);
        }
    }

    String getCookieStr(URL url) {
        if (!this.enabled) {
            return null;
        }
        String _host = url.getHost();
        if (_host == null) {
            return null;
        }
        String _protocol = url.getProtocol();
        if (!_protocol.equals("http") && !_protocol.equals("https")) {
            return null;
        }
        int _size = this.cookies.size();
        if (_size == 0) {
            return null;
        }
        StringBuffer _cookieString = new StringBuffer();
        Date _now = new Date();
        boolean _first = true;
        for (int i = 0; i < _size; ++i) {
            Cookie _cookie = (Cookie)this.cookies.elementAt(i);
            if (_cookie.getSecure() && _protocol.equals("http")) continue;
            boolean _doCookie = false;
            if (_cookie.expires == null || !_cookie.expires.before(_now)) {
                _doCookie = true;
            }
            if (!(!this.cookieExpirationBufferEnabled || _doCookie || _cookie.expires != null && _cookie.expires.before(new Date(_now.getTime() - 0x6DDD00L)))) {
                _doCookie = true;
            }
            if (!_doCookie || !this.cookieDomainMatch(_host, _cookie.domain) || !this.cookiePathMatch(url, _cookie)) continue;
            _cookie.use();
            if (!_first) {
                _cookieString.append("; ");
            } else {
                _first = false;
            }
            _cookieString.append(_cookie.name + "=" + _cookie.value);
        }
        return _cookieString.toString();
    }

    private boolean cookieDomainMatch(String host, String domain) {
        boolean match = false;
        int dl = domain.length();
        if (dl != 0) {
            int hl;
            if ('.' == domain.charAt(0)) {
                if (dl >= 2 && !(match = host.endsWith(domain)) && host.length() == dl - 1) {
                    match = domain.endsWith(host);
                }
            } else if (host.endsWith(domain) && ((hl = host.length()) == dl || '.' == host.charAt(hl - dl - 1))) {
                match = true;
            }
        }
        return match;
    }

    private boolean cookiePathMatch(URL requestURL, Cookie cookie) {
        String cookiePath = cookie.getPath();
        String urlPath = requestURL.getFile();
        int _index = urlPath.indexOf("?");
        if (_index != -1) {
            urlPath = urlPath.substring(0, _index);
        }
        if (cookiePath == null) {
            return true;
        }
        if (cookiePath.equals("") || cookiePath.equals("/")) {
            return true;
        }
        if (cookiePath.charAt(0) != '/') {
            cookiePath = "/" + cookiePath;
        }
        for (int i = 0; i < cookiePath.length(); ++i) {
            if (i == urlPath.length()) {
                return cookiePath.charAt(i + 1) == '/' && cookiePath.length() == urlPath.length() + 1;
            }
            if (cookiePath.charAt(i) == urlPath.charAt(i)) continue;
            return false;
        }
        if (cookiePath.endsWith("/")) {
            return true;
        }
        if (cookiePath.length() != urlPath.length() && urlPath.charAt(cookiePath.length()) == '/') {
            return true;
        }
        return cookiePath.length() == urlPath.length();
    }

    public synchronized void writeCookies(ObjectOutput out) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector<Cookie> _persistentCookies = new Vector<Cookie>();
            int _size = this.cookies.size();
            for (int i = 0; i < _size; ++i) {
                Cookie _cookie = (Cookie)this.cookies.elementAt(i);
                if (!this.persistPrivateCookies && _cookie.isPrivate() || _cookie.expires == null || !_cookie.expires.after(new Date())) continue;
                _persistentCookies.addElement(_cookie);
            }
            out.writeObject(_persistentCookies);
        }
        catch (IOException exception) {
            Debug.ex((Throwable)exception);
        }
        catch (Exception exception) {
            Debug.ex((Throwable)exception);
        }
    }

    public synchronized void readCookies(ObjectInput in) {
        block5: {
            if (!this.enabled) {
                return;
            }
            try {
                Vector v = (Vector)in.readObject();
                for (int i = 0; i < v.size(); ++i) {
                    this.addCookie((Cookie)v.elementAt(i));
                }
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex((Throwable)ex);
                }
                if (!Debug.trace) break block5;
                Debug.trace((String)("Error loading cookies: " + ex));
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vc) {
        super.addVetoableChangeListener(vc);
    }

    private boolean checkPrivate(URLConnection uc) {
        String _cacheControl = uc.getHeaderField("Cache-Control");
        return "private".equals(_cacheControl) || "no-cache".equals(_cacheControl);
    }
}

