/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.net.CacheManager;
import ice.net.Connection;
import ice.net.HttpURLConnection;
import ice.util.ICEException;
import ice.util.memory.MemoryManager;
import java.io.IOException;
import java.io.InputStream;

public class CachedInputStream
extends InputStream {
    private int contentLength;
    private CacheManager cacheHook;
    private Connection connectionHook;
    private byte[] buf;
    private int bufOffset;
    private int bufLength;
    protected byte[] cache;
    private int cacheOffset;
    private int cachedLength;
    private java.net.HttpURLConnection httpUrlConnection;
    private boolean dataDone = false;
    private boolean doCaching;
    private int maxCachedSize;
    private int initialCacheSize = 4096;
    private Object readlock = new Object();
    private Object cachelock = new Object();
    private Object cleanUpLock = new Object();
    private int BUFFERSIZE = 4096;
    private int requestCounter = 0;
    private boolean hasBeenCached = false;

    public CachedInputStream(java.net.HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length) {
        this(httpUrlConnection, cacheManager, connection, buffer, offset, length, -1);
    }

    CachedInputStream(java.net.HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length, int contentLength) {
        this.httpUrlConnection = httpUrlConnection;
        this.cacheHook = cacheManager;
        this.connectionHook = connection;
        this.buf = length > 0 ? new byte[length] : new byte[this.BUFFERSIZE];
        if (buffer != null) {
            System.arraycopy(buffer, offset, this.buf, 0, length);
        }
        this.bufOffset = 0;
        this.bufLength = length;
        this.contentLength = contentLength;
        if (this.cacheHook != null) {
            this.doCaching = this.cacheHook.isCacheOn();
            this.maxCachedSize = this.cacheHook.getMaxCacheable(httpUrlConnection);
        }
    }

    public CachedInputStream(HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length) {
        this((java.net.HttpURLConnection)httpUrlConnection, cacheManager, connection, buffer, offset, length, -1);
    }

    CachedInputStream(HttpURLConnection httpUrlConnection, CacheManager cacheManager, Connection connection, byte[] buffer, int offset, int length, int contentLength) {
        this((java.net.HttpURLConnection)httpUrlConnection, cacheManager, connection, buffer, offset, length, contentLength);
    }

    void markDone() {
        this.dataDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitToCache() throws ICEException {
        if (!this.doCaching) {
            return;
        }
        Object object = this.cachelock;
        synchronized (object) {
            if (!this.hasBeenCached && this.cacheHook != null) {
                MemoryManager memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(this.cachedLength)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                byte[] finishedArray = null;
                try {
                    finishedArray = new byte[this.cachedLength];
                }
                catch (OutOfMemoryError e) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                if (this.cache != null) {
                    System.arraycopy(this.cache, 0, finishedArray, 0, this.cachedLength);
                    if (this.httpUrlConnection instanceof HttpURLConnection) {
                        this.cacheHook.submit(finishedArray, (HttpURLConnection)this.httpUrlConnection);
                    } else {
                        this.cacheHook.submit(finishedArray, this.httpUrlConnection);
                    }
                    this.hasBeenCached = true;
                }
            }
        }
    }

    protected void addCache(byte[] dataIn, int dataOffset, int dataLength) throws ICEException {
        if (!this.doCaching) {
            return;
        }
        if (this.cachedLength >= this.maxCachedSize) {
            this.doCaching = false;
            return;
        }
        if (this.cache == null) {
            MemoryManager memoryManager = MemoryManager.getInstance();
            if (!memoryManager.canAllocate(this.initialCacheSize)) {
                throw new ICEException(2, 3, 2);
            }
            this.cache = new byte[this.initialCacheSize];
            this.cacheOffset = 0;
            this.cachedLength = 0;
        }
        if (this.cache.length - (this.cacheOffset + 1) < dataLength) {
            byte[] tmpArray = null;
            int freeCacheSpace = this.cache.length - this.cacheOffset;
            MemoryManager memoryManager = MemoryManager.getInstance();
            if (dataLength > this.cache.length + freeCacheSpace) {
                if (!memoryManager.canAllocate(this.cache.length + dataLength)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                tmpArray = new byte[this.cache.length + dataLength];
            } else {
                if (!memoryManager.canAllocate(this.cache.length * 2)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                try {
                    tmpArray = new byte[this.cache.length * 2];
                }
                catch (OutOfMemoryError exception) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
            }
            System.arraycopy(this.cache, 0, tmpArray, 0, this.cacheOffset);
            this.cache = null;
            this.cache = tmpArray;
        }
        System.arraycopy(dataIn, dataOffset, this.cache, this.cacheOffset, dataLength);
        this.cacheOffset += dataLength;
        this.cachedLength += dataLength;
        if (this.contentLength != -1 && this.cachedLength == this.contentLength) {
            this.submitToCache();
        }
    }

    protected void addCache(byte theData) throws ICEException {
        if (!this.doCaching) {
            return;
        }
        if (this.cachedLength >= this.maxCachedSize) {
            this.doCaching = false;
            return;
        }
        try {
            MemoryManager memoryManager;
            if (this.cache == null) {
                memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(4000)) {
                    throw new ICEException(2, 3, 2);
                }
                this.cache = new byte[4000];
                this.cacheOffset = 0;
                this.cachedLength = 0;
            }
            if (this.cache.length - this.cacheOffset > 0) {
                this.cache[this.cacheOffset] = theData;
                ++this.cacheOffset;
                ++this.cachedLength;
            } else {
                memoryManager = MemoryManager.getInstance();
                if (!memoryManager.canAllocate(this.cache.length * 2)) {
                    this.cache = null;
                    throw new ICEException(2, 3, 2);
                }
                byte[] newCache = new byte[this.cache.length * 2];
                System.arraycopy(this.cache, 0, newCache, 0, this.cacheOffset);
                this.cache = null;
                this.cache = newCache;
                this.cache[this.cacheOffset] = theData;
                ++this.cacheOffset;
                ++this.cachedLength;
            }
        }
        catch (OutOfMemoryError exception) {
            this.cache = null;
            throw new OutOfMemoryError();
        }
        if (this.contentLength != -1 && this.cachedLength == this.contentLength) {
            this.submitToCache();
        }
    }

    public int available() throws IOException {
        if (this.buf != null && this.bufLength > 0) {
            return this.bufLength;
        }
        if (this.requestCounter >= 4) {
            int bytesRead;
            if (this.buf == null) {
                this.buf = new byte[8192];
            }
            if ((bytesRead = this.connectionHook.read(this.buf, 0, this.buf.length)) > 0) {
                this.bufLength = bytesRead;
                return bytesRead;
            }
        } else {
            ++this.requestCounter;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.submitToCache();
        Object object = this.cleanUpLock;
        synchronized (object) {
            this.buf = null;
            this.connectionHook.close();
            this.httpUrlConnection = null;
            this.cacheHook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.readlock;
        synchronized (object) {
            int bytesRead;
            if (this.bufLength > 0) {
                int tmp = this.bufOffset++;
                this.addCache(this.buf[tmp]);
                if (--this.bufLength == 0) {
                    this.bufOffset = 0;
                }
                return this.buf[tmp] & 0xFF;
            }
            this.bufOffset = 0;
            this.bufLength = 0;
            if (this.dataDone) {
                this.submitToCache();
                return -1;
            }
            if (this.buf == null) {
                this.buf = new byte[this.BUFFERSIZE];
            }
            if (this.buf.length == 0) {
                this.buf = new byte[this.BUFFERSIZE];
            }
            if ((bytesRead = this.connectionHook.read(this.buf, 0, this.buf.length)) > 0) {
                this.bufLength = bytesRead;
                ++this.bufOffset;
                --this.bufLength;
                this.addCache(this.buf[this.bufOffset - 1]);
                return this.buf[this.bufOffset - 1] & 0xFF;
            }
            this.submitToCache();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.dataDone && this.buf == null) {
            return -1;
        }
        Object object = this.readlock;
        synchronized (object) {
            int bytesRead;
            int bytescopied = 0;
            if (this.bufLength >= len) {
                boolean doclear = this.bufLength == len;
                System.arraycopy(this.buf, this.bufOffset, b, off, len);
                this.addCache(this.buf, this.bufOffset, len);
                this.bufOffset += len;
                this.bufLength -= len;
                if (doclear) {
                    this.bufOffset = 0;
                    this.bufLength = 0;
                    this.buf = null;
                }
                return len;
            }
            if (this.buf != null && this.bufLength > 0) {
                int datasize = this.bufLength;
                System.arraycopy(this.buf, this.bufOffset, b, off, this.bufLength);
                this.addCache(this.buf, this.bufOffset, this.bufLength);
                off += this.bufLength;
                bytescopied += this.bufLength;
                len -= this.bufLength;
                this.bufOffset = 0;
                this.bufLength = 0;
                this.buf = null;
                return datasize;
            }
            if (this.buf == null) {
                this.buf = new byte[this.BUFFERSIZE];
            }
            if (this.buf.length == 0) {
                this.buf = new byte[this.BUFFERSIZE];
            }
            if ((bytesRead = this.connectionHook.read(this.buf, 0, this.buf.length)) <= 0) {
                this.submitToCache();
                return -1;
            }
            this.bufLength += bytesRead;
            if (this.bufLength > len) {
                System.arraycopy(this.buf, this.bufOffset, b, off, len);
                this.addCache(this.buf, this.bufOffset, len);
                this.bufOffset += len;
                this.bufLength -= len;
                return len;
            }
            int datasize = this.bufLength;
            System.arraycopy(this.buf, this.bufOffset, b, off, this.bufLength);
            this.addCache(this.buf, this.bufOffset, this.bufLength);
            off += this.bufLength;
            bytescopied += this.bufLength;
            len -= this.bufLength;
            this.bufOffset = 0;
            this.bufLength = 0;
            this.buf = null;
            return datasize;
        }
    }
}

