/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.util.Defs;
import ice.util.Settings;
import java.io.Serializable;

public class CacheManagerSettings
implements Serializable,
Settings {
    private static final boolean ALWAYS_REVALIDATE_DEFAULT = false;
    private static final String ALWAYS_REVALIDATE_KEY = "ice.net.alwaysRevalidate";
    private static final int CACHE_EXPIRATION_BUFFER_DEFAULT = 0;
    private static final String CACHE_EXPIRATION_BUFFER_KEY = "ice.net.cacheExpirationBuffer";
    private static final boolean PERSIST_PRIVATE_RESPONSES_DEFAULT = true;
    private static final String PERSIST_PRIVATE_RESPONSES_KEY = "ice.net.persistPrivateResponses";
    private boolean alwaysRevalidate;
    private int cacheExpirationBuffer;
    private boolean persistPrivateResponses;

    public CacheManagerSettings() {
        this.initialize();
    }

    public boolean equals(Object object) {
        return object instanceof CacheManagerSettings && ((CacheManagerSettings)object).alwaysRevalidate == this.alwaysRevalidate && ((CacheManagerSettings)object).cacheExpirationBuffer == this.cacheExpirationBuffer && ((CacheManagerSettings)object).persistPrivateResponses == this.persistPrivateResponses;
    }

    public int getCacheExpirationBuffer() {
        return this.cacheExpirationBuffer;
    }

    public static int getDefaultCacheExpirationBuffer() {
        return Defs.sysPropertyInt((String)CACHE_EXPIRATION_BUFFER_KEY, (int)0);
    }

    public void resetToDefault() {
        this.initialize();
    }

    public void setAlwaysRevalidate(boolean alwaysRevalidate) {
        this.alwaysRevalidate = alwaysRevalidate;
    }

    public void setCacheExpirationBuffer(int cacheExpirationBuffer) {
        this.cacheExpirationBuffer = cacheExpirationBuffer;
    }

    public static void setDefaultAlwaysRevalidate(boolean alwaysRevalidate) {
        Defs.setSystemProperty((String)ALWAYS_REVALIDATE_KEY, (String)new Boolean(alwaysRevalidate).toString());
    }

    public static void setDefaultCacheExpirationBuffer(int cacheExpirationBuffer) {
        Defs.setSystemProperty((String)CACHE_EXPIRATION_BUFFER_KEY, (String)new Integer(cacheExpirationBuffer).toString());
    }

    public static void setDefaultPersistPrivateResponses(boolean persistPrivateResponses) {
        Defs.setSystemProperty((String)PERSIST_PRIVATE_RESPONSES_KEY, (String)new Boolean(persistPrivateResponses).toString());
    }

    public void setPersistPrivateResponses(boolean persistPrivateResponses) {
        this.persistPrivateResponses = persistPrivateResponses;
    }

    public boolean shouldAlwaysRevalidate() {
        return this.alwaysRevalidate;
    }

    public static boolean shouldDefaultAlwaysRevalidate() {
        return Defs.sysPropertyBoolean((String)ALWAYS_REVALIDATE_KEY, (boolean)false);
    }

    public static boolean shouldDefaultPersistPrivateResponses() {
        return Defs.sysPropertyBoolean((String)PERSIST_PRIVATE_RESPONSES_KEY, (boolean)true);
    }

    public boolean shouldPersistPrivateResponses() {
        return this.persistPrivateResponses;
    }

    public String toString() {
        return "CacheManagerSettings [alwaysRevalidate: " + this.alwaysRevalidate + ", " + "cacheExpirationBuffer: " + this.cacheExpirationBuffer + ", " + "persistPrivateResponses: " + this.persistPrivateResponses + "]";
    }

    private void initialize() {
        this.alwaysRevalidate = CacheManagerSettings.shouldDefaultAlwaysRevalidate();
        this.cacheExpirationBuffer = CacheManagerSettings.getDefaultCacheExpirationBuffer();
        this.persistPrivateResponses = CacheManagerSettings.shouldDefaultPersistPrivateResponses();
    }
}

